/*
 * Decompiled with CFR 0.152.
 */
package forge.game;

import com.google.common.collect.Lists;
import forge.LobbyPlayer;
import forge.game.GameEndReason;
import forge.game.player.Player;
import forge.game.player.PlayerOutcome;
import forge.game.player.PlayerStatistics;
import forge.game.player.PlayerView;
import forge.game.player.RegisteredPlayer;
import forge.item.PaperCard;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class GameOutcome
implements Iterable<Map.Entry<RegisteredPlayer, PlayerStatistics>> {
    private int lastTurnNumber = 0;
    private int lifeDelta = 0;
    private int winningTeam = -1;
    private final HashMap<RegisteredPlayer, PlayerStatistics> playerRating = new HashMap();
    private final HashMap<RegisteredPlayer, String> playerNames = new HashMap();
    private final Map<RegisteredPlayer, AnteResult> anteResult = new HashMap<RegisteredPlayer, AnteResult>();
    private GameEndReason winCondition;

    public GameOutcome(GameEndReason reason, Iterable<Player> players) {
        this.winCondition = reason;
        for (Player p : players) {
            this.playerRating.put(p.getRegisteredPlayer(), p.getStats());
            this.playerNames.put(p.getRegisteredPlayer(), p.getName());
            if (this.winCondition != GameEndReason.AllOpposingTeamsLost || !p.getOutcome().hasWon()) continue;
            this.winningTeam = p.getTeam();
        }
        if (this.winCondition == GameEndReason.Draw) {
            return;
        }
        int winnersHealth = 0;
        int opponentsHealth = 0;
        for (Player p : players) {
            if (p.getTeam() == this.winningTeam) {
                winnersHealth += p.getLife();
                continue;
            }
            opponentsHealth += p.getLife();
        }
        this.calculateLifeDelta(players);
        this.lifeDelta = Math.max(0, winnersHealth - opponentsHealth);
    }

    private void calculateLifeDelta(Iterable<Player> players) {
        int opponentsHealth = 0;
        int winnersHealth = 0;
        for (Player p : players) {
            if (p.getOutcome().hasWon()) {
                winnersHealth += p.getLife();
                continue;
            }
            opponentsHealth += p.getLife();
        }
        this.lifeDelta = Math.max(0, winnersHealth - opponentsHealth);
    }

    public boolean isDraw() {
        for (PlayerStatistics stats : this.playerRating.values()) {
            if (!stats.getOutcome().hasWon()) continue;
            return false;
        }
        return true;
    }

    public boolean isWinner(LobbyPlayer who) {
        for (Map.Entry<RegisteredPlayer, PlayerStatistics> pv : this.playerRating.entrySet()) {
            if (!pv.getValue().getOutcome().hasWon() || !pv.getKey().getPlayer().equals(who)) continue;
            return true;
        }
        return false;
    }

    public boolean isWinner(RegisteredPlayer who) {
        for (Map.Entry<RegisteredPlayer, PlayerStatistics> pv : this.playerRating.entrySet()) {
            if (!pv.getValue().getOutcome().hasWon() || !pv.getKey().equals(who)) continue;
            return true;
        }
        return false;
    }

    public LobbyPlayer getWinningLobbyPlayer() {
        for (Map.Entry<RegisteredPlayer, PlayerStatistics> ps : this.playerRating.entrySet()) {
            if (!ps.getValue().getOutcome().hasWon()) continue;
            return ps.getKey().getPlayer();
        }
        return null;
    }

    public RegisteredPlayer getWinningPlayer() {
        for (Map.Entry<RegisteredPlayer, PlayerStatistics> pair : this.playerRating.entrySet()) {
            if (!pair.getValue().getOutcome().hasWon()) continue;
            return pair.getKey();
        }
        return null;
    }

    public int getWinningTeam() {
        return this.winningTeam;
    }

    public GameEndReason getWinCondition() {
        return this.winCondition;
    }

    public int getLastTurnNumber() {
        return this.lastTurnNumber;
    }

    public int getLifeDelta() {
        return this.lifeDelta;
    }

    public String getWinSpellEffect() {
        for (PlayerStatistics stats : this.playerRating.values()) {
            PlayerOutcome po = stats.getOutcome();
            if (!po.hasWon()) continue;
            return po.altWinSourceName;
        }
        return null;
    }

    @Override
    public Iterator<Map.Entry<RegisteredPlayer, PlayerStatistics>> iterator() {
        return this.playerRating.entrySet().iterator();
    }

    public void setTurnsPlayed(int turnNumber) {
        this.lastTurnNumber = turnNumber;
    }

    public HashMap<RegisteredPlayer, String> getPlayerNames() {
        return this.playerNames;
    }

    public List<String> getOutcomeStrings() {
        ArrayList<String> outcomes = Lists.newArrayList();
        for (RegisteredPlayer player : this.playerNames.keySet()) {
            outcomes.add(this.getOutcomeString(player));
        }
        return outcomes;
    }

    public String getOutcomeString(RegisteredPlayer player) {
        return this.playerNames.get(player) + " " + this.playerRating.get(player).getOutcome();
    }

    public void addAnteWon(RegisteredPlayer pl, List<PaperCard> cards) {
        if (!this.anteResult.containsKey(pl)) {
            this.anteResult.put(pl, new AnteResult());
        }
        this.anteResult.get(pl).addWon(cards);
    }

    public void addAnteLost(RegisteredPlayer pl, List<PaperCard> cards) {
        if (!this.anteResult.containsKey(pl)) {
            this.anteResult.put(pl, new AnteResult());
        }
        this.anteResult.get(pl).addLost(cards);
    }

    public AnteResult getAnteResult(RegisteredPlayer pl) {
        return this.anteResult.get(pl);
    }

    public AnteResult getAnteResult(PlayerView pv) {
        for (Map.Entry<RegisteredPlayer, AnteResult> e : this.anteResult.entrySet()) {
            if (!pv.isLobbyPlayer(e.getKey().getPlayer())) continue;
            return e.getValue();
        }
        return null;
    }

    public static class AnteResult
    implements Serializable {
        private static final long serialVersionUID = 5087554550408543192L;
        public final List<PaperCard> lostCards = Lists.newArrayList();
        public final List<PaperCard> wonCards = Lists.newArrayList();

        public void addWon(List<PaperCard> cards) {
            this.wonCards.addAll(cards);
        }

        public void addLost(List<PaperCard> cards) {
            this.lostCards.addAll(cards);
        }
    }
}

