/*
 * Decompiled with CFR 0.152.
 */
package forge.game;

import com.google.common.collect.Iterables;
import forge.game.GameEntity;
import forge.game.GameEntityViewMap;
import forge.game.card.CardView;
import forge.trackable.TrackableCollection;
import forge.trackable.TrackableObject;
import forge.trackable.TrackableProperty;
import forge.trackable.Tracker;

public abstract class GameEntityView
extends TrackableObject {
    private static final long serialVersionUID = -5129089945124455670L;

    public static GameEntityView get(GameEntity e) {
        return e == null ? null : e.getView();
    }

    public static TrackableCollection<GameEntityView> getEntityCollection(Iterable<? extends GameEntity> entities) {
        if (entities == null) {
            return null;
        }
        TrackableCollection<GameEntityView> collection = new TrackableCollection<GameEntityView>();
        for (GameEntity gameEntity : entities) {
            collection.add(gameEntity.getView());
        }
        return collection;
    }

    public static <T extends GameEntity, V extends GameEntityView> GameEntityViewMap<T, V> getMap(Iterable<T> spabs) {
        GameEntityViewMap gameViewCache = new GameEntityViewMap();
        gameViewCache.putAll(spabs);
        return gameViewCache;
    }

    protected GameEntityView(int id0, Tracker tracker) {
        super(id0, tracker);
    }

    public String getName() {
        return (String)this.get(TrackableProperty.Name);
    }

    protected void updateName(GameEntity e) {
        this.set(TrackableProperty.Name, e.getName());
    }

    public int getPreventNextDamage() {
        return (Integer)this.get(TrackableProperty.PreventNextDamage);
    }

    public void updatePreventNextDamage(GameEntity e) {
        this.set(TrackableProperty.PreventNextDamage, e.getPreventNextDamageTotalShields());
    }

    public Iterable<CardView> getAttachedCards() {
        Iterable<CardView> active;
        if (this.hasAnyCardAttachments() && !Iterables.isEmpty(active = Iterables.filter((Iterable)this.get(TrackableProperty.AttachedCards), c -> !c.isPhasedOut()))) {
            return active;
        }
        return null;
    }

    public boolean hasCardAttachments() {
        return this.getAttachedCards() != null;
    }

    public Iterable<CardView> getAllAttachedCards() {
        return (Iterable)this.get(TrackableProperty.AttachedCards);
    }

    public boolean hasAnyCardAttachments() {
        return this.getAllAttachedCards() != null;
    }

    protected void updateAttachedCards(GameEntity e) {
        if (!e.getAllAttachedCards().isEmpty()) {
            this.set(TrackableProperty.AttachedCards, CardView.getCollection(e.getAllAttachedCards()));
        } else {
            this.set(TrackableProperty.AttachedCards, null);
        }
    }
}

