/*
 * Decompiled with CFR 0.152.
 */
package forge.game;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import forge.card.CardStateName;
import forge.card.MagicColor;
import forge.card.mana.ManaAtom;
import forge.game.Game;
import forge.game.GameObject;
import forge.game.IHasSVars;
import forge.game.PlanarDice;
import forge.game.ability.AbilityUtils;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.card.CardLists;
import forge.game.card.CardPredicates;
import forge.game.card.CardState;
import forge.game.card.CardView;
import forge.game.card.IHasCardView;
import forge.game.keyword.Keyword;
import forge.game.keyword.KeywordInterface;
import forge.game.player.GameLossReason;
import forge.game.player.Player;
import forge.game.spellability.SpellAbility;
import forge.game.trigger.Trigger;
import forge.game.zone.ZoneType;
import forge.util.Expressions;
import forge.util.ITranslatable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public abstract class CardTraitBase
extends GameObject
implements IHasCardView,
IHasSVars {
    protected Card hostCard;
    protected CardState cardState = null;
    protected KeywordInterface keyword = null;
    protected Map<String, String> originalMapParams = Maps.newHashMap();
    protected Map<String, String> mapParams = Maps.newHashMap();
    protected boolean intrinsic;
    protected boolean suppressed = false;
    protected Map<String, String> sVars = Maps.newTreeMap();
    protected Map<String, String> intrinsicChangedTextColors = Maps.newHashMap();
    protected Map<String, String> intrinsicChangedTextTypes = Maps.newHashMap();
    protected Map<String, String> changedTextColors = Maps.newHashMap();
    protected Map<String, String> changedTextTypes = Maps.newHashMap();
    private static final ImmutableList<String> descriptiveKeys = ((ImmutableList.Builder)ImmutableList.builder().add(new String[]{"Description", "SpellDescription", "StackDescription", "TriggerDescription"})).build();
    private static final ImmutableList<String> noChangeKeys = ((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().add(new String[]{"TokenScript", "TokenImage", "NewName", "DefinedName", "ChooseFromList"})).add("AddAbility")).build();

    public final Map<String, String> getMapParams() {
        return this.mapParams;
    }

    public String getParamOrDefault(String key, String defaultValue) {
        String param = this.mapParams.get(key);
        return param != null ? param : defaultValue;
    }

    public String getParam(String key) {
        return this.mapParams.get(key);
    }

    public String getOriginalParam(String key) {
        return this.originalMapParams.get(key);
    }

    public boolean hasParam(String key) {
        return this.mapParams.containsKey(key);
    }

    public String putParam(String key, String value) {
        return this.mapParams.put(key, value);
    }

    public void removeParam(String key) {
        this.mapParams.remove(key);
    }

    public final Map<String, String> getOriginalMapParams() {
        return this.originalMapParams;
    }

    public boolean isIntrinsic() {
        return this.intrinsic;
    }

    public void setIntrinsic(boolean i) {
        this.intrinsic = i;
    }

    public Card getHostCard() {
        return this.hostCard;
    }

    public void setHostCard(Card c) {
        this.hostCard = c;
    }

    public boolean isKeyword(Keyword kw) {
        return this.keyword != null && this.keyword.getKeyword() == kw;
    }

    public KeywordInterface getKeyword() {
        return this.keyword;
    }

    public void setKeyword(KeywordInterface kw) {
        this.keyword = kw;
    }

    public boolean isEmbalm() {
        return this.isKeyword(Keyword.EMBALM);
    }

    public boolean isEternalize() {
        return this.isKeyword(Keyword.ETERNALIZE);
    }

    public boolean isSecondary() {
        return this.getParamOrDefault("Secondary", "False").equals("True");
    }

    public final boolean isClassAbility() {
        return this.hasParam("ClassLevel");
    }

    public final boolean isClassLevelNAbility(int level) {
        String classLevel = this.getParamOrDefault("ClassLevel", "0");
        if (!StringUtils.isNumeric(classLevel)) {
            classLevel = classLevel.substring(2);
        }
        return level == Integer.parseInt(classLevel);
    }

    public boolean matchesValid(Object o, String[] valids, Card srcCard) {
        if (srcCard == null) {
            return false;
        }
        Player controller = srcCard.getController();
        if (this instanceof Trigger && ((Trigger)this).getSpawningAbility() != null) {
            controller = ((Trigger)this).getSpawningAbility().getActivatingPlayer();
        }
        return this.matchesValid(o, valids, srcCard, controller);
    }

    public boolean matchesValid(Object o, String[] valids, Card srcCard, Player srcPlayer) {
        block6: {
            block8: {
                block7: {
                    block5: {
                        if (o instanceof GameObject) {
                            GameObject c = (GameObject)o;
                            return c.isValid(valids, srcPlayer, srcCard, this);
                        }
                        if (!(o instanceof Iterable)) break block5;
                        for (Object o2 : (Iterable)o) {
                            if (!this.matchesValid(o2, valids, srcCard, srcPlayer)) continue;
                            return true;
                        }
                        break block6;
                    }
                    if (!(o instanceof String)) break block7;
                    if (ArrayUtils.contains(valids, o)) {
                        return true;
                    }
                    break block6;
                }
                if (!(o instanceof PlanarDice)) break block8;
                for (String s2 : valids) {
                    PlanarDice valid = PlanarDice.smartValueOf(s2);
                    if (!((PlanarDice)((Object)o)).name().equals(valid.name())) continue;
                    return true;
                }
                break block6;
            }
            if (!(o instanceof GameLossReason)) break block6;
            for (String s3 : valids) {
                GameLossReason valid = GameLossReason.smartValueOf(s3);
                if (!((GameLossReason)((Object)o)).name().equals(valid.name())) continue;
                return true;
            }
        }
        return false;
    }

    public boolean matchesValid(Object o, String[] valids) {
        return this.matchesValid(o, valids, this.getHostCard());
    }

    public boolean matchesValidParam(String param, Object o, Card srcCard) {
        boolean result = this.hasParam("Invert" + param);
        if (this.hasParam(param) && !this.matchesValid(o, this.getParam(param).split(","), srcCard)) {
            return result;
        }
        return !result;
    }

    public boolean matchesValidParam(String param, Object o) {
        return this.matchesValidParam(param, o, this.getHostCard());
    }

    public final void setSuppressed(boolean supp) {
        this.suppressed = supp;
    }

    public final boolean isSuppressed() {
        return this.suppressed;
    }

    protected boolean meetsCommonRequirements(Map<String, String> params) {
        int levelMin;
        int level;
        SpellAbility castSA;
        int left;
        int right;
        ZoneType presentZone;
        String presentPlayer;
        String sIsPresent;
        SpellAbility sa;
        Player hostController = this.getHostCard().getController();
        Game game = hostController.getGame();
        if (!game.getStack().isEmpty() && game.getStack().isResolving(this.getHostCard()) && (sa = game.getStack().peek().getSpellAbility()).isTrigger()) {
            hostController = sa.getActivatingPlayer();
        }
        if (params.containsKey("Metalcraft") && "True".equalsIgnoreCase(params.get("Metalcraft")) != hostController.hasMetalcraft()) {
            return false;
        }
        if (params.containsKey("Delirium") && "True".equalsIgnoreCase(params.get("Delirium")) != hostController.hasDelirium()) {
            return false;
        }
        if (params.containsKey("Threshold") && "True".equalsIgnoreCase(params.get("Threshold")) != hostController.hasThreshold()) {
            return false;
        }
        if (params.containsKey("Hellbent") && "True".equalsIgnoreCase(params.get("Hellbent")) != hostController.hasHellbent()) {
            return false;
        }
        if (params.containsKey("Bloodthirst") && "True".equalsIgnoreCase(params.get("Bloodthirst")) != hostController.hasBloodthirst()) {
            return false;
        }
        if (params.containsKey("FatefulHour") && "True".equalsIgnoreCase(params.get("FatefulHour")) != hostController.getLife() <= 5) {
            return false;
        }
        if (params.containsKey("Monarch") && "True".equalsIgnoreCase(params.get("Monarch")) != hostController.isMonarch()) {
            return false;
        }
        if (params.containsKey("Revolt")) {
            if ("True".equalsIgnoreCase(params.get("Revolt")) != hostController.hasRevolt()) {
                return false;
            }
            if ("None".equalsIgnoreCase(params.get("Revolt"))) {
                boolean none = true;
                for (Player p : game.getRegisteredPlayers()) {
                    if (!p.hasRevolt()) continue;
                    none = false;
                    break;
                }
                if (!none) {
                    return false;
                }
            }
        }
        if (params.containsKey("Desert") && "True".equalsIgnoreCase(params.get("Desert")) != hostController.hasDesert()) {
            return false;
        }
        if (params.containsKey("Blessing") && "True".equalsIgnoreCase(params.get("Blessing")) != hostController.hasBlessing()) {
            return false;
        }
        if (params.containsKey("DayTime") && ("Day".equalsIgnoreCase(params.get("DayTime")) ? !game.isDay() : ("Night".equalsIgnoreCase(params.get("DayTime")) ? !game.isNight() : "Neither".equalsIgnoreCase(params.get("DayTime")) && !game.isNeitherDayNorNight()))) {
            return false;
        }
        if (params.containsKey("Adamant")) {
            if (this.hostCard.getCastSA() == null) {
                return false;
            }
            String payingMana = StringUtils.join(this.hostCard.getCastSA().getPayingMana());
            String color = params.get("Adamant");
            if ("Any".equals(color)) {
                boolean bFlag = false;
                for (byte c : MagicColor.WUBRG) {
                    if (StringUtils.countMatches((CharSequence)payingMana, MagicColor.toShortString(c)) < 3) continue;
                    bFlag = true;
                    break;
                }
                if (!bFlag) {
                    return false;
                }
            } else if (StringUtils.countMatches((CharSequence)payingMana, MagicColor.toShortString(color)) < 3) {
                return false;
            }
        }
        if (params.containsKey("Presence")) {
            int ctrl;
            if (this.hostCard.getCastFrom() == null || this.hostCard.getCastSA() == null) {
                return false;
            }
            String type = params.get("Presence");
            int revealed = AbilityUtils.calculateAmount(this.hostCard, "Revealed$Valid " + type, this.hostCard.getCastSA());
            if (revealed + (ctrl = AbilityUtils.calculateAmount(this.hostCard, "Count$LastStateBattlefield " + type + ".YouCtrl", this.hostCard.getCastSA())) == 0) {
                return false;
            }
        }
        if (params.containsKey("LifeTotal")) {
            String player = params.get("LifeTotal");
            String lifeCompare = this.getParamOrDefault("LifeAmount", "GE1");
            int life = 1;
            if (player.equals("You")) {
                life = hostController.getLife();
            }
            if (player.equals("OpponentSmallest")) {
                life = hostController.getOpponentsSmallestLifeTotal();
            }
            if (player.equals("OpponentGreatest")) {
                life = hostController.getOpponentsGreatestLifeTotal();
            }
            if (player.equals("ActivePlayer")) {
                life = game.getPhaseHandler().getPlayerTurn().getLife();
            }
            String rightString = lifeCompare.substring(2);
            int right2 = AbilityUtils.calculateAmount(this.getHostCard(), rightString, this);
            if (!Expressions.compare(life, lifeCompare, right2)) {
                return false;
            }
        }
        if (params.containsKey("IsPresent")) {
            CardCollection list;
            sIsPresent = params.get("IsPresent");
            String presentCompare = this.getParamOrDefault("PresentCompare", "GE1");
            presentPlayer = this.getParamOrDefault("PresentPlayer", "Any");
            presentZone = ZoneType.Battlefield;
            if (params.containsKey("PresentZone")) {
                presentZone = ZoneType.smartValueOf(params.get("PresentZone"));
            }
            if (params.containsKey("PresentDefined")) {
                list = AbilityUtils.getDefinedCards(this.getHostCard(), params.get("PresentDefined"), this);
            } else {
                list = new CardCollection();
                if (presentPlayer.equals("You") || presentPlayer.equals("Any")) {
                    list.addAll(hostController.getCardsIn(presentZone));
                }
                if (presentPlayer.equals("Opponent") || presentPlayer.equals("Any")) {
                    list.addAll(hostController.getOpponents().getCardsIn(presentZone));
                }
                if (presentPlayer.equals("Any")) {
                    list.addAll(hostController.getAllies().getCardsIn(presentZone));
                }
            }
            list = CardLists.getValidCards((Iterable<Card>)list, sIsPresent, hostController, this.getHostCard(), this);
            String rightString = presentCompare.substring(2);
            right = AbilityUtils.calculateAmount(this.getHostCard(), rightString, this);
            left = list.size();
            if (!Expressions.compare(left, presentCompare, right)) {
                return false;
            }
        }
        if (params.containsKey("IsPresent2")) {
            sIsPresent = params.get("IsPresent2");
            String presentCompare = this.getParamOrDefault("PresentCompare2", "GE1");
            presentPlayer = this.getParamOrDefault("PresentPlayer2", "Any");
            presentZone = ZoneType.Battlefield;
            if (params.containsKey("PresentZone2")) {
                presentZone = ZoneType.smartValueOf(params.get("PresentZone2"));
            }
            CardCollection list = new CardCollection();
            if (presentPlayer.equals("You") || presentPlayer.equals("Any")) {
                list.addAll(hostController.getCardsIn(presentZone));
            }
            if (presentPlayer.equals("Opponent") || presentPlayer.equals("Any")) {
                list.addAll(hostController.getOpponents().getCardsIn(presentZone));
            }
            list = CardLists.getValidCards((Iterable<Card>)list, sIsPresent, hostController, this.getHostCard(), this);
            String rightString = presentCompare.substring(2);
            right = AbilityUtils.calculateAmount(this.getHostCard(), rightString, this);
            left = list.size();
            if (!Expressions.compare(left, presentCompare, right)) {
                return false;
            }
        }
        if (params.containsKey("CheckDefinedPlayer")) {
            sIsPresent = params.get("CheckDefinedPlayer");
            int playersize = AbilityUtils.getDefinedPlayers(this.getHostCard(), sIsPresent, this).size();
            String comparator = this.getParamOrDefault("DefinedPlayerCompare", "GE1");
            String svarOperator = comparator.substring(0, 2);
            String svarOperand = comparator.substring(2);
            int operandValue = AbilityUtils.calculateAmount(this.getHostCard(), svarOperand, this);
            if (!Expressions.compare(playersize, svarOperator, operandValue)) {
                return false;
            }
        }
        if (params.containsKey("CheckSVar")) {
            int sVar = AbilityUtils.calculateAmount(this.getHostCard(), params.get("CheckSVar"), this);
            String comparator = this.getParamOrDefault("SVarCompare", "GE1");
            String svarOperator = comparator.substring(0, 2);
            String svarOperand = comparator.substring(2);
            int operandValue = AbilityUtils.calculateAmount(this.getHostCard(), svarOperand, this);
            if (!Expressions.compare(sVar, svarOperator, operandValue)) {
                return false;
            }
            if (this.hasParam("CheckSecondSVar")) {
                int sVar2 = AbilityUtils.calculateAmount(this.hostCard, this.getParam("CheckSecondSVar"), this);
                String comparator2 = this.getParamOrDefault("SecondSVarCompare", "GE1");
                String svarOperator2 = comparator2.substring(0, 2);
                String svarOperand2 = comparator2.substring(2);
                int operandValue2 = AbilityUtils.calculateAmount(this.getHostCard(), svarOperand2, this);
                if (!Expressions.compare(sVar2, svarOperator2, operandValue2)) {
                    return false;
                }
            }
        }
        if (params.containsKey("ManaSpent")) {
            SpellAbility castSA2 = this.getHostCard().getCastSA();
            if (castSA2 == null) {
                return false;
            }
            if (!castSA2.getPayingColors().hasAllColors(ManaAtom.fromName(params.get("ManaSpent")))) {
                return false;
            }
        }
        if (params.containsKey("ManaNotSpent") && (castSA = this.getHostCard().getCastSA()) != null && castSA.getPayingColors().hasAllColors(ManaAtom.fromName(params.get("ManaNotSpent")))) {
            return false;
        }
        if (params.containsKey("WerewolfTransformCondition") && !game.getStack().getSpellsCastLastTurn().isEmpty()) {
            return false;
        }
        if (params.containsKey("WerewolfUntransformCondition")) {
            List<Card> casted = game.getStack().getSpellsCastLastTurn();
            boolean conditionMet = false;
            for (Player p : game.getPlayers()) {
                if (CardLists.count(casted, CardPredicates.isController(p)) <= 1) continue;
                conditionMet = true;
                break;
            }
            if (!conditionMet) {
                return false;
            }
        }
        if (params.containsKey("ActivateNoLoyaltyAbilitiesCondition")) {
            Player active = game.getPhaseHandler().getPlayerTurn();
            return !active.getActivateLoyaltyAbilityThisTurn();
        }
        return !params.containsKey("ClassLevel") || (level = this.getHostCard().getClassLevel()) >= (levelMin = Integer.parseInt(params.get("ClassLevel")));
    }

    @Override
    public CardView getCardView() {
        return CardView.get(this.hostCard);
    }

    protected IHasSVars getSVarFallback() {
        if (this.getKeyword() != null && this.getKeyword().getStatic() != null) {
            return this.getKeyword().getStatic();
        }
        if (this.getCardState() != null) {
            return this.getCardState();
        }
        return this.getHostCard();
    }

    @Override
    public String getSVar(String name) {
        if (this.sVars.containsKey(name)) {
            return this.sVars.get(name);
        }
        return this.getSVarFallback().getSVar(name);
    }

    @Override
    public boolean hasSVar(String name) {
        return this.sVars.containsKey(name) || this.getSVarFallback().hasSVar(name);
    }

    public Integer getSVarInt(String name) {
        String var = this.getSVar(name);
        if (var != null) {
            try {
                return Integer.parseInt(var);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public final void setSVar(String name, String value) {
        this.sVars.put(name, value);
    }

    @Override
    public Map<String, String> getSVars() {
        HashMap<String, String> res = Maps.newHashMap(this.getSVarFallback().getSVars());
        res.putAll(this.sVars);
        return res;
    }

    @Override
    public Map<String, String> getDirectSVars() {
        return this.sVars;
    }

    @Override
    public void setSVars(Map<String, String> newSVars) {
        this.sVars = Maps.newTreeMap();
        this.sVars.putAll(newSVars);
    }

    @Override
    public void removeSVar(String var) {
        this.sVars.remove(var);
    }

    public CardState getCardState() {
        return this.cardState;
    }

    public void setCardState(CardState state) {
        this.cardState = state;
    }

    public CardStateName getCardStateName() {
        if (this.getCardState() == null) {
            return null;
        }
        return this.getCardState().getView().getState();
    }

    public ITranslatable getHostName(CardTraitBase node) {
        if (node.isIntrinsic() && node.cardState != null && !node.cardState.getStateName().equals((Object)this.getHostCard().getCurrentStateName())) {
            return node.cardState;
        }
        return node.getHostCard();
    }

    public Card getOriginalHost() {
        if (this.getCardState() != null) {
            return this.getCardState().getCard();
        }
        return null;
    }

    public boolean isCopiedTrait() {
        if (this.getCardState() == null) {
            return false;
        }
        return !this.getHostCard().equals(this.getCardState().getCard());
    }

    public Map<String, String> getChangedTextColors() {
        return this._combineChangedMap(this.intrinsicChangedTextColors, this.changedTextColors);
    }

    public Map<String, String> getChangedTextTypes() {
        return this._combineChangedMap(this.intrinsicChangedTextTypes, this.changedTextTypes);
    }

    private Map<String, String> _combineChangedMap(Map<String, String> input, Map<String, String> output) {
        if (input.isEmpty()) {
            return output;
        }
        if (output.isEmpty()) {
            return input;
        }
        HashMap<String, String> result = Maps.newHashMap(output);
        for (Map.Entry<String, String> e : input.entrySet()) {
            String value = e.getValue();
            result.put(e.getKey(), output.getOrDefault(value, value));
        }
        return result;
    }

    public void changeTextIntrinsic(Map<String, String> colorMap, Map<String, String> typeMap) {
        this.intrinsicChangedTextColors = colorMap;
        this.intrinsicChangedTextTypes = typeMap;
        for (String key : this.mapParams.keySet()) {
            String newValue;
            String value = this.originalMapParams.get(key);
            if (noChangeKeys.contains(key)) continue;
            if (descriptiveKeys.contains(key)) {
                newValue = AbilityUtils.applyTextChangeEffects(value, true, colorMap, typeMap);
            } else {
                if (this.getHostCard().hasSVar(value)) continue;
                newValue = AbilityUtils.applyTextChangeEffects(value, false, colorMap, typeMap);
            }
            if (newValue == null) continue;
            this.mapParams.put(key, newValue);
        }
        this.originalMapParams = Maps.newHashMap(this.mapParams);
    }

    public void changeText() {
        this.changedTextColors = this.getHostCard().getChangedTextColorWords();
        this.changedTextTypes = this.getHostCard().getChangedTextTypeWords();
        for (String key : this.mapParams.keySet()) {
            Object newValue;
            String value = this.originalMapParams.get(key);
            if (noChangeKeys.contains(key) || (newValue = descriptiveKeys.contains(key) ? AbilityUtils.applyDescriptionTextChangeEffects(value, this) : (this.getHostCard().hasSVar(value) ? null : AbilityUtils.applyAbilityTextChangeEffects(value, this))) == null) continue;
            this.mapParams.put(key, (String)newValue);
        }
    }

    protected void copyHelper(CardTraitBase copy, Card host) {
        this.copyHelper(copy, host, false);
    }

    protected void copyHelper(CardTraitBase copy, Card host, boolean keepTextChanges) {
        copy.originalMapParams = Maps.newHashMap(this.originalMapParams);
        copy.mapParams = Maps.newHashMap(keepTextChanges ? this.mapParams : this.originalMapParams);
        copy.setSVars(this.sVars);
        copy.setCardState(this.cardState);
        copy.hostCard = host;
        copy.keyword = this.keyword;
    }

    public abstract List<Object> getTriggerRemembered();
}

