/*
 * Decompiled with CFR 0.152.
 */
package forge.error;

import forge.Forge;
import forge.Graphics;
import forge.assets.FSkinColor;
import forge.assets.FSkinFont;
import forge.gui.error.BugReporter;
import forge.screens.FScreen;
import forge.toolbox.FButton;
import forge.toolbox.FScrollPane;
import forge.toolbox.FTextArea;
import forge.util.Callback;
import forge.util.TextBounds;
import forge.util.Utils;

public class BugReportDialog
extends FScreen {
    private static final float PADDING = Utils.scale(5.0f);
    private static final float BUTTON_HEIGHT = Utils.AVG_FINGER_HEIGHT * 0.75f;
    private static boolean isOpen;
    private final FTextArea lblHeader = this.add(new FTextArea(false, "Report Bug"));
    private final TemplateView tvDetails;
    private final FButton btnReport = this.add(new FButton(BugReporter.REPORT));
    private final FButton btnSave = this.add(new FButton(BugReporter.SAVE));
    private final FButton btnDiscard = this.add(new FButton(BugReporter.DISCARD));
    private final FButton btnExit = this.add(new FButton(BugReporter.EXIT));

    public static void show(String title, String text, boolean showExitAppBtn) {
        if (isOpen || Forge.getCurrentScreen() == null) {
            return;
        }
        isOpen = true;
        Forge.openScreen(new BugReportDialog(title, text, showExitAppBtn));
    }

    private BugReportDialog(String title, String text0, boolean showExitAppBtn) {
        super(title);
        this.lblHeader.setFont(FSkinFont.get(12));
        this.tvDetails = this.add(new TemplateView(text0));
        this.btnReport.setCommand(e -> {
            BugReporter.sendSentry();
            Forge.back();
        });
        this.btnSave.setCommand(e -> BugReporter.saveToFile(this.tvDetails.text));
        this.btnDiscard.setCommand(e -> Forge.back());
        if (showExitAppBtn) {
            this.btnExit.setCommand(e -> Forge.exit(true));
        } else {
            this.btnExit.setVisible(false);
        }
    }

    @Override
    public FScreen getLandscapeBackdropScreen() {
        return null;
    }

    @Override
    public void onClose(Callback<Boolean> canCloseCallback) {
        super.onClose(canCloseCallback);
        isOpen = false;
    }

    @Override
    protected void doLayout(float startY, float width, float height) {
        float totalButtonHeight;
        float buttonWidth;
        float x = PADDING;
        float y = startY + PADDING;
        float w = width - 2.0f * PADDING;
        this.lblHeader.setBounds(x, y, w, this.lblHeader.getPreferredHeight(w));
        y += this.lblHeader.getHeight() + PADDING;
        float buttonHeight = BUTTON_HEIGHT;
        boolean landscapeMode = Forge.isLandscapeMode();
        if (landscapeMode) {
            buttonWidth = (w - 3.0f * PADDING) / 4.0f;
            totalButtonHeight = buttonHeight;
        } else {
            buttonWidth = (w - PADDING) / 2.0f;
            totalButtonHeight = 2.0f * buttonHeight + PADDING;
        }
        this.tvDetails.setBounds(x, y, w, height - totalButtonHeight - 2.0f * PADDING - y);
        this.btnReport.setBounds(x, y += this.tvDetails.getHeight() + PADDING, buttonWidth, buttonHeight);
        this.btnSave.setBounds(x + buttonWidth + PADDING, y, buttonWidth, buttonHeight);
        if (landscapeMode) {
            x += 2.0f * (buttonWidth + PADDING);
        } else {
            y += buttonHeight + PADDING;
        }
        if (this.btnExit.isVisible()) {
            this.btnDiscard.setBounds(x, y, buttonWidth, buttonHeight);
            this.btnExit.setBounds(x + buttonWidth + PADDING, y, buttonWidth, buttonHeight);
        } else {
            this.btnDiscard.setBounds(x, y, 2.0f * buttonWidth + PADDING, buttonHeight);
        }
    }

    private static class TemplateView
    extends FScrollPane {
        private static final FSkinFont FONT = FSkinFont.get(11);
        private static final FSkinColor BACK_COLOR = FSkinColor.get(FSkinColor.Colors.CLR_ZEBRA);
        private static final FSkinColor FORE_COLOR = FSkinColor.get(FSkinColor.Colors.CLR_TEXT);
        private static final FSkinColor BORDER_COLOR = FSkinColor.get(FSkinColor.Colors.CLR_BORDERS);
        private static final float PADDING = Utils.scale(3.0f);
        private final String text;

        private TemplateView(String text0) {
            this.text = text0;
            this.setHeight(Forge.getScreenHeight() / 3);
        }

        @Override
        protected FScrollPane.ScrollBounds layoutAndGetScrollBounds(float visibleWidth, float visibleHeight) {
            TextBounds bounds = FONT.getMultiLineBounds(this.text);
            return new FScrollPane.ScrollBounds(bounds.width + 2.0f * PADDING, bounds.height + 2.0f * PADDING + FONT.getLineHeight() - FONT.getCapHeight());
        }

        @Override
        public void drawBackground(Graphics g2) {
            g2.fillRect(BACK_COLOR, 0.0f, 0.0f, this.getWidth(), this.getHeight());
            g2.drawText(this.text, FONT, FORE_COLOR, PADDING - this.getScrollLeft(), PADDING - this.getScrollTop(), this.getScrollWidth() - 2.0f * PADDING, this.getScrollHeight() - 2.0f * PADDING, false, 8, false);
        }

        @Override
        public void drawOverlay(Graphics g2) {
            super.drawOverlay(g2);
            g2.drawRect(1.0f, BORDER_COLOR, 0.0f, 0.0f, this.getWidth(), this.getHeight());
        }
    }
}

