/*
 * Decompiled with CFR 0.152.
 */
package forge.deck.io;

import com.google.common.collect.ImmutableList;
import forge.deck.Deck;
import forge.deck.DeckBase;
import forge.deck.DeckGroup;
import forge.deck.io.DeckSerializer;
import forge.util.IItemSerializer;
import forge.util.storage.StorageReaderFolder;
import java.io.File;
import java.io.FilenameFilter;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class DeckGroupSerializer
extends StorageReaderFolder<DeckGroup>
implements IItemSerializer<DeckGroup> {
    private static final String humanDeckFile = "human.dck";
    private final String rootDir;
    public static final int MAX_DRAFT_PLAYERS = 8;

    public DeckGroupSerializer(File deckDir0, String rootDir0) {
        super(deckDir0, DeckBase::getName);
        this.rootDir = rootDir0;
    }

    @Override
    public void save(DeckGroup unit) {
        File f = this.makeFileFor(unit);
        f.mkdir();
        DeckSerializer.writeDeck(unit.getHumanDeck(), new File(f, humanDeckFile));
        List<Deck> aiDecks = unit.getAiDecks();
        for (int i = 1; i <= aiDecks.size(); ++i) {
            DeckSerializer.writeDeck(aiDecks.get(i - 1), new File(f, "ai-" + i + ".dck"));
        }
    }

    @Override
    protected final DeckGroup read(File file) {
        File theFile;
        Deck humanDeck = DeckSerializer.fromFile(new File(file, humanDeckFile));
        if (humanDeck == null) {
            return null;
        }
        DeckGroup d = new DeckGroup(humanDeck.getName());
        d.setDirectory(file.getParent().substring(this.rootDir.length()));
        d.setHumanDeck(humanDeck);
        for (int i = 1; i < 8 && (theFile = new File(file, "ai-" + i + ".dck")).exists(); ++i) {
            d.addAiDeck(DeckSerializer.fromFile(theFile));
        }
        return d;
    }

    @Override
    public void erase(DeckGroup unit) {
        File[] files;
        File dir = this.makeFileFor(unit);
        for (File f : files = dir.listFiles()) {
            f.delete();
        }
        dir.delete();
    }

    public File makeFileFor(DeckGroup decks) {
        return new File(this.directory, decks.getBestFileName());
    }

    @Override
    protected FilenameFilter getFileFilter() {
        return (dir, name) -> {
            File testSubject = new File(dir, name);
            boolean isVisibleFolder = testSubject.isDirectory() && !testSubject.isHidden();
            boolean hasGoodName = StringUtils.isNotEmpty(name) && !name.startsWith(".");
            File fileHumanDeck = new File(testSubject, humanDeckFile);
            return isVisibleFolder && hasGoodName && fileHumanDeck.exists();
        };
    }

    @Override
    public Iterable<File> getSubFolders() {
        return ImmutableList.of();
    }
}

