/*
 * Decompiled with CFR 0.152.
 */
package forge.deck.generation;

import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import forge.card.ColorSet;
import forge.card.MagicColor;
import forge.deck.CardPool;
import forge.deck.DeckFormat;
import forge.deck.generation.DeckGeneratorBase;
import forge.deck.generation.IDeckGenPool;
import forge.item.PaperCard;
import forge.util.MyRandom;
import java.util.List;
import org.apache.commons.lang3.tuple.ImmutablePair;

public class DeckGeneratorMonoColor
extends DeckGeneratorBase {
    final List<ImmutablePair<DeckGeneratorBase.FilterCMC, Integer>> cmcLevels = Lists.newArrayList(ImmutablePair.of(new DeckGeneratorBase.FilterCMC(0, 2), 10), ImmutablePair.of(new DeckGeneratorBase.FilterCMC(3, 4), 8), ImmutablePair.of(new DeckGeneratorBase.FilterCMC(5, 6), 5), ImmutablePair.of(new DeckGeneratorBase.FilterCMC(7, 20), 3));

    @Override
    protected final float getLandPercentage() {
        return 0.4f;
    }

    @Override
    protected final float getCreaturePercentage() {
        return 0.35f;
    }

    @Override
    protected final float getSpellPercentage() {
        return 0.25f;
    }

    public DeckGeneratorMonoColor(IDeckGenPool pool0, DeckFormat format0, Predicate<PaperCard> formatFilter0, String clr1) {
        super(pool0, format0, formatFilter0);
        this.initialize(clr1);
    }

    public DeckGeneratorMonoColor(IDeckGenPool pool0, DeckFormat format0, String clr1) {
        super(pool0, format0);
        this.initialize(clr1);
    }

    public void initialize(String clr1) {
        if (MagicColor.fromName(clr1) == 0) {
            int color1 = MyRandom.getRandom().nextInt(5);
            this.colors = ColorSet.fromMask(1 << color1);
        } else {
            this.colors = ColorSet.fromNames(clr1);
        }
    }

    @Override
    public final CardPool getDeck(int size, boolean forAi) {
        this.addCreaturesAndSpells(size, this.cmcLevels, forAi);
        int numLands = Math.round((float)size * this.getLandPercentage());
        this.trace.append("numLands:").append(numLands).append("\n");
        this.addBasicLand(numLands);
        this.trace.append("DeckSize:").append(this.tDeck.countAll()).append("\n");
        this.adjustDeckSize(size);
        this.trace.append("DeckSize:").append(this.tDeck.countAll()).append("\n");
        return this.tDeck;
    }
}

