/*
 * Decompiled with CFR 0.152.
 */
package forge.deck;

import forge.Forge;
import forge.assets.FImage;
import forge.assets.FSkin;
import forge.assets.FSkinImage;
import forge.assets.FTextureRegionImage;
import forge.assets.ImageCache;
import forge.deck.CardPool;
import forge.deck.Deck;
import forge.deck.DeckSection;
import forge.deck.FDeckEditor;
import forge.item.PaperCard;
import forge.itemmanager.CardManager;
import forge.itemmanager.ItemManagerConfig;
import forge.itemmanager.filters.ItemFilter;
import forge.menu.FMenuItem;
import forge.menu.FPopupMenu;
import forge.screens.FScreen;
import forge.screens.match.MatchController;
import forge.toolbox.FOptionPane;
import java.util.Map;

public class FDeckViewer
extends FScreen {
    private static FDeckViewer deckViewer;
    private static FPopupMenu menu;
    private final Deck deck;
    private final CardManager cardManager;
    private DeckSection currentSection;

    public static void copyDeckToClipboard(Deck deck) {
        String nl = System.lineSeparator();
        StringBuilder deckList = new StringBuilder();
        String dName = deck.getName();
        if (dName.startsWith("[Commander") || dName.contains("Commander")) {
            dName = "";
        }
        deckList.append(dName == null ? "" : "Deck: " + dName + nl + nl);
        for (DeckSection s2 : DeckSection.values()) {
            CardPool cp = deck.get(s2);
            if (cp == null || cp.isEmpty()) continue;
            deckList.append(s2.toString()).append(": ");
            deckList.append(nl);
            for (Map.Entry ev : cp) {
                deckList.append(ev.getValue()).append(" ").append(((PaperCard)ev.getKey()).getCardName()).append(nl);
            }
            deckList.append(nl);
        }
        Forge.getClipboard().setContents(deckList.toString());
        FOptionPane.showMessageDialog(Forge.getLocalizer().getMessage("lblDeckListCopiedClipboard", deck.getName()));
    }

    public static void show(Deck deck0) {
        FDeckViewer.show(deck0, false, false);
    }

    public static void show(Deck deck0, boolean noPreload) {
        FDeckViewer.show(deck0, noPreload, false);
    }

    public static void show(Deck deck0, boolean noPreload, boolean showRanking) {
        if (deck0 == null) {
            return;
        }
        if (!noPreload) {
            ImageCache.preloadCache(deck0);
        }
        deckViewer = new FDeckViewer(deck0, showRanking);
        deckViewer.setRotate180(MatchController.getView() != null && MatchController.getView().isTopHumanPlayerActive());
        Forge.openScreen(deckViewer);
    }

    private FDeckViewer(Deck deck0, boolean showRanking) {
        super(new FScreen.MenuHeader(deck0.getName(), menu){

            @Override
            protected boolean displaySidebarForLandscapeMode() {
                return false;
            }
        });
        this.deck = deck0;
        this.cardManager = new CardManager(false);
        this.cardManager.setPool(this.deck.getMain());
        this.cardManager.setShowRanking(showRanking);
        this.currentSection = DeckSection.Main;
        this.updateCaption();
        this.add(this.cardManager);
        this.cardManager.setup(ItemManagerConfig.DECK_VIEWER);
    }

    private void setCurrentSection(DeckSection currentSection0) {
        if (this.currentSection == currentSection0) {
            return;
        }
        this.currentSection = currentSection0;
        this.cardManager.setPool(this.deck.get(this.currentSection));
        this.updateCaption();
    }

    private void updateCaption() {
        this.cardManager.setCaption(this.currentSection.name());
    }

    @Override
    protected void doLayout(float startY, float width, float height) {
        float x = 0.0f;
        if (Forge.isLandscapeMode()) {
            x = ItemFilter.PADDING;
            width -= 2.0f * x;
        }
        this.cardManager.setBounds(x, startY, width, height - startY);
    }

    @Override
    public FScreen getLandscapeBackdropScreen() {
        return null;
    }

    static {
        menu = new FPopupMenu(){

            @Override
            protected void buildMenu() {
                Deck deck = deckViewer.deck;
                for (Map.Entry<DeckSection, CardPool> entry : deck) {
                    FImage icon;
                    String captionPrefix;
                    DeckSection section = entry.getKey();
                    CardPool pool = entry.getValue();
                    int count = pool.countAll();
                    if (count == 0) continue;
                    switch (section) {
                        default: {
                            captionPrefix = Forge.getLocalizer().getMessage("ttMain", new Object[0]);
                            icon = FDeckEditor.MAIN_DECK_ICON;
                            break;
                        }
                        case Sideboard: {
                            captionPrefix = Forge.getLocalizer().getMessage("lblSideboard", new Object[0]);
                            icon = FDeckEditor.SIDEBOARD_ICON;
                            break;
                        }
                        case Commander: {
                            captionPrefix = Forge.getLocalizer().getMessage("lblCommander", new Object[0]);
                            icon = FSkinImage.COMMANDER;
                            break;
                        }
                        case Avatar: {
                            captionPrefix = Forge.getLocalizer().getMessage("lblAvatar", new Object[0]);
                            icon = new FTextureRegionImage(FSkin.getAvatars().get(0));
                            break;
                        }
                        case Planes: {
                            captionPrefix = Forge.getLocalizer().getMessage("lblPlanes", new Object[0]);
                            icon = FSkinImage.CHAOS;
                            break;
                        }
                        case Schemes: {
                            captionPrefix = Forge.getLocalizer().getMessage("lblSchemes", new Object[0]);
                            icon = FSkinImage.POISON;
                        }
                    }
                    FMenuItem item = new FMenuItem(captionPrefix + " (" + count + ")", icon, e -> deckViewer.setCurrentSection(section));
                    if (section == deckViewer.currentSection) {
                        item.setSelected(true);
                    }
                    this.addItem(item);
                }
                this.addItem(new FMenuItem(Forge.getLocalizer().getMessage("btnCopyToClipboard", new Object[0]), Forge.hdbuttons ? FSkinImage.HDEXPORT : FSkinImage.BLANK, e -> FDeckViewer.copyDeckToClipboard(deckViewer.deck)));
            }
        };
    }
}

