/*
 * Decompiled with CFR 0.152.
 */
package forge.deck;

import com.badlogic.gdx.math.Vector2;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import forge.Forge;
import forge.Graphics;
import forge.assets.FImage;
import forge.assets.FSkin;
import forge.assets.FSkinFont;
import forge.assets.FSkinImage;
import forge.assets.FTextureRegionImage;
import forge.card.CardEdition;
import forge.deck.AddBasicLandsDialog;
import forge.deck.CardPool;
import forge.deck.Deck;
import forge.deck.DeckBase;
import forge.deck.DeckFormat;
import forge.deck.DeckGroup;
import forge.deck.DeckProxy;
import forge.deck.DeckSection;
import forge.deck.FDeckImportDialog;
import forge.deck.FDeckViewer;
import forge.deck.io.DeckPreferences;
import forge.gamemodes.limited.BoosterDraft;
import forge.gamemodes.planarconquest.ConquestUtil;
import forge.gui.GuiBase;
import forge.gui.card.CardPreferences;
import forge.item.PaperCard;
import forge.itemmanager.CardManager;
import forge.itemmanager.ColumnDef;
import forge.itemmanager.ItemColumn;
import forge.itemmanager.ItemManager;
import forge.itemmanager.ItemManagerConfig;
import forge.itemmanager.filters.ItemFilter;
import forge.localinstance.properties.ForgePreferences;
import forge.menu.FCheckBoxMenuItem;
import forge.menu.FDropDownMenu;
import forge.menu.FMenuItem;
import forge.menu.FPopupMenu;
import forge.model.FModel;
import forge.screens.FScreen;
import forge.screens.TabPageScreen;
import forge.toolbox.FContainer;
import forge.toolbox.FEvent;
import forge.toolbox.FLabel;
import forge.toolbox.FOptionPane;
import forge.toolbox.GuiChoose;
import forge.util.Callback;
import forge.util.ItemPool;
import forge.util.Lang;
import forge.util.Localizer;
import forge.util.Utils;
import forge.util.storage.IStorage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class FDeckEditor
extends TabPageScreen<FDeckEditor> {
    public static FSkinImage MAIN_DECK_ICON = Forge.hdbuttons ? FSkinImage.HDLIBRARY : FSkinImage.DECKLIST;
    public static FSkinImage SIDEBOARD_ICON = Forge.hdbuttons ? FSkinImage.HDSIDEBOARD : FSkinImage.FLASHBACK;
    private static final float HEADER_HEIGHT = Math.round(Utils.AVG_FINGER_HEIGHT * 0.8f);
    private final EditorType editorType;
    private Deck deck;
    private final List<DeckSection> hiddenExtraSections = new ArrayList<DeckSection>();
    private CatalogPage catalogPage;
    private DeckSectionPage mainDeckPage;
    private DeckSectionPage sideboardPage;
    private DeckSectionPage commanderPage;
    private final Map<DeckSection, DeckSectionPage> pagesBySection = new EnumMap<DeckSection, DeckSectionPage>(DeckSection.class);
    private final Set<DeckSection> variantCardPools = new HashSet<DeckSection>();
    private FEvent.FEventHandler saveHandler;
    protected final DeckHeader deckHeader = this.add(new DeckHeader());
    protected final FLabel lblName = this.deckHeader.add(new FLabel.Builder().font(FSkinFont.get(16)).insets(new Vector2(Utils.scale(5.0f), 0.0f)).build());
    private final FLabel btnSave = this.deckHeader.add(new FLabel.Builder().icon(Forge.hdbuttons ? FSkinImage.HDSAVE : FSkinImage.SAVE).align(1).pressedColor(FScreen.Header.getBtnPressedColor()).build());
    private final FLabel btnMoreOptions = this.deckHeader.add(new FLabel.Builder().text("...").font(FSkinFont.get(20)).align(1).pressedColor(FScreen.Header.getBtnPressedColor()).build());
    private static final ImmutableList<String> onCloseOptions = ImmutableList.of(Localizer.getInstance().getMessage("lblSave", new Object[0]), Localizer.getInstance().getMessage("lblDontSave", new Object[0]), Localizer.getInstance().getMessage("lblCancel", new Object[0]));

    private static DeckEditorPage[] getPages(EditorType editorType) {
        DeckEditorPage[] deckEditorPageArray;
        boolean isLandscape = Forge.isLandscapeMode();
        switch (editorType) {
            default: {
                return new DeckEditorPage[]{new CatalogPage(ItemManagerConfig.CARD_CATALOG), new DeckSectionPage(DeckSection.Main), new DeckSectionPage(DeckSection.Sideboard)};
            }
            case Draft: 
            case QuestDraft: {
                return new DeckEditorPage[]{new DraftPackPage(), new DeckSectionPage(DeckSection.Main), new DeckSectionPage(DeckSection.Sideboard, ItemManagerConfig.DRAFT_POOL)};
            }
            case Sealed: {
                return new DeckEditorPage[]{new DeckSectionPage(DeckSection.Main), new DeckSectionPage(DeckSection.Sideboard, ItemManagerConfig.SEALED_POOL)};
            }
            case Commander: 
            case TinyLeaders: 
            case Brawl: {
                DeckEditorPage[] deckEditorPageArray2;
                if (isLandscape) {
                    DeckEditorPage[] deckEditorPageArray3 = new DeckEditorPage[4];
                    deckEditorPageArray3[0] = new CatalogPage(ItemManagerConfig.CARD_CATALOG);
                    deckEditorPageArray3[1] = new DeckSectionPage(DeckSection.Commander, ItemManagerConfig.COMMANDER_SECTION);
                    deckEditorPageArray3[2] = new DeckSectionPage(DeckSection.Main);
                    deckEditorPageArray2 = deckEditorPageArray3;
                    deckEditorPageArray3[3] = new DeckSectionPage(DeckSection.Sideboard);
                } else {
                    DeckEditorPage[] deckEditorPageArray4 = new DeckEditorPage[4];
                    deckEditorPageArray4[0] = new CatalogPage(ItemManagerConfig.CARD_CATALOG);
                    deckEditorPageArray4[1] = new DeckSectionPage(DeckSection.Main);
                    deckEditorPageArray4[2] = new DeckSectionPage(DeckSection.Commander, ItemManagerConfig.COMMANDER_SECTION);
                    deckEditorPageArray2 = deckEditorPageArray4;
                    deckEditorPageArray4[3] = new DeckSectionPage(DeckSection.Sideboard);
                }
                return deckEditorPageArray2;
            }
            case Oathbreaker: {
                DeckEditorPage[] deckEditorPageArray5;
                if (isLandscape) {
                    DeckEditorPage[] deckEditorPageArray6 = new DeckEditorPage[4];
                    deckEditorPageArray6[0] = new CatalogPage(ItemManagerConfig.CARD_CATALOG);
                    deckEditorPageArray6[1] = new DeckSectionPage(DeckSection.Commander, ItemManagerConfig.OATHBREAKER_SECTION, Forge.getLocalizer().getMessage("lblOathbreaker", new Object[0]), FSkinImage.COMMANDER);
                    deckEditorPageArray6[2] = new DeckSectionPage(DeckSection.Main);
                    deckEditorPageArray5 = deckEditorPageArray6;
                    deckEditorPageArray6[3] = new DeckSectionPage(DeckSection.Sideboard);
                } else {
                    DeckEditorPage[] deckEditorPageArray7 = new DeckEditorPage[4];
                    deckEditorPageArray7[0] = new CatalogPage(ItemManagerConfig.CARD_CATALOG);
                    deckEditorPageArray7[1] = new DeckSectionPage(DeckSection.Main);
                    deckEditorPageArray7[2] = new DeckSectionPage(DeckSection.Commander, ItemManagerConfig.OATHBREAKER_SECTION, Forge.getLocalizer().getMessage("lblOathbreaker", new Object[0]), FSkinImage.COMMANDER);
                    deckEditorPageArray5 = deckEditorPageArray7;
                    deckEditorPageArray7[3] = new DeckSectionPage(DeckSection.Sideboard);
                }
                return deckEditorPageArray5;
            }
            case Archenemy: {
                return new DeckEditorPage[]{new CatalogPage(ItemManagerConfig.SCHEME_POOL), new DeckSectionPage(DeckSection.Schemes, ItemManagerConfig.SCHEME_DECK_EDITOR)};
            }
            case Planechase: {
                return new DeckEditorPage[]{new CatalogPage(ItemManagerConfig.PLANAR_POOL), new DeckSectionPage(DeckSection.Planes, ItemManagerConfig.PLANAR_DECK_EDITOR)};
            }
            case Quest: {
                return new DeckEditorPage[]{new CatalogPage(ItemManagerConfig.QUEST_EDITOR_POOL, Forge.getLocalizer().getMessage("lblInventory", new Object[0]), FSkinImage.QUEST_BOX), new DeckSectionPage(DeckSection.Main, ItemManagerConfig.QUEST_DECK_EDITOR), new DeckSectionPage(DeckSection.Sideboard, ItemManagerConfig.QUEST_DECK_EDITOR)};
            }
            case QuestCommander: {
                DeckEditorPage[] deckEditorPageArray8;
                if (isLandscape) {
                    DeckEditorPage[] deckEditorPageArray9 = new DeckEditorPage[4];
                    deckEditorPageArray9[0] = new CatalogPage(ItemManagerConfig.QUEST_EDITOR_POOL, Forge.getLocalizer().getMessage("lblInventory", new Object[0]), FSkinImage.QUEST_BOX);
                    deckEditorPageArray9[1] = new DeckSectionPage(DeckSection.Commander, ItemManagerConfig.COMMANDER_SECTION);
                    deckEditorPageArray9[2] = new DeckSectionPage(DeckSection.Main, ItemManagerConfig.QUEST_DECK_EDITOR);
                    deckEditorPageArray8 = deckEditorPageArray9;
                    deckEditorPageArray9[3] = new DeckSectionPage(DeckSection.Sideboard, ItemManagerConfig.QUEST_DECK_EDITOR);
                } else {
                    DeckEditorPage[] deckEditorPageArray10 = new DeckEditorPage[4];
                    deckEditorPageArray10[0] = new CatalogPage(ItemManagerConfig.QUEST_EDITOR_POOL, Forge.getLocalizer().getMessage("lblInventory", new Object[0]), FSkinImage.QUEST_BOX);
                    deckEditorPageArray10[1] = new DeckSectionPage(DeckSection.Main, ItemManagerConfig.QUEST_DECK_EDITOR);
                    deckEditorPageArray10[2] = new DeckSectionPage(DeckSection.Commander, ItemManagerConfig.COMMANDER_SECTION);
                    deckEditorPageArray8 = deckEditorPageArray10;
                    deckEditorPageArray10[3] = new DeckSectionPage(DeckSection.Sideboard, ItemManagerConfig.QUEST_DECK_EDITOR);
                }
                return deckEditorPageArray8;
            }
            case PlanarConquest: 
        }
        if (isLandscape) {
            DeckEditorPage[] deckEditorPageArray11 = new DeckEditorPage[3];
            deckEditorPageArray11[0] = new CatalogPage(ItemManagerConfig.CONQUEST_COLLECTION, Forge.getLocalizer().getMessage("lblCollection", new Object[0]), FSkinImage.SPELLBOOK);
            deckEditorPageArray11[1] = new DeckSectionPage(DeckSection.Commander, ItemManagerConfig.COMMANDER_SECTION);
            deckEditorPageArray = deckEditorPageArray11;
            deckEditorPageArray11[2] = new DeckSectionPage(DeckSection.Main, ItemManagerConfig.CONQUEST_DECK_EDITOR, Forge.getLocalizer().getMessage("lblDeck", new Object[0]), Forge.hdbuttons ? FSkinImage.HDLIBRARY : FSkinImage.DECKLIST);
        } else {
            DeckEditorPage[] deckEditorPageArray12 = new DeckEditorPage[3];
            deckEditorPageArray12[0] = new CatalogPage(ItemManagerConfig.CONQUEST_COLLECTION, Forge.getLocalizer().getMessage("lblCollection", new Object[0]), FSkinImage.SPELLBOOK);
            deckEditorPageArray12[1] = new DeckSectionPage(DeckSection.Main, ItemManagerConfig.CONQUEST_DECK_EDITOR, Forge.getLocalizer().getMessage("lblDeck", new Object[0]), Forge.hdbuttons ? FSkinImage.HDLIBRARY : FSkinImage.DECKLIST);
            deckEditorPageArray = deckEditorPageArray12;
            deckEditorPageArray12[2] = new DeckSectionPage(DeckSection.Commander, ItemManagerConfig.COMMANDER_SECTION);
        }
        return deckEditorPageArray;
    }

    public static DeckSection[] getExtraSections(EditorType editorType) {
        switch (editorType) {
            case Constructed: 
            case Commander: {
                return new DeckSection[]{DeckSection.Avatar, DeckSection.Schemes, DeckSection.Planes, DeckSection.Conspiracy, DeckSection.Attractions};
            }
            case Draft: 
            case Sealed: {
                return new DeckSection[]{DeckSection.Conspiracy, DeckSection.Attractions};
            }
        }
        return new DeckSection[]{DeckSection.Attractions};
    }

    private static DeckSectionPage createPageForExtraSection(DeckSection deckSection, EditorType editorType) {
        switch (deckSection) {
            case Avatar: 
            case Commander: {
                return new DeckSectionPage(deckSection, ItemManagerConfig.COMMANDER_SECTION);
            }
            case Schemes: {
                return new DeckSectionPage(deckSection, ItemManagerConfig.SCHEME_DECK_EDITOR);
            }
            case Planes: {
                return new DeckSectionPage(deckSection, ItemManagerConfig.PLANAR_DECK_EDITOR);
            }
            case Conspiracy: {
                return new DeckSectionPage(deckSection, ItemManagerConfig.CONSPIRACY_DECKS);
            }
            case Dungeon: {
                return new DeckSectionPage(deckSection, ItemManagerConfig.DUNGEON_DECKS);
            }
            case Attractions: {
                if (editorType.isLimitedType()) {
                    return new DeckSectionPage(deckSection, ItemManagerConfig.ATTRACTION_DECK_EDITOR_LIMITED);
                }
                return new DeckSectionPage(deckSection, ItemManagerConfig.ATTRACTION_DECK_EDITOR);
            }
        }
        System.out.printf("Editor (%s) added an unsupported extra deck section - %s%n", new Object[]{deckSection, editorType});
        return new DeckSectionPage(deckSection);
    }

    private static String labelFromDeckSection(DeckSection deckSection) {
        String label = null;
        switch (deckSection) {
            case Main: {
                label = "lblMain";
                break;
            }
            case Sideboard: {
                label = "lblSide";
                break;
            }
            case Commander: {
                label = "lblCommander";
                break;
            }
            case Planes: {
                label = "lblPlanes";
                break;
            }
            case Schemes: {
                label = "lblSchemes";
                break;
            }
            case Avatar: {
                label = "lblAvatar";
                break;
            }
            case Conspiracy: {
                label = "lblConspiracies";
                break;
            }
            case Attractions: {
                label = "lblAttractions";
            }
        }
        String text = Localizer.getInstance().getMessage(label, new Object[0]);
        if (text == null) {
            return deckSection.toString();
        }
        return text;
    }

    public FDeckEditor(EditorType editorType0, DeckProxy editDeck, boolean showMainDeck) {
        this(editorType0, editDeck.getName(), editDeck.getPath(), null, showMainDeck, null);
    }

    public FDeckEditor(EditorType editorType0, String editDeckName, boolean showMainDeck, FEvent.FEventHandler backButton) {
        this(editorType0, editDeckName, "", null, showMainDeck, backButton);
    }

    public FDeckEditor(EditorType editorType0, String editDeckName, boolean showMainDeck) {
        this(editorType0, editDeckName, "", null, showMainDeck, null);
    }

    public FDeckEditor(EditorType editorType0, Deck newDeck, boolean showMainDeck) {
        this(editorType0, "", "", newDeck, showMainDeck, null);
    }

    private FDeckEditor(EditorType editorType0, String editDeckName, String editDeckPath, Deck newDeck, boolean showMainDeck, FEvent.FEventHandler backButton) {
        super(backButton, FDeckEditor.getPages(editorType0));
        this.editorType = editorType0;
        ((DeckController)this.editorType.getController()).editor = this;
        for (TabPageScreen.TabPage tabPage : this.tabPages) {
            if (tabPage instanceof CatalogPage) {
                this.catalogPage = (CatalogPage)tabPage;
                continue;
            }
            if (!(tabPage instanceof DeckSectionPage)) continue;
            DeckSectionPage deckSectionPage = (DeckSectionPage)tabPage;
            this.pagesBySection.put(deckSectionPage.deckSection, deckSectionPage);
            switch (deckSectionPage.deckSection) {
                case Schemes: 
                case Planes: 
                case Main: {
                    this.mainDeckPage = deckSectionPage;
                    break;
                }
                case Sideboard: {
                    this.sideboardPage = deckSectionPage;
                    break;
                }
                case Commander: {
                    this.commanderPage = deckSectionPage;
                    break;
                }
            }
        }
        switch (this.editorType) {
            case Sealed: {
                if (showMainDeck) break;
                this.setSelectedPage(this.sideboardPage);
                break;
            }
            case Draft: 
            case QuestDraft: {
                break;
            }
            default: {
                if (!showMainDeck) break;
                this.setSelectedPage(this.mainDeckPage);
            }
        }
        if (StringUtils.isEmpty(editDeckName)) {
            if (this.editorType == EditorType.Draft || this.editorType == EditorType.QuestDraft) {
                this.setDeck(new Deck());
                this.deckHeader.setVisible(false);
            } else if (newDeck == null) {
                this.editorType.getController().newModel();
            } else {
                this.editorType.getController().setDeck(newDeck);
            }
        } else {
            if (this.editorType == EditorType.Draft || this.editorType == EditorType.QuestDraft) {
                ((TabPageScreen.TabPage)this.tabPages.get(0)).hideTab();
            }
            this.editorType.getController().load(editDeckPath, editDeckName);
        }
        for (DeckSection section : FDeckEditor.getExtraSections(this.editorType)) {
            if (this.deck != null && this.deck.has(section)) {
                this.showExtraSectionTab(section);
                continue;
            }
            this.hiddenExtraSections.add(section);
            this.createExtraSectionPage(section).hideTab();
        }
        if (!this.getVariantCardPools().isEmpty() && this.editorType.hasInfiniteCardPool()) {
            this.getCatalogPage().scheduleRefresh();
        }
        if (this.allowsSave()) {
            this.btnSave.setCommand(e -> this.save(null));
        } else {
            this.btnSave.setVisible(false);
        }
        this.btnMoreOptions.setCommand(new FEvent.FEventHandler(){

            @Override
            public void handleEvent(FEvent fEvent) {
                FPopupMenu menu = new FPopupMenu(){

                    @Override
                    protected void buildMenu() {
                        Localizer localizer = Forge.getLocalizer();
                        if (FDeckEditor.this.allowsAddBasic()) {
                            this.addItem(new FMenuItem(localizer.getMessage("lblAddBasicLands", new Object[0]), FSkinImage.LANDLOGO, e -> {
                                CardEdition defaultLandSet;
                                switch (FDeckEditor.this.editorType) {
                                    case Draft: 
                                    case QuestDraft: 
                                    case Sealed: {
                                        HashSet<CardEdition> availableEditionCodes = new HashSet<CardEdition>();
                                        for (PaperCard p : FDeckEditor.this.deck.getAllCardsInASinglePool().toFlatList()) {
                                            availableEditionCodes.add(FModel.getMagicDb().getEditions().get(p.getEdition()));
                                        }
                                        defaultLandSet = CardEdition.Predicates.getRandomSetWithAllBasicLands(availableEditionCodes);
                                        break;
                                    }
                                    case Quest: 
                                    case QuestCommander: {
                                        defaultLandSet = FModel.getQuest().getDefaultLandSet();
                                        break;
                                    }
                                    default: {
                                        defaultLandSet = DeckProxy.getDefaultLandSet(FDeckEditor.this.deck);
                                    }
                                }
                                AddBasicLandsDialog dialog = new AddBasicLandsDialog(FDeckEditor.this.deck, defaultLandSet, new Callback<CardPool>(){

                                    @Override
                                    public void run(CardPool landsToAdd) {
                                        FDeckEditor.this.getMainDeckPage().addCards(landsToAdd);
                                    }
                                }, null);
                                dialog.show();
                                FDeckEditor.this.setSelectedPage(FDeckEditor.this.getMainDeckPage());
                            }));
                        }
                        if (FDeckEditor.this.allowsAddExtraSection()) {
                            this.addItem(new FMenuItem(localizer.getMessage("lblAddDeckSection", new Object[0]), FSkinImage.CHAOS, e -> {
                                final List options = FDeckEditor.this.hiddenExtraSections.stream().map(x$0 -> FDeckEditor.labelFromDeckSection(x$0)).collect(Collectors.toList());
                                GuiChoose.oneOrNone(localizer.getMessage("lblAddDeckSectionSelect", new Object[0]), options, new Callback<String>(){

                                    @Override
                                    public void run(String result) {
                                        if (result == null || !options.contains(result)) {
                                            return;
                                        }
                                        DeckSection newSection = (DeckSection)((Object)FDeckEditor.this.hiddenExtraSections.get(options.indexOf(result)));
                                        FDeckEditor.this.showExtraSectionTab(newSection);
                                        FDeckEditor.this.filterCatalogForExtraSection(newSection);
                                        FDeckEditor.this.getCatalogPage().scheduleRefresh();
                                        FDeckEditor.this.setSelectedPage(FDeckEditor.this.getCatalogPage());
                                    }
                                });
                            }));
                        }
                        if (!FDeckEditor.this.isLimitedEditor()) {
                            this.addItem(new FMenuItem(localizer.getMessage("lblImportFromClipboard", new Object[0]), Forge.hdbuttons ? FSkinImage.HDIMPORT : FSkinImage.OPEN, e -> {
                                final FDeckImportDialog dialog = new FDeckImportDialog(!FDeckEditor.this.deck.isEmpty(), FDeckEditor.this.editorType);
                                dialog.setCallback(new Callback<Deck>(){

                                    @Override
                                    public void run(Deck importedDeck) {
                                        if (FDeckEditor.this.deck != null && importedDeck.hasName()) {
                                            FDeckEditor.this.deck.setName(importedDeck.getName());
                                            FDeckEditor.this.lblName.setText(importedDeck.getName());
                                        }
                                        if (dialog.createNewDeck()) {
                                            for (Map.Entry<DeckSection, CardPool> section : importedDeck) {
                                                DeckSectionPage page = FDeckEditor.this.getPageForSection(section.getKey());
                                                if (page == null) continue;
                                                page.setCards(section.getValue());
                                            }
                                        } else {
                                            for (Map.Entry<DeckSection, CardPool> section : importedDeck) {
                                                DeckSectionPage page = FDeckEditor.this.getPageForSection(section.getKey());
                                                if (page == null) continue;
                                                page.addCards(section.getValue());
                                            }
                                        }
                                    }
                                });
                                dialog.show();
                                FDeckEditor.this.setSelectedPage(FDeckEditor.this.getMainDeckPage());
                            }));
                            if (FDeckEditor.this.allowsSave()) {
                                this.addItem(new FMenuItem(localizer.getMessage("lblSaveAs", new Object[0]), Forge.hdbuttons ? FSkinImage.HDSAVEAS : FSkinImage.SAVEAS, e -> {
                                    String defaultName = FDeckEditor.this.editorType.getController().getNextAvailableName();
                                    FOptionPane.showInputDialog(localizer.getMessage("lblNameNewCopyDeck", new Object[0]), defaultName, new Callback<String>(){

                                        @Override
                                        public void run(String result) {
                                            if (!StringUtils.isEmpty(result)) {
                                                FDeckEditor.this.editorType.getController().saveAs(result);
                                            }
                                        }
                                    });
                                }));
                            }
                        }
                        if (FDeckEditor.this.allowRename()) {
                            this.addItem(new FMenuItem(localizer.getMessage("lblRenameDeck", new Object[0]), Forge.hdbuttons ? FSkinImage.HDEDIT : FSkinImage.EDIT, e -> FOptionPane.showInputDialog(localizer.getMessage("lblNewNameDeck", new Object[0]), FDeckEditor.this.deck.getName(), new Callback<String>(){

                                @Override
                                public void run(String result) {
                                    FDeckEditor.this.editorType.getController().rename(result);
                                }
                            })));
                        }
                        if (FDeckEditor.this.allowDelete()) {
                            this.addItem(new FMenuItem(localizer.getMessage("lblDeleteDeck", new Object[0]), Forge.hdbuttons ? FSkinImage.HDDELETE : FSkinImage.DELETE, e -> FOptionPane.showConfirmDialog(localizer.getMessage("lblConfirmDelete", new Object[0]) + " '" + FDeckEditor.this.deck.getName() + "'?", localizer.getMessage("lblDeleteDeck", new Object[0]), localizer.getMessage("lblDelete", new Object[0]), localizer.getMessage("lblCancel", new Object[0]), false, new Callback<Boolean>(){

                                @Override
                                public void run(Boolean result) {
                                    if (result.booleanValue()) {
                                        FDeckEditor.this.editorType.getController().delete();
                                        Forge.back();
                                    }
                                }
                            })));
                        }
                        this.addItem(new FMenuItem(localizer.getMessage("btnCopyToClipboard", new Object[0]), Forge.hdbuttons ? FSkinImage.HDEXPORT : FSkinImage.BLANK, e -> FDeckViewer.copyDeckToClipboard(FDeckEditor.this.deck)));
                        ((DeckEditorPage)FDeckEditor.this.getSelectedPage()).buildDeckMenu(this);
                    }
                };
                menu.show(FDeckEditor.this.btnMoreOptions, 0.0f, FDeckEditor.this.btnMoreOptions.getHeight());
            }
        });
    }

    protected boolean allowRename() {
        return true;
    }

    protected boolean allowDelete() {
        return true;
    }

    @Override
    protected void doLayout(float startY, float width, float height) {
        if (this.deckHeader.isVisible()) {
            this.deckHeader.setBounds(0.0f, startY, width, HEADER_HEIGHT);
            startY += HEADER_HEIGHT;
        }
        super.doLayout(startY, width, height);
    }

    public EditorType getEditorType() {
        return this.editorType;
    }

    public Deck getDeck() {
        return this.deck;
    }

    public void setDeck(Deck deck0) {
        if (this.deck == deck0) {
            return;
        }
        this.deck = deck0;
        if (this.deck == null) {
            return;
        }
        for (TabPageScreen.TabPage tabPage : this.tabPages) {
            ((DeckEditorPage)tabPage).initialize();
        }
    }

    protected CatalogPage getCatalogPage() {
        return this.catalogPage;
    }

    protected DeckSectionPage getMainDeckPage() {
        return this.mainDeckPage;
    }

    protected DeckSectionPage getSideboardPage() {
        return this.sideboardPage;
    }

    protected DeckSectionPage getCommanderPage() {
        return this.commanderPage;
    }

    protected DeckSectionPage getPageForSection(DeckSection section) {
        return this.pagesBySection.get((Object)section);
    }

    protected Set<DeckSection> getVariantCardPools() {
        return this.variantCardPools;
    }

    public BoosterDraft getDraft() {
        return null;
    }

    private CardLimit getCardLimit() {
        switch (this.editorType) {
            default: {
                if (FModel.getPreferences().getPrefBoolean(ForgePreferences.FPref.ENFORCE_DECK_LEGALITY)) {
                    return CardLimit.Default;
                }
                return CardLimit.None;
            }
            case Draft: 
            case QuestDraft: 
            case Sealed: 
            case Winston: {
                return CardLimit.None;
            }
            case Commander: 
            case TinyLeaders: 
            case Brawl: 
            case Oathbreaker: 
            case QuestCommander: 
            case PlanarConquest: 
        }
        return CardLimit.Singleton;
    }

    private int getExtraSectionMaxCopies(DeckSection section) {
        switch (section) {
            case Avatar: 
            case Commander: 
            case Planes: 
            case Dungeon: {
                return 1;
            }
            case Schemes: {
                return 2;
            }
            case Conspiracy: {
                return Integer.MAX_VALUE;
            }
            case Attractions: {
                if (this.isLimitedEditor()) {
                    return Integer.MAX_VALUE;
                }
                return 1;
            }
        }
        return FModel.getPreferences().getPrefInt(ForgePreferences.FPref.DECK_DEFAULT_CARD_LIMIT);
    }

    protected ItemPool<PaperCard> getAllowedAdditions(Iterable<Map.Entry<PaperCard, Integer>> itemsToAdd, CardManagerPage source, CardManagerPage destination) {
        ItemPool<PaperCard> additions = new ItemPool<PaperCard>(destination.cardManager.getGenericType());
        for (Map.Entry<PaperCard, Integer> itemEntry : itemsToAdd) {
            int numAvailable;
            PaperCard card = itemEntry.getKey();
            int maxMovable = this.getMaxMovable(card, source, destination, numAvailable = Math.min(itemEntry.getValue(), source.cardManager.getItemCount(card)));
            if (maxMovable <= 0) continue;
            additions.add(card, maxMovable);
        }
        return additions;
    }

    protected int getMaxMovable(PaperCard card, CardManagerPage source, CardManagerPage destination) {
        return this.getMaxMovable(card, source, destination, source.cardManager.getItemCount(card));
    }

    protected int getMaxMovable(PaperCard card, CardManagerPage source, CardManagerPage destination, int numAvailable) {
        int numAllowedInDeck;
        if (numAvailable <= 0) {
            return 0;
        }
        if (destination instanceof CatalogPage || this.isLimitedEditor() && destination == this.getSideboardPage()) {
            return numAvailable;
        }
        int numInDeck = this.getDeck().countByName(card.getName());
        if (this.isLimitedEditor()) {
            numInDeck -= this.getDeck().getOrCreate(DeckSection.Sideboard).countByName(card);
        }
        if ((numAllowedInDeck = this.getNumAllowedInDeck(card)) == Integer.MAX_VALUE) {
            return numAvailable;
        }
        if (!FModel.getPreferences().getPrefBoolean(ForgePreferences.FPref.ENFORCE_DECK_LEGALITY)) {
            if (numAllowedInDeck == 1) {
                return 1;
            }
            return numAvailable;
        }
        if (source instanceof CatalogPage || this.isLimitedEditor() && source == this.getSideboardPage()) {
            return Math.min(numAvailable, Math.max(numAllowedInDeck - numInDeck, 0));
        }
        return numAvailable;
    }

    private int getNumAllowedInDeck(PaperCard card) {
        CardLimit limit = this.getCardLimit();
        if (DeckFormat.canHaveSpecificNumberInDeck(card) != null) {
            return DeckFormat.canHaveSpecificNumberInDeck(card);
        }
        if (DeckFormat.canHaveAnyNumberOf(card)) {
            return Integer.MAX_VALUE;
        }
        if (card.getRules().isVariant()) {
            return this.getExtraSectionMaxCopies(DeckSection.matchingSection(card));
        }
        if (limit == CardLimit.None) {
            return Integer.MAX_VALUE;
        }
        if (limit == CardLimit.Singleton) {
            return 1;
        }
        return FModel.getPreferences().getPrefInt(ForgePreferences.FPref.DECK_DEFAULT_CARD_LIMIT);
    }

    protected DeckSectionPage showExtraSectionTab(DeckSection section) {
        this.variantCardPools.add(section);
        this.hiddenExtraSections.remove((Object)section);
        DeckSectionPage page = this.getPageForSection(section);
        if (page == null) {
            page = this.createExtraSectionPage(section);
        }
        page.showTab();
        return page;
    }

    protected DeckSectionPage createExtraSectionPage(DeckSection section) {
        DeckSectionPage page = FDeckEditor.createPageForExtraSection(section, this.editorType);
        this.pagesBySection.put(section, page);
        this.addTabPage(page);
        page.initialize();
        return page;
    }

    protected void filterCatalogForExtraSection(DeckSection section) {
        CardManager cardManager = this.getCatalogPage().cardManager;
        switch (section) {
            case Avatar: {
                cardManager.applyAdvancedSearchFilter("CARD_TYPE CONTAINS_ALL Vanguard");
                break;
            }
            case Planes: {
                cardManager.applyAdvancedSearchFilter("CARD_TYPE CONTAINS_ANY Plane;Phenomenon");
                break;
            }
            case Schemes: {
                cardManager.applyAdvancedSearchFilter("CARD_TYPE CONTAINS_ALL Scheme");
                break;
            }
            case Conspiracy: {
                cardManager.applyAdvancedSearchFilter("CARD_TYPE CONTAINS_ALL Conspiracy");
                break;
            }
            case Dungeon: {
                cardManager.applyAdvancedSearchFilter("CARD_TYPE CONTAINS_ALL Dungeon");
                break;
            }
            case Attractions: {
                cardManager.applyAdvancedSearchFilter(new String[]{"CARD_TYPE CONTAINS_ALL Artifact", "CARD_SUB_TYPE CONTAINS_ALL Attraction"}, true);
                break;
            }
            default: {
                cardManager.resetFilters();
            }
        }
    }

    public void setSaveHandler(FEvent.FEventHandler saveHandler0) {
        this.saveHandler = saveHandler0;
    }

    public void save(final Callback<Boolean> callback) {
        if (StringUtils.isEmpty(this.deck.getName())) {
            List<PaperCard> commanders = this.deck.getCommanders();
            String initialInput = Lang.joinHomogenous(commanders);
            FOptionPane.showInputDialog(Forge.getLocalizer().getMessage("lblNameNewDeck", new Object[0]), initialInput, new Callback<String>(){

                @Override
                public void run(String result) {
                    if (StringUtils.isEmpty(result)) {
                        return;
                    }
                    FDeckEditor.this.editorType.getController().saveAs(result);
                    if (callback != null) {
                        callback.run(true);
                    }
                }
            });
            return;
        }
        this.editorType.getController().save();
        if (callback != null) {
            callback.run(true);
        }
    }

    @Override
    public void onClose(final Callback<Boolean> canCloseCallback) {
        if (this.editorType.getController().isSaved() || canCloseCallback == null) {
            super.onClose(canCloseCallback);
            return;
        }
        FOptionPane.showOptionDialog(Forge.getLocalizer().getMessage("lblSaveChangesCurrentDeck", new Object[0]), "", FOptionPane.QUESTION_ICON, onCloseOptions, new Callback<Integer>(){

            @Override
            public void run(Integer result) {
                if (result == 0) {
                    FDeckEditor.this.save(canCloseCallback);
                } else if (result == 1) {
                    FDeckEditor.this.editorType.getController().reload();
                    canCloseCallback.run(true);
                } else {
                    canCloseCallback.run(false);
                }
            }
        });
    }

    @Override
    public boolean keyDown(int keyCode) {
        switch (keyCode) {
            case 4: {
                return true;
            }
            case 47: {
                if (!Forge.KeyInputAdapter.isCtrlKeyDown()) break;
                this.save(null);
                return true;
            }
        }
        return super.keyDown(keyCode);
    }

    @Override
    public FScreen getLandscapeBackdropScreen() {
        return null;
    }

    protected boolean allowsSave() {
        return true;
    }

    protected boolean allowsAddBasic() {
        return true;
    }

    protected boolean allowsAddExtraSection() {
        return this.editorType.hasInfiniteCardPool() && !this.hiddenExtraSections.isEmpty();
    }

    protected boolean isLimitedEditor() {
        return this.editorType.isLimitedType();
    }

    protected boolean isCommanderEditor() {
        return this.editorType.isCommanderType();
    }

    protected boolean isDraftEditor() {
        switch (this.editorType) {
            case Draft: 
            case QuestDraft: {
                return true;
            }
        }
        return false;
    }

    public static boolean allowsReplacement(EditorType editorType) {
        switch (editorType) {
            case Constructed: 
            case Commander: 
            case TinyLeaders: 
            case Brawl: 
            case Oathbreaker: {
                return true;
            }
        }
        if (editorType.isLimitedType()) {
            return false;
        }
        if (editorType == EditorType.PlanarConquest || editorType == EditorType.Quest || editorType == EditorType.QuestCommander) {
            return FModel.getPreferences().getPrefBoolean(ForgePreferences.FPref.DEV_MODE_ENABLED);
        }
        return false;
    }

    private boolean isAllowedReplacement() {
        return FDeckEditor.allowsReplacement(this.editorType);
    }

    protected Map<ColumnDef, ItemColumn> getColOverrides(ItemManagerConfig config) {
        return null;
    }

    public static class DeckController<T extends DeckBase> {
        private T model;
        private boolean saved;
        private boolean modelInStorage;
        private IStorage<T> rootFolder;
        private IStorage<T> currentFolder;
        private String modelPath;
        private FDeckEditor editor;
        private final Supplier<T> newModelCreator;

        protected DeckController(IStorage<T> folder0, Supplier<T> newModelCreator0) {
            this.setRootFolder(folder0);
            this.newModelCreator = newModelCreator0;
        }

        public void setRootFolder(IStorage<T> folder0) {
            this.rootFolder = folder0;
            this.currentFolder = folder0;
            this.model = null;
            this.saved = true;
            this.modelInStorage = false;
            this.modelPath = "";
        }

        public T getModel() {
            return this.model;
        }

        public String getModelPath() {
            return this.modelPath;
        }

        public void setDeck(Deck deck) {
            this.modelInStorage = false;
            this.model = deck;
            this.currentFolder = this.rootFolder;
            this.modelPath = "";
            this.setSaved(false);
            this.editor.setDeck(deck);
        }

        public void setModel(T document) {
            this.setModel(document, false);
        }

        public void setModel(T document, boolean isStored) {
            this.modelInStorage = isStored;
            this.model = document;
            if (isStored) {
                if (this.isModelInSyncWithFolder()) {
                    this.setSaved(true);
                } else {
                    this.notifyModelChanged();
                }
            } else {
                this.currentFolder = this.rootFolder;
                this.modelPath = "";
                this.setSaved(true);
            }
            if (this.model != null) {
                this.editor.setDeck(((DeckBase)this.model).getHumanDeck());
            } else {
                this.editor.setDeck(null);
            }
        }

        private boolean isModelInSyncWithFolder() {
            if (((DeckBase)this.model).getName().isEmpty()) {
                return true;
            }
            DeckBase modelStored = (DeckBase)this.currentFolder.get(((DeckBase)this.model).getName());
            if (modelStored == this.model) {
                return true;
            }
            if (modelStored == null) {
                return false;
            }
            return modelStored.equals(this.model);
        }

        public void notifyModelChanged() {
            if (this.saved) {
                this.setSaved(false);
            }
        }

        private void setSaved(boolean val) {
            this.saved = val;
            if (this.editor != null) {
                String name = this.getModelName();
                if (name.isEmpty()) {
                    name = "[" + Forge.getLocalizer().getMessage("lblNewDeck", new Object[0]) + "]";
                }
                if (!this.saved && this.editor.allowsSave()) {
                    name = "*" + name;
                }
                this.editor.lblName.setText(name);
                this.editor.btnSave.setEnabled(!this.saved);
            }
        }

        public void reload() {
            String name = this.getModelName();
            if (name.isEmpty()) {
                this.newModel();
            } else {
                this.load(name);
            }
        }

        public void load(String path, String name) {
            this.currentFolder = StringUtils.isBlank(path) ? this.rootFolder : this.rootFolder.tryGetFolder(path);
            this.modelPath = path;
            this.load(name);
        }

        private void load(String name) {
            DeckBase newModel = (DeckBase)this.currentFolder.get(name);
            if (newModel != null) {
                this.setModel(newModel.copyTo(name), true);
            } else {
                this.setSaved(true);
            }
        }

        public void save() {
            if (this.model == null) {
                return;
            }
            this.currentFolder.add(((DeckBase)this.model).copyTo(((DeckBase)this.model).getName()));
            ((DeckBase)this.model).setDirectory(DeckProxy.getDeckDirectory(this.currentFolder));
            this.modelInStorage = true;
            this.setSaved(true);
            String deckStr = DeckProxy.getDeckString(this.getModelPath(), this.getModelName());
            switch (this.editor.getEditorType()) {
                case Constructed: {
                    DeckPreferences.setCurrentDeck(deckStr);
                    break;
                }
                case Commander: {
                    DeckPreferences.setCommanderDeck(deckStr);
                    break;
                }
                case Oathbreaker: {
                    DeckPreferences.setOathbreakerDeck(deckStr);
                    break;
                }
                case TinyLeaders: {
                    DeckPreferences.setTinyLeadersDeck(deckStr);
                    break;
                }
                case Brawl: {
                    DeckPreferences.setBrawlDeck(deckStr);
                    break;
                }
                case Archenemy: {
                    DeckPreferences.setSchemeDeck(deckStr);
                    break;
                }
                case Planechase: {
                    DeckPreferences.setPlanarDeck(deckStr);
                    break;
                }
                case Draft: 
                case QuestDraft: {
                    DeckPreferences.setDraftDeck(deckStr);
                    break;
                }
                case Sealed: {
                    DeckPreferences.setSealedDeck(deckStr);
                    break;
                }
                case Quest: 
                case QuestCommander: {
                    FModel.getQuest().setCurrentDeck(((DeckBase)this.model).toString());
                    FModel.getQuest().save();
                    break;
                }
            }
            this.editor.setDeck(((DeckBase)this.model).getHumanDeck());
            if (this.editor.saveHandler != null) {
                this.editor.saveHandler.handleEvent(new FEvent(this.editor, FEvent.FEventType.SAVE));
            }
        }

        public void saveAs(String name0) {
            this.model = ((DeckBase)this.model).copyTo(name0);
            this.modelInStorage = false;
            this.save();
        }

        public void rename(String name0) {
            if (StringUtils.isEmpty(name0)) {
                return;
            }
            String oldName = ((DeckBase)this.model).getName();
            if (name0.equals(oldName)) {
                return;
            }
            this.saveAs(name0);
            this.currentFolder.delete(oldName);
        }

        public String getNextAvailableName() {
            String name = ((DeckBase)this.model).getName();
            int idx = name.lastIndexOf(40);
            if (idx != -1) {
                name = name.substring(0, idx).trim();
            }
            String baseName = name;
            int number = 2;
            do {
                name = baseName + " (" + number + ")";
                ++number;
            } while (this.fileExists(name));
            return name;
        }

        public boolean isSaved() {
            return this.saved;
        }

        public boolean fileExists(String deckName) {
            return this.currentFolder.contains(deckName);
        }

        public void importDeck(T newDeck) {
            this.setModel(newDeck);
        }

        public void refreshModel() {
            if (this.model == null) {
                this.newModel();
            } else {
                this.setModel(this.model, this.modelInStorage);
            }
        }

        public void newModel() {
            this.setModel((DeckBase)this.newModelCreator.get());
        }

        public String getModelName() {
            return this.model != null ? ((DeckBase)this.model).getName() : "";
        }

        public boolean delete() {
            if (this.model == null) {
                return false;
            }
            this.currentFolder.delete(((DeckBase)this.model).getName());
            this.setModel(null);
            return true;
        }
    }

    private static class DraftPackPage
    extends CatalogPage {
        protected DraftPackPage() {
            super(ItemManagerConfig.DRAFT_PACK, Localizer.getInstance().getMessage("lblPackN", String.valueOf(1)), FSkinImage.PACK);
        }

        @Override
        public void refresh() {
            BoosterDraft draft = ((FDeckEditor)this.parentScreen).getDraft();
            if (draft == null) {
                return;
            }
            CardPool pool = draft.nextChoice();
            int packNumber = draft.getCurrentBoosterIndex() + 1;
            this.caption = Forge.getLocalizer().getMessage("lblPackN", String.valueOf(packNumber));
            this.cardManager.setPool(pool);
            this.cardManager.setShowRanking(true);
        }

        @Override
        protected void onCardActivated(PaperCard card) {
            super.onCardActivated(card);
            this.afterCardPicked(card);
        }

        private void afterCardPicked(PaperCard card) {
            BoosterDraft draft = ((FDeckEditor)this.parentScreen).getDraft();
            draft.setChoice(card);
            if (draft.hasNextChoice()) {
                this.refresh();
            } else {
                this.hideTab();
                ((FDeckEditor)this.parentScreen).save(null);
            }
        }

        @Override
        protected void buildMenu(FDropDownMenu menu, final PaperCard card) {
            final DeckSection destination = DeckSection.matchingSection(card);
            DeckSectionPage destinationPage = ((FDeckEditor)this.parentScreen).getPageForSection(destination);
            this.addMoveCardMenuItem(menu, this, destinationPage, new Callback<Integer>(){

                @Override
                public void run(Integer result) {
                    DeckSectionPage destinationPage = ((FDeckEditor)parentScreen).getPageForSection(destination);
                    if (destinationPage == null) {
                        destinationPage = ((FDeckEditor)parentScreen).showExtraSectionTab(destination);
                    }
                    destinationPage.addCard(card);
                    this.afterCardPicked(card);
                }
            });
            this.addMoveCardMenuItem(menu, this, ((FDeckEditor)this.parentScreen).getSideboardPage(), new Callback<Integer>(){

                @Override
                public void run(Integer result) {
                    ((FDeckEditor)parentScreen).getSideboardPage().addCard(card);
                    this.afterCardPicked(card);
                }
            });
        }
    }

    protected static class DeckSectionPage
    extends CardManagerPage {
        private String captionPrefix;
        private final DeckSection deckSection;

        protected DeckSectionPage(DeckSection deckSection0) {
            this(deckSection0, ItemManagerConfig.DECK_EDITOR);
        }

        protected DeckSectionPage(DeckSection deckSection0, ItemManagerConfig config) {
            super(config, null, null);
            this.deckSection = deckSection0;
            Localizer localizer = Forge.getLocalizer();
            switch (this.deckSection) {
                default: {
                    this.captionPrefix = localizer.getMessage("lblMain", new Object[0]);
                    this.cardManager.setCaption(localizer.getMessage("ttMain", new Object[0]));
                    this.icon = MAIN_DECK_ICON;
                    break;
                }
                case Sideboard: {
                    this.captionPrefix = localizer.getMessage("lblSide", new Object[0]);
                    this.cardManager.setCaption(localizer.getMessage("lblSideboard", new Object[0]));
                    this.icon = SIDEBOARD_ICON;
                    break;
                }
                case Commander: {
                    this.captionPrefix = localizer.getMessage("lblCommander", new Object[0]);
                    this.cardManager.setCaption(localizer.getMessage("lblCommander", new Object[0]));
                    this.icon = FSkinImage.COMMANDER;
                    break;
                }
                case Avatar: {
                    this.captionPrefix = localizer.getMessage("lblAvatar", new Object[0]);
                    this.cardManager.setCaption(localizer.getMessage("lblAvatar", new Object[0]));
                    this.icon = new FTextureRegionImage(FSkin.getAvatars().get(0));
                    break;
                }
                case Conspiracy: {
                    this.captionPrefix = localizer.getMessage("lblConspiracies", new Object[0]);
                    this.cardManager.setCaption(localizer.getMessage("lblConspiracies", new Object[0]));
                    this.icon = FSkinImage.UNKNOWN;
                    break;
                }
                case Planes: {
                    this.captionPrefix = localizer.getMessage("lblPlanes", new Object[0]);
                    this.cardManager.setCaption(localizer.getMessage("lblPlanes", new Object[0]));
                    this.icon = FSkinImage.CHAOS;
                    break;
                }
                case Schemes: {
                    this.captionPrefix = localizer.getMessage("lblSchemes", new Object[0]);
                    this.cardManager.setCaption(localizer.getMessage("lblSchemes", new Object[0]));
                    this.icon = FSkinImage.POISON;
                    break;
                }
                case Attractions: {
                    this.captionPrefix = localizer.getMessage("lblAttractions", new Object[0]);
                    this.cardManager.setCaption(localizer.getMessage("lblAttractions", new Object[0]));
                    this.icon = FSkinImage.TICKET;
                }
            }
        }

        protected DeckSectionPage(DeckSection deckSection0, ItemManagerConfig config, String caption0, FImage icon0) {
            super(config, null, icon0);
            this.deckSection = deckSection0;
            this.captionPrefix = caption0;
            this.cardManager.setCaption(caption0);
        }

        @Override
        protected void initialize() {
            super.initialize();
            this.cardManager.setPool(((FDeckEditor)this.parentScreen).getDeck().getOrCreate(this.deckSection));
            this.updateCaption();
        }

        @Override
        protected void updateCaption() {
            this.caption = this.deckSection == DeckSection.Commander ? this.captionPrefix : this.captionPrefix + " (" + ((FDeckEditor)this.parentScreen).getDeck().get(this.deckSection).countAll() + ")";
        }

        @Override
        public void addCard(PaperCard card, int qty) {
            super.addCard(card, qty);
            if (((FDeckEditor)this.parentScreen).hiddenExtraSections.contains((Object)this.deckSection)) {
                ((FDeckEditor)this.parentScreen).showExtraSectionTab(this.deckSection);
            }
        }

        @Override
        public void addCards(Iterable<Map.Entry<PaperCard, Integer>> cards) {
            super.addCards(cards);
            if (((FDeckEditor)this.parentScreen).hiddenExtraSections.contains((Object)this.deckSection)) {
                ((FDeckEditor)this.parentScreen).showExtraSectionTab(this.deckSection);
            }
        }

        @Override
        public void setCards(CardPool cards) {
            super.setCards(cards);
            if (((FDeckEditor)this.parentScreen).hiddenExtraSections.contains((Object)this.deckSection) && !cards.isEmpty()) {
                ((FDeckEditor)this.parentScreen).showExtraSectionTab(this.deckSection);
            }
        }

        @Override
        protected void onCardActivated(PaperCard card) {
            block0 : switch (this.deckSection) {
                case Schemes: 
                case Planes: 
                case Attractions: 
                case Main: {
                    this.removeCard(card);
                    switch (((FDeckEditor)this.parentScreen).getEditorType()) {
                        case Draft: 
                        case QuestDraft: 
                        case Sealed: {
                            ((FDeckEditor)this.parentScreen).getSideboardPage().addCard(card);
                            break block0;
                        }
                    }
                    if (((FDeckEditor)this.parentScreen).getCatalogPage() == null) break;
                    ((FDeckEditor)this.parentScreen).getCatalogPage().addCard(card);
                    break;
                }
                case Sideboard: {
                    this.removeCard(card);
                    ((FDeckEditor)this.parentScreen).getMainDeckPage().addCard(card);
                    break;
                }
            }
        }

        @Override
        protected void buildMenu(FDropDownMenu menu, final PaperCard card) {
            FSkinImage iconReplaceCard = Forge.hdbuttons ? FSkinImage.HDCHOICE : FSkinImage.DECKLIST;
            Localizer localizer = Forge.getLocalizer();
            String lblReplaceCard = localizer.getMessage("lblReplaceCard", new Object[0]);
            DeckSection destination = DeckSection.matchingSection(card);
            final DeckSectionPage destinationPage = ((FDeckEditor)this.parentScreen).getPageForSection(destination);
            switch (this.deckSection) {
                default: {
                    List<PaperCard> cardOptions;
                    final CardManagerPage cardSourceSection = ((FDeckEditor)this.parentScreen).isLimitedEditor() ? ((FDeckEditor)this.parentScreen).getSideboardPage() : ((FDeckEditor)this.parentScreen).getCatalogPage();
                    this.addMoveCardMenuItem(menu, cardSourceSection, this, new Callback<Integer>(){

                        @Override
                        public void run(Integer result) {
                            if (result == null || result <= 0) {
                                return;
                            }
                            cardSourceSection.removeCard(card, result);
                            this.addCard(card, result);
                        }
                    });
                    if (!((FDeckEditor)this.parentScreen).isLimitedEditor()) {
                        this.addMoveCardMenuItem(menu, this, cardSourceSection, new Callback<Integer>(){

                            @Override
                            public void run(Integer result) {
                                if (result == null || result <= 0) {
                                    return;
                                }
                                this.removeCard(card, result);
                                cardSourceSection.addCard(card, result);
                            }
                        });
                    }
                    if (((FDeckEditor)this.parentScreen).getSideboardPage() != null) {
                        this.addMoveCardMenuItem(menu, this, ((FDeckEditor)this.parentScreen).getSideboardPage(), new Callback<Integer>(){

                            @Override
                            public void run(Integer result) {
                                if (result == null || result <= 0) {
                                    return;
                                }
                                this.removeCard(card, result);
                                ((FDeckEditor)parentScreen).getSideboardPage().addCard(card, result);
                            }
                        });
                    }
                    if (((FDeckEditor)this.parentScreen).isAllowedReplacement() && (cardOptions = FModel.getMagicDb().getCommonCards().getAllCardsNoAlt(card.getName())).size() > 1) {
                        menu.addItem(new FMenuItem(lblReplaceCard, iconReplaceCard, e -> this.handleReplaceCard(card, cardOptions)));
                    }
                    this.addCommanderItems(menu, card);
                    break;
                }
                case Sideboard: {
                    List<PaperCard> cardOptions;
                    final CardManagerPage cardSourceSection = ((FDeckEditor)this.parentScreen).isLimitedEditor() ? ((FDeckEditor)this.parentScreen).getMainDeckPage() : ((FDeckEditor)this.parentScreen).getCatalogPage();
                    this.addMoveCardMenuItem(menu, cardSourceSection, this, new Callback<Integer>(){

                        @Override
                        public void run(Integer result) {
                            if (result == null || result <= 0) {
                                return;
                            }
                            cardSourceSection.removeCard(card, result);
                            this.addCard(card, result);
                        }
                    });
                    if (!((FDeckEditor)this.parentScreen).isLimitedEditor()) {
                        this.addMoveCardMenuItem(menu, this, cardSourceSection, new Callback<Integer>(){

                            @Override
                            public void run(Integer result) {
                                if (result == null || result <= 0) {
                                    return;
                                }
                                this.removeCard(card, result);
                                cardSourceSection.addCard(card, result);
                            }
                        });
                    }
                    this.addMoveCardMenuItem(menu, this, destinationPage, new Callback<Integer>(){

                        @Override
                        public void run(Integer result) {
                            if (result == null || result <= 0) {
                                return;
                            }
                            this.removeCard(card, result);
                            destinationPage.addCard(card, result);
                        }
                    });
                    if (((FDeckEditor)this.parentScreen).isAllowedReplacement() && (cardOptions = FModel.getMagicDb().getCommonCards().getAllCardsNoAlt(card.getName())).size() > 1) {
                        menu.addItem(new FMenuItem(lblReplaceCard, iconReplaceCard, e -> this.handleReplaceCard(card, cardOptions)));
                    }
                    this.addCommanderItems(menu, card);
                    break;
                }
                case Commander: {
                    List<PaperCard> cardOptions;
                    if (((FDeckEditor)this.parentScreen).editorType != EditorType.PlanarConquest || this.isPartnerCommander(card)) {
                        this.addMoveCardMenuItem(menu, this, ((FDeckEditor)this.parentScreen).getCatalogPage(), new Callback<Integer>(){

                            @Override
                            public void run(Integer result) {
                                if (result == null || result <= 0) {
                                    return;
                                }
                                this.removeCard(card, result);
                                ((FDeckEditor)parentScreen).getCatalogPage().refresh();
                                ((FDeckEditor)parentScreen).setSelectedPage(((FDeckEditor)parentScreen).getCatalogPage());
                            }
                        });
                    }
                    if (!((FDeckEditor)this.parentScreen).isAllowedReplacement() || (cardOptions = FModel.getMagicDb().getCommonCards().getAllCardsNoAlt(card.getName())).size() <= 1) break;
                    menu.addItem(new FMenuItem(lblReplaceCard, iconReplaceCard, e -> this.handleReplaceCard(card, cardOptions)));
                    break;
                }
                case Avatar: {
                    this.addMoveCardMenuItem(menu, this, ((FDeckEditor)this.parentScreen).getCatalogPage(), new Callback<Integer>(){

                        @Override
                        public void run(Integer result) {
                            if (result == null || result <= 0) {
                                return;
                            }
                            this.removeCard(card, result);
                        }
                    });
                    break;
                }
                case Schemes: {
                    this.addMoveCardMenuItem(menu, ((FDeckEditor)this.parentScreen).getCatalogPage(), this, new Callback<Integer>(){

                        @Override
                        public void run(Integer result) {
                            if (result == null || result <= 0) {
                                return;
                            }
                            this.addCard(card, result);
                        }
                    });
                    this.addMoveCardMenuItem(menu, this, ((FDeckEditor)this.parentScreen).getCatalogPage(), new Callback<Integer>(){

                        @Override
                        public void run(Integer result) {
                            if (result == null || result <= 0) {
                                return;
                            }
                            this.removeCard(card, result);
                        }
                    });
                    break;
                }
                case Planes: 
                case Attractions: {
                    List<PaperCard> cardOptions;
                    this.addMoveCardMenuItem(menu, this, ((FDeckEditor)this.parentScreen).getCatalogPage(), new Callback<Integer>(){

                        @Override
                        public void run(Integer result) {
                            if (result == null || result <= 0) {
                                return;
                            }
                            this.removeCard(card, result);
                        }
                    });
                    if (!((FDeckEditor)this.parentScreen).isAllowedReplacement() || (cardOptions = FModel.getMagicDb().getCommonCards().getAllCardsNoAlt(card.getName())).size() <= 1) break;
                    menu.addItem(new FMenuItem(lblReplaceCard, iconReplaceCard, e -> this.handleReplaceCard(card, cardOptions)));
                }
            }
        }

        private void handleReplaceCard(final PaperCard card, List<PaperCard> cardOptions) {
            ArrayList<PaperCard> sortedOptions = new ArrayList<PaperCard>();
            sortedOptions.add(card);
            for (PaperCard option : cardOptions) {
                if (option == card) continue;
                sortedOptions.add(option);
            }
            String prompt = Forge.getLocalizer().getMessage("lblSelectReplacementCard", new Object[0]) + " " + card.getName();
            GuiChoose.oneOrNone(prompt, sortedOptions, new Callback<PaperCard>(){

                @Override
                public void run(PaperCard result) {
                    if (result != null && result != card) {
                        this.addCard(result);
                        this.removeCard(card);
                    }
                }
            });
        }

        private boolean isPartnerCommander(PaperCard card) {
            if (!((FDeckEditor)this.parentScreen).isCommanderEditor() || ((FDeckEditor)this.parentScreen).getDeck().getCommanders().isEmpty()) {
                return false;
            }
            PaperCard firstCmdr = ((FDeckEditor)this.parentScreen).getDeck().getCommanders().get(0);
            return !card.getName().equals(firstCmdr.getName());
        }
    }

    public static class CatalogPage
    extends CardManagerPage {
        private boolean initialized;
        private boolean needRefreshWhenShown;

        protected CatalogPage(ItemManagerConfig config) {
            this(config, Localizer.getInstance().getMessage("lblCatalog", new Object[0]), Forge.hdbuttons ? FSkinImage.HDFOLDER : FSkinImage.FOLDER);
        }

        protected CatalogPage(ItemManagerConfig config, String caption0, FImage icon0) {
            super(config, caption0, icon0);
        }

        @Override
        protected void initialize() {
            if (this.initialized) {
                return;
            }
            this.initialized = true;
            super.initialize();
            this.cardManager.setCaption(this.getItemManagerCaption());
            if (!this.isVisible() && ((FDeckEditor)this.parentScreen).getEditorType() != EditorType.Quest && ((FDeckEditor)this.parentScreen).getEditorType() != EditorType.QuestCommander) {
                this.needRefreshWhenShown = true;
                this.cardManager.setPool(((FDeckEditor)this.parentScreen).getDeck().getAllCardsInASinglePool(), true);
                return;
            }
            this.refresh();
        }

        @Override
        protected boolean canAddCards() {
            if (this.needRefreshWhenShown) {
                this.needRefreshWhenShown = false;
                this.refresh();
            }
            return !this.cardManager.isInfinite();
        }

        protected String getItemManagerCaption() {
            switch (((FDeckEditor)this.parentScreen).getEditorType()) {
                case Archenemy: {
                    return Forge.getLocalizer().getMessage("lblSchemes", new Object[0]);
                }
                case Planechase: {
                    return Forge.getLocalizer().getMessage("lblPlanes", new Object[0]);
                }
            }
            return Forge.getLocalizer().getMessage("lblCards", new Object[0]);
        }

        public void scheduleRefresh() {
            if (this.isVisible()) {
                this.refresh();
            } else {
                this.needRefreshWhenShown = true;
            }
        }

        @Override
        public void setVisible(boolean visible0) {
            if (this.isVisible() == visible0) {
                return;
            }
            super.setVisible(visible0);
            if (visible0 && this.needRefreshWhenShown) {
                this.needRefreshWhenShown = false;
                this.refresh();
            }
        }

        @Override
        public void refresh() {
            Predicate<PaperCard> additionalFilter = null;
            EditorType editorType = ((FDeckEditor)this.parentScreen).getEditorType();
            Deck currentDeck = ((FDeckEditor)this.parentScreen).getDeck();
            switch (editorType) {
                case Archenemy: {
                    this.cardManager.setPool(FModel.getArchenemyCards(), true);
                    break;
                }
                case Planechase: {
                    this.cardManager.setPool(FModel.getPlanechaseCards(), true);
                    break;
                }
                case Quest: 
                case QuestCommander: {
                    ItemPool questPool = new ItemPool(PaperCard.class);
                    questPool.addAll(FModel.getQuest().getCards().getCardpool());
                    questPool.removeAll(currentDeck.getAllCardsInASinglePool(true, true));
                    if (editorType == EditorType.QuestCommander) {
                        String label;
                        Predicate<PaperCard> filter;
                        List<PaperCard> commanders = currentDeck.getCommanders();
                        if (commanders.isEmpty()) {
                            filter = DeckFormat.Commander.isLegalCommanderPredicate();
                            label = "lblCommanders";
                        } else {
                            filter = DeckFormat.Commander.isLegalCardForCommanderPredicate(commanders);
                            label = "lblCards";
                        }
                        this.cardManager.setCaption(Forge.getLocalizer().getMessage(label, new Object[0]));
                        questPool = editorType.applyCardFilter(questPool, filter);
                    }
                    this.cardManager.setPool(questPool);
                    break;
                }
                case PlanarConquest: {
                    this.cardManager.setPool(ConquestUtil.getAvailablePool(currentDeck));
                    break;
                }
                case Commander: 
                case TinyLeaders: 
                case Brawl: 
                case Oathbreaker: {
                    List<PaperCard> commanders = currentDeck.getCommanders();
                    if (commanders.isEmpty()) {
                        switch (editorType) {
                            case Commander: {
                                additionalFilter = DeckFormat.Commander.isLegalCommanderPredicate();
                                this.cardManager.setCaption(Forge.getLocalizer().getMessage("lblCommanders", new Object[0]));
                                break;
                            }
                            case Oathbreaker: {
                                additionalFilter = DeckFormat.Oathbreaker.isLegalCommanderPredicate();
                                this.cardManager.setCaption(Forge.getLocalizer().getMessage("lblOathbreakers", new Object[0]));
                                break;
                            }
                            case TinyLeaders: {
                                additionalFilter = DeckFormat.TinyLeaders.isLegalCommanderPredicate();
                                this.cardManager.setCaption(Forge.getLocalizer().getMessage("lblCommanders", new Object[0]));
                                break;
                            }
                            case Brawl: {
                                additionalFilter = DeckFormat.Brawl.isLegalCommanderPredicate();
                                this.cardManager.setCaption(Forge.getLocalizer().getMessage("lblCommanders", new Object[0]));
                                break;
                            }
                        }
                    } else {
                        switch (editorType) {
                            case Commander: {
                                additionalFilter = DeckFormat.Commander.isLegalCardForCommanderPredicate(commanders);
                                break;
                            }
                            case Oathbreaker: {
                                additionalFilter = DeckFormat.Oathbreaker.isLegalCardForCommanderPredicate(commanders);
                                break;
                            }
                            case TinyLeaders: {
                                additionalFilter = DeckFormat.TinyLeaders.isLegalCardForCommanderPredicate(commanders);
                                break;
                            }
                            case Brawl: {
                                additionalFilter = DeckFormat.Brawl.isLegalCardForCommanderPredicate(commanders);
                                break;
                            }
                        }
                        this.cardManager.setCaption(Forge.getLocalizer().getMessage("lblCards", new Object[0]));
                    }
                }
                default: {
                    ItemPool<PaperCard> cardPool = this.cardManager.getWantUnique() ? FModel.getUniqueCardsNoAlt() : FModel.getAllCardsNoAlt();
                    for (DeckSection variant : ((FDeckEditor)this.parentScreen).getVariantCardPools()) {
                        switch (variant) {
                            case Avatar: {
                                cardPool.addAll(FModel.getAvatarPool());
                                break;
                            }
                            case Conspiracy: {
                                cardPool.addAll(FModel.getConspiracyPool());
                                break;
                            }
                            case Planes: {
                                cardPool.addAll(FModel.getPlanechaseCards());
                                break;
                            }
                            case Schemes: {
                                cardPool.addAll(FModel.getArchenemyCards());
                                break;
                            }
                            case Dungeon: {
                                cardPool.addAll(FModel.getDungeonPool());
                                break;
                            }
                            case Attractions: {
                                cardPool.addAll(FModel.getAttractionPool());
                            }
                        }
                    }
                    this.cardManager.setPool(editorType.applyCardFilter(cardPool, additionalFilter), true);
                }
            }
        }

        @Override
        protected void onCardActivated(PaperCard card) {
            DeckSection destination = DeckSection.matchingSection(card);
            DeckSectionPage destinationPage = ((FDeckEditor)this.parentScreen).getPageForSection(destination);
            if (((FDeckEditor)this.parentScreen).getMaxMovable(card, this, destinationPage) <= 0) {
                return;
            }
            if (this.needsCommander()) {
                this.setCommander(card);
                return;
            }
            if (destination == DeckSection.Avatar) {
                this.setVanguard(card);
                return;
            }
            if (this.canOnlyBePartnerCommander(card)) {
                return;
            }
            if (!this.cardManager.isInfinite()) {
                this.removeCard(card);
            }
            destinationPage.addCard(card);
        }

        @Override
        protected void buildMenu(FDropDownMenu menu, final PaperCard card) {
            if (card == null) {
                return;
            }
            DeckSection destination = DeckSection.matchingSection(card);
            final DeckSectionPage destinationPage = ((FDeckEditor)this.parentScreen).getPageForSection(destination);
            if (!(this.needsCommander() || this.canOnlyBePartnerCommander(card) || this.canBeVanguard(card))) {
                this.addMoveCardMenuItem(menu, this, destinationPage, new Callback<Integer>(){

                    @Override
                    public void run(Integer result) {
                        if (result == null || result <= 0) {
                            return;
                        }
                        this.removeCard(card, result);
                        destinationPage.addCard(card, result);
                    }
                });
                if (this.canSideboard(card)) {
                    this.addMoveCardMenuItem(menu, this, ((FDeckEditor)this.parentScreen).getSideboardPage(), new Callback<Integer>(){

                        @Override
                        public void run(Integer result) {
                            if (result == null || result <= 0) {
                                return;
                            }
                            this.removeCard(card, result);
                            ((FDeckEditor)parentScreen).getSideboardPage().addCard(card, result);
                        }
                    });
                }
            }
            this.addCommanderItems(menu, card);
            if (this.canBeVanguard(card)) {
                Localizer localizer = Localizer.getInstance();
                String caption = String.join((CharSequence)" ", localizer.getMessage("lblAddCommander", new Object[0]), localizer.getMessage("lblasavatar", new Object[0]));
                menu.addItem(new FMenuItem(caption, destinationPage.getIcon(), e -> this.setVanguard(card)));
            }
            if (((FDeckEditor)this.parentScreen).getEditorType() == EditorType.Constructed) {
                final CardPreferences prefs = CardPreferences.getPrefs(card);
                if (prefs.getStarCount() == 0) {
                    menu.addItem(new FMenuItem(Forge.getLocalizer().getMessage("lblAddFavorites", new Object[0]), Forge.hdbuttons ? FSkinImage.HDSTAR_FILLED : FSkinImage.STAR_FILLED, e -> {
                        prefs.setStarCount(1);
                        CardPreferences.save();
                    }));
                } else {
                    menu.addItem(new FMenuItem(Forge.getLocalizer().getMessage("lblRemoveFavorites", new Object[0]), Forge.hdbuttons ? FSkinImage.HDSTAR_OUTLINE : FSkinImage.STAR_OUTLINE, e -> {
                        prefs.setStarCount(0);
                        CardPreferences.save();
                    }));
                }
                List<PaperCard> artOptions = FModel.getMagicDb().getCommonCards().getAllCardsNoAlt(card.getName());
                if (artOptions.size() > 1) {
                    menu.addItem(new FMenuItem(Forge.getLocalizer().getMessage("lblChangePreferredArt", new Object[0]), Forge.hdbuttons ? FSkinImage.HDPREFERENCE : FSkinImage.SETTINGS, e -> {
                        ArrayList<PaperCard> sortedOptions = new ArrayList<PaperCard>();
                        sortedOptions.add(card);
                        for (PaperCard option : artOptions) {
                            if (option == card) continue;
                            sortedOptions.add(option);
                        }
                        GuiChoose.oneOrNone(Forge.getLocalizer().getMessage("lblSelectPreferredArt", new Object[0]) + " " + card.getName(), sortedOptions, new Callback<PaperCard>(){

                            @Override
                            public void run(PaperCard result) {
                                if (result != null) {
                                    if (result != card) {
                                        cardManager.replaceAll(card, result);
                                    }
                                    prefs.setPreferredArt(result.getEdition(), result.getArtIndex());
                                    CardPreferences.save();
                                }
                            }
                        });
                    }));
                }
            }
        }

        @Override
        protected void buildDeckMenu(FPopupMenu menu) {
            if (this.cardManager.getConfig().getShowUniqueCardsOption()) {
                menu.addItem(new FCheckBoxMenuItem(Forge.getLocalizer().getMessage("lblUniqueCardsOnly", new Object[0]), this.cardManager.getWantUnique(), e -> {
                    boolean wantUnique = !this.cardManager.getWantUnique();
                    this.cardManager.setWantUnique(wantUnique);
                    this.refresh();
                    this.cardManager.getConfig().setUniqueCardsOnly(wantUnique);
                }));
            }
        }
    }

    protected static abstract class CardManagerPage
    extends DeckEditorPage {
        private final ItemManagerConfig config;
        protected final CardManager cardManager = this.add(new CardManager(false));

        protected CardManagerPage(ItemManagerConfig config0, String caption0, FImage icon0) {
            super(caption0, icon0);
            this.config = config0;
            this.cardManager.setItemActivateHandler(e -> this.onCardActivated((PaperCard)this.cardManager.getSelectedItem()));
            this.cardManager.setContextMenuBuilder(new ItemManager.ContextMenuBuilder<PaperCard>(){

                @Override
                public void buildMenu(FDropDownMenu menu, PaperCard card) {
                    this.buildMenu(menu, card);
                }
            });
            this.cardManager.setShowRanking(ItemManagerConfig.DRAFT_CONSPIRACY.equals((Object)config0) || ItemManagerConfig.DRAFT_PACK.equals((Object)config0) || ItemManagerConfig.DRAFT_POOL.equals((Object)config0) || ItemManagerConfig.DRAFT_DECKS.equals((Object)config0) || this.parentScreen != null && ((FDeckEditor)this.parentScreen).isDraftEditor());
        }

        @Override
        protected void initialize() {
            if (GuiBase.isAdventureMode()) {
                this.cardManager.setup(this.config);
            } else {
                this.cardManager.setup(this.config, ((FDeckEditor)this.parentScreen).getColOverrides(this.config));
            }
            this.cardManager.setShowRanking(ItemManagerConfig.DRAFT_CONSPIRACY.equals((Object)this.config) || ItemManagerConfig.DRAFT_PACK.equals((Object)this.config) || ItemManagerConfig.DRAFT_POOL.equals((Object)this.config) || ItemManagerConfig.DRAFT_DECKS.equals((Object)this.config) || this.parentScreen != null && ((FDeckEditor)this.parentScreen).isDraftEditor());
        }

        protected boolean canAddCards() {
            return true;
        }

        public void addCard(PaperCard card) {
            this.addCard(card, 1);
        }

        public void addCard(PaperCard card, int qty) {
            if (this.canAddCards()) {
                this.cardManager.addItem(card, qty);
                ((FDeckEditor)this.parentScreen).getEditorType().getController().notifyModelChanged();
                this.updateCaption();
            }
        }

        public void addCards(Iterable<Map.Entry<PaperCard, Integer>> cards) {
            if (this.canAddCards()) {
                this.cardManager.addItems(cards);
                ((FDeckEditor)this.parentScreen).getEditorType().getController().notifyModelChanged();
                this.updateCaption();
            }
        }

        public void removeCard(PaperCard card) {
            this.removeCard(card, 1);
        }

        public void removeCard(PaperCard card, int qty) {
            if (this.cardManager.isInfinite()) {
                return;
            }
            this.cardManager.removeItem(card, qty);
            ((FDeckEditor)this.parentScreen).getEditorType().getController().notifyModelChanged();
            this.updateCaption();
        }

        public void setCards(CardPool cards) {
            this.cardManager.setItems(cards);
            ((FDeckEditor)this.parentScreen).getEditorType().getController().notifyModelChanged();
            this.updateCaption();
        }

        protected void updateCaption() {
        }

        protected abstract void onCardActivated(PaperCard var1);

        protected abstract void buildMenu(FDropDownMenu var1, PaperCard var2);

        private ItemPool<PaperCard> getAllowedAdditions(Iterable<Map.Entry<PaperCard, Integer>> itemsToAdd, boolean isAddSource) {
            ItemPool<PaperCard> additions = new ItemPool<PaperCard>(this.cardManager.getGenericType());
            CardLimit limit = ((FDeckEditor)this.parentScreen).getCardLimit();
            Deck deck = ((FDeckEditor)this.parentScreen).getDeck();
            for (Map.Entry<PaperCard, Integer> itemEntry : itemsToAdd) {
                int qty;
                int max;
                PaperCard card = itemEntry.getKey();
                if (deck == null || card == null) {
                    max = Integer.MAX_VALUE;
                } else if (limit == CardLimit.None || DeckFormat.canHaveAnyNumberOf(card)) {
                    max = Integer.MAX_VALUE;
                    if (((FDeckEditor)this.parentScreen).isLimitedEditor() && !isAddSource) {
                        if (((FDeckEditor)this.parentScreen).getMainDeckPage() == this) {
                            max = deck.get(DeckSection.Sideboard).count(card);
                        } else if (((FDeckEditor)this.parentScreen).getSideboardPage() == this) {
                            max = deck.get(DeckSection.Main).count(card);
                        }
                    }
                } else {
                    max = limit == CardLimit.Singleton ? 1 : FModel.getPreferences().getPrefInt(ForgePreferences.FPref.DECK_DEFAULT_CARD_LIMIT);
                    Integer cardCopies = DeckFormat.canHaveSpecificNumberInDeck(card);
                    if (cardCopies != null) {
                        max = cardCopies;
                    }
                    max -= deck.getMain().count(card);
                    if (deck.has(DeckSection.Sideboard)) {
                        max -= deck.get(DeckSection.Sideboard).count(card);
                    }
                    if (deck.has(DeckSection.Commander)) {
                        max -= deck.get(DeckSection.Commander).count(card);
                    }
                    if (deck.has(DeckSection.Planes)) {
                        max -= deck.get(DeckSection.Planes).count(card);
                    }
                    if (deck.has(DeckSection.Schemes)) {
                        max -= deck.get(DeckSection.Schemes).count(card);
                    }
                }
                if (isAddSource) {
                    qty = itemEntry.getValue();
                } else if (((FDeckEditor)this.parentScreen).getEditorType() == EditorType.Quest || ((FDeckEditor)this.parentScreen).getEditorType() == EditorType.QuestCommander) {
                    try {
                        qty = ((FDeckEditor)this.parentScreen).getCatalogPage().cardManager.getItemCount(card);
                    }
                    catch (Exception e) {
                        qty = 0;
                    }
                } else {
                    qty = max;
                }
                if (qty > max) {
                    qty = max;
                }
                if (qty <= 0) continue;
                additions.add(card, qty);
            }
            return additions;
        }

        protected int getMaxMoveQuantity(boolean isAddMenu, boolean isAddSource) {
            ItemPool<PaperCard> selectedItemPool = this.cardManager.getSelectedItemPool();
            if (isAddMenu) {
                selectedItemPool = this.getAllowedAdditions(selectedItemPool, isAddSource);
            }
            if (selectedItemPool.isEmpty()) {
                return 0;
            }
            int max = Integer.MAX_VALUE;
            for (Map.Entry<PaperCard, Integer> entry : selectedItemPool) {
                if (entry.getValue() >= max) continue;
                max = entry.getValue();
            }
            return max;
        }

        protected void addItem(FDropDownMenu menu, String verb, String dest, FImage icon, boolean isAddMenu, boolean isAddSource, Callback<Integer> callback) {
            int max = this.getMaxMoveQuantity(isAddMenu, isAddSource);
            if (max == 0) {
                return;
            }
            String label = verb;
            if (!StringUtils.isEmpty(dest)) {
                label = label + " " + dest;
            }
            menu.addItem(new FMenuItem(label, icon, e -> {
                if (max == 1) {
                    callback.run(max);
                } else {
                    GuiChoose.getInteger(this.cardManager.getSelectedItem() + " - " + verb + " " + Forge.getLocalizer().getMessage("lblHowMany", new Object[0]), 1, max, 20, callback);
                }
            }));
        }

        /*
         * WARNING - void declaration
         */
        protected void addMoveCardMenuItem(FDropDownMenu menu, CardManagerPage source, CardManagerPage destination, Callback<Integer> callback) {
            void var8_16;
            String labelSection;
            ItemPool<PaperCard> selectedItemPool = this.cardManager.getSelectedItemPool();
            if (source != this || this.cardManager.isInfinite()) {
                selectedItemPool = ((FDeckEditor)this.parentScreen).getAllowedAdditions(selectedItemPool, source, destination);
            }
            int maxMovable = selectedItemPool.isEmpty() ? 0 : Integer.MAX_VALUE;
            for (Map.Entry<PaperCard, Integer> entry : selectedItemPool) {
                maxMovable = Math.min(maxMovable, entry.getValue());
            }
            if (maxMovable == 0) {
                return;
            }
            PaperCard sampleCard = (PaperCard)this.cardManager.getSelectedItem();
            if (destination == null || destination instanceof CatalogPage) {
                String string = "lblRemove";
                labelSection = source instanceof DeckSectionPage ? this.getMoveLabel((DeckSectionPage)source, sampleCard, true) : "lblCard";
            } else if (destination == this && source instanceof DeckSectionPage) {
                String string = "lblAdd";
                labelSection = this.getMoveLabel((DeckSectionPage)source, sampleCard, true);
            } else if (source instanceof DeckSectionPage && destination instanceof DeckSectionPage) {
                String string = "lblMove";
                labelSection = this.getMoveLabel((DeckSectionPage)destination, sampleCard, false);
            } else if (destination instanceof DeckSectionPage) {
                DeckSectionPage deckSectionPage = (DeckSectionPage)destination;
                if (deckSectionPage.deckSection == DeckSection.Commander || deckSectionPage.deckSection == DeckSection.Avatar) {
                    String string = "lblSet";
                } else {
                    String string = "lblAdd";
                }
                labelSection = this.getMoveLabel(deckSectionPage, sampleCard, false);
            } else {
                String string = "lblRemove";
                labelSection = "lblCard";
            }
            Localizer localizer = Localizer.getInstance();
            String action = localizer.getMessage((String)var8_16, new Object[0]);
            String label = String.join((CharSequence)" ", action, localizer.getMessage(labelSection, new Object[0]));
            String prompt = String.format("%s - %s %s", sampleCard, action, localizer.getMessage("lblHowMany", new Object[0]));
            FImage icon = source instanceof CatalogPage && destination instanceof DeckSectionPage && ((DeckSectionPage)destination).deckSection == DeckSection.Main ? (Forge.hdbuttons ? FSkinImage.HDPLUS : FSkinImage.PLUS) : (destination == null || destination instanceof CatalogPage ? (Forge.hdbuttons ? FSkinImage.HDMINUS : FSkinImage.MINUS) : destination.getIcon());
            int max = maxMovable;
            menu.addItem(new FMenuItem(label, icon, e -> {
                if (max < 2) {
                    callback.run(1);
                } else {
                    GuiChoose.getInteger(prompt, 1, max, 20, callback);
                }
            }));
        }

        private String getMoveLabel(DeckSectionPage page, PaperCard selectedCard, boolean from) {
            switch (page.deckSection) {
                default: {
                    return from ? "lblfromdeck" : "lbltodeck";
                }
                case Sideboard: {
                    return from ? "lblfromsideboard" : "lbltosideboard";
                }
                case Planes: {
                    return from ? "lblfromplanardeck" : "lbltoplanardeck";
                }
                case Schemes: {
                    return from ? "lblfromschemedeck" : "lbltoschemedeck";
                }
                case Conspiracy: {
                    return from ? "lblfromconspiracydeck" : "lbltoconspiracydeck";
                }
                case Dungeon: {
                    return from ? "lblfromdungeondeck" : "lbltodungeondeck";
                }
                case Attractions: {
                    return from ? "lblfromattractiondeck" : "lbltoattractiondeck";
                }
                case Avatar: {
                    return "lblasavatar";
                }
                case Commander: 
            }
            if (((FDeckEditor)this.parentScreen).editorType == EditorType.Oathbreaker) {
                if (selectedCard.getRules().canBeOathbreaker()) {
                    return "lblasoathbreaker";
                }
                return "lblassignaturespell";
            }
            return "lblascommander";
        }

        protected void addCommanderItems(FDropDownMenu menu, PaperCard card) {
            String caption;
            if (!((FDeckEditor)this.parentScreen).isCommanderEditor()) {
                return;
            }
            if (((FDeckEditor)this.parentScreen).getMaxMovable(card, this, ((FDeckEditor)this.parentScreen).getCommanderPage()) <= 0) {
                return;
            }
            Localizer localizer = Forge.getLocalizer();
            String captionPrefix = localizer.getMessage("lblAddCommander", new Object[0]);
            FImage icon = ((FDeckEditor)this.parentScreen).getCommanderPage().icon;
            if (this.canBeCommander(card)) {
                String captionSuffix = ((FDeckEditor)this.parentScreen).getEditorType() == EditorType.Oathbreaker ? localizer.getMessage("lblasoathbreaker", new Object[0]) : localizer.getMessage("lblascommander", new Object[0]);
                String caption2 = String.join((CharSequence)" ", captionPrefix, captionSuffix);
                menu.addItem(new FMenuItem(caption2, icon, e -> this.setCommander(card)));
            }
            if (this.canBePartnerCommander(card)) {
                caption = String.join((CharSequence)" ", captionPrefix, localizer.getMessage("lblaspartnercommander", new Object[0]));
                menu.addItem(new FMenuItem(caption, icon, e -> this.setPartnerCommander(card)));
            }
            if (this.canBeSignatureSpell(card)) {
                caption = String.join((CharSequence)" ", captionPrefix, localizer.getMessage("lblassignaturespell", new Object[0]));
                menu.addItem(new FMenuItem(caption, FSkinImage.SORCERY, e -> this.setSignatureSpell(card)));
            }
        }

        protected boolean needsCommander() {
            return ((FDeckEditor)this.parentScreen).isCommanderEditor() && ((FDeckEditor)this.parentScreen).getDeck().getCommanders().isEmpty();
        }

        protected boolean canBeCommander(PaperCard card) {
            if (!((FDeckEditor)this.parentScreen).isCommanderEditor() || ((FDeckEditor)this.parentScreen).getCommanderPage() == null) {
                return false;
            }
            if (((FDeckEditor)this.parentScreen).getCommanderPage().cardManager.getPool().contains(card)) {
                return false;
            }
            switch (((FDeckEditor)this.parentScreen).editorType) {
                case Brawl: {
                    return card.getRules().canBeBrawlCommander();
                }
                case TinyLeaders: {
                    return card.getRules().canBeTinyLeadersCommander();
                }
                case Oathbreaker: {
                    return card.getRules().canBeOathbreaker();
                }
                case PlanarConquest: {
                    return false;
                }
            }
            return DeckFormat.Commander.isLegalCommander(card.getRules());
        }

        protected boolean canBePartnerCommander(PaperCard card) {
            if (!((FDeckEditor)this.parentScreen).isCommanderEditor()) {
                return false;
            }
            if (((FDeckEditor)this.parentScreen).editorType == EditorType.Oathbreaker) {
                return false;
            }
            List commanders = ((FDeckEditor)this.parentScreen).getDeck().get(DeckSection.Commander).toFlatList();
            commanders.removeIf(c -> c.getRules().canBeSignatureSpell());
            if (commanders.size() != 1) {
                return false;
            }
            return ((PaperCard)commanders.get(0)).getRules().canBePartnerCommanders(card.getRules());
        }

        protected boolean canBeSignatureSpell(PaperCard card) {
            if (((FDeckEditor)this.parentScreen).getEditorType() != EditorType.Oathbreaker) {
                return false;
            }
            PaperCard oathbreaker = ((FDeckEditor)this.parentScreen).getDeck().getOathbreaker();
            if (oathbreaker == null) {
                return false;
            }
            return card.getRules().canBeSignatureSpell() && card.getRules().getColorIdentity().hasNoColorsExcept(oathbreaker.getRules().getColorIdentity());
        }

        protected boolean canSideboard(PaperCard card) {
            if (((FDeckEditor)this.parentScreen).getSideboardPage() == null) {
                return false;
            }
            if (((FDeckEditor)this.parentScreen).isLimitedEditor()) {
                return true;
            }
            return DeckSection.matchingSection(card) == DeckSection.Main;
        }

        protected boolean canOnlyBePartnerCommander(PaperCard card) {
            if (!((FDeckEditor)this.parentScreen).isCommanderEditor()) {
                return false;
            }
            int cmdCI = 0;
            for (PaperCard p : ((FDeckEditor)this.parentScreen).getDeck().getCommanders()) {
                cmdCI = (byte)(cmdCI | p.getRules().getColorIdentity().getColor());
            }
            return !card.getRules().getColorIdentity().hasNoColorsExcept(cmdCI);
        }

        protected boolean canBeVanguard(PaperCard card) {
            return DeckSection.matchingSection(card) == DeckSection.Avatar;
        }

        protected void setVanguard(PaperCard card) {
            if (!this.cardManager.isInfinite()) {
                this.removeCard(card);
            }
            CardPool newPool = new CardPool();
            newPool.add(card);
            ((FDeckEditor)this.parentScreen).getPageForSection(DeckSection.Avatar).setCards(newPool);
        }

        protected void setCommander(PaperCard card) {
            if (!this.cardManager.isInfinite()) {
                this.removeCard(card);
            }
            CardPool newPool = new CardPool();
            newPool.add(card);
            ((FDeckEditor)this.parentScreen).getCommanderPage().setCards(newPool);
            this.refresh();
        }

        protected void setPartnerCommander(PaperCard card) {
            if (!this.cardManager.isInfinite()) {
                this.removeCard(card);
            }
            ((FDeckEditor)this.parentScreen).getCommanderPage().addCard(card);
            this.refresh();
        }

        protected void setSignatureSpell(PaperCard card) {
            PaperCard signatureSpell;
            if (!this.cardManager.isInfinite()) {
                this.removeCard(card);
            }
            if ((signatureSpell = ((FDeckEditor)this.parentScreen).getDeck().getSignatureSpell()) != null) {
                ((FDeckEditor)this.parentScreen).getCommanderPage().removeCard(signatureSpell);
            }
            ((FDeckEditor)this.parentScreen).getCommanderPage().addCard(card);
        }

        public void refresh() {
        }

        @Override
        protected void doLayout(float width, float height) {
            float x = 0.0f;
            if (Forge.isLandscapeMode()) {
                x = ItemFilter.PADDING;
                width -= 2.0f * x;
            }
            this.cardManager.setBounds(x, 0.0f, width, height);
        }
    }

    protected static abstract class DeckEditorPage
    extends TabPageScreen.TabPage<FDeckEditor> {
        protected DeckEditorPage(String caption0, FImage icon0) {
            super(caption0, icon0);
        }

        protected void buildDeckMenu(FPopupMenu menu) {
        }

        protected abstract void initialize();

        @Override
        public boolean fling(float velocityX, float velocityY) {
            return false;
        }
    }

    protected class DeckHeader
    extends FContainer {
        private DeckHeader() {
            this.setHeight(HEADER_HEIGHT);
        }

        @Override
        public void drawBackground(Graphics g2) {
            g2.fillRect(FScreen.Header.getBackColor(), 0.0f, 0.0f, this.getWidth(), HEADER_HEIGHT);
        }

        @Override
        public void drawOverlay(Graphics g2) {
            float y = HEADER_HEIGHT - FScreen.Header.LINE_THICKNESS / 2.0f;
            g2.drawLine(FScreen.Header.LINE_THICKNESS, FScreen.Header.getLineColor(), 0.0f, y, this.getWidth(), y);
        }

        @Override
        protected void doLayout(float width, float height) {
            float x = 0.0f;
            FDeckEditor.this.lblName.setBounds(0.0f, 0.0f, width - 2.0f * height, height);
            FDeckEditor.this.btnSave.setBounds(x += FDeckEditor.this.lblName.getWidth(), 0.0f, height, height);
            FDeckEditor.this.btnMoreOptions.setBounds(x += height, 0.0f, height, height);
        }
    }

    private static enum CardLimit {
        Singleton,
        Default,
        None;

    }

    public static enum EditorType {
        Constructed(new DeckController<Deck>(FModel.getDecks().getConstructed(), Deck::new), null),
        Draft(new DeckController<DeckGroup>(FModel.getDecks().getDraft(), DeckGroup::new), null),
        Sealed(new DeckController<DeckGroup>(FModel.getDecks().getSealed(), DeckGroup::new), null),
        Winston(new DeckController<DeckGroup>(FModel.getDecks().getWinston(), DeckGroup::new), null),
        Commander(new DeckController<Deck>(FModel.getDecks().getCommander(), Deck::new), null),
        Oathbreaker(new DeckController<Deck>(FModel.getDecks().getOathbreaker(), Deck::new), null),
        TinyLeaders(new DeckController<Deck>(FModel.getDecks().getTinyLeaders(), Deck::new), DeckFormat.TinyLeaders.isLegalCardPredicate()),
        Brawl(new DeckController<Deck>(FModel.getDecks().getBrawl(), Deck::new), DeckFormat.Brawl.isLegalCardPredicate()),
        Archenemy(new DeckController<Deck>(FModel.getDecks().getScheme(), Deck::new), null),
        Planechase(new DeckController<Deck>(FModel.getDecks().getPlane(), Deck::new), null),
        Quest(new DeckController<Deck>(null, Deck::new), null),
        QuestCommander(new DeckController<Deck>(null, Deck::new), null),
        QuestDraft(new DeckController<DeckGroup>(null, DeckGroup::new), null),
        PlanarConquest(new DeckController<Deck>(null, Deck::new), null);

        private static final Set<EditorType> LIMITED_TYPES;
        private static final Set<EditorType> USER_CARD_POOL_TYPES;
        private static final Set<EditorType> COMMANDER_TYPES;
        private final DeckController<? extends DeckBase> controller;
        private final Predicate<PaperCard> cardFilter;

        public DeckController<? extends DeckBase> getController() {
            return this.controller;
        }

        private EditorType(DeckController<? extends DeckBase> controller0, Predicate<PaperCard> cardFilter0) {
            this.controller = controller0;
            this.cardFilter = cardFilter0;
        }

        private ItemPool<PaperCard> applyCardFilter(ItemPool<PaperCard> cardPool, Predicate<PaperCard> additionalFilter) {
            Predicate<PaperCard> filter = this.cardFilter;
            if (filter == null) {
                filter = additionalFilter;
                if (filter == null) {
                    return cardPool;
                }
            } else if (additionalFilter != null) {
                filter = Predicates.and(filter, additionalFilter);
            }
            ItemPool<PaperCard> filteredPool = new ItemPool<PaperCard>(PaperCard.class);
            for (Map.Entry<PaperCard, Integer> entry : cardPool) {
                if (!filter.apply(entry.getKey())) continue;
                filteredPool.add(entry.getKey(), entry.getValue());
            }
            return filteredPool;
        }

        public boolean isLimitedType() {
            return LIMITED_TYPES.contains((Object)this);
        }

        public boolean isCommanderType() {
            return COMMANDER_TYPES.contains((Object)this);
        }

        public boolean hasInfiniteCardPool() {
            return !USER_CARD_POOL_TYPES.contains((Object)this);
        }

        static {
            LIMITED_TYPES = Collections.unmodifiableSet(EnumSet.of(Draft, Sealed, Winston, QuestDraft));
            USER_CARD_POOL_TYPES = Collections.unmodifiableSet(EnumSet.of(Draft, new EditorType[]{Sealed, Winston, QuestDraft, Quest, QuestCommander, PlanarConquest}));
            COMMANDER_TYPES = Collections.unmodifiableSet(EnumSet.of(Commander, Oathbreaker, TinyLeaders, Brawl, QuestCommander));
        }
    }
}

