/*
 * Decompiled with CFR 0.152.
 */
package forge.deck;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import forge.Forge;
import forge.assets.ImageCache;
import forge.deck.ArchetypeDeckGenerator;
import forge.deck.ColorDeckGenerator;
import forge.deck.CommanderDeckGenerator;
import forge.deck.Deck;
import forge.deck.DeckProxy;
import forge.deck.DeckType;
import forge.deck.DeckgenUtil;
import forge.deck.FDeckEditor;
import forge.deck.FDeckViewer;
import forge.deck.NetDeckArchiveBlock;
import forge.deck.NetDeckArchiveLegacy;
import forge.deck.NetDeckArchiveModern;
import forge.deck.NetDeckArchivePauper;
import forge.deck.NetDeckArchivePioneer;
import forge.deck.NetDeckArchiveStandard;
import forge.deck.NetDeckArchiveVintage;
import forge.deck.NetDeckCategory;
import forge.deck.RandomDeckGenerator;
import forge.deck.io.DeckPreferences;
import forge.game.GameFormat;
import forge.game.GameType;
import forge.game.player.RegisteredPlayer;
import forge.gamemodes.gauntlet.GauntletData;
import forge.gamemodes.gauntlet.GauntletUtil;
import forge.gamemodes.match.HostedMatch;
import forge.gamemodes.quest.QuestController;
import forge.gamemodes.quest.QuestEvent;
import forge.gamemodes.quest.QuestEventChallenge;
import forge.gamemodes.quest.QuestUtil;
import forge.gui.FThreads;
import forge.gui.GuiBase;
import forge.gui.error.BugReporter;
import forge.gui.interfaces.IGuiGame;
import forge.itemmanager.DeckManager;
import forge.itemmanager.ItemManagerConfig;
import forge.itemmanager.filters.ItemFilter;
import forge.localinstance.properties.ForgePreferences;
import forge.model.FModel;
import forge.player.GamePlayerUtil;
import forge.screens.FScreen;
import forge.screens.LoadingOverlay;
import forge.screens.home.NewGameMenu;
import forge.screens.match.MatchController;
import forge.toolbox.FButton;
import forge.toolbox.FComboBox;
import forge.toolbox.FContainer;
import forge.toolbox.FDisplayObject;
import forge.toolbox.FEvent;
import forge.toolbox.FOptionPane;
import forge.toolbox.GuiChoose;
import forge.toolbox.ListChooser;
import forge.util.Callback;
import forge.util.Localizer;
import forge.util.MyRandom;
import forge.util.Utils;
import forge.util.storage.IStorage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class FDeckChooser
extends FScreen {
    public static final float PADDING = Utils.scale(5.0f);
    private FComboBox<DeckType> cmbDeckTypes;
    private DeckType selectedDeckType;
    private boolean needRefreshOnActivate;
    private Callback<Deck> callback;
    private NetDeckCategory netDeckCategory;
    private NetDeckArchiveStandard NetDeckArchiveStandard;
    private NetDeckArchivePioneer NetDeckArchivePioneer;
    private NetDeckArchiveModern NetDeckArchiveModern;
    private NetDeckArchivePauper NetDeckArchivePauper;
    private NetDeckArchiveLegacy NetDeckArchiveLegacy;
    private NetDeckArchiveVintage NetDeckArchiveVintage;
    private NetDeckArchiveBlock NetDeckArchiveBlock;
    private boolean refreshingDeckType;
    private boolean firstActivation = true;
    private final DeckManager lstDecks;
    private List<DeckProxy> AIDecks = new ArrayList<DeckProxy>();
    private final FButton btnNewDeck;
    private final FButton btnEditDeck;
    private final FButton btnViewDeck;
    private final FButton btnRandom;
    private RegisteredPlayer player;
    private boolean isAi;
    private final ForgePreferences prefs;
    private ForgePreferences.FPref stateSetting;
    private FOptionPane optionPane;
    private final String SELECTED_DECK_DELIMITER = "::";

    public static void promptForDeck(String title, GameType gameType, boolean forAi, final Callback<Deck> callback) {
        FThreads.assertExecutedByEdt(true);
        final FDeckChooser deckChooser = new FDeckChooser(gameType, forAi, null);
        FContainer container = new FContainer(){

            @Override
            protected void doLayout(float width, float height) {
                float x = 0.0f;
                float y = ItemFilter.PADDING;
                float fieldHeight = deckChooser.cmbDeckTypes.getHeight();
                deckChooser.cmbDeckTypes.setBounds(x, y, width, fieldHeight);
                deckChooser.lstDecks.setBounds(x, y += fieldHeight + 1.0f, width, height - y);
            }
        };
        container.add(deckChooser.cmbDeckTypes);
        container.add(deckChooser.lstDecks);
        container.setHeight(FOptionPane.getMaxDisplayObjHeight());
        Forge.getLocalizer();
        String string = Localizer.getInstance().getMessage("lblOK", new Object[0]);
        Forge.getLocalizer();
        deckChooser.optionPane = new FOptionPane(null, null, title, null, (FDisplayObject)container, ImmutableList.of(string, Localizer.getInstance().getMessage("lblCancel", new Object[0])), 0, (Callback)new Callback<Integer>(){

            @Override
            public void run(Integer result) {
                if (result == 0 && callback != null) {
                    callback.run(deckChooser.getDeck());
                }
            }
        }){

            @Override
            protected boolean padAboveAndBelow() {
                return false;
            }
        };
        deckChooser.optionPane.show();
    }

    public FDeckChooser(GameType gameType0, boolean isAi0, FEvent.FEventHandler selectionChangedHandler) {
        super("");
        Forge.getLocalizer();
        this.btnNewDeck = new FButton(Localizer.getInstance().getMessage("lblNewDeck", new Object[0]));
        Forge.getLocalizer();
        this.btnEditDeck = new FButton(Localizer.getInstance().getMessage("btnEditDeck", new Object[0]));
        Forge.getLocalizer();
        this.btnViewDeck = new FButton(Localizer.getInstance().getMessage("lblViewDeck", new Object[0]));
        Forge.getLocalizer();
        this.btnRandom = new FButton(Localizer.getInstance().getMessage("lblRandomDeck", new Object[0]));
        this.prefs = FModel.getPreferences();
        this.stateSetting = null;
        this.SELECTED_DECK_DELIMITER = "::";
        this.lstDecks = new DeckManager(gameType0);
        this.isAi = isAi0;
        this.lstDecks.setItemActivateHandler(event -> {
            if (this.lstDecks.getGameType() == GameType.DeckManager) {
                this.editSelectedDeck();
                return;
            }
            this.accept();
        });
        this.btnNewDeck.setCommand(event -> this.createNewDeck());
        this.btnEditDeck.setCommand(event -> this.editSelectedDeck());
        this.btnViewDeck.setCommand(event -> {
            if (this.selectedDeckType != DeckType.STANDARD_COLOR_DECK && this.selectedDeckType != DeckType.STANDARD_CARDGEN_DECK && this.selectedDeckType != DeckType.PIONEER_CARDGEN_DECK && this.selectedDeckType != DeckType.HISTORIC_CARDGEN_DECK && this.selectedDeckType != DeckType.MODERN_CARDGEN_DECK && this.selectedDeckType != DeckType.LEGACY_CARDGEN_DECK && this.selectedDeckType != DeckType.VINTAGE_CARDGEN_DECK && this.selectedDeckType != DeckType.MODERN_COLOR_DECK && this.selectedDeckType != DeckType.PAUPER_CARDGEN_DECK && this.selectedDeckType != DeckType.PAUPER_COLOR_DECK && this.selectedDeckType != DeckType.COLOR_DECK && this.selectedDeckType != DeckType.THEME_DECK && this.selectedDeckType != DeckType.RANDOM_COMMANDER_DECK && this.selectedDeckType != DeckType.RANDOM_CARDGEN_COMMANDER_DECK) {
                FDeckViewer.show(this.getDeck(), false, DeckType.DRAFT_DECK.equals((Object)this.selectedDeckType));
            }
        });
        this.btnRandom.setCommand(event -> {
            if (this.lstDecks.getGameType() == GameType.DeckManager) {
                this.testSelectedDeck();
                return;
            }
            if (this.selectedDeckType == DeckType.COLOR_DECK || this.selectedDeckType == DeckType.STANDARD_COLOR_DECK || this.selectedDeckType == DeckType.MODERN_COLOR_DECK || this.selectedDeckType == DeckType.PAUPER_COLOR_DECK) {
                DeckgenUtil.randomSelectColors(this.lstDecks);
            } else if (this.selectedDeckType == DeckType.STANDARD_CARDGEN_DECK) {
                DeckgenUtil.randomSelect(this.lstDecks);
            } else if (this.selectedDeckType == DeckType.PIONEER_CARDGEN_DECK) {
                DeckgenUtil.randomSelect(this.lstDecks);
            } else if (this.selectedDeckType == DeckType.HISTORIC_CARDGEN_DECK) {
                DeckgenUtil.randomSelect(this.lstDecks);
            } else if (this.selectedDeckType == DeckType.MODERN_CARDGEN_DECK) {
                DeckgenUtil.randomSelect(this.lstDecks);
            } else if (this.selectedDeckType == DeckType.LEGACY_CARDGEN_DECK) {
                DeckgenUtil.randomSelect(this.lstDecks);
            } else if (this.selectedDeckType == DeckType.VINTAGE_CARDGEN_DECK) {
                DeckgenUtil.randomSelect(this.lstDecks);
            } else if (this.selectedDeckType == DeckType.PAUPER_CARDGEN_DECK) {
                DeckgenUtil.randomSelect(this.lstDecks);
            } else {
                int size = 0;
                try {
                    if (this.isAi && !this.isGeneratedDeck(this.selectedDeckType) && Forge.autoAIDeckSelection) {
                        this.btnRandom.setEnabled(false);
                        this.AIDecks = this.lstDecks.getPool().toFlatList().parallelStream().filter(deckProxy -> deckProxy.getAI().inMainDeck == 0).collect(Collectors.toList());
                        size = this.AIDecks.size();
                    }
                    if (size > 10) {
                        this.lstDecks.setSelectedItem(this.AIDecks.get(MyRandom.getRandom().nextInt(size)));
                    } else {
                        DeckgenUtil.randomSelect(this.lstDecks);
                    }
                }
                catch (Exception ee) {
                    DeckgenUtil.randomSelect(this.lstDecks);
                }
            }
            this.btnRandom.setEnabled(true);
            this.accept();
        });
        switch (this.lstDecks.getGameType()) {
            case Constructed: {
                break;
            }
            case Commander: 
            case Oathbreaker: 
            case TinyLeaders: 
            case Brawl: 
            case Gauntlet: {
                this.initialize(null, DeckType.CUSTOM_DECK);
                break;
            }
            case DeckManager: {
                this.initialize(null, DeckPreferences.getSelectedDeckType());
                break;
            }
            default: {
                this.initialize(null, DeckType.RANDOM_DECK);
            }
        }
        this.lstDecks.setSelectionChangedHandler(selectionChangedHandler);
    }

    private void accept() {
        if (this.optionPane == null) {
            Forge.back();
            if (this.callback != null) {
                this.callback.run(this.getDeck());
            }
        } else {
            this.optionPane.setResult(0);
        }
    }

    @Override
    public void onActivate() {
        if (this.cmbDeckTypes != null && this.cmbDeckTypes.getDropDownisVisible()) {
            this.cmbDeckTypes.hideDropDown();
        }
        String selectedDeck = "";
        int index = 0;
        if (this.lstDecks.getSelectedItem() != null) {
            selectedDeck = ((DeckProxy)this.lstDecks.getSelectedItem()).getDeck().toString();
            index = this.lstDecks.getSelectedIndex();
        }
        if (this.lstDecks.getConfig().getViewIndex() == 1 && this.firstActivation) {
            this.firstActivation = false;
            this.lstDecks.refresh();
            if (this.selectedDeckType.name().startsWith("NET_")) {
                this.lstDecks.setSelectedString(selectedDeck);
            } else if (this.lstDecks.getSelectedIndex() < 0) {
                this.lstDecks.setSelectedIndex(index);
            }
        } else if (this.needRefreshOnActivate) {
            this.needRefreshOnActivate = false;
            this.refreshDecksList(this.selectedDeckType, true, null);
            block0 : switch (this.lstDecks.getGameType()) {
                case Commander: {
                    this.lstDecks.setSelectedString(DeckPreferences.getCommanderDeck());
                    break;
                }
                case Oathbreaker: {
                    this.lstDecks.setSelectedString(DeckPreferences.getOathbreakerDeck());
                    break;
                }
                case TinyLeaders: {
                    this.lstDecks.setSelectedString(DeckPreferences.getTinyLeadersDeck());
                    break;
                }
                case Brawl: {
                    this.lstDecks.setSelectedString(DeckPreferences.getBrawlDeck());
                    break;
                }
                case Archenemy: {
                    this.lstDecks.setSelectedString(DeckPreferences.getSchemeDeck());
                    break;
                }
                case Planechase: {
                    this.lstDecks.setSelectedString(DeckPreferences.getPlanarDeck());
                    break;
                }
                case DeckManager: {
                    switch (this.selectedDeckType) {
                        case COMMANDER_DECK: {
                            this.lstDecks.setSelectedString(DeckPreferences.getCommanderDeck());
                            break block0;
                        }
                        case OATHBREAKER_DECK: {
                            this.lstDecks.setSelectedString(DeckPreferences.getOathbreakerDeck());
                            break block0;
                        }
                        case TINY_LEADERS_DECK: {
                            this.lstDecks.setSelectedString(DeckPreferences.getTinyLeadersDeck());
                            break block0;
                        }
                        case BRAWL_DECK: {
                            this.lstDecks.setSelectedString(DeckPreferences.getBrawlDeck());
                            break block0;
                        }
                        case SCHEME_DECK: {
                            this.lstDecks.setSelectedString(DeckPreferences.getSchemeDeck());
                            break block0;
                        }
                        case PLANAR_DECK: {
                            this.lstDecks.setSelectedString(DeckPreferences.getPlanarDeck());
                            break block0;
                        }
                        case DRAFT_DECK: {
                            this.lstDecks.setSelectedString(DeckPreferences.getDraftDeck());
                            break block0;
                        }
                        case SEALED_DECK: {
                            this.lstDecks.setSelectedString(DeckPreferences.getSealedDeck());
                            break block0;
                        }
                    }
                    this.lstDecks.setSelectedString(DeckPreferences.getCurrentDeck());
                    break;
                }
                default: {
                    if (this.lstDecks.setSelectedString(DeckPreferences.getCurrentDeck())) break;
                    this.lstDecks.setSelectedString(selectedDeck);
                }
            }
        }
    }

    private boolean isGeneratedDeck(DeckType deckType) {
        switch (deckType) {
            case COLOR_DECK: 
            case STANDARD_COLOR_DECK: 
            case STANDARD_CARDGEN_DECK: 
            case PAUPER_COLOR_DECK: 
            case RANDOM_CARDGEN_COMMANDER_DECK: 
            case RANDOM_COMMANDER_DECK: 
            case MODERN_CARDGEN_DECK: 
            case PIONEER_CARDGEN_DECK: 
            case HISTORIC_CARDGEN_DECK: 
            case LEGACY_CARDGEN_DECK: 
            case VINTAGE_CARDGEN_DECK: 
            case PAUPER_CARDGEN_DECK: 
            case MODERN_COLOR_DECK: 
            case THEME_DECK: 
            case RANDOM_DECK: {
                return true;
            }
        }
        return false;
    }

    private void createNewDeck() {
        FDeckEditor editor;
        DeckProxy deck = (DeckProxy)this.lstDecks.getSelectedItem();
        if (this.selectedDeckType == DeckType.DRAFT_DECK) {
            NewGameMenu.NewGameScreen.BoosterDraft.open();
            return;
        }
        if (this.selectedDeckType == DeckType.SEALED_DECK) {
            NewGameMenu.NewGameScreen.SealedDeck.open();
            return;
        }
        if (this.isGeneratedDeck(this.selectedDeckType) && deck == null) {
            FOptionPane.showErrorDialog(Forge.getLocalizer().getMessage("lblMustSelectGenerateNewDeck", new Object[0]));
            return;
        }
        if (this.isGeneratedDeck(this.selectedDeckType)) {
            Deck generatedDeck = deck.getDeck();
            if (generatedDeck == null) {
                return;
            }
            generatedDeck = (Deck)generatedDeck.copyTo("");
            editor = new FDeckEditor(this.getEditorType(), generatedDeck, true);
        } else {
            editor = new FDeckEditor(this.getEditorType(), "", false);
        }
        editor.setSaveHandler(event -> {
            if (!this.needRefreshOnActivate) {
                this.needRefreshOnActivate = true;
                if (this.lstDecks.getGameType() == GameType.DeckManager) {
                    switch (this.selectedDeckType) {
                        case COMMANDER_DECK: 
                        case OATHBREAKER_DECK: 
                        case TINY_LEADERS_DECK: 
                        case BRAWL_DECK: 
                        case SCHEME_DECK: 
                        case PLANAR_DECK: 
                        case DRAFT_DECK: 
                        case SEALED_DECK: {
                            break;
                        }
                        default: {
                            this.setSelectedDeckType(DeckType.CONSTRUCTED_DECK);
                            break;
                        }
                    }
                } else {
                    this.setSelectedDeckType(DeckType.CUSTOM_DECK);
                }
            }
        });
        Forge.openScreen(editor);
    }

    private void editSelectedDeck() {
        final DeckProxy deck = (DeckProxy)this.lstDecks.getSelectedItem();
        if (deck == null) {
            return;
        }
        switch (this.selectedDeckType) {
            case COMMANDER_DECK: 
            case OATHBREAKER_DECK: 
            case TINY_LEADERS_DECK: 
            case BRAWL_DECK: 
            case SCHEME_DECK: 
            case PLANAR_DECK: 
            case DRAFT_DECK: 
            case SEALED_DECK: 
            case CUSTOM_DECK: 
            case CONSTRUCTED_DECK: {
                this.editDeck(deck);
                break;
            }
            default: {
                final DeckType fallbackType = this.lstDecks.getGameType() == GameType.DeckManager ? DeckType.CONSTRUCTED_DECK : DeckType.CUSTOM_DECK;
                IStorage<Deck> decks = FModel.getDecks().getConstructed();
                Deck existingDeck = decks.get(deck.getName());
                if (existingDeck != null) {
                    this.setSelectedDeckType(fallbackType);
                    this.editDeck(new DeckProxy(existingDeck, "Constructed", this.lstDecks.getGameType(), decks));
                    return;
                }
                FOptionPane.showConfirmDialog((Object)((Object)this.selectedDeckType) + " " + Forge.getLocalizer().getMessage("lblCannotEditDuplicateCustomDeck", new Object[0]).replace("%s", deck.getName()), Forge.getLocalizer().getMessage("lblDuplicateDeck", new Object[0]), Forge.getLocalizer().getMessage("lblDuplicate", new Object[0]), Forge.getLocalizer().getMessage("lblCancel", new Object[0]), new Callback<Boolean>(){

                    @Override
                    public void run(Boolean result) {
                        if (result.booleanValue()) {
                            IStorage<Deck> storage;
                            Deck copiedDeck = (Deck)deck.getDeck().copyTo(deck.getName());
                            switch (FDeckChooser.this.lstDecks.getGameType()) {
                                case Commander: {
                                    storage = FModel.getDecks().getCommander();
                                    break;
                                }
                                case Brawl: {
                                    storage = FModel.getDecks().getBrawl();
                                    break;
                                }
                                case TinyLeaders: {
                                    storage = FModel.getDecks().getTinyLeaders();
                                    break;
                                }
                                case Oathbreaker: {
                                    storage = FModel.getDecks().getOathbreaker();
                                    break;
                                }
                                default: {
                                    storage = FModel.getDecks().getConstructed();
                                }
                            }
                            storage.add(copiedDeck);
                            FDeckChooser.this.setSelectedDeckType(fallbackType);
                            FDeckChooser.this.editDeck(new DeckProxy(copiedDeck, "Constructed", FDeckChooser.this.lstDecks.getGameType(), storage));
                        }
                    }
                });
            }
        }
    }

    private FDeckEditor.EditorType getEditorType() {
        switch (this.lstDecks.getGameType()) {
            case DeckManager: {
                switch (this.selectedDeckType) {
                    case COMMANDER_DECK: {
                        return FDeckEditor.EditorType.Commander;
                    }
                    case OATHBREAKER_DECK: {
                        return FDeckEditor.EditorType.Oathbreaker;
                    }
                    case TINY_LEADERS_DECK: {
                        return FDeckEditor.EditorType.TinyLeaders;
                    }
                    case BRAWL_DECK: {
                        return FDeckEditor.EditorType.Brawl;
                    }
                    case SCHEME_DECK: {
                        return FDeckEditor.EditorType.Archenemy;
                    }
                    case PLANAR_DECK: {
                        return FDeckEditor.EditorType.Planechase;
                    }
                    case DRAFT_DECK: {
                        return FDeckEditor.EditorType.Draft;
                    }
                    case SEALED_DECK: {
                        return FDeckEditor.EditorType.Sealed;
                    }
                }
                return FDeckEditor.EditorType.Constructed;
            }
            case Commander: {
                return FDeckEditor.EditorType.Commander;
            }
            case Oathbreaker: {
                return FDeckEditor.EditorType.Oathbreaker;
            }
            case TinyLeaders: {
                return FDeckEditor.EditorType.TinyLeaders;
            }
            case Brawl: {
                return FDeckEditor.EditorType.Brawl;
            }
            case Archenemy: {
                return FDeckEditor.EditorType.Archenemy;
            }
            case Planechase: {
                return FDeckEditor.EditorType.Planechase;
            }
        }
        return FDeckEditor.EditorType.Constructed;
    }

    private void editDeck(DeckProxy deck) {
        FDeckEditor.EditorType editorType = this.getEditorType();
        switch (editorType) {
            case Commander: {
                DeckPreferences.setCommanderDeck(deck.getName());
                break;
            }
            case Oathbreaker: {
                DeckPreferences.setOathbreakerDeck(deck.getName());
                break;
            }
            case TinyLeaders: {
                DeckPreferences.setTinyLeadersDeck(deck.getName());
                break;
            }
            case Archenemy: {
                DeckPreferences.setSchemeDeck(deck.getName());
                break;
            }
            case Planechase: {
                DeckPreferences.setPlanarDeck(deck.getName());
                break;
            }
            case Draft: {
                DeckPreferences.setDraftDeck(deck.getName());
                break;
            }
            case Sealed: {
                DeckPreferences.setSealedDeck(deck.getName());
                break;
            }
            case Constructed: {
                DeckPreferences.setCurrentDeck(deck.getName());
                break;
            }
        }
        this.needRefreshOnActivate = true;
        ImageCache.preloadCache(deck.getDeck());
        Forge.openScreen(new FDeckEditor(editorType, deck, true));
    }

    public void initialize(ForgePreferences.FPref savedStateSetting, DeckType defaultDeckType) {
        this.stateSetting = savedStateSetting;
        this.selectedDeckType = defaultDeckType;
        if (this.cmbDeckTypes == null) {
            this.cmbDeckTypes = new FComboBox();
            this.cmbDeckTypes.setAutoClose(false);
            switch (this.lstDecks.getGameType()) {
                case Constructed: 
                case Gauntlet: {
                    this.cmbDeckTypes.addItem(DeckType.CUSTOM_DECK);
                    this.cmbDeckTypes.addItem(DeckType.PRECONSTRUCTED_DECK);
                    this.cmbDeckTypes.addItem(DeckType.QUEST_OPPONENT_DECK);
                    this.cmbDeckTypes.addItem(DeckType.COLOR_DECK);
                    this.cmbDeckTypes.addItem(DeckType.STANDARD_COLOR_DECK);
                    this.cmbDeckTypes.addItem(DeckType.MODERN_COLOR_DECK);
                    this.cmbDeckTypes.addItem(DeckType.PAUPER_COLOR_DECK);
                    this.cmbDeckTypes.addItem(DeckType.RANDOM_DECK);
                    this.cmbDeckTypes.addItem(DeckType.THEME_DECK);
                    if (FModel.isdeckGenMatrixLoaded()) {
                        this.cmbDeckTypes.addItem(DeckType.STANDARD_CARDGEN_DECK);
                        this.cmbDeckTypes.addItem(DeckType.MODERN_CARDGEN_DECK);
                        this.cmbDeckTypes.addItem(DeckType.PAUPER_CARDGEN_DECK);
                        this.cmbDeckTypes.addItem(DeckType.LEGACY_CARDGEN_DECK);
                        this.cmbDeckTypes.addItem(DeckType.VINTAGE_CARDGEN_DECK);
                        this.cmbDeckTypes.addItem(DeckType.PIONEER_CARDGEN_DECK);
                        this.cmbDeckTypes.addItem(DeckType.HISTORIC_CARDGEN_DECK);
                    }
                    this.cmbDeckTypes.addItem(DeckType.NET_DECK);
                    this.cmbDeckTypes.addItem(DeckType.NET_ARCHIVE_STANDARD_DECK);
                    this.cmbDeckTypes.addItem(DeckType.NET_ARCHIVE_PIONEER_DECK);
                    this.cmbDeckTypes.addItem(DeckType.NET_ARCHIVE_MODERN_DECK);
                    this.cmbDeckTypes.addItem(DeckType.NET_ARCHIVE_PAUPER_DECK);
                    this.cmbDeckTypes.addItem(DeckType.NET_ARCHIVE_LEGACY_DECK);
                    this.cmbDeckTypes.addItem(DeckType.NET_ARCHIVE_VINTAGE_DECK);
                    this.cmbDeckTypes.addItem(DeckType.NET_ARCHIVE_BLOCK_DECK);
                    break;
                }
                case Commander: 
                case Oathbreaker: 
                case TinyLeaders: 
                case Brawl: {
                    this.cmbDeckTypes.addItem(DeckType.CUSTOM_DECK);
                    this.cmbDeckTypes.addItem(DeckType.PRECON_COMMANDER_DECK);
                    this.cmbDeckTypes.addItem(DeckType.RANDOM_DECK);
                    if (FModel.isdeckGenMatrixLoaded()) {
                        this.cmbDeckTypes.addItem(DeckType.RANDOM_CARDGEN_COMMANDER_DECK);
                    }
                    this.cmbDeckTypes.addItem(DeckType.RANDOM_COMMANDER_DECK);
                    this.cmbDeckTypes.addItem(DeckType.NET_DECK);
                    break;
                }
                case DeckManager: {
                    this.cmbDeckTypes.addItem(DeckType.CONSTRUCTED_DECK);
                    this.cmbDeckTypes.addItem(DeckType.COMMANDER_DECK);
                    this.cmbDeckTypes.addItem(DeckType.OATHBREAKER_DECK);
                    this.cmbDeckTypes.addItem(DeckType.TINY_LEADERS_DECK);
                    this.cmbDeckTypes.addItem(DeckType.BRAWL_DECK);
                    this.cmbDeckTypes.addItem(DeckType.SCHEME_DECK);
                    this.cmbDeckTypes.addItem(DeckType.PLANAR_DECK);
                    this.cmbDeckTypes.addItem(DeckType.DRAFT_DECK);
                    this.cmbDeckTypes.addItem(DeckType.SEALED_DECK);
                    this.cmbDeckTypes.addItem(DeckType.PRECONSTRUCTED_DECK);
                    this.cmbDeckTypes.addItem(DeckType.PRECON_COMMANDER_DECK);
                    this.cmbDeckTypes.addItem(DeckType.QUEST_OPPONENT_DECK);
                    this.cmbDeckTypes.addItem(DeckType.NET_DECK);
                    this.cmbDeckTypes.addItem(DeckType.NET_COMMANDER_DECK);
                    this.cmbDeckTypes.addItem(DeckType.NET_ARCHIVE_STANDARD_DECK);
                    this.cmbDeckTypes.addItem(DeckType.NET_ARCHIVE_PIONEER_DECK);
                    this.cmbDeckTypes.addItem(DeckType.NET_ARCHIVE_MODERN_DECK);
                    this.cmbDeckTypes.addItem(DeckType.NET_ARCHIVE_PAUPER_DECK);
                    this.cmbDeckTypes.addItem(DeckType.NET_ARCHIVE_LEGACY_DECK);
                    this.cmbDeckTypes.addItem(DeckType.NET_ARCHIVE_VINTAGE_DECK);
                    this.cmbDeckTypes.addItem(DeckType.NET_ARCHIVE_BLOCK_DECK);
                    break;
                }
                default: {
                    this.cmbDeckTypes.addItem(DeckType.CUSTOM_DECK);
                    this.cmbDeckTypes.addItem(DeckType.RANDOM_DECK);
                }
            }
            this.cmbDeckTypes.setAlignment(1);
            this.restoreSavedState();
            this.cmbDeckTypes.setChangedHandler(event -> {
                DeckType deckType = this.cmbDeckTypes.getSelectedItem();
                if (!(this.refreshingDeckType || deckType != DeckType.NET_DECK && deckType != DeckType.NET_COMMANDER_DECK)) {
                    FThreads.invokeInBackgroundThread(() -> {
                        GameType gameType = this.lstDecks.getGameType();
                        if (gameType == GameType.DeckManager) {
                            gameType = deckType == DeckType.NET_COMMANDER_DECK ? GameType.Commander : GameType.Constructed;
                        }
                        NetDeckCategory category = NetDeckCategory.selectAndLoad(gameType);
                        FThreads.invokeInEdtLater(() -> {
                            if (category == null) {
                                this.cmbDeckTypes.setSelectedItem(this.selectedDeckType);
                                if (this.selectedDeckType == deckType && this.netDeckCategory != null) {
                                    this.cmbDeckTypes.setText(this.netDeckCategory.getDeckType());
                                }
                                return;
                            }
                            this.netDeckCategory = category;
                            this.refreshDecksList(deckType, true, event);
                        });
                    });
                    return;
                }
                if (!this.refreshingDeckType && deckType == DeckType.NET_ARCHIVE_STANDARD_DECK) {
                    FThreads.invokeInBackgroundThread(() -> {
                        GameType gameType = this.lstDecks.getGameType();
                        if (gameType == GameType.DeckManager) {
                            gameType = GameType.Constructed;
                        }
                        NetDeckArchiveStandard category = forge.deck.NetDeckArchiveStandard.selectAndLoad(gameType);
                        FThreads.invokeInEdtLater(() -> {
                            if (category == null) {
                                this.cmbDeckTypes.setSelectedItem(this.selectedDeckType);
                                if (this.selectedDeckType == deckType && this.NetDeckArchiveStandard != null) {
                                    this.cmbDeckTypes.setText(this.NetDeckArchiveStandard.getDeckType());
                                }
                                return;
                            }
                            this.NetDeckArchiveStandard = category;
                            this.refreshDecksList(deckType, true, event);
                        });
                    });
                    return;
                }
                if (!this.refreshingDeckType && deckType == DeckType.NET_ARCHIVE_PIONEER_DECK) {
                    FThreads.invokeInBackgroundThread(() -> {
                        GameType gameType = this.lstDecks.getGameType();
                        if (gameType == GameType.DeckManager) {
                            gameType = GameType.Constructed;
                        }
                        NetDeckArchivePioneer category = forge.deck.NetDeckArchivePioneer.selectAndLoad(gameType);
                        FThreads.invokeInEdtLater(() -> {
                            if (category == null) {
                                this.cmbDeckTypes.setSelectedItem(this.selectedDeckType);
                                if (this.selectedDeckType == deckType && this.NetDeckArchivePioneer != null) {
                                    this.cmbDeckTypes.setText(this.NetDeckArchivePioneer.getDeckType());
                                }
                                return;
                            }
                            this.NetDeckArchivePioneer = category;
                            this.refreshDecksList(deckType, true, event);
                        });
                    });
                    return;
                }
                if (!this.refreshingDeckType && deckType == DeckType.NET_ARCHIVE_MODERN_DECK) {
                    FThreads.invokeInBackgroundThread(() -> {
                        GameType gameType = this.lstDecks.getGameType();
                        if (gameType == GameType.DeckManager) {
                            gameType = GameType.Constructed;
                        }
                        NetDeckArchiveModern category = forge.deck.NetDeckArchiveModern.selectAndLoad(gameType);
                        FThreads.invokeInEdtLater(() -> {
                            if (category == null) {
                                this.cmbDeckTypes.setSelectedItem(this.selectedDeckType);
                                if (this.selectedDeckType == deckType && this.NetDeckArchiveModern != null) {
                                    this.cmbDeckTypes.setText(this.NetDeckArchiveModern.getDeckType());
                                }
                                return;
                            }
                            this.NetDeckArchiveModern = category;
                            this.refreshDecksList(deckType, true, event);
                        });
                    });
                    return;
                }
                if (!this.refreshingDeckType && deckType == DeckType.NET_ARCHIVE_PAUPER_DECK) {
                    FThreads.invokeInBackgroundThread(() -> {
                        GameType gameType = this.lstDecks.getGameType();
                        if (gameType == GameType.DeckManager) {
                            gameType = GameType.Constructed;
                        }
                        NetDeckArchivePauper category = forge.deck.NetDeckArchivePauper.selectAndLoad(gameType);
                        FThreads.invokeInEdtLater(() -> {
                            if (category == null) {
                                this.cmbDeckTypes.setSelectedItem(this.selectedDeckType);
                                if (this.selectedDeckType == deckType && this.NetDeckArchivePauper != null) {
                                    this.cmbDeckTypes.setText(this.NetDeckArchivePauper.getDeckType());
                                }
                                return;
                            }
                            this.NetDeckArchivePauper = category;
                            this.refreshDecksList(deckType, true, event);
                        });
                    });
                    return;
                }
                if (!this.refreshingDeckType && deckType == DeckType.NET_ARCHIVE_LEGACY_DECK) {
                    FThreads.invokeInBackgroundThread(() -> {
                        GameType gameType = this.lstDecks.getGameType();
                        if (gameType == GameType.DeckManager) {
                            gameType = GameType.Constructed;
                        }
                        NetDeckArchiveLegacy category = forge.deck.NetDeckArchiveLegacy.selectAndLoad(gameType);
                        FThreads.invokeInEdtLater(() -> {
                            if (category == null) {
                                this.cmbDeckTypes.setSelectedItem(this.selectedDeckType);
                                if (this.selectedDeckType == deckType && this.NetDeckArchiveLegacy != null) {
                                    this.cmbDeckTypes.setText(this.NetDeckArchiveLegacy.getDeckType());
                                }
                                return;
                            }
                            this.NetDeckArchiveLegacy = category;
                            this.refreshDecksList(deckType, true, event);
                        });
                    });
                    return;
                }
                if (!this.refreshingDeckType && deckType == DeckType.NET_ARCHIVE_VINTAGE_DECK) {
                    FThreads.invokeInBackgroundThread(() -> {
                        GameType gameType = this.lstDecks.getGameType();
                        if (gameType == GameType.DeckManager) {
                            gameType = GameType.Constructed;
                        }
                        NetDeckArchiveVintage category = forge.deck.NetDeckArchiveVintage.selectAndLoad(gameType);
                        FThreads.invokeInEdtLater(() -> {
                            if (category == null) {
                                this.cmbDeckTypes.setSelectedItem(this.selectedDeckType);
                                if (this.selectedDeckType == deckType && this.NetDeckArchiveVintage != null) {
                                    this.cmbDeckTypes.setText(this.NetDeckArchiveVintage.getDeckType());
                                }
                                return;
                            }
                            this.NetDeckArchiveVintage = category;
                            this.refreshDecksList(deckType, true, event);
                        });
                    });
                    return;
                }
                if (!this.refreshingDeckType && deckType == DeckType.NET_ARCHIVE_BLOCK_DECK) {
                    FThreads.invokeInBackgroundThread(() -> {
                        GameType gameType = this.lstDecks.getGameType();
                        if (gameType == GameType.DeckManager) {
                            gameType = GameType.Constructed;
                        }
                        NetDeckArchiveBlock category = forge.deck.NetDeckArchiveBlock.selectAndLoad(gameType);
                        FThreads.invokeInEdtLater(() -> {
                            if (category == null) {
                                this.cmbDeckTypes.setSelectedItem(this.selectedDeckType);
                                if (this.selectedDeckType == deckType && this.NetDeckArchiveBlock != null) {
                                    this.cmbDeckTypes.setText(this.NetDeckArchiveBlock.getDeckType());
                                }
                                return;
                            }
                            this.NetDeckArchiveBlock = category;
                            this.refreshDecksList(deckType, true, event);
                        });
                    });
                    return;
                }
                this.refreshDecksList(deckType, false, event);
            });
            this.add(this.cmbDeckTypes);
            this.add(this.lstDecks);
            this.add(this.btnNewDeck);
            this.add(this.btnEditDeck);
            this.add(this.btnViewDeck);
            this.add(this.btnRandom);
        } else {
            this.restoreSavedState();
        }
    }

    public void refreshDeckListForAI() {
        String currentName = ((DeckProxy)this.lstDecks.getSelectedItem()).getName();
        this.refreshDecksList(this.selectedDeckType, true, null);
        this.lstDecks.setSelectedString(currentName);
        this.saveState();
    }

    private void refreshDecksList(DeckType deckType, boolean forceRefresh, FEvent event) {
        ItemManagerConfig config;
        Iterable<DeckProxy> pool;
        if (this.selectedDeckType == deckType && !forceRefresh) {
            return;
        }
        this.selectedDeckType = deckType;
        if (event == null) {
            this.refreshingDeckType = true;
            this.cmbDeckTypes.setSelectedItem(deckType);
            this.refreshingDeckType = false;
        }
        if (deckType == null) {
            return;
        }
        int maxSelections = 1;
        block0 : switch (deckType) {
            case CUSTOM_DECK: {
                switch (this.lstDecks.getGameType()) {
                    case Commander: {
                        pool = DeckProxy.getAllCommanderDecks();
                        config = ItemManagerConfig.COMMANDER_DECKS;
                        break block0;
                    }
                    case Oathbreaker: {
                        pool = DeckProxy.getAllOathbreakerDecks();
                        config = ItemManagerConfig.COMMANDER_DECKS;
                        break block0;
                    }
                    case TinyLeaders: {
                        pool = DeckProxy.getAllTinyLeadersDecks();
                        config = ItemManagerConfig.COMMANDER_DECKS;
                        break block0;
                    }
                    case Brawl: {
                        pool = DeckProxy.getAllBrawlDecks();
                        config = ItemManagerConfig.COMMANDER_DECKS;
                        break block0;
                    }
                    case Archenemy: {
                        pool = DeckProxy.getAllSchemeDecks();
                        config = ItemManagerConfig.SCHEME_DECKS;
                        break block0;
                    }
                    case Planechase: {
                        pool = DeckProxy.getAllPlanarDecks();
                        config = ItemManagerConfig.PLANAR_DECKS;
                        break block0;
                    }
                }
                pool = DeckProxy.getAllConstructedDecks();
                config = ItemManagerConfig.CONSTRUCTED_DECKS;
                break;
            }
            case CONSTRUCTED_DECK: {
                pool = DeckProxy.getAllConstructedDecks();
                config = ItemManagerConfig.CONSTRUCTED_DECKS;
                break;
            }
            case COMMANDER_DECK: {
                pool = DeckProxy.getAllCommanderDecks();
                config = ItemManagerConfig.COMMANDER_DECKS;
                break;
            }
            case PRECON_COMMANDER_DECK: {
                pool = DeckProxy.getAllCommanderPreconDecks();
                config = ItemManagerConfig.COMMANDER_DECKS;
                break;
            }
            case OATHBREAKER_DECK: {
                pool = DeckProxy.getAllOathbreakerDecks();
                config = ItemManagerConfig.COMMANDER_DECKS;
                break;
            }
            case TINY_LEADERS_DECK: {
                pool = DeckProxy.getAllTinyLeadersDecks();
                config = ItemManagerConfig.COMMANDER_DECKS;
                break;
            }
            case BRAWL_DECK: {
                pool = DeckProxy.getAllBrawlDecks();
                config = ItemManagerConfig.COMMANDER_DECKS;
                break;
            }
            case RANDOM_COMMANDER_DECK: {
                pool = CommanderDeckGenerator.getCommanderDecks(this.lstDecks.getGameType().getDeckFormat(), this.isAi, false);
                config = ItemManagerConfig.STRING_ONLY;
                break;
            }
            case RANDOM_CARDGEN_COMMANDER_DECK: {
                pool = new ArrayList<DeckProxy>();
                if (FModel.isdeckGenMatrixLoaded()) {
                    pool = CommanderDeckGenerator.getCommanderDecks(this.lstDecks.getGameType().getDeckFormat(), this.isAi, true);
                }
                config = ItemManagerConfig.STRING_ONLY;
                break;
            }
            case SCHEME_DECK: {
                pool = DeckProxy.getAllSchemeDecks();
                config = ItemManagerConfig.SCHEME_DECKS;
                break;
            }
            case PLANAR_DECK: {
                pool = DeckProxy.getAllPlanarDecks();
                config = ItemManagerConfig.PLANAR_DECKS;
                break;
            }
            case DRAFT_DECK: {
                pool = DeckProxy.getAllDraftDecks();
                config = ItemManagerConfig.DRAFT_DECKS;
                break;
            }
            case SEALED_DECK: {
                pool = DeckProxy.getAllSealedDecks();
                config = ItemManagerConfig.SEALED_DECKS;
                break;
            }
            case COLOR_DECK: {
                maxSelections = 3;
                pool = ColorDeckGenerator.getColorDecks(this.lstDecks, null, this.isAi);
                config = ItemManagerConfig.STRING_ONLY;
                break;
            }
            case STANDARD_COLOR_DECK: {
                maxSelections = 3;
                pool = ColorDeckGenerator.getColorDecks(this.lstDecks, FModel.getFormats().getStandard().getFilterPrinted(), this.isAi);
                config = ItemManagerConfig.STRING_ONLY;
                break;
            }
            case STANDARD_CARDGEN_DECK: {
                maxSelections = 1;
                pool = this.getCardGenDeckPool(FModel.getFormats().getStandard());
                config = ItemManagerConfig.STRING_ONLY;
                break;
            }
            case PIONEER_CARDGEN_DECK: {
                maxSelections = 1;
                pool = this.getCardGenDeckPool(FModel.getFormats().getPioneer());
                config = ItemManagerConfig.STRING_ONLY;
                break;
            }
            case HISTORIC_CARDGEN_DECK: {
                maxSelections = 1;
                pool = this.getCardGenDeckPool(FModel.getFormats().getHistoric());
                config = ItemManagerConfig.STRING_ONLY;
                break;
            }
            case MODERN_CARDGEN_DECK: {
                maxSelections = 1;
                pool = this.getCardGenDeckPool(FModel.getFormats().getModern());
                config = ItemManagerConfig.STRING_ONLY;
                break;
            }
            case LEGACY_CARDGEN_DECK: {
                maxSelections = 1;
                pool = this.getCardGenDeckPool((GameFormat)FModel.getFormats().get("Legacy"));
                config = ItemManagerConfig.STRING_ONLY;
                break;
            }
            case VINTAGE_CARDGEN_DECK: {
                maxSelections = 1;
                pool = this.getCardGenDeckPool((GameFormat)FModel.getFormats().get("Vintage"));
                config = ItemManagerConfig.STRING_ONLY;
                break;
            }
            case PAUPER_CARDGEN_DECK: {
                maxSelections = 1;
                pool = this.getCardGenDeckPool(FModel.getFormats().getPauper());
                config = ItemManagerConfig.STRING_ONLY;
                break;
            }
            case MODERN_COLOR_DECK: {
                maxSelections = 3;
                pool = ColorDeckGenerator.getColorDecks(this.lstDecks, FModel.getFormats().getModern().getFilterPrinted(), this.isAi);
                config = ItemManagerConfig.STRING_ONLY;
                break;
            }
            case PAUPER_COLOR_DECK: {
                maxSelections = 3;
                pool = ColorDeckGenerator.getColorDecks(this.lstDecks, FModel.getFormats().getPauper().getFilterPrinted(), this.isAi);
                config = ItemManagerConfig.STRING_ONLY;
                break;
            }
            case THEME_DECK: {
                pool = DeckProxy.getAllThemeDecks();
                config = ItemManagerConfig.STRING_ONLY;
                break;
            }
            case QUEST_OPPONENT_DECK: {
                pool = DeckProxy.getAllQuestEventAndChallenges();
                config = ItemManagerConfig.QUEST_EVENT_DECKS;
                break;
            }
            case PRECONSTRUCTED_DECK: {
                pool = DeckProxy.getAllPreconstructedDecks(QuestController.getPrecons());
                config = ItemManagerConfig.PRECON_DECKS;
                break;
            }
            case RANDOM_DECK: {
                pool = RandomDeckGenerator.getRandomDecks(this.lstDecks, this.isAi);
                config = ItemManagerConfig.STRING_ONLY;
                break;
            }
            case NET_ARCHIVE_STANDARD_DECK: {
                if (this.NetDeckArchiveStandard != null) {
                    this.cmbDeckTypes.setText(this.NetDeckArchiveStandard.getDeckType());
                }
                pool = DeckProxy.getNetArchiveStandardDecks(this.NetDeckArchiveStandard);
                config = ItemManagerConfig.NET_ARCHIVE_STANDARD_DECKS;
                break;
            }
            case NET_ARCHIVE_PIONEER_DECK: {
                if (this.NetDeckArchivePioneer != null) {
                    this.cmbDeckTypes.setText(this.NetDeckArchivePioneer.getDeckType());
                }
                pool = DeckProxy.getNetArchivePioneerDecks(this.NetDeckArchivePioneer);
                config = ItemManagerConfig.NET_ARCHIVE_PIONEER_DECKS;
                break;
            }
            case NET_ARCHIVE_MODERN_DECK: {
                if (this.NetDeckArchiveModern != null) {
                    this.cmbDeckTypes.setText(this.NetDeckArchiveModern.getDeckType());
                }
                pool = DeckProxy.getNetArchiveModernDecks(this.NetDeckArchiveModern);
                config = ItemManagerConfig.NET_ARCHIVE_MODERN_DECKS;
                break;
            }
            case NET_ARCHIVE_PAUPER_DECK: {
                if (this.NetDeckArchivePauper != null) {
                    this.cmbDeckTypes.setText(this.NetDeckArchivePauper.getDeckType());
                }
                pool = DeckProxy.getNetArchivePauperDecks(this.NetDeckArchivePauper);
                config = ItemManagerConfig.NET_ARCHIVE_PAUPER_DECKS;
                break;
            }
            case NET_ARCHIVE_LEGACY_DECK: {
                if (this.NetDeckArchiveLegacy != null) {
                    this.cmbDeckTypes.setText(this.NetDeckArchiveLegacy.getDeckType());
                }
                pool = DeckProxy.getNetArchiveLegacyDecks(this.NetDeckArchiveLegacy);
                config = ItemManagerConfig.NET_ARCHIVE_LEGACY_DECKS;
                break;
            }
            case NET_ARCHIVE_VINTAGE_DECK: {
                if (this.NetDeckArchiveVintage != null) {
                    this.cmbDeckTypes.setText(this.NetDeckArchiveVintage.getDeckType());
                }
                pool = DeckProxy.getNetArchiveVintageDecks(this.NetDeckArchiveVintage);
                config = ItemManagerConfig.NET_ARCHIVE_VINTAGE_DECKS;
                break;
            }
            case NET_ARCHIVE_BLOCK_DECK: {
                if (this.NetDeckArchiveBlock != null) {
                    this.cmbDeckTypes.setText(this.NetDeckArchiveBlock.getDeckType());
                }
                pool = DeckProxy.getNetArchiveBlockDecks(this.NetDeckArchiveBlock);
                config = ItemManagerConfig.NET_ARCHIVE_BLOCK_DECKS;
                break;
            }
            case NET_DECK: 
            case NET_COMMANDER_DECK: {
                if (this.netDeckCategory != null) {
                    this.cmbDeckTypes.setText(this.netDeckCategory.getDeckType());
                }
                pool = DeckProxy.getNetDecks(this.netDeckCategory);
                config = ItemManagerConfig.NET_DECKS;
                break;
            }
            default: {
                BugReporter.reportBug("Unsupported deck type: " + (Object)((Object)deckType));
                return;
            }
        }
        this.lstDecks.setSelectionSupport(1, maxSelections);
        this.lstDecks.setPool(pool);
        this.lstDecks.setup(config);
        if (config == ItemManagerConfig.STRING_ONLY) {
            if (Forge.isLandscapeMode()) {
                this.btnNewDeck.setWidth((this.getWidth() - 3.0f * PADDING) / 2.0f);
            } else {
                this.btnNewDeck.setWidth(this.getWidth() - 2.0f * PADDING);
            }
            this.btnEditDeck.setVisible(false);
            this.btnViewDeck.setVisible(false);
            this.btnRandom.setWidth(this.btnNewDeck.getWidth());
            this.btnNewDeck.setText(Forge.getLocalizer().getMessage("lblGenerateNewDeck", new Object[0]));
            switch (deckType) {
                case COLOR_DECK: {
                    this.btnRandom.setText(Forge.getLocalizer().getMessage("lblRandomColors", new Object[0]));
                    break;
                }
                case THEME_DECK: {
                    this.btnRandom.setText(Forge.getLocalizer().getMessage("lblRandomTheme", new Object[0]));
                    break;
                }
                default: {
                    this.btnRandom.setText(Forge.getLocalizer().getMessage("lblRandomDeck", new Object[0]));
                    break;
                }
            }
        } else {
            this.btnNewDeck.setWidth(this.btnEditDeck.getWidth());
            this.btnEditDeck.setVisible(true);
            this.btnViewDeck.setVisible(true);
            this.btnRandom.setWidth(this.btnNewDeck.getWidth());
            this.btnNewDeck.setText(Forge.getLocalizer().getMessage("lblNewDeck", new Object[0]));
            if (this.lstDecks.getGameType() == GameType.DeckManager) {
                this.btnRandom.setText(Forge.getLocalizer().getMessage("lblTestDeck", new Object[0]));
                switch (this.selectedDeckType) {
                    case SCHEME_DECK: 
                    case PLANAR_DECK: {
                        this.btnRandom.setEnabled(false);
                        break;
                    }
                    default: {
                        this.btnRandom.setEnabled(true);
                        break;
                    }
                }
            } else {
                this.btnRandom.setText(Forge.getLocalizer().getMessage("lblRandomDeck", new Object[0]));
            }
        }
        this.btnRandom.setLeft(this.getWidth() - PADDING - this.btnRandom.getWidth());
        if (event != null) {
            if (deckType == DeckType.COLOR_DECK) {
                this.lstDecks.setSelectedIndices(new Integer[]{0, 1});
            } else {
                this.lstDecks.setSelectedIndex(0);
            }
            if (this.lstDecks.getGameType() == GameType.DeckManager) {
                DeckPreferences.setSelectedDeckType(deckType);
            }
        }
    }

    private Iterable<DeckProxy> getCardGenDeckPool(GameFormat format) {
        List<DeckProxy> pool = new ArrayList<DeckProxy>();
        if (FModel.isdeckGenMatrixLoaded()) {
            pool = ArchetypeDeckGenerator.getMatrixDecks(format, this.isAi);
        }
        return pool;
    }

    @Override
    protected void doLayout(float startY, float width, float height) {
        float x = PADDING;
        float y = startY + PADDING;
        float fieldHeight = this.cmbDeckTypes.getHeight();
        boolean landscapeMode = Forge.isLandscapeMode();
        float totalButtonHeight = landscapeMode ? fieldHeight : 2.0f * fieldHeight + PADDING;
        this.cmbDeckTypes.setBounds(x, y, width -= 2.0f * x, fieldHeight);
        this.lstDecks.setBounds(x, y += this.cmbDeckTypes.getHeight() + 1.0f, width, height - y - totalButtonHeight - 2.0f * PADDING);
        y += this.lstDecks.getHeight() + PADDING;
        float buttonWidth = landscapeMode ? (width - 3.0f * PADDING) / 4.0f : (width - PADDING) / 2.0f;
        if (this.btnEditDeck.isVisible()) {
            this.btnNewDeck.setBounds(x, y, buttonWidth, fieldHeight);
        } else if (landscapeMode) {
            this.btnNewDeck.setBounds(x, y, 2.0f * buttonWidth + PADDING, fieldHeight);
        } else {
            this.btnNewDeck.setBounds(x, y, width, fieldHeight);
        }
        this.btnEditDeck.setBounds(x + buttonWidth + PADDING, y, buttonWidth, fieldHeight);
        if (landscapeMode) {
            x += 2.0f * (buttonWidth + PADDING);
        } else {
            y += fieldHeight + PADDING;
        }
        this.btnViewDeck.setBounds(x, y, buttonWidth, fieldHeight);
        if (this.btnViewDeck.isVisible()) {
            this.btnRandom.setBounds(x + buttonWidth + PADDING, y, buttonWidth, fieldHeight);
        } else if (landscapeMode) {
            this.btnRandom.setBounds(x, y, 2.0f * buttonWidth + PADDING, fieldHeight);
        } else {
            this.btnRandom.setBounds(x, y, width, fieldHeight);
        }
    }

    public DeckType getSelectedDeckType() {
        return this.selectedDeckType;
    }

    public void setSelectedDeckType(DeckType selectedDeckType0) {
        this.refreshDecksList(selectedDeckType0, false, null);
    }

    public DeckManager getLstDecks() {
        return this.lstDecks;
    }

    public Deck getDeck() {
        DeckProxy proxy;
        if (this.lstDecks.getSelectedIndex() == -1) {
            this.lstDecks.setSelectedIndex(0);
        }
        if ((proxy = (DeckProxy)this.lstDecks.getSelectedItem()) == null) {
            return null;
        }
        return proxy.getDeck();
    }

    public RegisteredPlayer getPlayer(boolean forceRefresh) {
        if (this.player != null && !forceRefresh) {
            return this.player;
        }
        if (this.lstDecks.getSelectedIndex() < 0) {
            this.player = null;
        } else if (this.selectedDeckType == DeckType.QUEST_OPPONENT_DECK) {
            QuestEvent event = DeckgenUtil.getQuestEvent(((DeckProxy)this.lstDecks.getSelectedItem()).getName());
            this.player = new RegisteredPlayer(event.getEventDeck());
            if (event instanceof QuestEventChallenge) {
                this.player.setStartingLife(((QuestEventChallenge)event).getAiLife());
            }
            this.player.setCardsOnBattlefield(QuestUtil.getComputerStartingCards(event));
        } else {
            this.player = new RegisteredPlayer(this.getDeck());
        }
        return this.player;
    }

    public final boolean isAi() {
        return this.isAi;
    }

    public void setIsAi(boolean isAiDeck) {
        this.isAi = isAiDeck;
    }

    public void saveState() {
        if (this.stateSetting == null) {
            throw new NullPointerException("State setting missing. Specify first using the initialize() method.");
        }
        this.prefs.setPref(this.stateSetting, this.getState());
        this.prefs.save();
    }

    private String getState() {
        StringBuilder state = new StringBuilder();
        if (this.cmbDeckTypes.getSelectedItem() == null || this.cmbDeckTypes.getSelectedItem() == DeckType.NET_DECK) {
            if (this.netDeckCategory == null) {
                return "";
            }
            state.append("NET_DECK_").append(this.netDeckCategory.getName());
        } else {
            state.append(this.cmbDeckTypes.getSelectedItem().name());
        }
        state.append(";");
        this.joinSelectedDecks(state, "::");
        return state.toString();
    }

    private void joinSelectedDecks(StringBuilder state, String delimiter) {
        Collection selectedDecks = this.lstDecks.getSelectedItems();
        boolean isFirst = true;
        if (selectedDecks != null) {
            for (DeckProxy deck : selectedDecks) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    state.append(delimiter);
                }
                state.append(deck.toString());
            }
        }
    }

    private void restoreSavedState() {
        DeckType oldDeckType = this.selectedDeckType;
        if (this.stateSetting == null) {
            this.refreshDecksList(oldDeckType, true, null);
            return;
        }
        String savedState = this.prefs.getPref(this.stateSetting);
        this.refreshDecksList(this.getDeckTypeFromSavedState(savedState), true, null);
        if (!this.lstDecks.setSelectedStrings(this.getSelectedDecksFromSavedState(savedState))) {
            this.refreshDecksList(oldDeckType, true, null);
        }
    }

    private DeckType getDeckTypeFromSavedState(String savedState) {
        try {
            if (StringUtils.isBlank(savedState)) {
                return this.selectedDeckType;
            }
            String deckType = savedState.split(";")[0];
            if (deckType.startsWith("NET_DECK_")) {
                this.netDeckCategory = NetDeckCategory.selectAndLoad(this.lstDecks.getGameType(), deckType.substring("NET_DECK_".length()));
                return DeckType.NET_DECK;
            }
            if (deckType.startsWith("NET_ARCHIVE_STANDARD_DECK")) {
                this.NetDeckArchiveStandard = forge.deck.NetDeckArchiveStandard.selectAndLoad(this.lstDecks.getGameType(), deckType.substring("NET_ARCHIVE_STANDARD_DECK".length()));
                return DeckType.NET_ARCHIVE_STANDARD_DECK;
            }
            if (deckType.startsWith("NET_ARCHIVE_PIONEER_DECK")) {
                this.NetDeckArchivePioneer = forge.deck.NetDeckArchivePioneer.selectAndLoad(this.lstDecks.getGameType(), deckType.substring("NET_ARCHIVE_PIONEER_DECK".length()));
                return DeckType.NET_ARCHIVE_PIONEER_DECK;
            }
            if (deckType.startsWith("NET_ARCHIVE_MODERN_DECK")) {
                this.NetDeckArchiveModern = forge.deck.NetDeckArchiveModern.selectAndLoad(this.lstDecks.getGameType(), deckType.substring("NET_ARCHIVE_MODERN_DECK".length()));
                return DeckType.NET_ARCHIVE_MODERN_DECK;
            }
            if (deckType.startsWith("NET_ARCHIVE_PAUPER_DECK")) {
                this.NetDeckArchivePauper = forge.deck.NetDeckArchivePauper.selectAndLoad(this.lstDecks.getGameType(), deckType.substring("NET_ARCHIVE_PAUPER_DECK".length()));
                return DeckType.NET_ARCHIVE_PAUPER_DECK;
            }
            if (deckType.startsWith("NET_ARCHIVE_LEGACY_DECK")) {
                this.NetDeckArchiveLegacy = forge.deck.NetDeckArchiveLegacy.selectAndLoad(this.lstDecks.getGameType(), deckType.substring("NET_ARCHIVE_LEGACY_DECK".length()));
                return DeckType.NET_ARCHIVE_LEGACY_DECK;
            }
            if (deckType.startsWith("NET_ARCHIVE_VINTAGE_DECK")) {
                this.NetDeckArchiveVintage = forge.deck.NetDeckArchiveVintage.selectAndLoad(this.lstDecks.getGameType(), deckType.substring("NET_ARCHIVE_VINTAGE_DECK".length()));
                return DeckType.NET_ARCHIVE_VINTAGE_DECK;
            }
            if (deckType.startsWith("NET_ARCHIVE_BLOCK_DECK")) {
                this.NetDeckArchiveBlock = forge.deck.NetDeckArchiveBlock.selectAndLoad(this.lstDecks.getGameType(), deckType.substring("NET_ARCHIVE_BLOCK_DECK".length()));
                return DeckType.NET_ARCHIVE_BLOCK_DECK;
            }
            return DeckType.valueOf(deckType);
        }
        catch (IllegalArgumentException ex) {
            System.err.println(ex.getMessage() + ". Using default : " + (Object)((Object)this.selectedDeckType));
            return this.selectedDeckType;
        }
    }

    private List<String> getSelectedDecksFromSavedState(String savedState) {
        try {
            if (StringUtils.isBlank(savedState)) {
                return new ArrayList<String>();
            }
            String[] parts = savedState.split(";", -1);
            return Arrays.asList(parts[1].split("::"));
        }
        catch (Exception ex) {
            System.err.println(ex + " [savedState=" + savedState + "]");
            return new ArrayList<String>();
        }
    }

    public FComboBox<DeckType> getDecksComboBox() {
        return this.cmbDeckTypes;
    }

    private void testSelectedDeck() {
        DeckProxy deckProxy = (DeckProxy)this.lstDecks.getSelectedItem();
        if (deckProxy == null) {
            return;
        }
        final Deck userDeck = deckProxy.getDeck();
        if (userDeck == null) {
            return;
        }
        if (this.selectedDeckType == DeckType.COMMANDER_DECK || this.selectedDeckType == DeckType.NET_COMMANDER_DECK) {
            this.testVariantDeck(userDeck, GameType.Commander);
            return;
        }
        if (this.selectedDeckType == DeckType.OATHBREAKER_DECK) {
            this.testVariantDeck(userDeck, GameType.Oathbreaker);
            return;
        }
        if (this.selectedDeckType == DeckType.TINY_LEADERS_DECK) {
            this.testVariantDeck(userDeck, GameType.TinyLeaders);
            return;
        }
        if (this.selectedDeckType == DeckType.BRAWL_DECK) {
            this.testVariantDeck(userDeck, GameType.Brawl);
            return;
        }
        GuiChoose.getInteger(Forge.getLocalizer().getMessage("lblHowManyOpponents", new Object[0]), 1, 50, new Callback<Integer>(){

            @Override
            public void run(final Integer numOpponents) {
                if (numOpponents == null) {
                    return;
                }
                ArrayList<DeckType> deckTypes = Lists.newArrayList(DeckType.CUSTOM_DECK, DeckType.PRECONSTRUCTED_DECK, DeckType.QUEST_OPPONENT_DECK, DeckType.COLOR_DECK, DeckType.STANDARD_COLOR_DECK, DeckType.STANDARD_CARDGEN_DECK, DeckType.MODERN_COLOR_DECK, DeckType.PAUPER_COLOR_DECK, DeckType.PIONEER_CARDGEN_DECK, DeckType.HISTORIC_CARDGEN_DECK, DeckType.MODERN_CARDGEN_DECK, DeckType.LEGACY_CARDGEN_DECK, DeckType.VINTAGE_CARDGEN_DECK, DeckType.PAUPER_CARDGEN_DECK, DeckType.THEME_DECK, DeckType.NET_DECK, DeckType.NET_ARCHIVE_STANDARD_DECK, DeckType.NET_ARCHIVE_PIONEER_DECK, DeckType.NET_ARCHIVE_MODERN_DECK, DeckType.NET_ARCHIVE_PAUPER_DECK, DeckType.NET_ARCHIVE_VINTAGE_DECK, DeckType.NET_ARCHIVE_LEGACY_DECK, DeckType.NET_ARCHIVE_BLOCK_DECK);
                if (!FModel.isdeckGenMatrixLoaded()) {
                    deckTypes.remove((Object)DeckType.STANDARD_CARDGEN_DECK);
                    deckTypes.remove((Object)DeckType.PIONEER_CARDGEN_DECK);
                    deckTypes.remove((Object)DeckType.HISTORIC_CARDGEN_DECK);
                    deckTypes.remove((Object)DeckType.MODERN_CARDGEN_DECK);
                    deckTypes.remove((Object)DeckType.LEGACY_CARDGEN_DECK);
                    deckTypes.remove((Object)DeckType.VINTAGE_CARDGEN_DECK);
                    deckTypes.remove((Object)DeckType.PAUPER_CARDGEN_DECK);
                }
                ListChooser<DeckType> chooser = new ListChooser<DeckType>(Forge.getLocalizer().getMessage("lblChooseAllowedDeckTypeOpponents", new Object[0]), 0, deckTypes.size(), deckTypes, null, new Callback<List<DeckType>>(){

                    @Override
                    public void run(List<DeckType> allowedDeckTypes) {
                        if (allowedDeckTypes == null || allowedDeckTypes.isEmpty()) {
                            return;
                        }
                        FThreads.invokeInBackgroundThread(() -> {
                            NetDeckCategory netCat = allowedDeckTypes.contains((Object)DeckType.NET_DECK) ? NetDeckCategory.selectAndLoad(GameType.Constructed) : null;
                            FThreads.invokeInEdtLater(() -> LoadingOverlay.show(Forge.getLocalizer().getMessage("lblLoadingNewGame", new Object[0]), true, () -> {
                                GauntletData gauntlet = GauntletUtil.createQuickGauntlet(userDeck, numOpponents, allowedDeckTypes, netCat);
                                FModel.setGauntletData(gauntlet);
                                ArrayList<RegisteredPlayer> players = new ArrayList<RegisteredPlayer>();
                                RegisteredPlayer humanPlayer = new RegisteredPlayer(userDeck).setPlayer(GamePlayerUtil.getGuiPlayer());
                                players.add(humanPlayer);
                                players.add(new RegisteredPlayer(gauntlet.getDecks().get(gauntlet.getCompleted())).setPlayer(GamePlayerUtil.createAiPlayer()));
                                gauntlet.startRound(players, humanPlayer);
                            }));
                        });
                    }
                });
                chooser.show(null, false);
            }
        });
    }

    private void testVariantDeck(final Deck userDeck, final GameType variant) {
        FDeckChooser.promptForDeck(Forge.getLocalizer().getMessage("lblSelectOpponentDeck", new Object[0]), variant, true, new Callback<Deck>(){

            @Override
            public void run(Deck aiDeck) {
                if (aiDeck == null) {
                    return;
                }
                LoadingOverlay.show(Forge.getLocalizer().getMessage("lblLoadingNewGame", new Object[0]), true, () -> {
                    HashSet<GameType> appliedVariants = new HashSet<GameType>();
                    appliedVariants.add(variant);
                    ArrayList<RegisteredPlayer> players = new ArrayList<RegisteredPlayer>();
                    RegisteredPlayer humanPlayer = RegisteredPlayer.forVariants(2, appliedVariants, userDeck, null, false, null, null);
                    humanPlayer.setPlayer(GamePlayerUtil.getGuiPlayer());
                    RegisteredPlayer aiPlayer = RegisteredPlayer.forVariants(2, appliedVariants, aiDeck, null, false, null, null);
                    aiPlayer.setPlayer(GamePlayerUtil.createAiPlayer());
                    players.add(humanPlayer);
                    players.add(aiPlayer);
                    HashMap<RegisteredPlayer, IGuiGame> guiMap = new HashMap<RegisteredPlayer, IGuiGame>();
                    guiMap.put(humanPlayer, MatchController.instance);
                    HostedMatch hostedMatch = GuiBase.getInterface().hostMatch();
                    hostedMatch.startMatch(GameType.Constructed, appliedVariants, players, guiMap);
                });
            }
        });
    }

    @Override
    protected boolean allowBackInLandscapeMode() {
        return true;
    }
}

