/*
 * Decompiled with CFR 0.152.
 */
package forge.deck;

import forge.StaticData;
import forge.card.CardDb;
import forge.card.CardEdition;
import forge.deck.CardPool;
import forge.deck.Deck;
import forge.deck.DeckFormat;
import forge.deck.DeckRecognizer;
import forge.deck.DeckSection;
import forge.game.GameFormat;
import forge.game.GameType;
import forge.gui.interfaces.ICheckBox;
import forge.gui.interfaces.IComboBox;
import forge.gui.util.SOptionPane;
import forge.item.PaperCard;
import forge.localinstance.properties.ForgePreferences;
import forge.model.FModel;
import forge.util.Localizer;
import java.text.DateFormatSymbols;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class DeckImportController {
    private boolean createNewDeck;
    private final ICheckBox dateTimeCheck;
    private final IComboBox<String> monthDropdown;
    private final IComboBox<Integer> yearDropdown;
    private CardDb.CardArtPreference artPreference;
    private boolean smartCardArt;
    private boolean inlcludeBnRInDeck = false;
    private final List<DeckRecognizer.Token> tokens = new ArrayList<DeckRecognizer.Token>();
    private final Map<PaperCard, DeckRecognizer.Token> cardsInTokens = new HashMap<PaperCard, DeckRecognizer.Token>();
    private final boolean currentDeckNotEmpty;
    private Deck currentDeckInEditor = null;
    private DeckFormat currentDeckFormat;
    private GameFormat currentGameFormat;
    private final List<DeckSection> allowedSections = new ArrayList<DeckSection>();

    public DeckImportController(ICheckBox dateTimeCheck0, IComboBox<String> monthDropdown0, IComboBox<Integer> yearDropdown0, boolean currentDeckNotEmpty) {
        this.dateTimeCheck = dateTimeCheck0;
        this.monthDropdown = monthDropdown0;
        this.yearDropdown = yearDropdown0;
        this.currentDeckNotEmpty = currentDeckNotEmpty;
        this.createNewDeck = false;
        this.artPreference = StaticData.instance().getCardArtPreference();
        this.smartCardArt = StaticData.instance().isEnabledCardArtSmartSelection();
        this.currentDeckFormat = null;
        this.currentGameFormat = null;
        this.fillDateDropdowns();
    }

    public void setGameFormat(GameType gameType) {
        if (gameType == null) {
            this.currentGameFormat = null;
            this.currentDeckFormat = null;
        } else {
            this.currentDeckFormat = gameType.getDeckFormat();
            this.currentGameFormat = (GameFormat)FModel.getFormats().get(gameType.name());
        }
    }

    public void setCurrentDeckInEditor(Deck deckInEditor) {
        this.currentDeckInEditor = deckInEditor;
    }

    public void setAllowedSections(List<DeckSection> allSections) {
        this.allowedSections.addAll(allSections);
    }

    public boolean hasNoDefaultGameFormat() {
        return this.currentGameFormat == null;
    }

    public String getCurrentGameFormatName() {
        if (this.currentGameFormat == null) {
            return "";
        }
        return this.currentGameFormat.getName();
    }

    public void setCardArtPreference(boolean isLatest, boolean coreFilterEnabled) {
        this.artPreference = StaticData.instance().getCardArtPreference(isLatest, coreFilterEnabled);
    }

    public void setSmartCardArtOptimisation(boolean enableSmartArt) {
        this.smartCardArt = enableSmartArt;
    }

    public boolean isSmartCardArtEnabled() {
        return this.smartCardArt;
    }

    public void setCreateNewDeck(boolean createNewDeck) {
        this.createNewDeck = createNewDeck;
    }

    public boolean getCreateNewDeck() {
        return this.createNewDeck;
    }

    private void fillDateDropdowns() {
        int yearNow;
        String[] months;
        DateFormatSymbols dfs = new DateFormatSymbols();
        this.monthDropdown.removeAllItems();
        for (String monthName : months = dfs.getMonths()) {
            if (StringUtils.isBlank(monthName)) continue;
            this.monthDropdown.addItem(monthName);
        }
        for (int i = yearNow = Calendar.getInstance().get(1); i >= 1993; --i) {
            this.yearDropdown.addItem(i);
        }
    }

    public void fillFormatDropdown(IComboBox<GameFormat> formatsDropdown) {
        if (formatsDropdown == null) {
            return;
        }
        formatsDropdown.removeAllItems();
        if (this.currentGameFormat == null) {
            GameFormat SEPARATOR = GameFormat.NoFormat;
            Iterable<GameFormat> sanctionedFormats = FModel.getFormats().getSanctionedList();
            for (GameFormat gameFormat : sanctionedFormats) {
                formatsDropdown.addItem(gameFormat);
            }
            formatsDropdown.addItem(SEPARATOR);
            Iterable<GameFormat> casualFormats = FModel.getFormats().getCasualList();
            for (GameFormat f : casualFormats) {
                formatsDropdown.addItem(f);
            }
            if (FModel.getPreferences().getPrefBoolean(ForgePreferences.FPref.LOAD_ARCHIVED_FORMATS)) {
                formatsDropdown.addItem(SEPARATOR);
                Iterable<GameFormat> iterable = FModel.getFormats().getBlockList();
                for (GameFormat f : iterable) {
                    formatsDropdown.addItem(f);
                }
            }
        }
    }

    public void setCurrentGameFormat(GameFormat gameFormat) {
        this.currentGameFormat = gameFormat;
    }

    public void importBannedAndRestrictedCards(boolean includeBannedAndRestricted) {
        this.inlcludeBnRInDeck = includeBannedAndRestricted;
    }

    public boolean importBannedAndRestrictedCards() {
        return this.inlcludeBnRInDeck;
    }

    public List<DeckRecognizer.Token> parseInput(String input) {
        String[] lines;
        List<DeckRecognizer.Token> parsedTokens;
        this.tokens.clear();
        this.cardsInTokens.clear();
        DeckRecognizer recognizer = new DeckRecognizer();
        recognizer.setArtPreference(this.artPreference);
        if (this.dateTimeCheck.isSelected()) {
            recognizer.setDateConstraint(this.yearDropdown.getSelectedItem(), this.monthDropdown.getSelectedIndex());
        }
        if (this.currentGameFormat != null) {
            recognizer.setGameFormatConstraint(this.currentGameFormat.getAllowedSetCodes(), this.currentGameFormat.getBannedCardNames(), this.currentGameFormat.getRestrictedCards());
        }
        if (this.currentDeckFormat != null) {
            recognizer.setDeckFormatConstraint(this.currentDeckFormat);
        }
        if (!this.allowedSections.isEmpty()) {
            recognizer.setAllowedDeckSections(this.allowedSections);
        }
        if (this.inlcludeBnRInDeck) {
            recognizer.forceImportBannedAndRestrictedCards();
        }
        if ((parsedTokens = recognizer.parseCardList(lines = input.split("\n"))) != null) {
            this.tokens.addAll(parsedTokens);
        }
        if (this.currentGameFormatAllowsCommander()) {
            List<Pair<Integer, DeckRecognizer.Token>> commanderTokens = this.getTokensInSection(DeckSection.Commander);
            if (commanderTokens.isEmpty()) {
                this.checkAndFixCommanderIn(DeckSection.Sideboard);
            }
            this.checkAndFixCommanderIn(DeckSection.Commander);
        }
        this.collectAllCardsInTokens();
        return this.tokens;
    }

    private void collectAllCardsInTokens() {
        this.cardsInTokens.clear();
        for (DeckRecognizer.Token token : this.tokens) {
            if (!token.isCardToken()) continue;
            PaperCard tokenCard = token.getCard();
            this.cardsInTokens.put(tokenCard, token);
        }
    }

    private void checkAndFixCommanderIn(DeckSection targetDeckSection) {
        List<Pair<Integer, DeckRecognizer.Token>> sectionTokens = this.getTokensInSection(targetDeckSection);
        List<Pair<Integer, DeckRecognizer.Token>> candidateCommanderTokens = this.getAllCommanderTokens(sectionTokens);
        if (candidateCommanderTokens.isEmpty()) {
            return;
        }
        int commandersCandidateCount = 0;
        for (Pair<Integer, DeckRecognizer.Token> ccTokenPair : candidateCommanderTokens) {
            commandersCandidateCount += ccTokenPair.getRight().getQuantity();
        }
        if (commandersCandidateCount > 1) {
            String msg = this.getListOfCandidateCommandersIn(targetDeckSection, candidateCommanderTokens, commandersCandidateCount);
            DeckRecognizer.Token warningMsg = DeckRecognizer.Token.WarningMessage(msg);
            int targetSecTokenIndex = candidateCommanderTokens.get(0).getLeft() - 1;
            DeckRecognizer.Token tokenInList = this.tokens.get(targetSecTokenIndex);
            while (!tokenInList.isDeckSection() && --targetSecTokenIndex >= 0) {
                tokenInList = this.tokens.get(targetSecTokenIndex);
            }
            if (targetSecTokenIndex >= 0 && targetSecTokenIndex + 1 < this.tokens.size()) {
                this.tokens.add(targetSecTokenIndex + 1, warningMsg);
            } else {
                this.tokens.add(warningMsg);
            }
            return;
        }
        if (commandersCandidateCount == 1 && targetDeckSection == DeckSection.Commander) {
            return;
        }
        Pair<Integer, DeckRecognizer.Token> commanderTokenPair = candidateCommanderTokens.get(0);
        int tokenIndex = commanderTokenPair.getLeft();
        DeckRecognizer.Token commanderToken = commanderTokenPair.getRight();
        String msg = Localizer.getInstance().getMessage("lblWarnCardInInvalidSection", commanderToken.getText(), targetDeckSection.name(), DeckSection.Commander.name());
        DeckRecognizer.Token cardInInvalidSectionToken = DeckRecognizer.Token.WarningMessage(msg);
        commanderToken.resetTokenSection(DeckSection.Commander);
        if (tokenIndex - 1 >= 0 && this.tokens.get(tokenIndex - 1).isDeckSection() && this.tokens.get(tokenIndex - 1).getText().equals(targetDeckSection.name())) {
            this.tokens.remove(tokenIndex - 1);
            this.tokens.add(tokenIndex - 1, DeckRecognizer.Token.DeckSection(DeckSection.Commander.name(), this.allowedSections));
        }
        this.tokens.add(tokenIndex, cardInInvalidSectionToken);
    }

    private String getListOfCandidateCommandersIn(DeckSection targetSection, List<Pair<Integer, DeckRecognizer.Token>> candidateCommandersInSide, int cardsNumber) {
        StringBuilder commandersCardNames = new StringBuilder();
        for (Pair<Integer, DeckRecognizer.Token> ccTokenPair : candidateCommandersInSide) {
            DeckRecognizer.Token ccToken = ccTokenPair.getRight();
            commandersCardNames.append(String.format("\n- %d x %s", ccToken.getQuantity(), ccToken.getText()));
        }
        String msg = Localizer.getInstance().getMessage("lblWarnTooManyCommanders", targetSection.name(), cardsNumber, commandersCardNames.toString());
        if (targetSection != DeckSection.Commander) {
            return String.format("%s\n%s", msg, Localizer.getInstance().getMessage("lblWarnCommandersInSideExtra", new Object[0]));
        }
        return msg;
    }

    private List<Pair<Integer, DeckRecognizer.Token>> getAllCommanderTokens(List<Pair<Integer, DeckRecognizer.Token>> sectionTokenPairs) {
        ArrayList<Pair<Integer, DeckRecognizer.Token>> candidateCommandersInSide = new ArrayList<Pair<Integer, DeckRecognizer.Token>>();
        for (Pair<Integer, DeckRecognizer.Token> secTokenPair : sectionTokenPairs) {
            DeckRecognizer.Token secToken = secTokenPair.getRight();
            PaperCard card = secToken.getCard();
            if (card == null || !DeckSection.Commander.validate(card)) continue;
            candidateCommandersInSide.add(secTokenPair);
        }
        return candidateCommandersInSide;
    }

    private List<Pair<Integer, DeckRecognizer.Token>> getTokensInSection(DeckSection section) {
        ArrayList<Pair<Integer, DeckRecognizer.Token>> tokensInSection = new ArrayList<Pair<Integer, DeckRecognizer.Token>>();
        for (int idx = 0; idx < this.tokens.size(); ++idx) {
            DeckRecognizer.Token token = this.tokens.get(idx);
            DeckSection tokenSection = token.getTokenSection();
            if (tokenSection != section) continue;
            tokensInSection.add(Pair.of(idx, token));
        }
        return tokensInSection;
    }

    public boolean currentGameFormatAllowsCommander() {
        return this.allowedSections.contains((Object)DeckSection.Commander);
    }

    public List<DeckRecognizer.Token> optimiseCardArtInTokens() {
        HashMap tokensPerSectionWithSet = new HashMap();
        HashMap<DeckSection, ArrayList<DeckRecognizer.Token>> tokensPerSectionWithNoSet = new HashMap<DeckSection, ArrayList<DeckRecognizer.Token>>();
        for (DeckRecognizer.Token token : this.tokens) {
            if (!token.isCardTokenForDeck()) continue;
            DeckSection tokenSection = token.getTokenSection();
            HashMap<DeckSection, Object> refTokenMap = token.cardRequestHasNoCode() ? tokensPerSectionWithNoSet : tokensPerSectionWithSet;
            ArrayList<DeckRecognizer.Token> tokensInSection = refTokenMap.getOrDefault((Object)tokenSection, null);
            if (tokensInSection == null) {
                tokensInSection = new ArrayList<DeckRecognizer.Token>();
                tokensInSection.add(token);
                refTokenMap.put(tokenSection, tokensInSection);
                continue;
            }
            tokensInSection.add(token);
        }
        if (tokensPerSectionWithNoSet.isEmpty()) {
            return this.tokens;
        }
        HashMap<DeckSection, CardPool> referencePoolPerSection = new HashMap<DeckSection, CardPool>();
        if (this.currentDeckNotEmpty && !this.createNewDeck && this.currentDeckInEditor != null) {
            for (DeckSection section : tokensPerSectionWithNoSet.keySet()) {
                CardPool cardsInDeck = this.currentDeckInEditor.get(section);
                if (cardsInDeck == null || cardsInDeck.isEmpty()) continue;
                CardPool optCardPool = new CardPool(cardsInDeck);
                referencePoolPerSection.put(section, optCardPool);
            }
        }
        for (DeckSection section : tokensPerSectionWithNoSet.keySet()) {
            List sectionTokensNoSet = (List)tokensPerSectionWithNoSet.get((Object)section);
            List sectionTokenWithSet = tokensPerSectionWithSet.getOrDefault((Object)section, null);
            CardPool sectionCardPool = referencePoolPerSection.getOrDefault((Object)section, null);
            if (sectionCardPool == null) {
                sectionCardPool = new CardPool();
            }
            int tokensWithSetCount = this.countTokens(sectionTokenWithSet);
            int cardsInPoolCount = sectionCardPool.countAll();
            int tokensNoSetCount = this.countTokens(sectionTokensNoSet);
            int totalCount = tokensNoSetCount + tokensWithSetCount + cardsInPoolCount;
            if (totalCount == 0) continue;
            float cardsWithSetRatio = (float)(tokensWithSetCount + cardsInPoolCount) / (float)totalCount;
            if ((double)cardsWithSetRatio < 0.5) {
                for (DeckRecognizer.Token t2 : sectionTokensNoSet) {
                    sectionCardPool.add(t2.getCard(), t2.getQuantity());
                }
            }
            if (sectionTokenWithSet != null) {
                for (DeckRecognizer.Token t2 : sectionTokenWithSet) {
                    sectionCardPool.add(t2.getCard(), t2.getQuantity());
                }
            }
            referencePoolPerSection.put(section, sectionCardPool);
        }
        StaticData staticData = StaticData.instance();
        boolean isCardArtPreferenceLatestArt = this.artPreference.latestFirst;
        boolean cardArtPreferenceHasFilter = this.artPreference.filterSets;
        List<String> allowedSetCodes = this.currentGameFormat != null ? this.currentGameFormat.getAllowedSetCodes() : null;
        for (DeckSection section : tokensPerSectionWithNoSet.keySet()) {
            CardPool cardArtReferencePool = (CardPool)referencePoolPerSection.get((Object)section);
            if (cardArtReferencePool == null || cardArtReferencePool.isEmpty()) continue;
            boolean isExpansionTheMajorityInThePool = cardArtReferencePool.getTheMostFrequentEditionType() == CardEdition.Type.EXPANSION;
            boolean isPoolModernFramed = cardArtReferencePool.isModern();
            CardEdition pivotEdition = cardArtReferencePool.getPivotCardEdition(isCardArtPreferenceLatestArt);
            if (pivotEdition == null) continue;
            Date releaseDatePivotEdition = pivotEdition.getDate();
            List tokensToOptimise = (List)tokensPerSectionWithNoSet.get((Object)section);
            for (DeckRecognizer.Token t3 : tokensToOptimise) {
                PaperCard tokenCard = t3.getCard();
                PaperCard alternativeCardPrint = staticData.getAlternativeCardPrint(tokenCard, releaseDatePivotEdition, isCardArtPreferenceLatestArt, cardArtPreferenceHasFilter, isExpansionTheMajorityInThePool, isPoolModernFramed, allowedSetCodes);
                if (alternativeCardPrint == null) continue;
                t3.replaceTokenCard(alternativeCardPrint);
            }
        }
        this.collectAllCardsInTokens();
        return this.tokens;
    }

    private int countTokens(List<DeckRecognizer.Token> tokensInSection) {
        if (tokensInSection == null || tokensInSection.isEmpty()) {
            return 0;
        }
        int tokensCount = 0;
        for (DeckRecognizer.Token t2 : tokensInSection) {
            PaperCard tCard;
            if (!t2.isCardTokenForDeck() || (tCard = t2.getCard()).isVeryBasicLand()) continue;
            tokensCount += t2.getQuantity();
        }
        return tokensCount;
    }

    public PaperCard getCardFromDecklist(PaperCard card) {
        if (this.cardsInTokens.containsKey(card)) {
            return card;
        }
        PaperCard cardKey = card.isFoil() ? card.getUnFoiled() : card.getFoiled();
        return this.cardsInTokens.containsKey(cardKey) ? cardKey : null;
    }

    public PaperCard getCardFromDecklistByName(String cardName) {
        for (PaperCard cardKey : this.cardsInTokens.keySet()) {
            if (!cardKey.getName().equals(cardName)) continue;
            return cardKey;
        }
        return null;
    }

    public DeckRecognizer.Token getTokenFromCardInDecklist(PaperCard cardKey) {
        return this.cardsInTokens.getOrDefault(cardKey, null);
    }

    public Deck accept() {
        return this.accept("");
    }

    public Deck accept(String currentDeckName) {
        String extraWarning;
        String warning;
        String tokenDeckName;
        Localizer localizer = Localizer.getInstance();
        if (this.tokens.isEmpty()) {
            return null;
        }
        String deckName = "";
        if (currentDeckName != null && currentDeckName.trim().length() > 0) {
            deckName = String.format("\"%s\"", currentDeckName.trim());
        }
        if ((tokenDeckName = this.getTokenDeckNameIfAny()).length() > 0) {
            tokenDeckName = String.format("\"%s\"", tokenDeckName);
        }
        if (this.createNewDeck ? !SOptionPane.showConfirmDialog(warning = localizer.getMessage("lblConfirmCreateNewDeck", tokenDeckName, extraWarning = this.currentDeckNotEmpty ? localizer.getMessage("lblNewDeckWarning", deckName) : ""), localizer.getMessage("lblNewDeckDialogTitle", new Object[0]), localizer.getMessage("lblYes", new Object[0]), localizer.getMessage("lblNo", new Object[0])) : this.currentDeckNotEmpty && !SOptionPane.showConfirmDialog(warning = localizer.getMessage("lblConfirmCardImport", deckName, extraWarning = tokenDeckName.length() > 0 && !tokenDeckName.equals(deckName) ? localizer.getMessage("lblCardImportWarning", deckName, tokenDeckName) : ""), localizer.getMessage("lblImportCardsDialogTitle", new Object[0]), localizer.getMessage("lblYes", new Object[0]), localizer.getMessage("lblNo", new Object[0]))) {
            return null;
        }
        Deck resultDeck = new Deck();
        for (DeckRecognizer.Token t2 : this.tokens) {
            DeckRecognizer.TokenType type = t2.getType();
            if (!t2.isTokenForDeck() || type == DeckRecognizer.TokenType.LIMITED_CARD && !this.inlcludeBnRInDeck) continue;
            if (type == DeckRecognizer.TokenType.DECK_NAME) {
                resultDeck.setName(t2.getText());
                continue;
            }
            DeckSection deckSection = t2.getTokenSection();
            PaperCard crd = t2.getCard();
            resultDeck.getOrCreate(deckSection).add(crd, t2.getQuantity());
        }
        return resultDeck;
    }

    private String getTokenDeckNameIfAny() {
        for (DeckRecognizer.Token t2 : this.tokens) {
            DeckRecognizer.TokenType tType;
            if (!t2.isTokenForDeck() || (tType = t2.getType()) != DeckRecognizer.TokenType.DECK_NAME) continue;
            return t2.getText();
        }
        return "";
    }
}

