/*
 * Decompiled with CFR 0.152.
 */
package forge.deck;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import forge.StaticData;
import forge.card.CardRules;
import forge.card.CardRulesPredicates;
import forge.card.CardType;
import forge.card.ColorSet;
import forge.card.ICardFace;
import forge.deck.CardPool;
import forge.deck.Deck;
import forge.deck.DeckSection;
import forge.deck.generation.DeckGenPool;
import forge.deck.generation.DeckGeneratorBase;
import forge.deck.generation.IDeckGenPool;
import forge.item.IPaperCard;
import forge.item.PaperCard;
import forge.util.Aggregates;
import forge.util.TextUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.Range;
import org.apache.commons.lang3.tuple.ImmutablePair;

public enum DeckFormat {
    Constructed(Range.between(60, Integer.MAX_VALUE), Range.between(0, 15), 4),
    QuestDeck(Range.between(40, Integer.MAX_VALUE), Range.between(0, 15), 4),
    Limited((Range)Range.between(40, Integer.MAX_VALUE), null, Integer.MAX_VALUE){

        @Override
        public String getAttractionDeckConformanceProblem(Deck deck) {
            if (deck.get(DeckSection.Attractions).countAll() < 3) {
                return "must contain at least 3 attractions, or none at all";
            }
            return null;
        }
    }
    ,
    Commander(Range.is(99), Range.between(0, 10), 1, null, card -> StaticData.instance().getCommanderPredicate().apply((PaperCard)card)),
    Oathbreaker(Range.is(58), Range.between(0, 10), 1, null, card -> StaticData.instance().getOathbreakerPredicate().apply((PaperCard)card)),
    Pauper(Range.is(60), Range.between(0, 10), 1),
    Brawl(Range.is(59), Range.between(0, 15), 1, null, card -> StaticData.instance().getBrawlPredicate().apply((PaperCard)card)),
    TinyLeaders((Range)Range.is(49), (Range)Range.between(0, 10), 1, (Predicate)new Predicate<CardRules>(){
        private final Set<String> bannedCards = ImmutableSet.of("Ancestral Recall", "Balance", "Black Lotus", "Black Vise", "Channel", "Chaos Orb", new String[]{"Contract From Below", "Counterbalance", "Darkpact", "Demonic Attorney", "Demonic Tutor", "Earthcraft", "Edric, Spymaster of Trest", "Falling Star", "Fastbond", "Flash", "Goblin Recruiter", "Grindstone", "Hermit Druid", "Imperial Seal", "Jeweled Bird", "Karakas", "Library of Alexandria", "Mana Crypt", "Mana Drain", "Mana Vault", "Metalworker", "Mind Twist", "Mishra's Workshop", "Mox Emerald", "Mox Jet", "Mox Pearl", "Mox Ruby", "Mox Sapphire", "Najeela, the Blade Blossom", "Necropotence", "Shahrazad", "Skullclamp", "Sol Ring", "Strip Mine", "Survival of the Fittest", "Sword of Body and Mind", "Time Vault", "Time Walk", "Timetwister", "Timmerian Fiends", "Tolarian Academy", "Umezawa's Jitte", "Vampiric Tutor", "Wheel of Fortune", "Yawgmoth's Will"});

        @Override
        public boolean apply(CardRules rules) {
            if (rules.getMainPart().getManaCost().getCMC() > 3) {
                return false;
            }
            ICardFace otherPart = rules.getOtherPart();
            if (otherPart != null && otherPart.getManaCost().getCMC() > 3) {
                return false;
            }
            return !this.bannedCards.contains(rules.getName());
        }
    }){
        private final Set<String> bannedCommanders = ImmutableSet.of("Derevi, Empyrial Tactician", "Erayo, Soratami Ascendant", "Rofellos, Llanowar Emissary");

        @Override
        public boolean isLegalCommander(CardRules rules) {
            return super.isLegalCommander(rules) && !this.bannedCommanders.contains(rules.getName());
        }

        @Override
        public void adjustCMCLevels(List<ImmutablePair<DeckGeneratorBase.FilterCMC, Integer>> cmcLevels) {
            cmcLevels.clear();
            cmcLevels.add(ImmutablePair.of(new DeckGeneratorBase.FilterCMC(0, 1), 3));
            cmcLevels.add(ImmutablePair.of(new DeckGeneratorBase.FilterCMC(2, 2), 3));
            cmcLevels.add(ImmutablePair.of(new DeckGeneratorBase.FilterCMC(3, 3), 3));
        }
    }
    ,
    PlanarConquest(Range.between(40, Integer.MAX_VALUE), Range.is(0), 1),
    Adventure(Range.between(40, Integer.MAX_VALUE), Range.between(0, 15), 4),
    Vanguard(Range.between(60, Integer.MAX_VALUE), Range.is(0), 4),
    Planechase(Range.between(60, Integer.MAX_VALUE), Range.is(0), 4),
    Archenemy(Range.between(60, Integer.MAX_VALUE), Range.is(0), 4),
    Puzzle(Range.between(0, Integer.MAX_VALUE), Range.is(0), 4);

    private final Range<Integer> mainRange;
    private final Range<Integer> sideRange;
    private final int maxCardCopies;
    private final Predicate<CardRules> cardPoolFilter;
    private final Predicate<PaperCard> paperCardPoolFilter;
    private static final String ADVPROCLAMATION = "Advantageous Proclamation";

    private DeckFormat(Range<Integer> mainRange0, Range<Integer> sideRange0, int maxCardCopies0, Predicate<CardRules> cardPoolFilter0, Predicate<PaperCard> paperCardPoolFilter0) {
        this.mainRange = mainRange0;
        this.sideRange = sideRange0;
        this.maxCardCopies = maxCardCopies0;
        this.cardPoolFilter = cardPoolFilter0;
        this.paperCardPoolFilter = paperCardPoolFilter0;
    }

    private DeckFormat(Range<Integer> mainRange0, Range<Integer> sideRange0, int maxCardCopies0, Predicate<CardRules> cardPoolFilter0) {
        this.mainRange = mainRange0;
        this.sideRange = sideRange0;
        this.maxCardCopies = maxCardCopies0;
        this.paperCardPoolFilter = null;
        this.cardPoolFilter = cardPoolFilter0;
    }

    private DeckFormat(Range<Integer> mainRange0, Range<Integer> sideRange0, int maxCardCopies0) {
        this.mainRange = mainRange0;
        this.sideRange = sideRange0;
        this.maxCardCopies = maxCardCopies0;
        this.paperCardPoolFilter = null;
        this.cardPoolFilter = null;
    }

    public boolean hasCommander() {
        return this == Commander || this == Oathbreaker || this == TinyLeaders || this == Brawl;
    }

    public boolean hasSignatureSpell() {
        return this == Oathbreaker;
    }

    public static DeckFormat smartValueOf(String value, DeckFormat defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        String valToCompate = value.trim();
        for (DeckFormat v : DeckFormat.values()) {
            if (v.name().compareToIgnoreCase(valToCompate) != 0) continue;
            return v;
        }
        throw new IllegalArgumentException("No element named " + value + " in enum GameType");
    }

    public Range<Integer> getSideRange() {
        return this.sideRange;
    }

    public Range<Integer> getMainRange() {
        return this.mainRange;
    }

    public int getMaxCardCopies() {
        return this.maxCardCopies;
    }

    public String getDeckConformanceProblem(Deck deck) {
        String attractionError;
        if (deck == null) {
            return "is not selected";
        }
        int deckSize = deck.getMain().countAll();
        int min2 = this.getMainRange().getMinimum();
        int max = this.getMainRange().getMaximum();
        CardPool conspiracies = deck.get(DeckSection.Conspiracy);
        if (conspiracies != null) {
            min2 -= 5 * conspiracies.countByName(ADVPROCLAMATION);
        }
        if (this.hasCommander()) {
            byte cmdCI = 0;
            int wildColors = 0;
            if (this.equals((Object)Oathbreaker)) {
                PaperCard oathbreaker = deck.getOathbreaker();
                if (oathbreaker == null) {
                    return "is missing an oathbreaker";
                }
                if (deck.getSignatureSpell() == null) {
                    return "is missing a signature spell";
                }
                if (deck.getCommanders().size() > 2) {
                    return "has too many commanders";
                }
                cmdCI = oathbreaker.getRules().getColorIdentity().getColor();
            } else {
                List<PaperCard> commanders = deck.getCommanders();
                if (commanders.isEmpty()) {
                    return "is missing a commander";
                }
                if (commanders.size() > 2) {
                    return "has too many commanders";
                }
                for (PaperCard pc2 : commanders) {
                    if (!this.isLegalCommander(pc2.getRules())) {
                        return "has an illegal commander";
                    }
                    cmdCI = (byte)(cmdCI | pc2.getRules().getColorIdentity().getColor());
                    wildColors += pc2.getRules().getAddsWildCardColor() ? 1 : 0;
                }
                if (commanders.size() == 2) {
                    --min2;
                    --max;
                    PaperCard paperCard = commanders.get(0);
                    Iterator b = commanders.get(1);
                    if (!paperCard.getRules().canBePartnerCommanders(((PaperCard)((Object)b)).getRules())) {
                        return "has an illegal commander partnership";
                    }
                }
            }
            ArrayList<PaperCard> erroneousCI = new ArrayList<PaperCard>();
            HashSet<String> hashSet = new HashSet<String>();
            for (Map.Entry cp : deck.get(DeckSection.Main)) {
                ColorSet missingColors;
                if (cmdCI == 0 && ((PaperCard)cp.getKey()).getRules().getType().isBasicLand()) {
                    hashSet.add(((PaperCard)cp.getKey()).getName());
                    if (hashSet.size() < 2) continue;
                }
                if ((missingColors = ((PaperCard)cp.getKey()).getRules().getColorIdentity().getMissingColors(cmdCI)).countColors() <= 0) continue;
                if (missingColors.countColors() <= wildColors) {
                    wildColors -= missingColors.countColors();
                    cmdCI = (byte)(cmdCI | missingColors.getColor());
                    continue;
                }
                erroneousCI.add((PaperCard)cp.getKey());
            }
            if (deck.has(DeckSection.Sideboard)) {
                for (Map.Entry cp : deck.get(DeckSection.Sideboard)) {
                    if (((PaperCard)cp.getKey()).getRules().getColorIdentity().hasNoColorsExcept(cmdCI)) continue;
                    erroneousCI.add((PaperCard)cp.getKey());
                }
            }
            if (erroneousCI.size() > 0) {
                StringBuilder sb = new StringBuilder("contains one or more cards that do not match the commanders color identity:");
                for (PaperCard cp : erroneousCI) {
                    sb.append("\n").append(cp.getName());
                }
                return sb.toString();
            }
        }
        if (deckSize < min2) {
            return TextUtil.concatWithSpace("should have at least", String.valueOf(min2), "cards");
        }
        if (deckSize > max) {
            return TextUtil.concatWithSpace("should have no more than", String.valueOf(max), "cards");
        }
        if (this.cardPoolFilter != null) {
            ArrayList<PaperCard> erroneousCI = new ArrayList<PaperCard>();
            for (Object cp : deck.getAllCardsInASinglePool()) {
                if (this.cardPoolFilter.apply(((PaperCard)cp.getKey()).getRules())) continue;
                erroneousCI.add((PaperCard)cp.getKey());
            }
            if (erroneousCI.size() > 0) {
                StringBuilder sb = new StringBuilder("contains the following illegal cards:\n");
                for (PaperCard paperCard : erroneousCI) {
                    sb.append("\n").append(paperCard.getName());
                }
                return sb.toString();
            }
        }
        if (deck.has(DeckSection.Attractions) && (attractionError = this.getAttractionDeckConformanceProblem(deck)) != null) {
            return attractionError;
        }
        int maxCopies = this.getMaxCardCopies();
        CardPool allCards = deck.getAllCardsInASinglePool(this.hasCommander());
        for (Map.Entry entry : Aggregates.groupSumBy(allCards, pc -> StaticData.instance().getCommonCards().getName(pc.getName(), true))) {
            PaperCard simpleCard = StaticData.instance().getCommonCards().getCard((String)entry.getKey());
            if (simpleCard != null && simpleCard.getRules().isCustom() && !StaticData.instance().allowCustomCardsInDecksConformance()) {
                return TextUtil.concatWithSpace("contains a Custom Card:", (String)entry.getKey(), "\nPlease Enable Custom Cards in Forge Preferences to use this deck.");
            }
            if (simpleCard == null && (simpleCard = StaticData.instance().getVariantCards().getCard((String)entry.getKey())) == null) {
                return TextUtil.concatWithSpace("contains the nonexisting card", (String)entry.getKey());
            }
            if (DeckFormat.canHaveAnyNumberOf(simpleCard)) continue;
            Integer cardCopies = DeckFormat.canHaveSpecificNumberInDeck(simpleCard);
            if (cardCopies != null && deck.getMain().countByName((String)entry.getKey()) > cardCopies) {
                return TextUtil.concatWithSpace("must not contain more than", String.valueOf(cardCopies), "copies of the card", (String)entry.getKey());
            }
            if (cardCopies != null || (Integer)entry.getValue() <= maxCopies) continue;
            return TextUtil.concatWithSpace("must not contain more than", String.valueOf(maxCopies), "copies of the card", (String)entry.getKey());
        }
        int sideboardSize = deck.has(DeckSection.Sideboard) ? deck.get(DeckSection.Sideboard).countAll() : 0;
        Range<Integer> range = this.getSideRange();
        if (range != null && sideboardSize > 0 && !range.contains(sideboardSize)) {
            return range.getMinimum() == range.getMaximum() ? TextUtil.concatWithSpace("must have a sideboard of", String.valueOf(range.getMinimum()), "cards or no sideboard at all") : TextUtil.concatWithSpace("must have a sideboard of", String.valueOf(range.getMinimum()), "to", String.valueOf(range.getMaximum()), "cards or no sideboard at all");
        }
        return null;
    }

    public String getAttractionDeckConformanceProblem(Deck deck) {
        CardPool attractionDeck = deck.get(DeckSection.Attractions);
        if (attractionDeck.countAll() < 10) {
            return "must contain at least 10 attractions, or none at all";
        }
        for (Map.Entry cp : attractionDeck) {
            if (attractionDeck.countByName((PaperCard)cp.getKey()) <= 1) continue;
            return TextUtil.concatWithSpace("contains more than 1 copy of the attraction", ((PaperCard)cp.getKey()).getName());
        }
        return null;
    }

    public static boolean canHaveAnyNumberOf(IPaperCard icard) {
        return icard.getRules().getType().isBasicLand() || Iterables.contains(icard.getRules().getMainPart().getKeywords(), "A deck can have any number of cards named CARDNAME.");
    }

    public static Integer canHaveSpecificNumberInDeck(IPaperCard card) {
        return card.getRules().getKeywordMagnitude("DeckLimit");
    }

    public static String getPlaneSectionConformanceProblem(CardPool planes) {
        if (planes == null || planes.countAll() < 10) {
            return "should have at least 10 planes";
        }
        int phenoms = 0;
        for (Map.Entry cp : planes) {
            if (((PaperCard)cp.getKey()).getRules().getType().hasType(CardType.CoreType.Phenomenon)) {
                ++phenoms;
            }
            if (cp.getValue() <= 1) continue;
            return "must not contain multiple copies of any Plane or Phenomena";
        }
        if (phenoms > 2) {
            return "must not contain more than 2 Phenomena";
        }
        return null;
    }

    public static String getSchemeSectionConformanceProblem(CardPool schemes) {
        if (schemes == null || schemes.countAll() < 20) {
            return "must contain at least 20 schemes";
        }
        for (Map.Entry cp : schemes) {
            if (cp.getValue() <= 2) continue;
            return TextUtil.concatWithSpace("must not contain more than 2 copies of any Scheme, but has", String.valueOf(cp.getValue()), "of", TextUtil.enclosedSingleQuote(((PaperCard)cp.getKey()).getName()));
        }
        return null;
    }

    public IDeckGenPool getCardPool(IDeckGenPool basePool) {
        if (this.cardPoolFilter == null) {
            if (this.paperCardPoolFilter == null) {
                return basePool;
            }
            DeckGenPool filteredPool = new DeckGenPool();
            for (PaperCard pc : basePool.getAllCards()) {
                if (!this.paperCardPoolFilter.apply(pc)) continue;
                filteredPool.add(pc);
            }
            return filteredPool;
        }
        DeckGenPool filteredPool = new DeckGenPool();
        for (PaperCard pc : basePool.getAllCards()) {
            if (!this.cardPoolFilter.apply(pc.getRules())) continue;
            filteredPool.add(pc);
        }
        return filteredPool;
    }

    public void adjustCMCLevels(List<ImmutablePair<DeckGeneratorBase.FilterCMC, Integer>> cmcLevels) {
    }

    public boolean isLegalCard(PaperCard pc) {
        if (this.cardPoolFilter == null) {
            if (this.paperCardPoolFilter == null) {
                return true;
            }
            return this.paperCardPoolFilter.apply(pc);
        }
        return this.cardPoolFilter.apply(pc.getRules());
    }

    public boolean isLegalCommander(CardRules rules) {
        if (this.cardPoolFilter != null && !this.cardPoolFilter.apply(rules)) {
            return false;
        }
        if (this.equals((Object)Oathbreaker)) {
            return rules.canBeOathbreaker();
        }
        if (this.equals((Object)Brawl)) {
            return rules.canBeBrawlCommander();
        }
        if (this.equals((Object)TinyLeaders)) {
            return rules.canBeTinyLeadersCommander();
        }
        return rules.canBeCommander();
    }

    public Predicate<Deck> isLegalDeckPredicate() {
        return deck -> this.getDeckConformanceProblem((Deck)deck) == null;
    }

    public Predicate<Deck> hasLegalCardsPredicate(boolean enforceDeckLegality) {
        return deck -> {
            if (!enforceDeckLegality) {
                return true;
            }
            if (this.cardPoolFilter != null) {
                for (Map.Entry cp : deck.getAllCardsInASinglePool()) {
                    if (this.cardPoolFilter.apply(((PaperCard)cp.getKey()).getRules())) continue;
                    return false;
                }
            }
            if (this.paperCardPoolFilter != null) {
                for (Map.Entry cp : deck.getAllCardsInASinglePool()) {
                    if (this.paperCardPoolFilter.apply((PaperCard)cp.getKey())) continue;
                    System.err.println("Excluding deck: '" + deck.toString() + "' Reason: '" + cp.getKey() + "' is not legal.");
                    return false;
                }
            }
            return true;
        };
    }

    public Predicate<PaperCard> isLegalCardPredicate() {
        return this::isLegalCard;
    }

    public Predicate<PaperCard> isLegalCommanderPredicate() {
        return card -> this.isLegalCommander(card.getRules());
    }

    public Predicate<PaperCard> isLegalCardForCommanderPredicate(List<PaperCard> commanders) {
        int cmdCI = 0;
        for (PaperCard p : commanders) {
            cmdCI = (byte)(cmdCI | p.getRules().getColorIdentity().getColor());
        }
        Predicate<CardRules> predicate = CardRulesPredicates.hasColorIdentity(cmdCI);
        if (commanders.size() == 1 && commanders.get(0).getRules().canBePartnerCommander()) {
            predicate = Predicates.or(predicate, CardRulesPredicates.canBePartnerCommanderWith(commanders.get(0).getRules()));
        }
        return Predicates.compose(predicate, PaperCard::getRules);
    }
}

