/*
 * Decompiled with CFR 0.152.
 */
package forge.deck;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import forge.card.CardEdition;
import forge.card.CardRules;
import forge.card.CardRulesPredicates;
import forge.deck.CardArchetypeLDAGenerator;
import forge.deck.CardRelationMatrixGenerator;
import forge.deck.Deck;
import forge.deck.DeckFormat;
import forge.deck.DeckProxy;
import forge.deck.DeckgenUtil;
import forge.deck.generation.DeckGeneratorBase;
import forge.item.PaperCard;
import forge.model.FModel;
import forge.util.ItemPool;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CommanderDeckGenerator
extends DeckProxy
implements Comparable<CommanderDeckGenerator> {
    private final PaperCard legend;
    private final int index;
    private final DeckFormat format;
    private final boolean isForAi;
    private final boolean isCardgen;

    public static List<DeckProxy> getCommanderDecks(DeckFormat format, boolean isForAi, boolean isCardGen) {
        ItemPool<PaperCard> uniqueCards;
        if (format.equals((Object)DeckFormat.Brawl)) {
            return CommanderDeckGenerator.getBrawlDecks(format, isForAi, isCardGen);
        }
        if (isCardGen) {
            uniqueCards = new ItemPool<PaperCard>(PaperCard.class);
            String matrixKey = (format.equals((Object)DeckFormat.TinyLeaders) ? DeckFormat.Commander : format).toString();
            HashMap<String, List<Map.Entry<PaperCard, Integer>>> matrixPool = CardRelationMatrixGenerator.cardPools.get(matrixKey);
            if (matrixPool != null) {
                Set<String> legendNames = matrixPool.keySet();
                for (String legendName : legendNames) {
                    uniqueCards.add(FModel.getMagicDb().getCommonCards().getUniqueByName(legendName));
                }
            }
        } else {
            uniqueCards = ItemPool.createFrom(FModel.getMagicDb().getCommonCards().getUniqueCards(), PaperCard.class);
        }
        Predicate<CardRules> canPlay = isForAi ? DeckGeneratorBase.AI_CAN_PLAY : CardRulesPredicates.IS_KEPT_IN_RANDOM_DECKS;
        Iterable<PaperCard> legends = Iterables.filter(uniqueCards.toFlatList(), Predicates.and(format.isLegalCommanderPredicate(), Predicates.compose(canPlay, PaperCard::getRules)));
        ArrayList<DeckProxy> decks = new ArrayList<DeckProxy>();
        for (PaperCard legend : legends) {
            decks.add(new CommanderDeckGenerator(legend, format, isForAi, isCardGen));
        }
        return decks;
    }

    public static List<DeckProxy> getBrawlDecks(DeckFormat format, boolean isForAi, boolean isCardGen) {
        ItemPool<PaperCard> uniqueCards;
        if (isCardGen) {
            uniqueCards = new ItemPool<PaperCard>(PaperCard.class);
            Set<String> legendNames = CardArchetypeLDAGenerator.ldaPools.get(FModel.getFormats().getStandard().getName()).keySet();
            for (String legendName : legendNames) {
                uniqueCards.add(FModel.getMagicDb().getCommonCards().getUniqueByName(legendName));
            }
        } else {
            uniqueCards = ItemPool.createFrom(FModel.getMagicDb().getCommonCards().getUniqueCards(), PaperCard.class);
        }
        Predicate<CardRules> canPlay = isForAi ? DeckGeneratorBase.AI_CAN_PLAY : CardRulesPredicates.IS_KEPT_IN_RANDOM_DECKS;
        Iterable<PaperCard> legends = Iterables.filter(uniqueCards.toFlatList(), Predicates.and(format.isLegalCardPredicate(), Predicates.compose(Predicates.and(CardRulesPredicates.Presets.CAN_BE_BRAWL_COMMANDER, canPlay), PaperCard::getRules)));
        ArrayList<DeckProxy> decks = new ArrayList<DeckProxy>();
        for (PaperCard legend : legends) {
            decks.add(new CommanderDeckGenerator(legend, format, isForAi, isCardGen));
        }
        return decks;
    }

    private CommanderDeckGenerator(PaperCard legend0, DeckFormat format0, boolean isForAi0, boolean isCardgen0) {
        this.legend = legend0;
        this.index = 0;
        this.isForAi = isForAi0;
        this.format = format0;
        this.isCardgen = isCardgen0;
    }

    @Override
    public CardEdition getEdition() {
        return CardEdition.UNKNOWN;
    }

    @Override
    public String getName() {
        return this.legend.getName();
    }

    @Override
    public String toString() {
        return this.legend.getName();
    }

    @Override
    public int compareTo(CommanderDeckGenerator d) {
        return this.getName().compareTo(d.getName());
    }

    @Override
    public Deck getDeck() {
        return DeckgenUtil.generateRandomCommanderDeck(this.legend, this.format, this.isForAi, this.isCardgen);
    }

    @Override
    public boolean isGeneratedDeck() {
        return true;
    }

    @Override
    public String getImageKey(boolean altState) {
        return this.legend.getImageKey(altState);
    }

    public PaperCard getPaperCard() {
        return this.legend;
    }
}

