/*
 * Decompiled with CFR 0.152.
 */
package forge.deck;

import forge.StaticData;
import forge.deck.io.Archetype;
import forge.deck.io.CardThemedLDAIO;
import forge.model.FModel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;

public final class CardArchetypeLDAGenerator {
    public static Map<String, Map<String, List<List<Pair<String, Double>>>>> ldaPools = new HashMap<String, Map<String, List<List<Pair<String, Double>>>>>();
    public static Map<String, List<Archetype>> ldaArchetypes = new HashMap<String, List<Archetype>>();

    public static boolean initialize() {
        ArrayList<String> formatStrings = new ArrayList<String>();
        formatStrings.add(FModel.getFormats().getStandard().getName());
        formatStrings.add(FModel.getFormats().getPioneer().getName());
        formatStrings.add(FModel.getFormats().getHistoric().getName());
        formatStrings.add(FModel.getFormats().getModern().getName());
        formatStrings.add(FModel.getFormats().getPauper().getName());
        formatStrings.add("Legacy");
        formatStrings.add("Vintage");
        for (String formatString : formatStrings) {
            if (CardArchetypeLDAGenerator.initializeFormat(formatString)) continue;
            return false;
        }
        return true;
    }

    public static boolean initializeFormat(String format) {
        List<Archetype> lda = CardThemedLDAIO.loadRawLDA(format);
        Map<String, List<List<Pair<String, Double>>>> formatMap = CardThemedLDAIO.loadLDA(format);
        if (formatMap == null) {
            try {
                formatMap = CardArchetypeLDAGenerator.loadFormat(lda);
                CardThemedLDAIO.saveLDA(format, formatMap);
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
        }
        ldaPools.put(format, formatMap);
        ldaArchetypes.put(format, CardArchetypeLDAGenerator.pruneArchetypes(lda));
        return true;
    }

    public static List<Archetype> pruneArchetypes(List<Archetype> archetypes) {
        ArrayList<Archetype> pruned = new ArrayList<Archetype>();
        float deckCount = 0.0f;
        for (Archetype archetype : archetypes) {
            deckCount += (float)archetype.getDeckCount().intValue();
        }
        for (Archetype archetype : archetypes) {
            float metaPercent = archetype.getDeckCount().floatValue() / deckCount;
            if (!((double)metaPercent > 0.001)) continue;
            pruned.add(archetype);
        }
        return pruned;
    }

    public static Map<String, List<List<Pair<String, Double>>>> loadFormat(List<Archetype> lda) throws Exception {
        ArrayList topics = new ArrayList();
        HashSet cards = new HashSet();
        for (int t2 = 0; t2 < lda.size(); ++t2) {
            ArrayList<Pair<String, Double>> topic = new ArrayList<Pair<String, Double>>();
            HashSet<String> topicCards = new HashSet<String>();
            List<Pair<String, Double>> highRankVocabs = lda.get(t2).getCardProbabilities();
            if (highRankVocabs.get(0).getRight() <= 0.01) continue;
            System.out.print("t" + t2 + ": ");
            for (int i = 0; topic.size() <= 40 && i < highRankVocabs.size(); ++i) {
                String string = highRankVocabs.get(i).getLeft();
                if (StaticData.instance().getCommonCards().getUniqueByName(string).getRules().getType().isBasicLand()) continue;
                if (highRankVocabs.get(i).getRight() >= 0.005) {
                    topicCards.add(string);
                }
                System.out.println("[" + highRankVocabs.get(i).getLeft() + "," + highRankVocabs.get(i).getRight() + "],");
                topic.add(highRankVocabs.get(i));
            }
            System.out.println();
            if (topic.size() <= 18) continue;
            cards.addAll(topicCards);
            topics.add(topic);
        }
        HashMap<String, List<List<Pair<String, Double>>>> cardTopicMap = new HashMap<String, List<List<Pair<String, Double>>>>();
        for (String card : cards) {
            ArrayList<List> cardTopics = new ArrayList<List>();
            for (List list : topics) {
                if (!CardArchetypeLDAGenerator.topicContains(card, list)) continue;
                cardTopics.add(list);
            }
            cardTopicMap.put(card, cardTopics);
        }
        return cardTopicMap;
    }

    public static boolean topicContains(String card, List<Pair<String, Double>> topic) {
        for (Pair<String, Double> pair : topic) {
            if (!pair.getLeft().equals(card)) continue;
            return true;
        }
        return false;
    }
}

