/*
 * Decompiled with CFR 0.152.
 */
package forge.deck;

import forge.card.CardEdition;
import forge.deck.CardArchetypeLDAGenerator;
import forge.deck.Deck;
import forge.deck.DeckProxy;
import forge.deck.DeckgenUtil;
import forge.deck.io.Archetype;
import forge.game.GameFormat;
import forge.item.PaperCard;
import forge.model.FModel;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.tuple.Pair;

public class ArchetypeDeckGenerator
extends DeckProxy
implements Comparable<ArchetypeDeckGenerator> {
    private final Archetype archetype;
    private final int index;
    private final GameFormat format;
    private final boolean isForAi;
    private PaperCard card;

    public static List<DeckProxy> getMatrixDecks(GameFormat format, boolean isForAi) {
        ArrayList<DeckProxy> decks = new ArrayList<DeckProxy>();
        for (Archetype archetype : CardArchetypeLDAGenerator.ldaArchetypes.get(format.getName())) {
            decks.add(new ArchetypeDeckGenerator(archetype, format, isForAi));
        }
        return decks;
    }

    private ArchetypeDeckGenerator(Archetype archetype0, GameFormat format0, boolean isForAi0) {
        this.archetype = archetype0;
        this.index = 0;
        this.format = format0;
        this.isForAi = isForAi0;
        for (Pair<String, Double> cardPair : this.archetype.getCardProbabilities()) {
            PaperCard candidate = FModel.getMagicDb().getCommonCards().getUniqueByName(cardPair.getLeft());
            if (candidate.getRules().getType().isLand()) continue;
            this.card = candidate;
            break;
        }
    }

    @Override
    public CardEdition getEdition() {
        return CardEdition.UNKNOWN;
    }

    @Override
    public String getName() {
        return this.archetype.getName();
    }

    @Override
    public String toString() {
        return this.archetype.getName();
    }

    public Archetype getArchetype() {
        return this.archetype;
    }

    @Override
    public int compareTo(ArchetypeDeckGenerator d) {
        return d.getArchetype().getDeckCount().compareTo(this.archetype.getDeckCount());
    }

    @Override
    public Deck getDeck() {
        return DeckgenUtil.buildLDACArchetypeDeck(this.archetype, this.format, this.isForAi);
    }

    @Override
    public boolean isGeneratedDeck() {
        return true;
    }

    @Override
    public String getImageKey(boolean altState) {
        return this.card.getImageKey(altState);
    }

    public PaperCard getPaperCard() {
        return this.card;
    }
}

