/*
 * Decompiled with CFR 0.152.
 */
package forge.card.mana;

import com.google.common.collect.Lists;
import forge.card.mana.IParserManaCost;
import forge.card.mana.ManaAtom;
import forge.card.mana.ManaCostShard;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public final class ManaCost
implements Comparable<ManaCost>,
Iterable<ManaCostShard>,
Serializable,
Cloneable {
    private static final long serialVersionUID = -2477430496624149226L;
    private static final char DELIM = '\u0006';
    private List<ManaCostShard> shards;
    private final int genericCost;
    private final boolean hasNoCost;
    private String stringValue;
    private Float compareWeight = null;
    public static final ManaCost NO_COST = new ManaCost(-1);
    public static final ManaCost ZERO = new ManaCost(0);
    public static final ManaCost ONE = new ManaCost(1);
    public static final ManaCost TWO = new ManaCost(2);
    public static final ManaCost THREE = new ManaCost(3);
    public static final ManaCost FOUR = new ManaCost(4);

    public static ManaCost get(int cntGeneric) {
        switch (cntGeneric) {
            case 0: {
                return ZERO;
            }
            case 1: {
                return ONE;
            }
            case 2: {
                return TWO;
            }
            case 3: {
                return THREE;
            }
            case 4: {
                return FOUR;
            }
        }
        return cntGeneric > 0 ? new ManaCost(cntGeneric) : NO_COST;
    }

    private ManaCost(int cmc) {
        this.hasNoCost = cmc < 0;
        this.genericCost = cmc < 0 ? 0 : cmc;
        this.sealClass(Lists.newArrayList());
    }

    private ManaCost(int cmc, List<ManaCostShard> shards0) {
        this.hasNoCost = cmc < 0;
        this.genericCost = cmc < 0 ? 0 : cmc;
        this.sealClass(shards0);
    }

    private void sealClass(List<ManaCostShard> shards0) {
        this.shards = Collections.unmodifiableList(shards0);
        this.stringValue = this.getSimpleString();
    }

    public ManaCost(IParserManaCost parser) {
        ArrayList<ManaCostShard> shardsTemp = Lists.newArrayList();
        this.hasNoCost = false;
        while (parser.hasNext()) {
            ManaCostShard shard = (ManaCostShard)((Object)parser.next());
            if (shard == null || shard == ManaCostShard.GENERIC) continue;
            shardsTemp.add(shard);
        }
        this.genericCost = parser.getTotalGenericCost();
        this.sealClass(shardsTemp);
    }

    public String getSimpleString() {
        if (this.hasNoCost) {
            return "no cost";
        }
        if (this.shards.isEmpty()) {
            return "{" + this.genericCost + "}";
        }
        StringBuilder sb = new StringBuilder();
        if (this.genericCost > 0) {
            sb.append("{").append(this.genericCost).append("}");
        }
        for (ManaCostShard s2 : this.shards) {
            if (s2 == ManaCostShard.X) {
                sb.insert(0, s2.toString());
                continue;
            }
            sb.append(s2.toString());
        }
        return sb.toString();
    }

    public int getCMC() {
        int sum = 0;
        for (ManaCostShard s2 : this.shards) {
            sum += s2.getCmc();
        }
        return sum + this.genericCost;
    }

    public byte getColorProfile() {
        byte result = 0;
        for (ManaCostShard s2 : this.shards) {
            result = (byte)(result | s2.getColorMask());
        }
        return result;
    }

    public int getShardCount(ManaCostShard which) {
        if (which == ManaCostShard.GENERIC) {
            return this.genericCost;
        }
        int res = 0;
        for (ManaCostShard shard : this.shards) {
            if (shard != which) continue;
            ++res;
        }
        return res;
    }

    public int[] getColorShardCounts() {
        int[] counts = new int[6];
        for (int i = 0; i < this.stringValue.length(); ++i) {
            char symbol = this.stringValue.charAt(i);
            switch (symbol) {
                case 'B': 
                case 'C': 
                case 'G': 
                case 'R': 
                case 'U': 
                case 'W': {
                    int n = ManaAtom.getIndexOfFirstManaType(ManaAtom.fromName(symbol));
                    counts[n] = counts[n] + 1;
                }
            }
        }
        return counts;
    }

    public int getGenericCost() {
        return this.genericCost;
    }

    public boolean isNoCost() {
        return this.hasNoCost;
    }

    public boolean isPureGeneric() {
        return this.shards.isEmpty() && !this.isNoCost();
    }

    public boolean isZero() {
        return this.genericCost == 0 && this.isPureGeneric();
    }

    @Override
    public int compareTo(ManaCost o) {
        return this.getCompareWeight().compareTo(o.getCompareWeight());
    }

    private Float getCompareWeight() {
        if (this.compareWeight == null) {
            float weight = this.genericCost;
            for (ManaCostShard s2 : this.shards) {
                weight += s2.getCmpc();
            }
            if (this.hasNoCost) {
                weight = -1.0f;
            }
            this.compareWeight = Float.valueOf(weight);
        }
        return this.compareWeight;
    }

    public static String serialize(ManaCost mc) {
        StringBuilder builder = new StringBuilder();
        builder.append(mc.hasNoCost ? -1 : mc.genericCost);
        for (ManaCostShard shard : mc.shards) {
            builder.append('\u0006').append(shard.name());
        }
        return builder.toString();
    }

    public static ManaCost deserialize(String value) {
        String[] pieces = StringUtils.split(value, '\u0006');
        ManaCost mc = new ManaCost(Integer.parseInt(pieces[0]));
        ArrayList<ManaCostShard> sh = Lists.newArrayList();
        for (int i = 1; i < pieces.length; ++i) {
            sh.add(ManaCostShard.valueOf(pieces[i]));
        }
        mc.sealClass(sh);
        return mc;
    }

    public String toString() {
        return this.stringValue;
    }

    public String getShortString() {
        StringBuilder sb = new StringBuilder();
        int generic = this.getGenericCost();
        if (this.isZero()) {
            sb.append('0');
        }
        if (generic > 0) {
            sb.append(generic);
        }
        for (ManaCostShard s2 : this.shards) {
            sb.append(' ');
            sb.append((Object)s2);
        }
        return sb.toString().trim();
    }

    public boolean hasPhyrexian() {
        for (ManaCostShard shard : this.shards) {
            if (!shard.isPhyrexian()) continue;
            return true;
        }
        return false;
    }

    public int getPhyrexianCount() {
        int i = 0;
        for (ManaCostShard shard : this.shards) {
            if (!shard.isPhyrexian()) continue;
            ++i;
        }
        return i;
    }

    public boolean hasMultiColor() {
        for (ManaCostShard shard : this.shards) {
            if (!shard.isMultiColor()) continue;
            return true;
        }
        return false;
    }

    public String getFirstPhyrexianPip() {
        for (ManaCostShard shard : this.shards) {
            if (!shard.isPhyrexian()) continue;
            return shard.toString();
        }
        return null;
    }

    public ManaCost getNormalizedMana() {
        ArrayList<ManaCostShard> list = Lists.newArrayList();
        for (ManaCostShard shard : this.shards) {
            list.add(ManaCostShard.valueOf(shard.getColorMask()));
        }
        return new ManaCost(this.genericCost, list);
    }

    public int countX() {
        return this.getShardCount(ManaCostShard.X);
    }

    public boolean canBePaidWithAvailable(byte colorCode) {
        for (ManaCostShard shard : this.shards) {
            if (shard.isPhyrexian() || shard.canBePaidWithManaOfColor(colorCode)) continue;
            return false;
        }
        return true;
    }

    public static ManaCost combine(ManaCost a, ManaCost b) {
        ManaCost res = new ManaCost(a.genericCost + b.genericCost);
        ArrayList<ManaCostShard> sh = Lists.newArrayList();
        sh.addAll(a.shards);
        sh.addAll(b.shards);
        res.sealClass(sh);
        return res;
    }

    @Override
    public Iterator<ManaCostShard> iterator() {
        return this.shards.iterator();
    }

    public int getGlyphCount() {
        int width = this.shards.size();
        if (this.genericCost > 0 || this.genericCost == 0 && width == 0) {
            ++width;
        }
        return width;
    }
}

