/*
 * Decompiled with CFR 0.152.
 */
package forge.card;

import com.google.common.collect.ImmutableList;
import forge.Forge;
import forge.Graphics;
import forge.assets.FImage;
import forge.assets.FSkinFont;
import forge.assets.FSkinImage;
import forge.game.GameEntityView;
import forge.game.card.CardView;
import forge.screens.FScreen;
import forge.screens.TabPageScreen;
import forge.toolbox.FChoiceList;
import forge.toolbox.FEvent;
import forge.toolbox.FOptionPane;
import forge.toolbox.FTextField;
import forge.util.Callback;
import java.util.ArrayList;
import java.util.Collection;

public class GameEntityPicker
extends TabPageScreen<GameEntityPicker> {
    private final FOptionPane optionPane;

    public GameEntityPicker(String title, Collection<? extends GameEntityView> choiceList, Collection<CardView> revealList, String revealListCaption, FImage revealListImage, boolean isOptional, final Callback<GameEntityView> callback) {
        super(new PickerTab[]{new PickerTab(choiceList, Forge.getLocalizer().getMessage("lblChoices", new Object[0]), Forge.hdbuttons ? FSkinImage.HDCHOICE : FSkinImage.DECKLIST, 1), new PickerTab(revealList, revealListCaption, revealListImage, 0)}, false);
        this.setHeight(FOptionPane.getMaxDisplayObjHeight());
        this.optionPane = new FOptionPane(null, null, title, null, this, isOptional ? ImmutableList.of(Forge.getLocalizer().getMessage("lblOK", new Object[0]), Forge.getLocalizer().getMessage("lblCancel", new Object[0])) : ImmutableList.of(Forge.getLocalizer().getMessage("lblOK", new Object[0])), 0, new Callback<Integer>(){

            @Override
            public void run(Integer result) {
                if (result == 0) {
                    callback.run((GameEntityView)((PickerTab)GameEntityPicker.this.tabPages.get(0)).list.getSelectedItem());
                } else {
                    callback.run(null);
                }
            }
        }){

            @Override
            protected boolean padAboveAndBelow() {
                return false;
            }
        };
    }

    public void show() {
        this.optionPane.show();
    }

    @Override
    protected boolean canActivateTabPage() {
        return true;
    }

    @Override
    public FScreen getLandscapeBackdropScreen() {
        return null;
    }

    private static class PickerTab
    extends TabPageScreen.TabPage<GameEntityPicker> {
        private final FTextField txtSearch = this.add(new FTextField());
        private final FChoiceList<GameEntityView> list;

        private PickerTab(final Collection<? extends GameEntityView> items, String caption0, FImage icon0, final int maxChoices) {
            super(caption0 + " (" + items.size() + ")", icon0);
            this.txtSearch.setFont(FSkinFont.get(12));
            this.txtSearch.setGhostText(Forge.getLocalizer().getMessage("lblSearch", new Object[0]));
            this.txtSearch.setChangedHandler(new FEvent.FEventHandler(){

                @Override
                public void handleEvent(FEvent e) {
                    String pattern = txtSearch.getText().toLowerCase();
                    list.clearSelection();
                    if (pattern.isEmpty()) {
                        list.setListData(items);
                    } else {
                        ArrayList<GameEntityView> filteredList = new ArrayList<GameEntityView>();
                        for (GameEntityView option : items) {
                            if (!option.toString().toLowerCase().contains(pattern)) continue;
                            filteredList.add(option);
                        }
                        list.setListData(filteredList);
                    }
                    if (!list.isEmpty() && maxChoices > 0) {
                        list.addSelectedIndex(0);
                    }
                    list.setScrollTop(0.0f);
                }
            });
            this.list = this.add(new FChoiceList<GameEntityView>(items, maxChoices, maxChoices){

                @Override
                protected void onItemActivate(Integer index, GameEntityView value) {
                    if (this.maxChoices > 0) {
                        ((GameEntityPicker)parentScreen).optionPane.setResult(0);
                    }
                }

                @Override
                public void drawOverlay(Graphics g2) {
                }
            });
            if (maxChoices > 0) {
                this.list.addSelectedIndex(0);
            }
        }

        @Override
        protected void onActivate() {
            if (((GameEntityPicker)this.parentScreen).optionPane != null) {
                ((GameEntityPicker)this.parentScreen).optionPane.setButtonEnabled(0, this.list.getMaxChoices() > 0);
            }
        }

        @Override
        protected void doLayout(float width, float height) {
            float padding;
            float y = padding = this.txtSearch.getHeight() * 0.25f;
            this.txtSearch.setBounds(0.0f, y, width, this.txtSearch.getHeight());
            this.list.setBounds(0.0f, y += this.txtSearch.getHeight() + padding, width, height - y);
        }
    }
}

