/*
 * Decompiled with CFR 0.152.
 */
package forge.card;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import forge.StaticData;
import forge.card.CardRules;
import forge.card.CardRulesPredicates;
import forge.card.ColorSet;
import forge.item.PaperCard;
import forge.token.TokenDb;
import forge.util.PredicateString;
import forge.util.collect.FCollection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;

public class DeckHints {
    private boolean valid = false;
    private boolean tokens = true;
    private List<Pair<Type, String>> filters = null;

    public DeckHints(String hints) {
        String[] pieces = hints.split("\\&");
        if (pieces.length > 0) {
            for (String piece : pieces) {
                Pair<Type, String> pair = this.parseHint(piece.trim());
                if (pair == null) continue;
                if (pair.getKey() == Type.MODIFIER) {
                    if (!pair.getRight().contains("NoToken")) continue;
                    this.tokens = false;
                    continue;
                }
                if (this.filters == null) {
                    this.filters = new ArrayList<Pair<Type, String>>();
                }
                this.filters.add(pair);
                this.valid = true;
            }
        }
    }

    public boolean isValid() {
        return this.valid;
    }

    public boolean contains(Type type, String hint) {
        if (this.filters == null) {
            return false;
        }
        for (Pair<Type, String> filter : this.filters) {
            if (filter.getLeft() != type || !filter.getRight().contains(hint)) continue;
            return true;
        }
        return false;
    }

    public boolean is(Type type, String[] hints) {
        if (this.filters == null) {
            return false;
        }
        int num = 0;
        for (String hint : hints) {
            for (Pair<Type, String> filter : this.filters) {
                if (filter.getLeft() != type || !filter.getRight().equals(hint) || ++num != hints.length) continue;
                return true;
            }
        }
        return false;
    }

    public Map<Type, Iterable<PaperCard>> filterByType(Iterable<PaperCard> cardList) {
        HashMap<Type, Iterable<PaperCard>> ret = new HashMap<Type, Iterable<PaperCard>>();
        for (Pair<Type, String> pair : this.filters) {
            String param;
            Type type = pair.getLeft();
            Iterable<PaperCard> cards = this.getCardsForFilter(cardList, type, param = pair.getRight());
            if (cards == null) continue;
            if (ret.containsKey((Object)type)) {
                Iterables.retainAll(cards, new FCollection((Iterable)ret.get((Object)type)));
            }
            ret.put(type, cards);
        }
        return ret;
    }

    public Iterable<PaperCard> filter(Iterable<PaperCard> cardList) {
        return Iterables.concat(this.filterByType(cardList).values());
    }

    private Pair<Type, String> parseHint(String hint) {
        Pair<Type, String> pair = null;
        String[] pieces = hint.split("\\$");
        if (pieces.length == 2) {
            try {
                Type typeValue = Type.valueOf(pieces[0].toUpperCase());
                for (Type t2 : Type.values()) {
                    if (typeValue != t2) continue;
                    pair = Pair.of(t2, pieces[1]);
                    break;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return pair;
    }

    private Iterable<PaperCard> getCardsForFilter(Iterable<PaperCard> cardList, Type type, String param) {
        String[] params;
        ArrayList<PaperCard> cards = new ArrayList<PaperCard>();
        for (String ability : params = param.split("\\|")) {
            Iterables.addAll(cards, this.getMatchingItems(cardList, CardRulesPredicates.deckHas(type, ability), PaperCard::getRules));
        }
        if (params.length > 1) {
            Iterables.addAll(cards, this.getMatchingItems(cardList, CardRulesPredicates.deckHasExactly(type, params), PaperCard::getRules));
        }
        block7: for (String p : params) {
            switch (type) {
                case COLOR: {
                    ColorSet cc = ColorSet.fromNames(p);
                    if (cc.isColorless()) {
                        Iterables.addAll(cards, this.getMatchingItems(cardList, CardRulesPredicates.Presets.IS_COLORLESS, PaperCard::getRules));
                        continue block7;
                    }
                    Iterables.addAll(cards, this.getMatchingItems(cardList, CardRulesPredicates.isColor(cc.getColor()), PaperCard::getRules));
                    continue block7;
                }
                case KEYWORD: {
                    Iterables.addAll(cards, this.getMatchingItems(cardList, CardRulesPredicates.hasKeyword(p), PaperCard::getRules));
                    continue block7;
                }
                case NAME: {
                    Iterables.addAll(cards, this.getMatchingItems(cardList, CardRulesPredicates.name(PredicateString.StringOp.EQUALS, p), PaperCard::getRules));
                    continue block7;
                }
                case TYPE: {
                    Iterables.addAll(cards, this.getMatchingItems(cardList, CardRulesPredicates.joinedType(PredicateString.StringOp.CONTAINS_IC, p), PaperCard::getRules));
                    continue block7;
                }
            }
        }
        return cards;
    }

    private Iterable<PaperCard> getMatchingItems(Iterable<PaperCard> source, Predicate<CardRules> predicate, Function<PaperCard, CardRules> fn) {
        return Iterables.filter(source, Predicates.compose(this.tokens ? DeckHints.rulesWithTokens(predicate) : predicate, fn));
    }

    public static Predicate<CardRules> rulesWithTokens(Predicate<CardRules> predicate) {
        TokenDb tdb = StaticData.instance() != null ? StaticData.instance().getAllTokens() : null;
        return card -> {
            if (predicate.apply((CardRules)card)) {
                return true;
            }
            for (String tok : card.getTokens()) {
                if (tdb == null || !tdb.containsRule(tok) || !DeckHints.rulesWithTokens(predicate).apply(tdb.getToken(tok).getRules())) continue;
                return true;
            }
            return false;
        };
    }

    public static enum Type {
        MODIFIER,
        ABILITY,
        COLOR,
        KEYWORD,
        NAME,
        TYPE,
        NONE;

    }
}

