/*
 * Decompiled with CFR 0.152.
 */
package forge.card;

import com.google.common.collect.UnmodifiableIterator;
import forge.card.MagicColor;
import forge.card.mana.ManaCost;
import forge.card.mana.ManaCostShard;
import forge.util.BinaryUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;

public final class ColorSet
implements Comparable<ColorSet>,
Iterable<Byte>,
Serializable {
    private static final long serialVersionUID = 794691267379929080L;
    private final byte myColor;
    private final float orderWeight;
    private static final ColorSet[] cache = new ColorSet[32];
    public static final ColorSet ALL_COLORS = ColorSet.fromMask(31);
    private static final ColorSet NO_COLORS = ColorSet.fromMask(0);
    private static final ManaCostShard[][] shardOrderLookup = new ManaCostShard[32][];

    private ColorSet(byte mask) {
        this.myColor = mask;
        this.orderWeight = this.getOrderWeight();
    }

    public static ColorSet fromMask(int mask) {
        int mask32 = mask & 0x1F;
        if (cache[mask32] == null) {
            ColorSet.cache[mask32] = new ColorSet((byte)mask32);
        }
        return cache[mask32];
    }

    public static ColorSet fromNames(String ... colors) {
        int mask = 0;
        for (String s2 : colors) {
            mask = (byte)(mask | MagicColor.fromName(s2));
        }
        return ColorSet.fromMask(mask);
    }

    public static ColorSet fromNames(Iterable<String> colors) {
        int mask = 0;
        for (String s2 : colors) {
            mask = (byte)(mask | MagicColor.fromName(s2));
        }
        return ColorSet.fromMask(mask);
    }

    public static ColorSet fromNames(char[] colors) {
        int mask = 0;
        for (char s2 : colors) {
            mask = (byte)(mask | MagicColor.fromName(s2));
        }
        return ColorSet.fromMask(mask);
    }

    public static ColorSet fromManaCost(ManaCost mana) {
        return ColorSet.fromMask(mana.getColorProfile());
    }

    public boolean hasAnyColor(int colormask) {
        return (this.myColor & colormask) != 0;
    }

    public boolean hasAllColors(int colormask) {
        return (this.myColor & colormask) == colormask;
    }

    public boolean hasExactlyColor(int colormask) {
        return this.myColor == colormask;
    }

    public boolean hasNoColorsExcept(ColorSet other) {
        return this.hasNoColorsExcept(other.getColor());
    }

    public boolean hasNoColorsExcept(int colormask) {
        return (this.myColor & ~colormask) == 0;
    }

    public ColorSet getMissingColors(byte colormask) {
        return ColorSet.fromMask(this.myColor & ~colormask);
    }

    public boolean containsAllColorsFrom(int colorProfile) {
        return (~this.myColor & colorProfile) == 0;
    }

    public int countColors() {
        return BinaryUtil.bitCount(this.myColor);
    }

    private float getOrderWeight() {
        float res = this.countColors();
        if (this.hasWhite()) {
            res += 5.0E-4f;
        }
        if (this.hasBlue()) {
            res += 0.002f;
        }
        if (this.hasBlack()) {
            res += 0.008f;
        }
        if (this.hasRed()) {
            res += 0.032f;
        }
        if (this.hasGreen()) {
            res += 0.128f;
        }
        return res;
    }

    public boolean isColorless() {
        return this.myColor == 0;
    }

    public boolean isMulticolor() {
        return this.countColors() > 1;
    }

    public boolean isAllColors() {
        return this == ALL_COLORS;
    }

    public boolean isMonoColor() {
        return this.countColors() == 1;
    }

    public boolean isEqual(byte color) {
        return color == this.myColor;
    }

    @Override
    public int compareTo(ColorSet other) {
        return Float.compare(this.orderWeight, other.orderWeight);
    }

    public boolean hasWhite() {
        return this.hasAnyColor(1);
    }

    public boolean hasBlue() {
        return this.hasAnyColor(2);
    }

    public boolean hasBlack() {
        return this.hasAnyColor(4);
    }

    public boolean hasRed() {
        return this.hasAnyColor(8);
    }

    public boolean hasGreen() {
        return this.hasAnyColor(16);
    }

    public ColorSet inverse() {
        byte mask = this.myColor;
        mask = (byte)(mask ^ 0x1F);
        return ColorSet.fromMask(mask);
    }

    public byte getColor() {
        return this.myColor;
    }

    public String toString() {
        if (this.orderWeight == -1.0f) {
            return "n/a";
        }
        String toReturn = MagicColor.toLongString(this.myColor);
        if (toReturn.equals("colorless") && this.myColor != 0) {
            return "multi";
        }
        return toReturn;
    }

    public static ColorSet getNullColor() {
        return NO_COLORS;
    }

    public boolean sharesColorWith(ColorSet ccOther) {
        return (this.myColor & ccOther.myColor) != 0;
    }

    public ColorSet getSharedColors(ColorSet ccOther) {
        return ColorSet.fromMask(this.getColor() & ccOther.getColor());
    }

    public ColorSet getOffColors(ColorSet ccOther) {
        return ColorSet.fromMask(~this.myColor & ccOther.myColor);
    }

    public Set<MagicColor.Color> toEnumSet() {
        if (this.isColorless()) {
            return EnumSet.of(MagicColor.Color.COLORLESS);
        }
        ArrayList<MagicColor.Color> list = new ArrayList<MagicColor.Color>();
        for (MagicColor.Color c : MagicColor.Color.values()) {
            if (!this.hasAnyColor(c.getColormask())) continue;
            list.add(c);
        }
        return EnumSet.copyOf(list);
    }

    @Override
    public Iterator<Byte> iterator() {
        return new ColorIterator();
    }

    public ManaCostShard[] getOrderedShards() {
        return shardOrderLookup[this.myColor];
    }

    static {
        int COLORLESS = 0;
        int WHITE = 1;
        int BLUE = 2;
        int BLACK = 4;
        int RED = 8;
        int GREEN = 16;
        ManaCostShard C2 = ManaCostShard.COLORLESS;
        ManaCostShard W = ManaCostShard.WHITE;
        ManaCostShard U = ManaCostShard.BLUE;
        ManaCostShard B = ManaCostShard.BLACK;
        ManaCostShard R = ManaCostShard.RED;
        ManaCostShard G = ManaCostShard.GREEN;
        ColorSet.shardOrderLookup[COLORLESS] = new ManaCostShard[]{C2};
        ColorSet.shardOrderLookup[WHITE] = new ManaCostShard[]{W};
        ColorSet.shardOrderLookup[BLUE] = new ManaCostShard[]{U};
        ColorSet.shardOrderLookup[BLACK] = new ManaCostShard[]{B};
        ColorSet.shardOrderLookup[RED] = new ManaCostShard[]{R};
        ColorSet.shardOrderLookup[GREEN] = new ManaCostShard[]{G};
        ColorSet.shardOrderLookup[WHITE | BLUE] = new ManaCostShard[]{W, U};
        ColorSet.shardOrderLookup[WHITE | BLACK] = new ManaCostShard[]{W, B};
        ColorSet.shardOrderLookup[BLUE | BLACK] = new ManaCostShard[]{U, B};
        ColorSet.shardOrderLookup[BLUE | RED] = new ManaCostShard[]{U, R};
        ColorSet.shardOrderLookup[BLACK | RED] = new ManaCostShard[]{B, R};
        ColorSet.shardOrderLookup[BLACK | GREEN] = new ManaCostShard[]{B, G};
        ColorSet.shardOrderLookup[RED | GREEN] = new ManaCostShard[]{R, G};
        ColorSet.shardOrderLookup[RED | WHITE] = new ManaCostShard[]{R, W};
        ColorSet.shardOrderLookup[GREEN | WHITE] = new ManaCostShard[]{G, W};
        ColorSet.shardOrderLookup[GREEN | BLUE] = new ManaCostShard[]{G, U};
        ColorSet.shardOrderLookup[WHITE | BLUE | BLACK] = new ManaCostShard[]{W, U, B};
        ColorSet.shardOrderLookup[WHITE | BLACK | GREEN] = new ManaCostShard[]{W, B, G};
        ColorSet.shardOrderLookup[BLUE | BLACK | RED] = new ManaCostShard[]{U, B, R};
        ColorSet.shardOrderLookup[BLUE | RED | WHITE] = new ManaCostShard[]{U, R, W};
        ColorSet.shardOrderLookup[BLACK | RED | GREEN] = new ManaCostShard[]{B, R, G};
        ColorSet.shardOrderLookup[BLACK | GREEN | BLUE] = new ManaCostShard[]{B, G, U};
        ColorSet.shardOrderLookup[RED | GREEN | WHITE] = new ManaCostShard[]{R, G, W};
        ColorSet.shardOrderLookup[RED | WHITE | BLACK] = new ManaCostShard[]{R, W, B};
        ColorSet.shardOrderLookup[GREEN | WHITE | BLUE] = new ManaCostShard[]{G, W, U};
        ColorSet.shardOrderLookup[GREEN | BLUE | RED] = new ManaCostShard[]{G, U, R};
        ColorSet.shardOrderLookup[WHITE | BLUE | BLACK | RED] = new ManaCostShard[]{W, U, B, R};
        ColorSet.shardOrderLookup[BLUE | BLACK | RED | GREEN] = new ManaCostShard[]{U, B, R, G};
        ColorSet.shardOrderLookup[BLACK | RED | GREEN | WHITE] = new ManaCostShard[]{B, R, G, W};
        ColorSet.shardOrderLookup[RED | GREEN | WHITE | BLUE] = new ManaCostShard[]{R, G, W, U};
        ColorSet.shardOrderLookup[GREEN | WHITE | BLUE | BLACK] = new ManaCostShard[]{G, W, U, B};
        ColorSet.shardOrderLookup[WHITE | BLUE | BLACK | RED | GREEN] = new ManaCostShard[]{W, U, B, R, G};
    }

    private class ColorIterator
    extends UnmodifiableIterator<Byte> {
        int currentBit = -1;

        private ColorIterator() {
        }

        private int getIndexOfNextColor() {
            int nextBit;
            for (nextBit = this.currentBit + 1; nextBit < 5 && (ColorSet.this.myColor & MagicColor.WUBRG[nextBit]) == 0; ++nextBit) {
            }
            return nextBit;
        }

        @Override
        public boolean hasNext() {
            return this.getIndexOfNextColor() < 5;
        }

        @Override
        public Byte next() {
            this.currentBit = this.getIndexOfNextColor();
            if (this.currentBit >= 5) {
                throw new NoSuchElementException();
            }
            return MagicColor.WUBRG[this.currentBit];
        }
    }
}

