/*
 * Decompiled with CFR 0.152.
 */
package forge.card;

import com.google.common.base.Predicate;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import forge.card.CardChangedType;
import forge.card.CardTypeView;
import forge.card.GamePieceType;
import forge.util.Settable;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.EnumUtils;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.commons.lang3.StringUtils;

public final class CardType
implements Comparable<CardType>,
CardTypeView {
    private static final long serialVersionUID = 4629853583167022151L;
    public static final CardTypeView EMPTY = new CardType(false);
    private final Set<CoreType> coreTypes = EnumSet.noneOf(CoreType.class);
    private final Set<Supertype> supertypes = EnumSet.noneOf(Supertype.class);
    private final Set<String> subtypes = Sets.newLinkedHashSet();
    private boolean allCreatureTypes = false;
    private final Set<String> excludedCreatureSubtypes = Sets.newLinkedHashSet();
    private boolean incomplete = false;
    private transient String calculatedType = null;
    private static List<String> combinedSuperAndCoreTypes;
    private static List<String> sortedSubTypes;

    public CardType(boolean incomplete) {
        this.incomplete = incomplete;
    }

    public CardType(Iterable<String> from0, boolean incomplete) {
        this.incomplete = incomplete;
        this.addAll(from0);
    }

    public CardType(CardType from0) {
        this.addAll(from0);
        this.allCreatureTypes = from0.allCreatureTypes;
        this.excludedCreatureSubtypes.addAll(from0.excludedCreatureSubtypes);
    }

    public CardType(CardTypeView from0) {
        this.addAll(from0);
    }

    public boolean add(String t2) {
        Supertype st;
        CoreType ct = CoreType.getEnum(t2);
        boolean changed = ct != null ? this.coreTypes.add(ct) : ((st = Supertype.getEnum(t2)) != null ? this.supertypes.add(st) : this.subtypes.add(t2));
        if (changed) {
            this.calculatedType = null;
            return true;
        }
        return false;
    }

    public boolean addAll(Iterable<String> types) {
        if (types == null) {
            return false;
        }
        boolean changed = false;
        for (String t2 : types) {
            if (!this.add(t2)) continue;
            changed = true;
        }
        this.sanisfySubtypes();
        return changed;
    }

    public boolean addAll(CardType type) {
        boolean changed = false;
        if (this.coreTypes.addAll(type.coreTypes)) {
            changed = true;
        }
        if (this.supertypes.addAll(type.supertypes)) {
            changed = true;
        }
        if (this.subtypes.addAll(type.subtypes)) {
            changed = true;
        }
        this.sanisfySubtypes();
        return changed;
    }

    public boolean addAll(CardTypeView type) {
        boolean changed = false;
        if (Iterables.addAll(this.coreTypes, type.getCoreTypes())) {
            changed = true;
        }
        if (Iterables.addAll(this.supertypes, type.getSupertypes())) {
            changed = true;
        }
        if (Iterables.addAll(this.subtypes, type.getSubtypes())) {
            changed = true;
        }
        this.sanisfySubtypes();
        return changed;
    }

    public boolean removeAll(CardType type) {
        boolean changed = false;
        if (this.coreTypes.removeAll(type.coreTypes)) {
            changed = true;
        }
        if (this.supertypes.removeAll(type.supertypes)) {
            changed = true;
        }
        if (this.subtypes.removeAll(type.subtypes)) {
            changed = true;
        }
        if (changed) {
            this.sanisfySubtypes();
            this.calculatedType = null;
            return true;
        }
        return false;
    }

    public void clear() {
        if (this.isEmpty()) {
            return;
        }
        this.coreTypes.clear();
        this.supertypes.clear();
        this.subtypes.clear();
        this.calculatedType = null;
    }

    public void removeCardTypes() {
        this.coreTypes.clear();
    }

    public boolean remove(Supertype st) {
        return this.supertypes.remove((Object)st);
    }

    public boolean remove(String str) {
        boolean changed = false;
        if (this.subtypes.remove(str)) {
            changed = true;
        } else {
            CoreType ct;
            Supertype st = Supertype.getEnum(str);
            if (st != null && this.supertypes.remove((Object)st)) {
                changed = true;
            }
            if ((ct = CoreType.getEnum(str)) != null && this.coreTypes.remove((Object)ct)) {
                changed = true;
            }
        }
        if (changed) {
            this.sanisfySubtypes();
            this.calculatedType = null;
        }
        return changed;
    }

    public boolean setCreatureTypes(Collection<String> ctypes) {
        if (!this.isCreature() && !this.isKindred()) {
            return false;
        }
        boolean changed = Iterables.removeIf(this.subtypes, Predicates.IS_CREATURE_TYPE);
        if (this.allCreatureTypes) {
            changed = true;
        }
        this.allCreatureTypes = false;
        this.subtypes.addAll(ctypes);
        return changed;
    }

    @Override
    public boolean isEmpty() {
        return this.coreTypes.isEmpty() && this.supertypes.isEmpty() && this.subtypes.isEmpty() && this.excludedCreatureSubtypes.isEmpty();
    }

    @Override
    public Iterable<CoreType> getCoreTypes() {
        return this.coreTypes;
    }

    @Override
    public Iterable<Supertype> getSupertypes() {
        return this.supertypes;
    }

    @Override
    public Iterable<String> getSubtypes() {
        return this.subtypes;
    }

    @Override
    public Iterable<String> getExcludedCreatureSubTypes() {
        return this.excludedCreatureSubtypes;
    }

    @Override
    public Set<String> getCreatureTypes() {
        HashSet<String> creatureTypes = Sets.newHashSet();
        if (!this.isCreature() && !this.isKindred()) {
            return creatureTypes;
        }
        if (this.hasAllCreatureTypes()) {
            creatureTypes.addAll(CardType.getAllCreatureTypes());
            creatureTypes.removeAll(this.excludedCreatureSubtypes);
        } else {
            for (String t2 : Iterables.filter(this.subtypes, Predicates.IS_CREATURE_TYPE)) {
                creatureTypes.add(t2);
            }
        }
        return creatureTypes;
    }

    @Override
    public Set<String> getLandTypes() {
        HashSet<String> landTypes = Sets.newHashSet();
        if (this.isLand()) {
            for (String t2 : this.subtypes) {
                if (!CardType.isALandType(t2)) continue;
                landTypes.add(t2);
            }
        }
        return landTypes;
    }

    @Override
    public boolean hasStringType(String t2) {
        if (t2.isEmpty()) {
            return false;
        }
        if (this.hasSubtype(t2)) {
            return true;
        }
        CoreType type = CoreType.getEnum(t2 = StringUtils.capitalize(t2));
        if (type != null) {
            return this.hasType(type);
        }
        Supertype supertype = Supertype.getEnum(t2);
        if (supertype != null) {
            return this.hasSupertype(supertype);
        }
        return false;
    }

    @Override
    public boolean hasType(CoreType type) {
        return this.coreTypes.contains((Object)type);
    }

    @Override
    public boolean hasSupertype(Supertype supertype) {
        return this.supertypes.contains((Object)supertype);
    }

    @Override
    public boolean hasAllCreatureTypes() {
        if (!this.isCreature() && !this.isKindred()) {
            return false;
        }
        return this.allCreatureTypes;
    }

    @Override
    public boolean hasSubtype(String subtype) {
        if (this.hasCreatureType(subtype)) {
            return true;
        }
        return this.subtypes.contains(subtype);
    }

    @Override
    public boolean hasCreatureType(String creatureType) {
        if (!this.isCreature() && !this.isKindred()) {
            return false;
        }
        if (!CardType.isACreatureType(creatureType = CardType.toMixedCase(creatureType))) {
            return false;
        }
        if (this.excludedCreatureSubtypes.contains(creatureType)) {
            return false;
        }
        if (this.allCreatureTypes) {
            return true;
        }
        return this.subtypes.contains(creatureType);
    }

    private static String toMixedCase(String s2) {
        if (s2.isEmpty()) {
            return s2;
        }
        StringBuilder sb = new StringBuilder();
        String[] types = s2.split("-");
        for (int i = 0; i < types.length; ++i) {
            if (i != 0) {
                sb.append("-");
            }
            sb.append(StringUtils.capitalize(types[i]));
        }
        return sb.toString();
    }

    @Override
    public boolean hasABasicLandType() {
        return Iterables.any(this.subtypes, Predicates.IS_BASIC_LAND_TYPE);
    }

    @Override
    public boolean hasANonBasicLandType() {
        return !Collections.disjoint(this.subtypes, CardType.getNonBasicTypes());
    }

    @Override
    public boolean isPermanent() {
        for (CoreType type : this.coreTypes) {
            if (!type.isPermanent) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isCreature() {
        return this.coreTypes.contains((Object)CoreType.Creature);
    }

    @Override
    public boolean isPlaneswalker() {
        return this.coreTypes.contains((Object)CoreType.Planeswalker);
    }

    @Override
    public boolean isBattle() {
        return this.coreTypes.contains((Object)CoreType.Battle);
    }

    @Override
    public boolean isLand() {
        return this.coreTypes.contains((Object)CoreType.Land);
    }

    @Override
    public boolean isArtifact() {
        return this.coreTypes.contains((Object)CoreType.Artifact);
    }

    @Override
    public boolean isInstant() {
        return this.coreTypes.contains((Object)CoreType.Instant);
    }

    @Override
    public boolean isSorcery() {
        return this.coreTypes.contains((Object)CoreType.Sorcery);
    }

    @Override
    public boolean isConspiracy() {
        return this.coreTypes.contains((Object)CoreType.Conspiracy);
    }

    @Override
    public boolean isVanguard() {
        return this.coreTypes.contains((Object)CoreType.Vanguard);
    }

    @Override
    public boolean isScheme() {
        return this.coreTypes.contains((Object)CoreType.Scheme);
    }

    @Override
    public boolean isEnchantment() {
        return this.coreTypes.contains((Object)CoreType.Enchantment);
    }

    @Override
    public boolean isBasic() {
        return this.supertypes.contains((Object)Supertype.Basic);
    }

    @Override
    public boolean isLegendary() {
        return this.supertypes.contains((Object)Supertype.Legendary);
    }

    @Override
    public boolean isSnow() {
        return this.supertypes.contains((Object)Supertype.Snow);
    }

    @Override
    public boolean isBasicLand() {
        return this.isBasic() && this.isLand();
    }

    @Override
    public boolean isPlane() {
        return this.coreTypes.contains((Object)CoreType.Plane);
    }

    @Override
    public boolean isPhenomenon() {
        return this.coreTypes.contains((Object)CoreType.Phenomenon);
    }

    @Override
    public boolean isKindred() {
        return this.coreTypes.contains((Object)CoreType.Kindred);
    }

    @Override
    public boolean isDungeon() {
        return this.coreTypes.contains((Object)CoreType.Dungeon);
    }

    @Override
    public boolean isAttachment() {
        return this.isAura() || this.isEquipment() || this.isFortification();
    }

    @Override
    public boolean isAura() {
        return this.hasSubtype("Aura");
    }

    @Override
    public boolean isEquipment() {
        return this.hasSubtype("Equipment");
    }

    @Override
    public boolean isFortification() {
        return this.hasSubtype("Fortification");
    }

    @Override
    public boolean isAttraction() {
        return this.hasSubtype("Attraction");
    }

    @Override
    public boolean isSaga() {
        return this.hasSubtype("Saga");
    }

    @Override
    public boolean isHistoric() {
        return this.isLegendary() || this.isArtifact() || this.isSaga();
    }

    @Override
    public boolean isOutlaw() {
        if (!this.isCreature() && !this.isKindred()) {
            return false;
        }
        return !Collections.disjoint(this.getCreatureTypes(), Constant.OUTLAW_TYPES);
    }

    public String toString() {
        if (this.calculatedType == null) {
            StringBuilder sb = new StringBuilder(StringUtils.join(this.getTypesBeforeDash(), ' '));
            if (!this.subtypes.isEmpty() || this.hasAllCreatureTypes()) {
                sb.append(" - ");
            }
            if (!this.subtypes.isEmpty()) {
                sb.append(StringUtils.join(this.subtypes, " "));
            }
            if (this.hasAllCreatureTypes()) {
                if (!this.subtypes.isEmpty()) {
                    sb.append(" ");
                }
                sb.append("(All");
                if (!this.excludedCreatureSubtypes.isEmpty()) {
                    sb.append(" except ").append(StringUtils.join(this.excludedCreatureSubtypes, " "));
                }
                sb.append(")");
            }
            this.calculatedType = sb.toString();
        }
        return this.calculatedType;
    }

    private Set<String> getTypesBeforeDash() {
        LinkedHashSet<String> types = Sets.newLinkedHashSet();
        for (Supertype st : this.supertypes) {
            types.add(st.name());
        }
        for (CoreType ct : this.coreTypes) {
            types.add(ct.name());
        }
        return types;
    }

    @Override
    public CardTypeView getTypeWithChanges(Iterable<CardChangedType> changedCardTypes) {
        CardType newType = null;
        if (Iterables.isEmpty(changedCardTypes)) {
            return this;
        }
        for (CardChangedType ct : changedCardTypes) {
            if (null == newType) {
                newType = new CardType(this);
            }
            if (ct.isRemoveCardTypes()) {
                newType.coreTypes.retainAll(CoreType.spellTypes);
            }
            if (ct.isRemoveSuperTypes()) {
                newType.supertypes.clear();
            }
            if (ct.isRemoveSubTypes()) {
                newType.subtypes.clear();
            } else if (!newType.subtypes.isEmpty()) {
                if (ct.isRemoveLandTypes()) {
                    Iterables.removeIf(newType.subtypes, Predicates.IS_LAND_TYPE);
                }
                if (ct.isRemoveCreatureTypes()) {
                    Iterables.removeIf(newType.subtypes, Predicates.IS_CREATURE_TYPE);
                    newType.allCreatureTypes = false;
                }
                if (ct.isRemoveArtifactTypes()) {
                    Iterables.removeIf(newType.subtypes, Predicates.IS_ARTIFACT_TYPE);
                }
                if (ct.isRemoveEnchantmentTypes()) {
                    Iterables.removeIf(newType.subtypes, Predicates.IS_ENCHANTMENT_TYPE);
                }
            }
            if (ct.getRemoveType() != null) {
                newType.removeAll(ct.getRemoveType());
            }
            if (ct.getAddType() != null) {
                newType.addAll(ct.getAddType());
                if (ct.getAddType().hasAllCreatureTypes()) {
                    newType.allCreatureTypes = true;
                }
            }
            if (ct.isAddAllCreatureTypes()) {
                newType.allCreatureTypes = true;
            }
            if (ct.getRemoveType() == null || !newType.allCreatureTypes) continue;
            newType.excludedCreatureSubtypes.addAll(Lists.newArrayList(Iterables.filter(ct.getRemoveType(), Predicates.IS_CREATURE_TYPE)));
        }
        if (newType != null && !newType.subtypes.isEmpty()) {
            newType.sanisfySubtypes();
        }
        return newType == null ? this : newType;
    }

    public void sanisfySubtypes() {
        if (this.incomplete) {
            return;
        }
        if (!this.isCreature() && !this.isKindred()) {
            this.allCreatureTypes = false;
        }
        if (this.subtypes.isEmpty()) {
            return;
        }
        if (!this.isCreature() && !this.isKindred()) {
            Iterables.removeIf(this.subtypes, Predicates.IS_CREATURE_TYPE);
        }
        if (!this.isLand()) {
            Iterables.removeIf(this.subtypes, Predicates.IS_LAND_TYPE);
        }
        if (!this.isArtifact()) {
            Iterables.removeIf(this.subtypes, Predicates.IS_ARTIFACT_TYPE);
        }
        if (!this.isEnchantment()) {
            Iterables.removeIf(this.subtypes, Predicates.IS_ENCHANTMENT_TYPE);
        }
        if (!this.isInstant() && !this.isSorcery()) {
            Iterables.removeIf(this.subtypes, Predicates.IS_SPELL_TYPE);
        }
        if (!this.isPlaneswalker()) {
            Iterables.removeIf(this.subtypes, Predicates.IS_WALKER_TYPE);
        }
        if (!this.isDungeon()) {
            Iterables.removeIf(this.subtypes, Predicates.IS_DUNGEON_TYPE);
        }
        if (!this.isBattle()) {
            Iterables.removeIf(this.subtypes, Predicates.IS_BATTLE_TYPE);
        }
        if (!this.isPlane()) {
            Iterables.removeIf(this.subtypes, Predicates.IS_PLANAR_TYPE);
        }
    }

    @Override
    public Iterator<String> iterator() {
        final Iterator<CoreType> coreTypeIterator = this.coreTypes.iterator();
        final Iterator<Supertype> supertypeIterator = this.supertypes.iterator();
        final Iterator<String> subtypeIterator = this.subtypes.iterator();
        return new Iterator<String>(){

            @Override
            public boolean hasNext() {
                return coreTypeIterator.hasNext() || supertypeIterator.hasNext() || subtypeIterator.hasNext();
            }

            @Override
            public String next() {
                if (coreTypeIterator.hasNext()) {
                    return ((CoreType)((Object)coreTypeIterator.next())).name();
                }
                if (supertypeIterator.hasNext()) {
                    return ((Supertype)((Object)supertypeIterator.next())).name();
                }
                return (String)subtypeIterator.next();
            }

            @Override
            public void remove() {
                throw new NotImplementedException("Removing this way not supported");
            }
        };
    }

    @Override
    public int compareTo(CardType o) {
        return this.toString().compareTo(o.toString());
    }

    @Override
    public boolean sharesCreaturetypeWith(CardTypeView ctOther) {
        if (ctOther == null) {
            return false;
        }
        if (!this.isCreature() && !this.isKindred()) {
            return false;
        }
        if (!ctOther.isCreature() && !ctOther.isKindred()) {
            return false;
        }
        if (this.allCreatureTypes && ctOther.hasAllCreatureTypes() && this.excludedCreatureSubtypes.isEmpty() && Iterables.isEmpty(ctOther.getExcludedCreatureSubTypes())) {
            return true;
        }
        for (String type : this.getCreatureTypes()) {
            if (!ctOther.hasCreatureType(type)) continue;
            return true;
        }
        for (String type : ctOther.getCreatureTypes()) {
            if (!this.hasCreatureType(type)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean sharesLandTypeWith(CardTypeView ctOther) {
        if (ctOther == null) {
            return false;
        }
        for (String type : this.getLandTypes()) {
            if (!ctOther.hasSubtype(type)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean sharesPermanentTypeWith(CardTypeView ctOther) {
        if (ctOther == null) {
            return false;
        }
        for (CoreType type : this.getCoreTypes()) {
            if (!type.isPermanent || !ctOther.hasType(type)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean sharesCardTypeWith(CardTypeView ctOther) {
        if (ctOther == null) {
            return false;
        }
        for (CoreType type : this.getCoreTypes()) {
            if (!ctOther.hasType(type)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean sharesAllCardTypesWith(CardTypeView ctOther) {
        if (ctOther == null) {
            return false;
        }
        for (CoreType type : this.getCoreTypes()) {
            if (ctOther.hasType(type)) continue;
            return false;
        }
        for (CoreType type : ctOther.getCoreTypes()) {
            if (this.hasType(type)) continue;
            return false;
        }
        return true;
    }

    public boolean sharesSubtypeWith(CardTypeView ctOther) {
        if (ctOther == null) {
            return false;
        }
        if (this.sharesCreaturetypeWith(ctOther)) {
            return true;
        }
        for (String t2 : ctOther.getSubtypes()) {
            if (!this.hasSubtype(t2)) continue;
            return true;
        }
        return false;
    }

    public GamePieceType getGamePieceType() {
        if (this.isAttraction()) {
            return GamePieceType.ATTRACTION;
        }
        for (CoreType type : this.coreTypes) {
            GamePieceType r = type.toGamePieceType();
            if (r == GamePieceType.CARD) continue;
            return r;
        }
        return GamePieceType.CARD;
    }

    public static CardType parse(String typeText, boolean incomplete) {
        boolean hasMoreTypes;
        int space = 32;
        CardType result = new CardType(incomplete);
        int iTypeStart = 0;
        int max = typeText.length();
        boolean bl = hasMoreTypes = max > 0;
        while (hasMoreTypes) {
            String rest = typeText.substring(iTypeStart);
            String type = CardType.getMultiwordType(rest);
            if (type == null) {
                int iSpace = typeText.indexOf(32, iTypeStart);
                type = typeText.substring(iTypeStart, iSpace == -1 ? max : iSpace);
            }
            result.add(type);
            hasMoreTypes = (iTypeStart += type.length() + 1) < max;
        }
        return result;
    }

    public static CardType combine(CardType a, CardType b) {
        CardType result = new CardType(false);
        result.supertypes.addAll(a.supertypes);
        result.supertypes.addAll(b.supertypes);
        result.coreTypes.addAll(a.coreTypes);
        result.coreTypes.addAll(b.coreTypes);
        result.subtypes.addAll(a.subtypes);
        result.subtypes.addAll(b.subtypes);
        return result;
    }

    private static String getMultiwordType(String type) {
        for (String multi : Constant.MultiwordTypes) {
            if (!type.startsWith(multi)) continue;
            return multi;
        }
        return null;
    }

    public static boolean isACardType(String cardType) {
        return CoreType.isValidEnum(cardType);
    }

    public static Set<String> getAllCardTypes() {
        return CoreType.allCoreTypeNames;
    }

    public static List<String> getCombinedSuperAndCoreTypes() {
        if (combinedSuperAndCoreTypes == null) {
            combinedSuperAndCoreTypes = Lists.newArrayList();
            combinedSuperAndCoreTypes.addAll(Supertype.allSuperTypeNames);
            combinedSuperAndCoreTypes.addAll(CoreType.allCoreTypeNames);
        }
        return combinedSuperAndCoreTypes;
    }

    public static List<String> getSortedSubTypes() {
        if (sortedSubTypes == null) {
            sortedSubTypes = Lists.newArrayList();
            sortedSubTypes.addAll(Constant.BASIC_TYPES);
            sortedSubTypes.addAll(Constant.LAND_TYPES);
            sortedSubTypes.addAll(Constant.CREATURE_TYPES);
            sortedSubTypes.addAll(Constant.SPELL_TYPES);
            sortedSubTypes.addAll(Constant.ENCHANTMENT_TYPES);
            sortedSubTypes.addAll(Constant.ARTIFACT_TYPES);
            sortedSubTypes.addAll(Constant.WALKER_TYPES);
            sortedSubTypes.addAll(Constant.DUNGEON_TYPES);
            sortedSubTypes.addAll(Constant.BATTLE_TYPES);
            sortedSubTypes.addAll(Constant.PLANAR_TYPES);
            Collections.sort(sortedSubTypes);
        }
        return sortedSubTypes;
    }

    public static Collection<String> getBasicTypes() {
        return Collections.unmodifiableCollection(Constant.BASIC_TYPES);
    }

    public static Collection<String> getNonBasicTypes() {
        return Collections.unmodifiableCollection(Constant.LAND_TYPES);
    }

    public static Collection<String> getAllCreatureTypes() {
        return Collections.unmodifiableCollection(Constant.CREATURE_TYPES);
    }

    public static Collection<String> getAllWalkerTypes() {
        return Collections.unmodifiableCollection(Constant.WALKER_TYPES);
    }

    public static List<String> getAllLandTypes() {
        return ((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(CardType.getBasicTypes())).addAll(Constant.LAND_TYPES)).build();
    }

    public static boolean isASupertype(String cardType) {
        return Supertype.isValidEnum(cardType);
    }

    public static boolean isASubType(String cardType) {
        return CardType.getSortedSubTypes().contains(cardType);
    }

    public static boolean isAnArtifactType(String cardType) {
        return Constant.ARTIFACT_TYPES.contains(cardType);
    }

    public static boolean isACreatureType(String cardType) {
        return Constant.CREATURE_TYPES.contains(cardType);
    }

    public static boolean isALandType(String cardType) {
        return Constant.LAND_TYPES.contains(cardType) || CardType.isABasicLandType(cardType);
    }

    public static boolean isAPlaneswalkerType(String cardType) {
        return Constant.WALKER_TYPES.contains(cardType);
    }

    public static boolean isABasicLandType(String cardType) {
        return Constant.BASIC_TYPES.contains(cardType);
    }

    public static boolean isAnEnchantmentType(String cardType) {
        return Constant.ENCHANTMENT_TYPES.contains(cardType);
    }

    public static boolean isASpellType(String cardType) {
        return Constant.SPELL_TYPES.contains(cardType);
    }

    public static boolean isADungeonType(String cardType) {
        return Constant.DUNGEON_TYPES.contains(cardType);
    }

    public static boolean isABattleType(String cardType) {
        return Constant.BATTLE_TYPES.contains(cardType);
    }

    public static boolean isAPlanarType(String cardType) {
        return Constant.PLANAR_TYPES.contains(cardType);
    }

    public static String getSingularType(String type) {
        if (Constant.singularTypes.containsKey(type)) {
            return (String)Constant.singularTypes.get(type);
        }
        return type;
    }

    public static String getPluralType(String type) {
        if (Constant.pluralTypes.containsKey(type)) {
            return (String)Constant.pluralTypes.get(type);
        }
        return type;
    }

    public static class Predicates {
        public static Predicate<String> IS_LAND_TYPE = CardType::isALandType;
        public static Predicate<String> IS_BASIC_LAND_TYPE = CardType::isABasicLandType;
        public static Predicate<String> IS_ARTIFACT_TYPE = CardType::isAnArtifactType;
        public static Predicate<String> IS_CREATURE_TYPE = CardType::isACreatureType;
        public static Predicate<String> IS_ENCHANTMENT_TYPE = CardType::isAnEnchantmentType;
        public static Predicate<String> IS_SPELL_TYPE = CardType::isASpellType;
        public static Predicate<String> IS_WALKER_TYPE = CardType::isAPlaneswalkerType;
        public static Predicate<String> IS_DUNGEON_TYPE = CardType::isADungeonType;
        public static Predicate<String> IS_BATTLE_TYPE = CardType::isABattleType;
        public static Predicate<String> IS_PLANAR_TYPE = CardType::isAPlanarType;
    }

    public static class Constant {
        public static final Settable LOADED = new Settable();
        public static final Set<String> BASIC_TYPES = Sets.newHashSet();
        public static final Set<String> LAND_TYPES = Sets.newHashSet();
        public static final Set<String> CREATURE_TYPES = Sets.newHashSet();
        public static final Set<String> SPELL_TYPES = Sets.newHashSet();
        public static final Set<String> ENCHANTMENT_TYPES = Sets.newHashSet();
        public static final Set<String> ARTIFACT_TYPES = Sets.newHashSet();
        public static final Set<String> WALKER_TYPES = Sets.newHashSet();
        public static final Set<String> DUNGEON_TYPES = Sets.newHashSet();
        public static final Set<String> BATTLE_TYPES = Sets.newHashSet();
        public static final Set<String> PLANAR_TYPES = Sets.newHashSet();
        public static final Set<String> MultiwordTypes = Sets.newHashSet();
        public static final BiMap<String, String> pluralTypes = HashBiMap.create();
        public static final BiMap<String, String> singularTypes = pluralTypes.inverse();
        public static final Set<String> OUTLAW_TYPES;

        static {
            for (CoreType c : CoreType.values()) {
                pluralTypes.put(c.name(), c.pluralName);
            }
            OUTLAW_TYPES = Sets.newHashSet("Assassin", "Mercenary", "Pirate", "Rogue", "Warlock");
        }
    }

    public static enum Supertype {
        Basic,
        Elite,
        Host,
        Legendary,
        Snow,
        Ongoing,
        World;

        private static Map<String, Supertype> stringToSupertype;
        private static final Set<String> allSuperTypeNames;

        public static Supertype getEnum(String name) {
            return stringToSupertype.get(name);
        }

        public static boolean isValidEnum(String name) {
            return stringToSupertype.containsKey(name);
        }

        static {
            stringToSupertype = EnumUtils.getEnumMap(Supertype.class);
            allSuperTypeNames = stringToSupertype.keySet();
        }
    }

    public static enum CoreType {
        Kindred(false, "kindreds"),
        Artifact(true, "artifacts"),
        Battle(true, "battles"),
        Conspiracy(false, "conspiracies"),
        Enchantment(true, "enchantments"),
        Creature(true, "creatures"),
        Dungeon(false, "dungeons"),
        Instant(false, "instants"),
        Land(true, "lands"),
        Phenomenon(false, "phenomenons"),
        Plane(false, "planes"),
        Planeswalker(true, "planeswalkers"),
        Scheme(false, "schemes"),
        Sorcery(false, "sorceries"),
        Vanguard(false, "vanguards");

        public final boolean isPermanent;
        public final String pluralName;
        private static Map<String, CoreType> stringToCoreType;
        private static final Set<String> allCoreTypeNames;
        public static final Set<CoreType> spellTypes;

        public static CoreType getEnum(String name) {
            return stringToCoreType.get(name);
        }

        public static boolean isValidEnum(String name) {
            return stringToCoreType.containsKey(name);
        }

        private CoreType(boolean permanent, String plural) {
            this.isPermanent = permanent;
            this.pluralName = plural;
        }

        public GamePieceType toGamePieceType() {
            switch (this) {
                case Plane: 
                case Phenomenon: {
                    return GamePieceType.PLANAR;
                }
                case Scheme: {
                    return GamePieceType.SCHEME;
                }
                case Dungeon: {
                    return GamePieceType.DUNGEON;
                }
                case Vanguard: {
                    return GamePieceType.AVATAR;
                }
            }
            return GamePieceType.CARD;
        }

        static {
            stringToCoreType = EnumUtils.getEnumMap(CoreType.class);
            allCoreTypeNames = stringToCoreType.keySet();
            spellTypes = ImmutableSet.of(Instant, Sorcery);
        }
    }
}

