/*
 * Decompiled with CFR 0.152.
 */
package forge.card;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import forge.card.CardAiHints;
import forge.card.CardFace;
import forge.card.CardSplitType;
import forge.card.CardStateName;
import forge.card.CardType;
import forge.card.ColorSet;
import forge.card.DeckHints;
import forge.card.ICardCharacteristics;
import forge.card.ICardFace;
import forge.card.MagicColor;
import forge.card.mana.IParserManaCost;
import forge.card.mana.ManaCost;
import forge.card.mana.ManaCostShard;
import forge.util.TextUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.commons.lang3.StringUtils;

public final class CardRules
implements ICardCharacteristics {
    private String normalizedName;
    private CardSplitType splitType;
    private ICardFace mainPart;
    private ICardFace otherPart;
    private Map<CardStateName, ICardFace> specializedParts = Maps.newHashMap();
    private CardAiHints aiHints;
    private ColorSet colorIdentity;
    private ColorSet deckbuildingColors;
    private String meldWith;
    private String partnerWith;
    private boolean addsWildCardColor;
    private boolean custom;
    private int deltaHand;
    private int deltaLife;
    private List<String> tokens = Collections.emptyList();
    private Set<String> supportedFunctionalVariants;

    public CardRules(ICardFace[] faces, CardSplitType altMode, CardAiHints cah) {
        this.splitType = altMode;
        this.mainPart = faces[0];
        this.otherPart = faces[1];
        if (CardSplitType.Specialize.equals((Object)this.splitType)) {
            this.specializedParts.put(CardStateName.SpecializeW, faces[2]);
            this.specializedParts.put(CardStateName.SpecializeU, faces[3]);
            this.specializedParts.put(CardStateName.SpecializeB, faces[4]);
            this.specializedParts.put(CardStateName.SpecializeR, faces[5]);
            this.specializedParts.put(CardStateName.SpecializeG, faces[6]);
        }
        this.aiHints = cah;
        this.meldWith = "";
        this.partnerWith = "";
        this.addsWildCardColor = false;
        byte colMask = CardRules.calculateColorIdentity(this.mainPart);
        if (this.otherPart != null) {
            colMask = (byte)(colMask | CardRules.calculateColorIdentity(this.otherPart));
        }
        this.colorIdentity = ColorSet.fromMask(colMask);
    }

    void reinitializeFromRules(CardRules newRules) {
        if (!newRules.getName().equals(this.getName())) {
            throw new UnsupportedOperationException("You cannot rename the card using the same CardRules object");
        }
        this.splitType = newRules.splitType;
        this.mainPart = newRules.mainPart;
        this.otherPart = newRules.otherPart;
        this.specializedParts = Maps.newHashMap(newRules.specializedParts);
        this.aiHints = newRules.aiHints;
        this.colorIdentity = newRules.colorIdentity;
        this.meldWith = newRules.meldWith;
        this.partnerWith = newRules.partnerWith;
        this.addsWildCardColor = newRules.addsWildCardColor;
        this.tokens = newRules.tokens;
    }

    private static byte calculateColorIdentity(ICardFace face) {
        byte res = face.getColor().getColor();
        boolean isReminder = false;
        boolean isSymbol = false;
        String oracleText = face.getOracleText();
        for (String staticAbility : face.getStaticAbilities()) {
            if (!staticAbility.contains("CharacteristicDefining$ True") || !staticAbility.contains("SetColor$ All")) continue;
            res = (byte)(res | 0x1F);
        }
        int len = oracleText.length();
        block14: for (int i = 0; i < len; ++i) {
            char c = oracleText.charAt(i);
            switch (c) {
                case '(': {
                    isReminder = i > 0;
                    continue block14;
                }
                case ')': {
                    isReminder = false;
                    continue block14;
                }
                case '{': {
                    isSymbol = true;
                    continue block14;
                }
                case '}': {
                    isSymbol = false;
                    continue block14;
                }
                default: {
                    if (!isSymbol || isReminder) continue block14;
                    switch (c) {
                        case 'W': {
                            res = (byte)(res | 1);
                            continue block14;
                        }
                        case 'U': {
                            res = (byte)(res | 2);
                            continue block14;
                        }
                        case 'B': {
                            res = (byte)(res | 4);
                            continue block14;
                        }
                        case 'R': {
                            res = (byte)(res | 8);
                            continue block14;
                        }
                        case 'G': {
                            res = (byte)(res | 0x10);
                        }
                    }
                }
            }
        }
        return res;
    }

    public boolean isVariant() {
        CardType t2 = this.getType();
        return t2.isVanguard() || t2.isScheme() || t2.isPlane() || t2.isPhenomenon() || t2.isConspiracy() || t2.isDungeon() || t2.isAttraction();
    }

    public CardSplitType getSplitType() {
        return this.splitType;
    }

    public ICardFace getMainPart() {
        return this.mainPart;
    }

    public ICardFace getOtherPart() {
        return this.otherPart;
    }

    public Map<CardStateName, ICardFace> getSpecializeParts() {
        return this.specializedParts;
    }

    public Iterable<ICardFace> getAllFaces() {
        return Iterables.concat(Arrays.asList(this.mainPart, this.otherPart), this.specializedParts.values());
    }

    public ICardFace getWSpecialize() {
        return this.specializedParts.get((Object)CardStateName.SpecializeW);
    }

    public ICardFace getUSpecialize() {
        return this.specializedParts.get((Object)CardStateName.SpecializeU);
    }

    public ICardFace getBSpecialize() {
        return this.specializedParts.get((Object)CardStateName.SpecializeB);
    }

    public ICardFace getRSpecialize() {
        return this.specializedParts.get((Object)CardStateName.SpecializeR);
    }

    public ICardFace getGSpecialize() {
        return this.specializedParts.get((Object)CardStateName.SpecializeG);
    }

    @Override
    public String getName() {
        switch (this.splitType.getAggregationMethod()) {
            case COMBINE: {
                return this.mainPart.getName() + " // " + this.otherPart.getName();
            }
        }
        return this.mainPart.getName();
    }

    public String getNormalizedName() {
        return this.normalizedName;
    }

    public void setNormalizedName(String filename) {
        this.normalizedName = filename;
    }

    public CardAiHints getAiHints() {
        return this.aiHints;
    }

    public boolean isCustom() {
        return this.custom;
    }

    public void setCustom() {
        this.custom = true;
    }

    @Override
    public CardType getType() {
        switch (this.splitType.getAggregationMethod()) {
            case COMBINE: {
                return CardType.combine(this.mainPart.getType(), this.otherPart.getType());
            }
        }
        return this.mainPart.getType();
    }

    @Override
    public ManaCost getManaCost() {
        switch (this.splitType.getAggregationMethod()) {
            case COMBINE: {
                return ManaCost.combine(this.mainPart.getManaCost(), this.otherPart.getManaCost());
            }
        }
        return this.mainPart.getManaCost();
    }

    @Override
    public ColorSet getColor() {
        switch (this.splitType.getAggregationMethod()) {
            case COMBINE: {
                return ColorSet.fromMask(this.mainPart.getColor().getColor() | this.otherPart.getColor().getColor());
            }
        }
        return this.mainPart.getColor();
    }

    private static boolean canCastFace(ICardFace face, byte colorCode) {
        if (face.getManaCost().isNoCost()) {
            return face.getColor().hasNoColorsExcept(colorCode);
        }
        return face.getManaCost().canBePaidWithAvailable(colorCode);
    }

    public boolean canCastWithAvailable(byte colorCode) {
        switch (this.splitType.getAggregationMethod()) {
            case COMBINE: {
                return CardRules.canCastFace(this.mainPart, colorCode) || CardRules.canCastFace(this.otherPart, colorCode);
            }
        }
        return CardRules.canCastFace(this.mainPart, colorCode);
    }

    @Override
    public int getIntPower() {
        return this.mainPart.getIntPower();
    }

    @Override
    public int getIntToughness() {
        return this.mainPart.getIntToughness();
    }

    @Override
    public String getPower() {
        return this.mainPart.getPower();
    }

    @Override
    public String getToughness() {
        return this.mainPart.getToughness();
    }

    @Override
    public String getInitialLoyalty() {
        return this.mainPart.getInitialLoyalty();
    }

    @Override
    public String getDefense() {
        return this.mainPart.getDefense();
    }

    @Override
    public Set<Integer> getAttractionLights() {
        return this.mainPart.getAttractionLights();
    }

    @Override
    public String getOracleText() {
        switch (this.splitType.getAggregationMethod()) {
            case COMBINE: {
                return this.mainPart.getOracleText() + "\r\n\r\n" + this.otherPart.getOracleText();
            }
        }
        return this.mainPart.getOracleText();
    }

    public boolean isEnterableDungeon() {
        if (this.mainPart.getOracleText().contains("You can't enter this dungeon unless")) {
            return false;
        }
        return this.getType().isDungeon();
    }

    public boolean canBeCommander() {
        if (this.mainPart.getOracleText().contains(" is your commander, choose a color before the game begins.")) {
            this.addsWildCardColor = true;
        }
        if (this.mainPart.getOracleText().contains("can be your commander") || this.canBeBackground()) {
            return true;
        }
        CardType type = this.mainPart.getType();
        boolean creature = type.isCreature();
        for (String staticAbility : this.mainPart.getStaticAbilities()) {
            if (!staticAbility.contains("CharacteristicDefining$ True") || !staticAbility.contains("AddType$ Creature")) continue;
            creature = true;
            break;
        }
        return type.isLegendary() && creature;
    }

    public boolean canBePartnerCommanders(CardRules b) {
        if (!this.canBePartnerCommander() || !b.canBePartnerCommander()) {
            return false;
        }
        boolean legal = false;
        if (this.hasKeyword("Partner") && b.hasKeyword("Partner")) {
            legal = true;
        }
        if (this.getName().equals(b.getPartnerWith()) && b.getName().equals(this.getPartnerWith())) {
            legal = true;
        }
        if (this.hasKeyword("Friends forever") && b.hasKeyword("Friends forever")) {
            legal = true;
        }
        if (this.hasKeyword("Choose a Background") && b.canBeBackground() || b.hasKeyword("Choose a Background") && this.canBeBackground()) {
            legal = true;
        }
        if (this.isDoctor() && b.hasKeyword("Doctor's companion") || this.hasKeyword("Doctor's companion") && b.isDoctor()) {
            legal = true;
        }
        return legal;
    }

    public boolean canBePartnerCommander() {
        if (this.canBeBackground()) {
            return true;
        }
        return this.canBeCommander() && (this.hasKeyword("Partner") || !this.partnerWith.isEmpty() || this.hasKeyword("Friends forever") || this.hasKeyword("Choose a Background") || this.hasKeyword("Doctor's companion") || this.isDoctor());
    }

    public boolean canBeBackground() {
        return this.mainPart.getType().hasSubtype("Background");
    }

    public boolean isDoctor() {
        for (String type : this.mainPart.getType().getSubtypes()) {
            if (type.equals("Time Lord") || type.equals("Doctor")) continue;
            return false;
        }
        return true;
    }

    public boolean canBeOathbreaker() {
        CardType type = this.mainPart.getType();
        return type.isPlaneswalker();
    }

    public boolean canBeSignatureSpell() {
        CardType type = this.mainPart.getType();
        return type.isInstant() || type.isSorcery();
    }

    public boolean canBeBrawlCommander() {
        CardType type = this.mainPart.getType();
        if (!type.isLegendary()) {
            return false;
        }
        if (type.isCreature() || type.isPlaneswalker()) {
            return true;
        }
        for (String staticAbility : this.mainPart.getStaticAbilities()) {
            if (!staticAbility.contains("CharacteristicDefining$ True") || !staticAbility.contains("AddType$ Creature")) continue;
            return true;
        }
        return false;
    }

    public boolean canBeTinyLeadersCommander() {
        CardType type = this.mainPart.getType();
        if (!type.isLegendary()) {
            return false;
        }
        if (type.isCreature() || type.isPlaneswalker()) {
            return true;
        }
        for (String staticAbility : this.mainPart.getStaticAbilities()) {
            if (!staticAbility.contains("CharacteristicDefining$ True") || !staticAbility.contains("AddType$ Creature")) continue;
            return true;
        }
        return false;
    }

    public String getMeldWith() {
        return this.meldWith;
    }

    public String getPartnerWith() {
        return this.partnerWith;
    }

    public boolean getAddsWildCardColor() {
        return this.addsWildCardColor;
    }

    public List<String> getTokens() {
        return this.tokens;
    }

    public int getHand() {
        return this.deltaHand;
    }

    public int getLife() {
        return this.deltaLife;
    }

    public void setVanguardProperties(String pt) {
        int slashPos;
        int n = slashPos = pt == null ? -1 : pt.indexOf(47);
        if (slashPos == -1) {
            throw new RuntimeException("Vanguard '" + this.getName() + "' has bad hand/life stats");
        }
        this.deltaHand = Integer.parseInt(TextUtil.fastReplace(pt.substring(0, slashPos), "+", ""));
        this.deltaLife = Integer.parseInt(TextUtil.fastReplace(pt.substring(slashPos + 1), "+", ""));
    }

    public boolean hasFunctionalVariants() {
        return this.supportedFunctionalVariants != null;
    }

    public Set<String> getSupportedFunctionalVariants() {
        return this.supportedFunctionalVariants;
    }

    public ColorSet getColorIdentity() {
        return this.colorIdentity;
    }

    public static CardRules fromScript(Iterable<String> script) {
        Reader crr = new Reader();
        for (String line : script) {
            crr.parseLine(line);
        }
        return crr.getCard();
    }

    public static CardRules getUnsupportedCardNamed(String name) {
        CardAiHints cah = new CardAiHints(true, true, true, null, null, null);
        ICardFace[] faces = new CardFace[]{new CardFace(name), null, null, null, null, null, null};
        faces[0].setColor(ColorSet.fromMask(0));
        faces[0].setType(CardType.parse("", false));
        faces[0].setOracleText("This card is not supported by Forge. Whenever you start a game with this card, it will be bugged.");
        faces[0].setNonAbilityText("This card is not supported by Forge.\nWhenever you start a game with this card, it will be bugged.");
        faces[0].assignMissingFields();
        CardRules result = new CardRules(faces, CardSplitType.None, cah);
        return result;
    }

    public boolean hasKeyword(String k) {
        return Iterables.contains(this.mainPart.getKeywords(), k);
    }

    public boolean hasStartOfKeyword(String k) {
        return this.hasStartOfKeyword(k, this.mainPart);
    }

    public boolean hasStartOfKeyword(String k, ICardFace cf) {
        for (String inst : cf.getKeywords()) {
            String[] parts = inst.split(":");
            if (!parts[0].equals(k)) continue;
            return true;
        }
        return false;
    }

    public Integer getKeywordMagnitude(String k) {
        for (String inst : this.mainPart.getKeywords()) {
            String[] parts = inst.split(":");
            if (!parts[0].equals(k) || !StringUtils.isNumeric(parts[1])) continue;
            return Integer.valueOf(parts[1]);
        }
        return null;
    }

    public ColorSet getDeckbuildingColors() {
        if (this.deckbuildingColors == null) {
            byte colors = 0;
            if (this.mainPart.getType().isLand()) {
                colors = this.getColorIdentity().getColor();
                for (int i = 0; i < 5; ++i) {
                    if (!StringUtils.containsIgnoreCase(this.mainPart.getOracleText(), (CharSequence)MagicColor.Constant.BASIC_LANDS.get(i))) continue;
                    colors = (byte)(colors | 1 << i);
                }
            } else {
                colors = this.getColor().getColor();
                if (this.getOtherPart() != null) {
                    colors = (byte)(colors | this.getOtherPart().getManaCost().getColorProfile());
                }
            }
            this.deckbuildingColors = ColorSet.fromMask(colors);
        }
        return this.deckbuildingColors;
    }

    public static class Reader {
        private CardFace[] faces = new CardFace[]{null, null, null, null, null, null, null};
        private int curFace = 0;
        private CardSplitType altMode = CardSplitType.None;
        private String meldWith = "";
        private String partnerWith = "";
        private boolean addsWildCardColor = false;
        private String handLife = null;
        private String normalizedName = "";
        private Set<String> supportedFunctionalVariants = null;
        private List<String> tokens = Lists.newArrayList();
        private boolean removedFromAIDecks = false;
        private boolean removedFromRandomDecks = false;
        private boolean removedFromNonCommanderDecks = false;
        private DeckHints hints = null;
        private DeckHints needs = null;
        private DeckHints has = null;

        public final void reset() {
            this.curFace = 0;
            this.faces[0] = null;
            this.faces[1] = null;
            this.faces[2] = null;
            this.faces[3] = null;
            this.faces[4] = null;
            this.faces[5] = null;
            this.faces[6] = null;
            this.handLife = null;
            this.altMode = CardSplitType.None;
            this.removedFromAIDecks = false;
            this.removedFromRandomDecks = false;
            this.removedFromNonCommanderDecks = false;
            this.needs = null;
            this.hints = null;
            this.has = null;
            this.meldWith = "";
            this.partnerWith = "";
            this.addsWildCardColor = false;
            this.normalizedName = "";
            this.supportedFunctionalVariants = null;
            this.tokens = Lists.newArrayList();
        }

        public final CardRules getCard() {
            CardAiHints cah = new CardAiHints(this.removedFromAIDecks, this.removedFromRandomDecks, this.removedFromNonCommanderDecks, this.hints, this.needs, this.has);
            this.faces[0].assignMissingFields();
            if (null != this.faces[1]) {
                this.faces[1].assignMissingFields();
            }
            if (null != this.faces[2]) {
                this.faces[2].assignMissingFields();
            }
            if (null != this.faces[3]) {
                this.faces[3].assignMissingFields();
            }
            if (null != this.faces[4]) {
                this.faces[4].assignMissingFields();
            }
            if (null != this.faces[5]) {
                this.faces[5].assignMissingFields();
            }
            if (null != this.faces[6]) {
                this.faces[6].assignMissingFields();
            }
            CardRules result = new CardRules(this.faces, this.altMode, cah);
            result.setNormalizedName(this.normalizedName);
            result.meldWith = this.meldWith;
            result.partnerWith = this.partnerWith;
            result.addsWildCardColor = this.addsWildCardColor;
            if (!this.tokens.isEmpty()) {
                result.tokens = this.tokens;
            }
            if (StringUtils.isNotBlank(this.handLife)) {
                result.setVanguardProperties(this.handLife);
            }
            result.supportedFunctionalVariants = this.supportedFunctionalVariants;
            return result;
        }

        public final CardRules readCard(Iterable<String> script, String filename) {
            this.reset();
            for (String line : script) {
                if (line.isEmpty() || line.charAt(0) == '#') continue;
                this.parseLine(line, this.faces[this.curFace]);
            }
            this.normalizedName = filename;
            return this.getCard();
        }

        public final CardRules readCard(Iterable<String> script) {
            return this.readCard(script, null);
        }

        public final void parseLine(String line) {
            this.parseLine(line, this.faces[this.curFace]);
        }

        private void parseLine(String line, CardFace face) {
            int tokIdx;
            String value;
            int colonPos = line.indexOf(58);
            String key = colonPos > 0 ? line.substring(0, colonPos) : line;
            String string = value = colonPos > 0 ? line.substring(1 + colonPos).trim() : null;
            if (value != null && (tokIdx = value.indexOf("TokenScript$")) > 0) {
                String tokenParam = value.substring(tokIdx + 12).trim();
                int endIdx = tokenParam.indexOf("|");
                if (endIdx > 0) {
                    tokenParam = tokenParam.substring(0, endIdx).trim();
                }
                this.tokens.addAll(Arrays.asList(tokenParam.split(",")));
            }
            switch (key.charAt(0)) {
                case 'A': {
                    if ("A".equals(key)) {
                        face.addAbility(value);
                        break;
                    }
                    if ("AI".equals(key)) {
                        colonPos = value.indexOf(58);
                        String variable = colonPos > 0 ? value.substring(0, colonPos) : value;
                        String string2 = value = colonPos > 0 ? value.substring(1 + colonPos) : null;
                        if (!"RemoveDeck".equals(variable)) break;
                        this.removedFromAIDecks |= "All".equalsIgnoreCase(value);
                        this.removedFromRandomDecks |= "Random".equalsIgnoreCase(value);
                        this.removedFromNonCommanderDecks |= "NonCommander".equalsIgnoreCase(value);
                        break;
                    }
                    if ("AlternateMode".equals(key)) {
                        this.altMode = CardSplitType.smartValueOf(value);
                        break;
                    }
                    if ("ALTERNATE".equals(key)) {
                        this.curFace = 1;
                        break;
                    }
                    if (!"AltName".equals(key)) break;
                    face.setAltName(value);
                    break;
                }
                case 'C': {
                    if (!"Colors".equals(key)) break;
                    ColorSet newCol = ColorSet.fromNames(value.split(","));
                    face.setColor(newCol);
                    break;
                }
                case 'D': {
                    if ("DeckHints".equals(key)) {
                        this.hints = new DeckHints(value);
                        break;
                    }
                    if ("DeckNeeds".equals(key)) {
                        this.needs = new DeckHints(value);
                        break;
                    }
                    if ("DeckHas".equals(key)) {
                        this.has = new DeckHints(value);
                        break;
                    }
                    if ("Defense".equals(key)) {
                        face.setDefense(value);
                        break;
                    }
                    if (!"Draft".equals(key)) break;
                    face.addDraftAction(value);
                    break;
                }
                case 'H': {
                    if (!"HandLifeModifier".equals(key)) break;
                    this.handLife = value;
                    break;
                }
                case 'K': {
                    if (!"K".equals(key)) break;
                    face.addKeyword(value);
                    if (!value.startsWith("Partner:")) break;
                    this.partnerWith = value.split(":")[1];
                    break;
                }
                case 'L': {
                    if ("Loyalty".equals(key)) {
                        face.setInitialLoyalty(value);
                    }
                    if (!"Lights".equals(key)) break;
                    face.setAttractionLights(value);
                    break;
                }
                case 'M': {
                    if ("ManaCost".equals(key)) {
                        face.setManaCost("no cost".equals(value) ? ManaCost.NO_COST : new ManaCost(new ManaCostParser(value)));
                        break;
                    }
                    if (!"MeldPair".equals(key)) break;
                    this.meldWith = value;
                    break;
                }
                case 'N': {
                    if (!"Name".equals(key)) break;
                    this.faces[this.curFace] = new CardFace(value);
                    break;
                }
                case 'O': {
                    if (!"Oracle".equals(key)) break;
                    face.setOracleText(value);
                    break;
                }
                case 'P': {
                    if (!"PT".equals(key)) break;
                    face.setPtText(value);
                    break;
                }
                case 'R': {
                    if (!"R".equals(key)) break;
                    face.addReplacementEffect(value);
                    break;
                }
                case 'S': {
                    if ("S".equals(key)) {
                        face.addStaticAbility(value);
                        break;
                    }
                    if (key.startsWith("SPECIALIZE")) {
                        if (value.equals("WHITE")) {
                            this.curFace = 2;
                            break;
                        }
                        if (value.equals("BLUE")) {
                            this.curFace = 3;
                            break;
                        }
                        if (value.equals("BLACK")) {
                            this.curFace = 4;
                            break;
                        }
                        if (value.equals("RED")) {
                            this.curFace = 5;
                            break;
                        }
                        if (!value.equals("GREEN")) break;
                        this.curFace = 6;
                        break;
                    }
                    if (!"SVar".equals(key)) break;
                    if (null == value) {
                        throw new IllegalArgumentException("SVar has no variable name");
                    }
                    colonPos = value.indexOf(58);
                    String variable = colonPos > 0 ? value.substring(0, colonPos) : value;
                    value = colonPos > 0 ? value.substring(1 + colonPos) : null;
                    face.addSVar(variable, value);
                    break;
                }
                case 'T': {
                    if ("T".equals(key)) {
                        face.addTrigger(value);
                        break;
                    }
                    if ("Types".equals(key)) {
                        face.setType(CardType.parse(value, false));
                        break;
                    }
                    if (!"Text".equals(key) || "no text".equals(value) || !StringUtils.isNotBlank(value)) break;
                    face.setNonAbilityText(value);
                    break;
                }
                case 'V': {
                    if (!"Variant".equals(key)) break;
                    if (value == null) {
                        value = "";
                    }
                    if ((colonPos = value.indexOf(58)) <= 0) {
                        throw new IllegalArgumentException("Missing variant name");
                    }
                    String variantName = value.substring(0, colonPos);
                    CardFace varFace = face.getOrCreateFunctionalVariant(variantName);
                    String variantLine = value.substring(1 + colonPos);
                    this.parseLine(variantLine, varFace);
                    if (this.supportedFunctionalVariants == null) {
                        this.supportedFunctionalVariants = new HashSet<String>();
                    }
                    this.supportedFunctionalVariants.add(variantName);
                }
            }
        }

        private static class ManaCostParser
        implements IParserManaCost {
            private final StringTokenizer st;
            private int genericCost;

            public ManaCostParser(String cost) {
                this.st = new StringTokenizer(cost, " ");
                this.genericCost = 0;
            }

            @Override
            public final int getTotalGenericCost() {
                if (this.hasNext()) {
                    throw new RuntimeException("Generic cost should be obtained after iteration is complete");
                }
                return this.genericCost;
            }

            @Override
            public final boolean hasNext() {
                return this.st.hasMoreTokens();
            }

            @Override
            public final ManaCostShard next() {
                String unparsed = this.st.nextToken();
                if (StringUtils.isNumeric(unparsed)) {
                    this.genericCost += Integer.parseInt(unparsed);
                    return null;
                }
                return ManaCostShard.parseNonGeneric(unparsed);
            }

            @Override
            public void remove() {
            }
        }
    }
}

