/*
 * Decompiled with CFR 0.152.
 */
package forge.card;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.GlyphLayout;
import com.badlogic.gdx.graphics.g2d.PixmapPacker;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.graphics.g2d.freetype.FreeTypeFontGenerator;
import com.badlogic.gdx.graphics.glutils.PixmapTextureData;
import com.badlogic.gdx.utils.Array;
import forge.CachedCardImage;
import forge.Forge;
import forge.Graphics;
import forge.assets.FImage;
import forge.assets.FImageComplex;
import forge.assets.FRotatedImage;
import forge.assets.FSkin;
import forge.assets.FSkinColor;
import forge.assets.FSkinFont;
import forge.assets.FSkinImageInterface;
import forge.assets.FTextureRegionImage;
import forge.assets.ImageCache;
import forge.card.CardEdition;
import forge.card.CardFaceSymbols;
import forge.card.CardImageRenderer;
import forge.card.CardRarity;
import forge.card.CardSplitType;
import forge.card.CardType;
import forge.card.CardTypeView;
import forge.card.CardZoom;
import forge.card.mana.ManaCost;
import forge.game.card.CardView;
import forge.game.card.CounterType;
import forge.game.zone.ZoneType;
import forge.gui.FThreads;
import forge.gui.card.CardDetailUtil;
import forge.item.IPaperCard;
import forge.item.InventoryItem;
import forge.localinstance.properties.ForgeConstants;
import forge.localinstance.properties.ForgePreferences;
import forge.localinstance.skin.FSkinProp;
import forge.model.FModel;
import forge.screens.match.MatchController;
import forge.toolbox.FList;
import forge.util.CardTranslation;
import forge.util.FileUtil;
import forge.util.TextBounds;
import forge.util.Utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class CardRenderer {
    private static final FSkinFont NAME_FONT = FSkinFont.get(16);
    public static final float NAME_BOX_TINT = 0.2f;
    public static final float TEXT_BOX_TINT = 0.1f;
    public static final float PT_BOX_TINT = 0.2f;
    private static final float MANA_COST_PADDING = Utils.scale(3.0f);
    public static final float SET_BOX_MARGIN = Utils.scale(1.0f);
    public static final float MANA_SYMBOL_SIZE = CardRenderer.calcSymbolSize(FSkinProp.IMG_MANA_1);
    private static final float NAME_COST_THRESHOLD = Utils.scale(200.0f);
    private static final float BORDER_THICKNESS = Utils.scale(1.0f);
    public static final float PADDING_MULTIPLIER = 0.021f;
    public static final float CROP_MULTIPLIER = 0.96f;
    private static final Color counterBackgroundColor = new Color(0.0f, 0.0f, 0.0f, 0.9f);
    private static final Map<CounterType, Color> counterColorCache = new HashMap<CounterType, Color>();
    private static final GlyphLayout layout = new GlyphLayout();
    public static final float CARD_ART_RATIO = 1.302f;
    public static final float CARD_ART_HEIGHT_PERCENTAGE = 0.43f;
    private static List<String> classicModuleCardtoCrop;
    static float markersHeight;
    private static final int GL_BLEND = 3042;

    private static float calcSymbolSize(FSkinProp skinProp) {
        if (skinProp == null) {
            return 0.0f;
        }
        FSkinImageInterface image = FSkin.getImages().get((Object)skinProp);
        if (image == null) {
            return 0.0f;
        }
        return image.getNearestHQWidth(2.0f * (NAME_FONT.getCapHeight() - MANA_COST_PADDING));
    }

    private static Color fromDetailColor(CardDetailUtil.DetailColors detailColor) {
        return FSkinColor.fromRGB(detailColor.r, detailColor.g, detailColor.b);
    }

    public static Color getRarityColor(CardRarity rarity) {
        if (rarity == null) {
            return Color.CLEAR;
        }
        switch (rarity) {
            case Uncommon: {
                return CardRenderer.fromDetailColor(CardDetailUtil.DetailColors.UNCOMMON);
            }
            case Rare: {
                return CardRenderer.fromDetailColor(CardDetailUtil.DetailColors.RARE);
            }
            case MythicRare: {
                return CardRenderer.fromDetailColor(CardDetailUtil.DetailColors.MYTHIC);
            }
            case Special: {
                return CardRenderer.fromDetailColor(CardDetailUtil.DetailColors.SPECIAL);
            }
        }
        return CardRenderer.fromDetailColor(CardDetailUtil.DetailColors.COMMON);
    }

    public static boolean isModernFrame(IPaperCard c) {
        if (c == null) {
            return false;
        }
        CardEdition ed = FModel.getMagicDb().getEditions().get(c.getEdition());
        if (ed != null) {
            switch (ed.getCode()) {
                case "MED": 
                case "ME2": 
                case "ME3": 
                case "ME4": 
                case "TSB": {
                    return false;
                }
            }
            return ed.isModern();
        }
        return false;
    }

    public static boolean isModernFrame(CardView c) {
        if (c == null) {
            return false;
        }
        CardView.CardStateView state = c.getCurrentState();
        CardEdition ed = FModel.getMagicDb().getEditions().get(state.getSetCode());
        if (ed != null) {
            switch (ed.getCode()) {
                case "MED": 
                case "ME2": 
                case "ME3": 
                case "ME4": 
                case "TSB": {
                    return false;
                }
            }
            return ed.isModern();
        }
        return false;
    }

    public static float getCardListItemHeight(boolean compactMode) {
        if (compactMode) {
            return MANA_SYMBOL_SIZE + 2.0f * FList.PADDING;
        }
        return Math.round(MANA_SYMBOL_SIZE + FSkinFont.get(12).getLineHeight() + 3.0f * FList.PADDING + 1.0f);
    }

    public static void clearcardArtCache() {
        Forge.getAssets().cardArtCache().clear();
    }

    public static FImageComplex getCardArt(IPaperCard pc) {
        return CardRenderer.getCardArt(pc, false);
    }

    public static FImageComplex getCardArt(IPaperCard pc, boolean backFace) {
        if (pc == null) {
            return CardImageRenderer.forgeArt;
        }
        if (pc.getRules() == null) {
            return CardRenderer.getCardArt(pc.getImageKey(backFace), false, false, false, false, false, false, false, false, true, false);
        }
        CardType type = pc.getRules().getType();
        return CardRenderer.getCardArt(pc.getImageKey(backFace), pc.getRules().getSplitType() == CardSplitType.Split, type.isPlane() || type.isPhenomenon(), pc.getRules().getOracleText().contains("Aftermath"), type.hasSubtype("Saga"), type.hasSubtype("Class") || type.hasSubtype("Case"), type.isDungeon(), CardSplitType.Flip.equals((Object)pc.getRules().getSplitType()), type.isPlaneswalker(), CardRenderer.isModernFrame(pc), type.isBattle());
    }

    public static FImageComplex getCardArt(CardView card) {
        CardTypeView type = card.getCurrentState().getType();
        return CardRenderer.getCardArt(card.getCurrentState().getImageKey(), card.isSplitCard(), type.isPlane() || type.isPhenomenon(), card.getText().contains("Aftermath"), type.hasSubtype("Saga"), type.hasSubtype("Class") || type.hasSubtype("Case"), type.isDungeon(), card.isFlipCard(), type.isPlaneswalker(), CardRenderer.isModernFrame(card), type.isBattle());
    }

    /*
     * Enabled aggressive block sorting
     */
    public static FImageComplex getCardArt(String imageKey, boolean isSplitCard, boolean isHorizontalCard, boolean isAftermathCard, boolean isSaga, boolean isClass, boolean isDungeon, boolean isFlipCard, boolean isPlanesWalker, boolean isModernFrame, boolean isBattle) {
        Texture image;
        boolean isClassicModule;
        FImageComplex cardArt = Forge.getAssets().cardArtCache().get(imageKey);
        boolean bl = isClassicModule = imageKey != null && imageKey.length() > 2 && classicModuleCardtoCrop.contains(imageKey.substring("c:".length()).replace(".jpg", "").replace(".png", ""));
        if (cardArt == null && (image = new RendererCachedCardImage(imageKey, true).getImage()) != null) {
            if (image == ImageCache.getDefaultImage()) {
                cardArt = CardImageRenderer.forgeArt;
            } else {
                float y;
                float x;
                float w = image.getWidth();
                float h2 = image.getHeight();
                if (isClassicModule) {
                    x = w * 0.09f;
                    y = h2 * 0.2f;
                    w -= 2.0f * x;
                    h2 -= 3.0f * y;
                } else if (isPlanesWalker) {
                    x = w * 0.09f;
                    y = h2 * 0.11f;
                    w -= 2.0f * x;
                    h2 -= 5.71f * y;
                } else if (isFlipCard) {
                    x = w * 0.09f;
                    y = h2 * 0.32f;
                    w -= 2.0f * x;
                    h2 -= 2.1f * y;
                } else if (isDungeon) {
                    x = w * 0.09f;
                    y = h2 * 0.1f;
                    w -= 2.0f * x;
                    h2 -= 2.2f * y;
                } else if (isClass) {
                    x = w * 0.09f;
                    y = h2 * 0.11f;
                    w -= 1.1f * x + w / 2.0f;
                    h2 -= 2.45f * y;
                } else {
                    if (isBattle) {
                        float x2 = w * 0.14f;
                        float y2 = h2 * 0.1f;
                        w -= 0.5f * x2 + w / 2.0f;
                        cardArt = new FRotatedImage(image, Math.round(x2), Math.round(y2), Math.round(w), Math.round(h2 -= 2.35f * y2), true);
                        Forge.getAssets().cardArtCache().put(imageKey, cardArt);
                        return cardArt;
                    }
                    if (isSaga) {
                        x = w * 0.1f + w * 0.8f / 2.0f;
                        y = h2 * 0.11f;
                        w -= 1.16f * x;
                        h2 -= 2.45f * y;
                    } else if (isSplitCard && !isAftermathCard) {
                        x = w * 33.0f / 250.0f;
                        y = 0.0f;
                        w *= 0.424f;
                    } else if (isHorizontalCard) {
                        float artX = 40.0f;
                        float artY = 40.0f;
                        float artW = 350.0f;
                        float artH = 156.0f;
                        float srcW = 430.0f;
                        float srcH = 300.0f;
                        if (!(w > h2)) {
                            float x3 = w * artY / srcH;
                            float y3 = h2 * (srcW - artW - artX) / srcW;
                            cardArt = new FRotatedImage(image, Math.round(x3), Math.round(y3), Math.round(w *= artH / srcH), Math.round(h2 *= artW / srcW), true);
                            Forge.getAssets().cardArtCache().put(imageKey, cardArt);
                            return cardArt;
                        }
                        x = w * 40.0f / 430.0f;
                        y = h2 * 40.0f / srcH;
                        w *= artW / srcW;
                        h2 *= artH / srcH;
                    } else {
                        x = isModernFrame ? w * 0.1f : w * 0.12f;
                        y = isModernFrame ? h2 * 0.12f : h2 * 0.11f;
                        float ratioRatio = (w -= isModernFrame ? 2.0f * x : 2.1f * x) / (h2 *= 0.43f) / 1.302f;
                        if (ratioRatio > 1.0f) {
                            float dw = w * (ratioRatio - 1.0f);
                            w -= dw;
                            x += dw / 2.0f;
                        } else {
                            float dh = h2 * (1.0f - ratioRatio);
                            h2 -= dh;
                            y += dh / 2.0f;
                        }
                    }
                }
                cardArt = new FTextureRegionImage(new TextureRegion(image, Math.round(x), Math.round(y), Math.round(w), Math.round(h2)));
            }
            if (!CardImageRenderer.forgeArt.equals(cardArt)) {
                Forge.getAssets().cardArtCache().put(imageKey, cardArt);
            }
        }
        if (imageKey == "" && cardArt == null) {
            return CardImageRenderer.forgeArt;
        }
        return cardArt;
    }

    public static FImageComplex getAftermathSecondCardArt(final String imageKey) {
        Texture image;
        FImageComplex cardArt = Forge.getAssets().cardArtCache().get("Aftermath_second_" + imageKey);
        if (cardArt == null && (image = new CachedCardImage(imageKey){

            @Override
            public void onImageFetched() {
                ImageCache.clear();
                Forge.getAssets().cardArtCache().remove("Aftermath_second_" + imageKey);
            }
        }.getImage()) != null) {
            if (image == ImageCache.getDefaultImage()) {
                cardArt = CardImageRenderer.forgeArt;
            } else {
                float w = image.getWidth();
                float h2 = image.getHeight();
                float x = w * 138.0f / 250.0f;
                float y = h2 * 210.0f / 370.0f;
                cardArt = new FTextureRegionImage(new TextureRegion(image, Math.round(x), Math.round(y), Math.round(w *= 0.272f), Math.round(h2 *= 0.34594595f)));
            }
            if (!CardImageRenderer.forgeArt.equals(cardArt)) {
                Forge.getAssets().cardArtCache().put("Aftermath_second_" + imageKey, cardArt);
            }
        }
        return cardArt;
    }

    public static FImageComplex getAlternateCardArt(final String imageKey, boolean isPlanesWalker) {
        Texture image;
        FImageComplex cardArt = Forge.getAssets().cardArtCache().get("Alternate_" + imageKey);
        if (cardArt == null && (image = new CachedCardImage(imageKey){

            @Override
            public void onImageFetched() {
                ImageCache.clear();
                Forge.getAssets().cardArtCache().remove("Alternate_" + imageKey);
            }
        }.getImage()) != null) {
            if (image == ImageCache.getDefaultImage()) {
                cardArt = CardImageRenderer.forgeArt;
            } else {
                float y;
                float x;
                float w = image.getWidth();
                float h2 = image.getHeight();
                if (isPlanesWalker) {
                    x = w * 0.09f;
                    y = h2 * 0.11f;
                    w -= 2.0f * x;
                    h2 -= 5.71f * y;
                } else {
                    x = w * 0.1f;
                    y = h2 * 0.11f;
                    float ratioRatio = (w -= 2.0f * x) / (h2 *= 0.43f) / 1.302f;
                    if (ratioRatio > 1.0f) {
                        float dw = w * (ratioRatio - 1.0f);
                        w -= dw;
                        x += dw / 2.0f;
                    } else {
                        float dh = h2 * (1.0f - ratioRatio);
                        h2 -= dh;
                        y += dh / 2.0f;
                    }
                }
                cardArt = new FTextureRegionImage(new TextureRegion(image, Math.round(x), Math.round(y), Math.round(w), Math.round(h2)));
            }
            if (!CardImageRenderer.forgeArt.equals(cardArt)) {
                Forge.getAssets().cardArtCache().put("Alternate_" + imageKey, cardArt);
            }
        }
        return cardArt;
    }

    public static FImageComplex getMeldCardParts(final String imageKey, boolean bottom) {
        Texture image;
        FImageComplex cardArt = !bottom ? Forge.getAssets().cardArtCache().get("Meld_primary_" + imageKey) : Forge.getAssets().cardArtCache().get("Meld_secondary_" + imageKey);
        if (cardArt == null && (image = new CachedCardImage(imageKey){

            @Override
            public void onImageFetched() {
                ImageCache.clear();
                Forge.getAssets().cardArtCache().remove("Meld_primary_" + imageKey);
                Forge.getAssets().cardArtCache().remove("Meld_secondary_" + imageKey);
            }
        }.getImage()) != null) {
            if (image == ImageCache.getDefaultImage()) {
                cardArt = CardImageRenderer.forgeArt;
            } else {
                float x = 0.0f;
                float w = image.getWidth();
                float h2 = (float)image.getHeight() / 2.0f;
                float y = bottom ? h2 : 0.0f;
                cardArt = new FTextureRegionImage(new TextureRegion(image, Math.round(x), Math.round(y), Math.round(w), Math.round(h2)));
            }
            if (!bottom && !CardImageRenderer.forgeArt.equals(cardArt)) {
                Forge.getAssets().cardArtCache().put("Meld_primary_" + imageKey, cardArt);
            } else if (!CardImageRenderer.forgeArt.equals(cardArt)) {
                Forge.getAssets().cardArtCache().put("Meld_secondary_" + imageKey, cardArt);
            }
        }
        return cardArt;
    }

    public static void drawCardListItem(Graphics g2, FSkinFont font, FSkinColor foreColor, CardView card, int count, String suffix, float x, float y, float w, float h2, boolean compactMode) {
        CardView.CardStateView state = card.getCurrentState();
        if (card.getId() > 0) {
            CardRenderer.drawCardListItem(g2, font, foreColor, CardRenderer.getCardArt(card), card, state.getSetCode(), state.getRarity(), state.getPower(), state.getToughness(), state.getLoyalty(), count, suffix, x, y, w, h2, compactMode);
        } else {
            String name = CardTranslation.getTranslatedName(state.getName());
            if (count > 0) {
                name = count + " " + name;
            }
            if (suffix != null) {
                name = name + suffix;
            }
            g2.drawText(name, font, foreColor, x, y, w, h2, false, 1, true);
        }
    }

    public static void drawCardListItem(Graphics g2, FSkinFont font, FSkinColor foreColor, IPaperCard pc, int count, String suffix, float x, float y, float w, float h2, boolean compactMode) {
        CardView card = CardView.getCardForUi(pc);
        CardView.CardStateView state = card.getCurrentState();
        CardRenderer.drawCardListItem(g2, font, foreColor, CardRenderer.getCardArt(pc), card, pc.getEdition(), pc.getRarity(), state.getPower(), state.getToughness(), state.getLoyalty(), count, suffix, x, y, w, h2, compactMode);
    }

    public static void drawCardListItem(Graphics g2, FSkinFont font, FSkinColor foreColor, FImageComplex cardArt, CardView card, String set, CardRarity rarity, int power, int toughness, String loyalty, int count, String suffix, float x, float y, float w, float h2, boolean compactMode) {
        float cardArtHeight = h2 + 2.0f * FList.PADDING;
        float cardArtWidth = cardArtHeight * 1.302f;
        CardView.CardStateView cardCurrentState = card.getCurrentState();
        if (cardArt != null) {
            float artX = x - FList.PADDING;
            float artY = y - FList.PADDING;
            if (card.isSplitCard() && !card.getText().contains("Aftermath")) {
                float srcY = cardArt.getHeight() * 13.0f / 354.0f;
                float srcHeight = cardArt.getHeight() * 150.0f / 354.0f;
                float dh = srcHeight * (1.0f - cardArt.getWidth() / srcHeight / 1.302f);
                g2.drawRotatedImage(cardArt.getTexture(), artX, artY, cardArtHeight, cardArtWidth / 2.0f, artX + cardArtWidth / 2.0f, artY + cardArtWidth / 2.0f, cardArt.getRegionX(), (int)(srcY += dh / 2.0f), (int)cardArt.getWidth(), (int)(srcHeight -= dh), -90.0f);
                g2.drawRotatedImage(cardArt.getTexture(), artX, artY + cardArtWidth / 2.0f, cardArtHeight, cardArtWidth / 2.0f, artX + cardArtWidth / 2.0f, artY + cardArtWidth / 2.0f, cardArt.getRegionX(), (int)cardArt.getHeight() - (int)(srcY + srcHeight), (int)cardArt.getWidth(), (int)srcHeight, -90.0f);
            } else if (card.getText().contains("Aftermath")) {
                FImageComplex secondArt = CardRenderer.getAftermathSecondCardArt(cardCurrentState.getImageKey());
                g2.drawRotatedImage(cardArt.getTexture(), artX, artY, cardArtWidth, cardArtHeight / 2.0f, artX + cardArtWidth, artY + cardArtHeight / 2.0f, cardArt.getRegionX(), cardArt.getRegionY(), (int)cardArt.getWidth(), (int)cardArt.getHeight() / 2, 0.0f);
                g2.drawRotatedImage(secondArt.getTexture(), artX - cardArtHeight / 2.0f, artY + cardArtHeight / 2.0f, cardArtHeight / 2.0f, cardArtWidth, artX, artY + cardArtHeight / 2.0f, secondArt.getRegionX(), secondArt.getRegionY(), (int)secondArt.getWidth(), (int)secondArt.getHeight(), 90.0f);
            } else {
                g2.drawImage(cardArt, artX, artY, cardArtWidth, cardArtHeight);
            }
        }
        float manaCostWidth = 0.0f;
        ManaCost mainManaCost = cardCurrentState.getManaCost();
        if (!mainManaCost.isNoCost() || card.isSplitCard() && !card.getLeftSplitState().getManaCost().isNoCost()) {
            if (card.isSplitCard()) {
                mainManaCost = card.getLeftSplitState().getManaCost();
                ManaCost otherManaCost = card.getAlternateState().getManaCost();
                manaCostWidth = CardFaceSymbols.getWidth(otherManaCost, MANA_SYMBOL_SIZE) + MANA_COST_PADDING;
                CardFaceSymbols.drawManaCost(g2, otherManaCost, x + w - manaCostWidth + MANA_COST_PADDING, y, MANA_SYMBOL_SIZE);
                g2.drawText("//", font, foreColor, x + w - (manaCostWidth += font.getBounds((CharSequence)"//").width + MANA_COST_PADDING) + MANA_COST_PADDING, y, w, MANA_SYMBOL_SIZE, false, 8, true);
            }
            CardFaceSymbols.drawManaCost(g2, mainManaCost, x + w - (manaCostWidth += CardFaceSymbols.getWidth(mainManaCost, MANA_SYMBOL_SIZE)), y, MANA_SYMBOL_SIZE);
        } else if (cardCurrentState.isAttraction()) {
            float lightWidth = 6.0f * MANA_SYMBOL_SIZE + MANA_COST_PADDING;
            CardFaceSymbols.drawAttractionLights(g2, cardCurrentState.getAttractionLights(), x + w - lightWidth, y, MANA_SYMBOL_SIZE, false);
        }
        x += cardArtWidth;
        String name = CardTranslation.getTranslatedName(card.getCurrentState().getName());
        if (count > 0) {
            name = count + " " + name;
        }
        if (suffix != null) {
            name = name + suffix;
        }
        g2.drawText(name, font, foreColor, x, y, w - manaCostWidth - cardArtWidth - FList.PADDING, MANA_SYMBOL_SIZE, false, 8, true);
        if (compactMode) {
            return;
        }
        y += MANA_SYMBOL_SIZE + FList.PADDING + SET_BOX_MARGIN;
        FSkinFont typeFont = FSkinFont.get(12);
        float availableTypeWidth = w - cardArtWidth;
        float lineHeight = typeFont.getLineHeight();
        if (!StringUtils.isEmpty(set)) {
            float setWidth = CardRenderer.getSetWidth(typeFont, set);
            CardRenderer.drawSetLabel(g2, typeFont, set, rarity, x + (availableTypeWidth -= setWidth) + SET_BOX_MARGIN, y - SET_BOX_MARGIN, setWidth, lineHeight + 2.0f * SET_BOX_MARGIN);
        }
        String type = CardDetailUtil.formatCardType(card.getCurrentState(), true);
        if (cardCurrentState.isCreature()) {
            type = type + " (" + power + " / " + toughness + ")";
        } else if (cardCurrentState.isPlaneswalker()) {
            type = type + " (" + loyalty + ")";
        } else if (cardCurrentState.isVehicle()) {
            type = type + String.format(" [%s / %s]", power, toughness);
        } else if (cardCurrentState.isBattle()) {
            type = type + " (" + cardCurrentState.getDefense() + ")";
        }
        g2.drawText(type, typeFont, foreColor, x, y, availableTypeWidth, lineHeight, false, 8, true);
    }

    public static boolean cardListItemTap(List<?> cards, int selectedIndex, CardZoom.ActivateHandler activateHandler, float x, float y, int count, boolean compactMode) {
        if (x <= CardRenderer.getCardListItemHeight(compactMode) * 1.302f) {
            CardZoom.show(cards, selectedIndex, activateHandler);
            return true;
        }
        return false;
    }

    public static boolean paperCardListItemTap(List<?> cards, int selectedIndex, CardZoom.ActivateHandler activateHandler, float x, float y, int count, boolean compactMode) {
        float cardArtHeight = CardRenderer.getCardListItemHeight(compactMode);
        float cardArtWidth = cardArtHeight * 1.302f;
        if (x <= cardArtWidth && y <= cardArtHeight) {
            CardZoom.show(cards, selectedIndex, activateHandler);
            return true;
        }
        return false;
    }

    public static float getSetWidth(FSkinFont font, String set) {
        return font.getBounds((CharSequence)set).width + font.getCapHeight();
    }

    public static void drawSetLabel(Graphics g2, FSkinFont font, String set, CardRarity rarity, float x, float y, float w, float h2) {
        Color backColor = CardRenderer.getRarityColor(rarity);
        Color foreColor = FSkinColor.getHighContrastColor(backColor);
        g2.fillRect(backColor, x, y, w, h2);
        g2.drawText(set, font, foreColor, x, y, w, h2, false, 1, true);
    }

    public static void drawCard(Graphics g2, IPaperCard pc, float x, float y, float w, float h2, CardStackPosition pos) {
        float minusxy;
        Texture image = new RendererCachedCardImage(pc, false).getImage();
        float radius = (h2 - w) / 8.0f;
        float croppedArea = CardRenderer.isModernFrame(pc) ? 0.96f : 0.97f;
        float f = minusxy = CardRenderer.isModernFrame(pc) ? 0.0f : 0.13f * radius;
        if (pc.getEdition().equals("LEA") || pc.getEdition().equals("LEB")) {
            croppedArea = 0.975f;
            minusxy = 0.135f * radius;
        }
        if (image != null) {
            if (image == ImageCache.getDefaultImage() || Forge.enableUIMask.equals("Art")) {
                CardImageRenderer.drawCardImage(g2, CardView.getCardForUi(pc), false, x, y, w, h2, pos, true, true);
            } else if (Forge.enableUIMask.equals("Full")) {
                if (image.toString().contains(".fullborder.")) {
                    g2.drawCardRoundRect(image, null, x, y, w, h2, false, false);
                } else {
                    g2.drawImage(ImageCache.getBorderImage(image.toString()), ImageCache.borderColor(image), x, y, w, h2);
                    g2.drawImage(ImageCache.croppedBorderImage(image), x + radius / 2.4f - minusxy, y + radius / 2.0f - minusxy, w * croppedArea, h2 * croppedArea);
                }
            } else if (Forge.enableUIMask.equals("Crop")) {
                g2.drawImage(ImageCache.croppedBorderImage(image), x, y, w, h2);
            } else {
                g2.drawImage(image, x, y, w, h2);
            }
            if (pc.isFoil()) {
                CardView card = CardView.getCardForUi(pc);
                if (card.getCurrentState().getFoilIndex() == 0) {
                    card.getCurrentState().setFoilIndexOverride(-1);
                }
                CardRenderer.drawFoilEffect(g2, card, x, y, w, h2, false);
            }
        } else {
            CardImageRenderer.drawCardImage(g2, CardView.getCardForUi(pc), false, x, y, w, h2, pos, true, true);
        }
    }

    public static void drawCard(Graphics g2, CardView card, float x, float y, float w, float h2, CardStackPosition pos, boolean rotate) {
        CardRenderer.drawCard(g2, card, x, y, w, h2, pos, rotate, false, false, false);
    }

    public static void drawCard(Graphics g2, CardView card, float x, float y, float w, float h2, CardStackPosition pos, boolean rotate, boolean showAltState, boolean isChoiceList, boolean magnify) {
        float minusxy;
        boolean canshow = MatchController.instance.mayView(card);
        boolean showsleeves = card.isFaceDown() && card.isInZone(EnumSet.of(ZoneType.Exile));
        Texture image = new RendererCachedCardImage(card, false).getImage(showAltState ? card.getAlternateState().getImageKey() : card.getCurrentState().getImageKey());
        TextureRegion crack_overlay = FSkin.getCracks().get(card.getCrackOverlayInt());
        FImage sleeves = MatchController.getPlayerSleeve(card.getOwner());
        float radius = (h2 - w) / 8.0f;
        float croppedArea = CardRenderer.isModernFrame(card) ? 0.96f : 0.97f;
        float f = minusxy = CardRenderer.isModernFrame(card) ? 0.0f : 0.13f * radius;
        if (card.getCurrentState().getSetCode().equals("LEA") || card.getCurrentState().getSetCode().equals("LEB")) {
            croppedArea = 0.975f;
            minusxy = 0.135f * radius;
        }
        float oldAlpha = g2.getfloatAlphaComposite();
        if (card.isPhasedOut() && !magnify) {
            g2.setAlphaComposite(0.2f);
        }
        if (image != null) {
            if (image == ImageCache.getDefaultImage() || Forge.enableUIMask.equals("Art")) {
                CardImageRenderer.drawCardImage(g2, card, showAltState, x, y, w, h2, pos, true, false, isChoiceList, !CardRenderer.showCardIdOverlay(card));
            } else if (showsleeves) {
                if (!card.isForeTold()) {
                    g2.drawCardImage(sleeves, crack_overlay, x, y, w, h2, card.wasDestroyed(), magnify ? false : card.getDamage() > 0);
                } else {
                    g2.drawCardImage(image, crack_overlay, x, y, w, h2, card.wasDestroyed(), magnify ? false : card.getDamage() > 0);
                }
            } else if (FModel.getPreferences().getPrefBoolean(ForgePreferences.FPref.UI_ROTATE_PLANE_OR_PHENOMENON) && (card.getCurrentState().isPhenomenon() || card.getCurrentState().isPlane() || card.getCurrentState().isBattle() && !showAltState || card.getAlternateState() != null && card.getAlternateState().isBattle() && showAltState) && rotate) {
                if (Forge.enableUIMask.equals("Full")) {
                    if (image.toString().contains(".fullborder.")) {
                        g2.drawCardRoundRect(image, x, y, w, h2, x + w / 2.0f, y + h2 / 2.0f, -90.0f);
                    } else {
                        g2.drawRotatedImage(FSkin.getBorders().get(0), x, y, w, h2, x + w / 2.0f, y + h2 / 2.0f, -90.0f);
                        g2.drawRotatedImage(ImageCache.croppedBorderImage(image), x + radius / 2.3f - minusxy, y + radius / 2.0f - minusxy, w * croppedArea, h2 * croppedArea, x + radius / 2.3f - minusxy + w * croppedArea / 2.0f, y + radius / 2.0f - minusxy + h2 * croppedArea / 2.0f, -90.0f);
                    }
                } else if (Forge.enableUIMask.equals("Crop")) {
                    g2.drawRotatedImage(ImageCache.croppedBorderImage(image), x, y, w, h2, x + w / 2.0f, y + h2 / 2.0f, -90.0f);
                } else {
                    g2.drawRotatedImage(image, x, y, w, h2, x + w / 2.0f, y + h2 / 2.0f, -90.0f);
                }
            } else if (Forge.enableUIMask.equals("Full") && canshow) {
                if (image.toString().contains(".fullborder.")) {
                    g2.drawCardRoundRect(image, crack_overlay, x, y, w, h2, card.wasDestroyed(), magnify ? false : card.getDamage() > 0);
                } else {
                    boolean t2 = card.getCurrentState().getOriginalColors() != card.getCurrentState().getColors() || card.getCurrentState().hasChangeColors();
                    g2.drawBorderImage(ImageCache.getBorderImage(image.toString(), canshow), ImageCache.borderColor(image), ImageCache.getTint(card, image), x, y, w, h2, t2);
                    g2.drawCardImage(ImageCache.croppedBorderImage(image), crack_overlay, x + radius / 2.4f - minusxy, y + radius / 2.0f - minusxy, w * croppedArea, h2 * croppedArea, card.wasDestroyed(), magnify ? false : card.getDamage() > 0);
                }
            } else if (Forge.enableUIMask.equals("Crop") && canshow) {
                g2.drawCardImage(ImageCache.croppedBorderImage(image), crack_overlay, x, y, w, h2, card.wasDestroyed(), magnify ? false : card.getDamage() > 0);
            } else if (canshow) {
                g2.drawCardImage(image, crack_overlay, x, y, w, h2, card.wasDestroyed(), magnify ? false : card.getDamage() > 0);
            } else {
                g2.drawCardImage(sleeves, crack_overlay, x, y, w, h2, card.wasDestroyed(), magnify ? false : card.getDamage() > 0);
            }
            CardRenderer.drawFoilEffect(g2, card, x, y, w, h2, false);
        } else {
            CardImageRenderer.drawCardImage(g2, card, showAltState, x, y, w, h2, pos, true, false, isChoiceList, !CardRenderer.showCardIdOverlay(card));
        }
        g2.setAlphaComposite(oldAlpha);
    }

    public static void drawCardWithOverlays(Graphics g2, CardView card, float x, float y, float w, float h2, CardStackPosition pos) {
        CardRenderer.drawCardWithOverlays(g2, card, x, y, w, h2, pos, false, false, false);
    }

    public static void drawCardWithOverlays(Graphics g2, CardView card, float x, float y, float w, float h2, CardStackPosition pos, boolean stackview, boolean showAltState, boolean isChoiceList) {
        ArrayList<String> markers;
        boolean onTop;
        boolean canShow = MatchController.instance.mayView(card);
        float oldAlpha = g2.getfloatAlphaComposite();
        boolean unselectable = !MatchController.instance.isSelectable(card) && MatchController.instance.isSelecting();
        float cx = x;
        float cy = y;
        float cw = w;
        float ch = h2;
        CardRenderer.drawCard(g2, card, x, y, w, h2, pos, false, showAltState, isChoiceList, false);
        float padding = w * 0.021f;
        x += padding;
        y += padding;
        w -= 2.0f * padding;
        h2 -= 2.0f * padding;
        CardView.CardStateView details = showAltState ? card.getAlternateState() : (isChoiceList && card.isSplitCard() ? card.getLeftSplitState() : card.getCurrentState());
        boolean isFaceDown = card.isFaceDown();
        CardDetailUtil.DetailColors borderColor = isFaceDown ? CardDetailUtil.DetailColors.FACE_DOWN : CardDetailUtil.getBorderColor(details, canShow);
        Color color = FSkinColor.fromRGB(borderColor.r, borderColor.g, borderColor.b);
        color = FSkinColor.tintColor(Color.WHITE, color, 0.2f);
        if (stackview) {
            return;
        }
        if (pos == CardStackPosition.BehindVert) {
            return;
        }
        boolean bl = onTop = pos == CardStackPosition.Top;
        if (canShow && CardRenderer.showCardIdOverlay(card)) {
            FSkinFont idFont = FSkinFont.forHeight(h2 * 0.11f);
            float idHeight = idFont.getCapHeight();
            g2.drawOutlinedText(String.valueOf(card.getId()), idFont, Color.WHITE, Color.BLACK, x + padding, y + h2 - idHeight - padding, w, h2, false, 8, false);
        }
        if (card.getCounters() != null && !card.getCounters().isEmpty()) {
            switch (ForgeConstants.CounterDisplayType.from(FModel.getPreferences().getPref(ForgePreferences.FPref.UI_CARD_COUNTER_DISPLAY_TYPE))) {
                case OLD_WHEN_SMALL: 
                case TEXT: {
                    CardRenderer.drawCounterTabs(card, g2, x, y, w, h2);
                    break;
                }
                case IMAGE: {
                    CardRenderer.drawCounterImage(card, g2, x, y, w, h2);
                    break;
                }
                case HYBRID: {
                    CardRenderer.drawCounterImage(card, g2, x, y, w, h2);
                    CardRenderer.drawCounterTabs(card, g2, x, y, w, h2);
                }
            }
        }
        if (card.getCurrentRoom() != null && !card.getCurrentRoom().isEmpty()) {
            markers = new ArrayList<String>();
            markers.add("In Room:");
            markers.add(card.getCurrentRoom());
            CardRenderer.drawMarkersTabs(markers, g2, x, y, w, h2, false);
        }
        if (card.getCurrentState().getType().hasStringType("Class") && ZoneType.Battlefield.equals((Object)card.getZone())) {
            markers = new ArrayList();
            markers.add("CL:" + card.getClassLevel());
            CardRenderer.drawMarkersTabs(markers, g2, x, y - markersHeight, w, h2, true);
        }
        if (card.getRingLevel() > 0) {
            markers = new ArrayList();
            markers.add("RL:" + card.getRingLevel());
            CardRenderer.drawMarkersTabs(markers, g2, x, y - markersHeight, w, h2, true);
        }
        float otherSymbolsSize = w / 4.0f;
        float combatXSymbols = x + w / 4.0f - otherSymbolsSize / 2.0f - 10.0f;
        float stateXSymbols = x + w / 2.0f - otherSymbolsSize / 2.0f - 10.0f;
        float ySymbols = y + h2 - h2 / 12.0f - otherSymbolsSize / 2.0f;
        if (card.isAttacking()) {
            CardFaceSymbols.drawSymbol("attack", g2, combatXSymbols, ySymbols, otherSymbolsSize, otherSymbolsSize);
        } else if (card.isBlocking()) {
            CardFaceSymbols.drawSymbol("defend", g2, combatXSymbols, ySymbols, otherSymbolsSize, otherSymbolsSize);
        }
        if (MatchController.instance.isUsedToPay(card)) {
            float sacSymbolSize = otherSymbolsSize * 1.2f;
            CardFaceSymbols.drawSymbol("sacrifice", g2, x + w / 2.0f - sacSymbolSize / 2.0f, y + h2 / 2.0f - sacSymbolSize / 2.0f, otherSymbolsSize, otherSymbolsSize);
        }
        if (onTop && CardRenderer.showCardPowerOverlay(card) && (canShow || card.isFaceDown())) {
            CardRenderer.drawPtBox(g2, card, details, color, x, y, w, h2);
        }
        if (unselectable) {
            g2.fillRect(FSkinColor.getStandardColor(Color.BLACK).alphaColor(0.6f), cx, cy, cw, ch);
        }
        if (MatchController.instance.isUsedToPay(card)) {
            g2.drawRect(BORDER_THICKNESS, Color.MAGENTA, cx, cy, cw, ch);
        }
        boolean onbattlefield = ZoneType.Battlefield.equals((Object)card.getZone());
        if (unselectable) {
            g2.setAlphaComposite(0.6f);
        }
        if (onbattlefield && onTop) {
            CardRenderer.drawAbilityIcons(g2, card, cx, cy, cw, cx + cw * 2.0f / 2.3f, cy, cw / 5.5f, cw / 5.7f, CardRenderer.showAbilityIcons(card));
        } else if (canShow && !onbattlefield && CardRenderer.showAbilityIcons(card)) {
            String keywordKey = card.getCurrentState().getKeywordKey();
            String abilityText = card.getCurrentState().getAbilityText();
            if ((keywordKey.contains("Flash") || abilityText.contains("May be played by") && abilityText.contains("and as though it has flash")) && !keywordKey.contains("Flashback")) {
                CardFaceSymbols.drawSymbol("flash", g2, cx + cw * 2.0f / 2.3f, cy, cw / 5.5f, cw / 5.5f);
            }
        }
        if (h2 <= NAME_COST_THRESHOLD && canShow) {
            if (CardRenderer.showCardNameOverlay(card)) {
                float multiplier;
                switch (Forge.extrawide) {
                    case "default": {
                        multiplier = 0.145f;
                        break;
                    }
                    case "wide": {
                        multiplier = 0.15f;
                        break;
                    }
                    case "extrawide": {
                        multiplier = 0.155f;
                        break;
                    }
                    default: {
                        multiplier = 0.15f;
                    }
                }
                g2.drawOutlinedText(CardTranslation.getTranslatedName(details.getName()), FSkinFont.forHeight(h2 * multiplier), Color.WHITE, Color.BLACK, x + padding - 1.0f, y + padding, w - 2.0f * padding, h2 * 0.4f, true, 8, false, true);
            }
            if (CardRenderer.showCardManaCostOverlay(card)) {
                float manaSymbolSize = w / 4.5f;
                if (card.isSplitCard() && card.hasAlternateState() && !card.isFaceDown() && card.getZone() != ZoneType.Stack && card.getZone() != ZoneType.Battlefield) {
                    if (isChoiceList) {
                        if (card.getRightSplitState().getName().equals(details.getName())) {
                            CardRenderer.drawManaCost(g2, card.getRightSplitState().getManaCost(), x - padding, y, w + 2.0f * padding, h2, manaSymbolSize);
                        } else {
                            CardRenderer.drawManaCost(g2, card.getLeftSplitState().getManaCost(), x - padding, y, w + 2.0f * padding, h2, manaSymbolSize);
                        }
                    } else {
                        ManaCost leftManaCost = card.getLeftSplitState().getManaCost();
                        ManaCost rightManaCost = card.getRightSplitState().getManaCost();
                        CardRenderer.drawManaCost(g2, leftManaCost, x - padding, y - manaSymbolSize / 1.5f, w + 2.0f * padding, h2, manaSymbolSize);
                        CardRenderer.drawManaCost(g2, rightManaCost, x - padding, y + manaSymbolSize / 1.5f, w + 2.0f * padding, h2, manaSymbolSize);
                    }
                } else {
                    CardRenderer.drawManaCost(g2, showAltState ? card.getAlternateState().getManaCost() : card.getCurrentState().getManaCost(), x - padding, y, w + 2.0f * padding, h2, manaSymbolSize);
                }
            }
        }
        g2.setAlphaComposite(oldAlpha);
    }

    public static void drawAbilityIcons(Graphics g2, CardView card, float cx, float cy, float cw, float abiX, float abiY, float abiScale, float abiSpace, boolean showAbilityIcons) {
        float abiCount = 0.0f;
        if (card.isToken()) {
            CardFaceSymbols.drawSymbol("token", g2, abiX, abiY, abiScale, abiScale);
            abiY += abiSpace;
            abiCount += 1.0f;
        }
        if (card.isSick()) {
            CardFaceSymbols.drawSymbol("summonsick", g2, abiX, abiY, cw / 4.7f, cw / 4.7f);
            abiY += abiSpace + 1.7f;
            abiCount += 1.0f;
        }
        if (card.isPhasedOut()) {
            CardFaceSymbols.drawSymbol("phasing", g2, abiX, abiY, cw / 4.7f, cw / 4.7f);
            abiY += abiSpace + 1.7f;
            abiCount += 1.0f;
        }
        if (!showAbilityIcons) {
            return;
        }
        if (card.isCommander()) {
            CardFaceSymbols.drawSymbol("commander", g2, abiX, abiY, abiScale, abiScale);
            abiY += abiSpace;
            abiCount += 1.0f;
        }
        if (card.isRingBearer()) {
            CardFaceSymbols.drawSymbol("ringbearer", g2, abiX, abiY, abiScale, abiScale);
            abiY += abiSpace;
            abiCount += 1.0f;
        }
        if (card.getCurrentState().hasFlying()) {
            CardFaceSymbols.drawSymbol("flying", g2, abiX, abiY, abiScale, abiScale);
            abiY += abiSpace;
            abiCount += 1.0f;
        }
        if (card.getCurrentState().hasHaste()) {
            CardFaceSymbols.drawSymbol("haste", g2, abiX, abiY, abiScale, abiScale);
            abiY += abiSpace;
            abiCount += 1.0f;
        }
        if (card.getCurrentState().hasDoubleStrike()) {
            CardFaceSymbols.drawSymbol("doublestrike", g2, abiX, abiY, abiScale, abiScale);
            abiY += abiSpace;
            abiCount += 1.0f;
        } else if (card.getCurrentState().hasFirstStrike()) {
            CardFaceSymbols.drawSymbol("firststrike", g2, abiX, abiY, abiScale, abiScale);
            abiY += abiSpace;
            abiCount += 1.0f;
        }
        if (card.getCurrentState().hasAnnihilator()) {
            if (abiCount > 5.0f) {
                abiY = cy + abiSpace * (abiCount - 6.0f);
                abiX = cx + cw * 2.0f / 1.92f;
            }
            CardFaceSymbols.drawSymbol("annihilator", g2, abiX, abiY, abiScale, abiScale);
            abiY += abiSpace;
            abiCount += 1.0f;
        }
        if (card.getCurrentState().hasExalted()) {
            if (abiCount > 5.0f) {
                abiY = cy + abiSpace * (abiCount - 6.0f);
                abiX = cx + cw * 2.0f / 1.92f;
            }
            CardFaceSymbols.drawSymbol("exalted", g2, abiX, abiY, abiScale, abiScale);
            abiY += abiSpace;
            abiCount += 1.0f;
        }
        if (card.getCurrentState().hasDeathtouch()) {
            if (abiCount > 5.0f) {
                abiY = cy + abiSpace * (abiCount - 6.0f);
                abiX = cx + cw * 2.0f / 1.92f;
            }
            CardFaceSymbols.drawSymbol("deathtouch", g2, abiX, abiY, abiScale, abiScale);
            abiY += abiSpace;
            abiCount += 1.0f;
        }
        if (card.getCurrentState().hasToxic()) {
            if (abiCount > 5.0f) {
                abiY = cy + abiSpace * (abiCount - 6.0f);
                abiX = cx + cw * 2.0f / 1.92f;
            }
            CardFaceSymbols.drawSymbol("toxic", g2, abiX, abiY, abiScale, abiScale);
            abiY += abiSpace;
            abiCount += 1.0f;
        }
        if (card.getCurrentState().hasIndestructible()) {
            if (abiCount > 5.0f) {
                abiY = cy + abiSpace * (abiCount - 6.0f);
                abiX = cx + cw * 2.0f / 1.92f;
            }
            CardFaceSymbols.drawSymbol("indestructible", g2, abiX, abiY, abiScale, abiScale);
            abiY += abiSpace;
            abiCount += 1.0f;
        }
        if (card.getCurrentState().hasMenace()) {
            if (abiCount > 5.0f) {
                abiY = cy + abiSpace * (abiCount - 6.0f);
                abiX = cx + cw * 2.0f / 1.92f;
            }
            CardFaceSymbols.drawSymbol("menace", g2, abiX, abiY, abiScale, abiScale);
            abiY += abiSpace;
            abiCount += 1.0f;
        }
        if (card.getCurrentState().hasFear()) {
            if (abiCount > 5.0f) {
                abiY = cy + abiSpace * (abiCount - 6.0f);
                abiX = cx + cw * 2.0f / 1.92f;
            }
            CardFaceSymbols.drawSymbol("fear", g2, abiX, abiY, abiScale, abiScale);
            abiY += abiSpace;
            abiCount += 1.0f;
        }
        if (card.getCurrentState().hasIntimidate()) {
            if (abiCount > 5.0f) {
                abiY = cy + abiSpace * (abiCount - 6.0f);
                abiX = cx + cw * 2.0f / 1.92f;
            }
            CardFaceSymbols.drawSymbol("intimidate", g2, abiX, abiY, abiScale, abiScale);
            abiY += abiSpace;
            abiCount += 1.0f;
        }
        if (card.getCurrentState().hasShadow()) {
            if (abiCount > 5.0f) {
                abiY = cy + abiSpace * (abiCount - 6.0f);
                abiX = cx + cw * 2.0f / 1.92f;
            }
            CardFaceSymbols.drawSymbol("shadow", g2, abiX, abiY, abiScale, abiScale);
            abiY += abiSpace;
            abiCount += 1.0f;
        }
        if (card.getCurrentState().hasHorsemanship()) {
            if (abiCount > 5.0f) {
                abiY = cy + abiSpace * (abiCount - 6.0f);
                abiX = cx + cw * 2.0f / 1.92f;
            }
            CardFaceSymbols.drawSymbol("horsemanship", g2, abiX, abiY, abiScale, abiScale);
            abiY += abiSpace;
            abiCount += 1.0f;
        }
        if (card.getCurrentState().hasLandwalk()) {
            CardFaceSymbols.drawSymbol("landwalk", g2, abiX, abiY, abiScale, abiScale);
            abiY += abiSpace;
            abiCount += 1.0f;
        }
        if (card.getCurrentState().hasHexproof()) {
            if (abiCount > 5.0f) {
                abiY = cy + abiSpace * (abiCount - 6.0f);
                abiX = cx + cw * 2.0f / 1.92f;
            }
            if (!card.getCurrentState().getHexproofKey().isEmpty()) {
                String[] splitK = card.getCurrentState().getHexproofKey().split(":");
                List<String> listHK = Arrays.asList(splitK);
                if (listHK.contains("generic")) {
                    CardFaceSymbols.drawSymbol("hexproof", g2, abiX, abiY, abiScale, abiScale);
                    abiY += abiSpace;
                    abiCount += 1.0f;
                }
                if (listHK.contains("R")) {
                    CardFaceSymbols.drawSymbol("hexproofR", g2, abiX, abiY, abiScale, abiScale);
                    abiY += abiSpace;
                    abiCount += 1.0f;
                }
                if (listHK.contains("B")) {
                    CardFaceSymbols.drawSymbol("hexproofB", g2, abiX, abiY, abiScale, abiScale);
                    abiY += abiSpace;
                    abiCount += 1.0f;
                }
                if (listHK.contains("U")) {
                    CardFaceSymbols.drawSymbol("hexproofU", g2, abiX, abiY, abiScale, abiScale);
                    abiY += abiSpace;
                    abiCount += 1.0f;
                }
                if (listHK.contains("G")) {
                    CardFaceSymbols.drawSymbol("hexproofG", g2, abiX, abiY, abiScale, abiScale);
                    abiY += abiSpace;
                    abiCount += 1.0f;
                }
                if (listHK.contains("W")) {
                    CardFaceSymbols.drawSymbol("hexproofW", g2, abiX, abiY, abiScale, abiScale);
                    abiY += abiSpace;
                    abiCount += 1.0f;
                }
                if (listHK.contains("monocolored")) {
                    CardFaceSymbols.drawSymbol("hexproofC", g2, abiX, abiY, abiScale, abiScale);
                    abiY += abiSpace;
                    abiCount += 1.0f;
                }
            } else {
                CardFaceSymbols.drawSymbol("hexproof", g2, abiX, abiY, abiScale, abiScale);
                abiY += abiSpace;
                abiCount += 1.0f;
            }
        } else if (card.getCurrentState().hasShroud()) {
            if (abiCount > 5.0f) {
                abiY = cy + abiSpace * (abiCount - 6.0f);
                abiX = cx + cw * 2.0f / 1.92f;
            }
            CardFaceSymbols.drawSymbol("shroud", g2, abiX, abiY, abiScale, abiScale);
            abiY += abiSpace;
            abiCount += 1.0f;
        }
        if (card.getCurrentState().hasVigilance()) {
            if (abiCount > 5.0f) {
                abiY = cy + abiSpace * (abiCount - 6.0f);
                abiX = cx + cw * 2.0f / 1.92f;
            }
            CardFaceSymbols.drawSymbol("vigilance", g2, abiX, abiY, abiScale, abiScale);
            abiY += abiSpace;
            abiCount += 1.0f;
        }
        if (card.getCurrentState().hasTrample()) {
            if (abiCount > 5.0f) {
                abiY = cy + abiSpace * (abiCount - 6.0f);
                abiX = cx + cw * 2.0f / 1.92f;
            }
            CardFaceSymbols.drawSymbol("trample", g2, abiX, abiY, abiScale, abiScale);
            abiY += abiSpace;
            abiCount += 1.0f;
        }
        if (card.getCurrentState().hasReach()) {
            if (abiCount > 5.0f) {
                abiY = cy + abiSpace * (abiCount - 6.0f);
                abiX = cx + cw * 2.0f / 1.92f;
            }
            CardFaceSymbols.drawSymbol("reach", g2, abiX, abiY, abiScale, abiScale);
            abiY += abiSpace;
            abiCount += 1.0f;
        }
        if (card.getCurrentState().hasLifelink()) {
            if (abiCount > 5.0f) {
                abiY = cy + abiSpace * (abiCount - 6.0f);
                abiX = cx + cw * 2.0f / 1.92f;
            }
            CardFaceSymbols.drawSymbol("lifelink", g2, abiX, abiY, abiScale, abiScale);
            abiY += abiSpace;
            abiCount += 1.0f;
        }
        if (card.getCurrentState().hasWard()) {
            if (abiCount > 5.0f) {
                abiY = cy + abiSpace * (abiCount - 6.0f);
                abiX = cx + cw * 2.0f / 1.92f;
            }
            CardFaceSymbols.drawSymbol("ward", g2, abiX, abiY, abiScale, abiScale);
            abiY += abiSpace;
            abiCount += 1.0f;
        }
        if (card.getCurrentState().hasWither()) {
            if (abiCount > 5.0f) {
                abiY = cy + abiSpace * (abiCount - 6.0f);
                abiX = cx + cw * 2.0f / 1.92f;
            }
            CardFaceSymbols.drawSymbol("wither", g2, abiX, abiY, abiScale, abiScale);
            abiY += abiSpace;
            abiCount += 1.0f;
        }
        if (card.getCurrentState().hasDefender()) {
            if (abiCount > 5.0f) {
                abiY = cy + abiSpace * (abiCount - 6.0f);
                abiX = cx + cw * 2.0f / 1.92f;
            }
            CardFaceSymbols.drawSymbol("defender", g2, abiX, abiY, abiScale, abiScale);
            abiY += abiSpace;
            abiCount += 1.0f;
        }
        if (!card.getCurrentState().getProtectionKey().isEmpty()) {
            if (abiCount > 5.0f) {
                abiY = cy + abiSpace * (abiCount - 6.0f);
                abiX = cx + cw * 2.0f / 1.92f;
            }
            if (card.getCurrentState().getProtectionKey().contains("everything") || card.getCurrentState().getProtectionKey().contains("allcolors")) {
                CardFaceSymbols.drawSymbol("protectAll", g2, abiX, abiY, abiScale, abiScale);
                abiY += abiSpace;
                abiCount += 1.0f;
            } else if (card.getCurrentState().getProtectionKey().contains("coloredspells")) {
                CardFaceSymbols.drawSymbol("protectColoredSpells", g2, abiX, abiY, abiScale, abiScale);
                abiY += abiSpace;
                abiCount += 1.0f;
            } else if (card.getCurrentState().getProtectionKey().equals("R")) {
                CardFaceSymbols.drawSymbol("protectR", g2, abiX, abiY, abiScale, abiScale);
                abiY += abiSpace;
                abiCount += 1.0f;
            } else if (card.getCurrentState().getProtectionKey().equals("G")) {
                CardFaceSymbols.drawSymbol("protectG", g2, abiX, abiY, abiScale, abiScale);
                abiY += abiSpace;
                abiCount += 1.0f;
            } else if (card.getCurrentState().getProtectionKey().equals("B")) {
                CardFaceSymbols.drawSymbol("protectB", g2, abiX, abiY, abiScale, abiScale);
                abiY += abiSpace;
                abiCount += 1.0f;
            } else if (card.getCurrentState().getProtectionKey().equals("U")) {
                CardFaceSymbols.drawSymbol("protectU", g2, abiX, abiY, abiScale, abiScale);
                abiY += abiSpace;
                abiCount += 1.0f;
            } else if (card.getCurrentState().getProtectionKey().equals("W")) {
                CardFaceSymbols.drawSymbol("protectW", g2, abiX, abiY, abiScale, abiScale);
                abiY += abiSpace;
                abiCount += 1.0f;
            } else if (card.getCurrentState().getProtectionKey().equals("RG") || card.getCurrentState().getProtectionKey().equals("GR")) {
                CardFaceSymbols.drawSymbol("protectRG", g2, abiX, abiY, abiScale, abiScale);
                abiY += abiSpace;
                abiCount += 1.0f;
            } else if (card.getCurrentState().getProtectionKey().equals("RB") || card.getCurrentState().getProtectionKey().equals("BR")) {
                CardFaceSymbols.drawSymbol("protectRB", g2, abiX, abiY, abiScale, abiScale);
                abiY += abiSpace;
                abiCount += 1.0f;
            } else if (card.getCurrentState().getProtectionKey().equals("RU") || card.getCurrentState().getProtectionKey().equals("UR")) {
                CardFaceSymbols.drawSymbol("protectRU", g2, abiX, abiY, abiScale, abiScale);
                abiY += abiSpace;
                abiCount += 1.0f;
            } else if (card.getCurrentState().getProtectionKey().equals("RW") || card.getCurrentState().getProtectionKey().equals("WR")) {
                CardFaceSymbols.drawSymbol("protectRW", g2, abiX, abiY, abiScale, abiScale);
                abiY += abiSpace;
                abiCount += 1.0f;
            } else if (card.getCurrentState().getProtectionKey().equals("GB") || card.getCurrentState().getProtectionKey().equals("BG")) {
                CardFaceSymbols.drawSymbol("protectGB", g2, abiX, abiY, abiScale, abiScale);
                abiY += abiSpace;
                abiCount += 1.0f;
            } else if (card.getCurrentState().getProtectionKey().equals("GU") || card.getCurrentState().getProtectionKey().equals("UG")) {
                CardFaceSymbols.drawSymbol("protectGU", g2, abiX, abiY, abiScale, abiScale);
                abiY += abiSpace;
                abiCount += 1.0f;
            } else if (card.getCurrentState().getProtectionKey().equals("GW") || card.getCurrentState().getProtectionKey().equals("WG")) {
                CardFaceSymbols.drawSymbol("protectGW", g2, abiX, abiY, abiScale, abiScale);
                abiY += abiSpace;
                abiCount += 1.0f;
            } else if (card.getCurrentState().getProtectionKey().equals("BU") || card.getCurrentState().getProtectionKey().equals("UB")) {
                CardFaceSymbols.drawSymbol("protectBU", g2, abiX, abiY, abiScale, abiScale);
                abiY += abiSpace;
                abiCount += 1.0f;
            } else if (card.getCurrentState().getProtectionKey().equals("BW") || card.getCurrentState().getProtectionKey().equals("WB")) {
                CardFaceSymbols.drawSymbol("protectBW", g2, abiX, abiY, abiScale, abiScale);
                abiY += abiSpace;
                abiCount += 1.0f;
            } else if (card.getCurrentState().getProtectionKey().equals("UW") || card.getCurrentState().getProtectionKey().equals("WU")) {
                CardFaceSymbols.drawSymbol("protectUW", g2, abiX, abiY, abiScale, abiScale);
                abiY += abiSpace;
                abiCount += 1.0f;
            } else if (card.getCurrentState().getProtectionKey().contains("generic") || card.getCurrentState().getProtectionKey().length() > 2) {
                CardFaceSymbols.drawSymbol("protectGeneric", g2, abiX, abiY, abiScale, abiScale);
                abiY += abiSpace;
                abiCount += 1.0f;
            }
        }
    }

    private static void drawCounterTabs(CardView card, Graphics g2, float x, float y, float w, float h2) {
        int fontSize = Math.max(11, Math.min(22, (int)((double)h2 * 0.08)));
        BitmapFont font = Forge.getAssets().counterFonts().get(fontSize);
        float additionalXOffset = 3.0f * ((float)(fontSize - 11) / 11.0f);
        float variableWidth = (float)(fontSize - 11) / 11.0f * 44.0f;
        float otherSymbolsSize = w / 3.5f;
        float ySymbols = h2 / 12.0f - otherSymbolsSize / 2.0f;
        float counterBoxHeight = 9 + fontSize;
        float counterBoxBaseWidth = 50.0f + variableWidth + additionalXOffset * 2.0f;
        float counterBoxSpacing = -4.0f;
        float spaceFromTopOfCard = y + h2 - counterBoxHeight - -4.0f - otherSymbolsSize + ySymbols;
        int currentCounter = 0;
        if (ForgeConstants.CounterDisplayType.from(FModel.getPreferences().getPref(ForgePreferences.FPref.UI_CARD_COUNTER_DISPLAY_TYPE)) == ForgeConstants.CounterDisplayType.OLD_WHEN_SMALL) {
            int maxCounters = 0;
            for (Integer n : card.getCounters().values()) {
                maxCounters = Math.max(maxCounters, n);
            }
            if (font != null && !String.valueOf(maxCounters).isEmpty()) {
                layout.setText(font, String.valueOf(maxCounters));
                if (counterBoxBaseWidth + CardRenderer.layout.width > w) {
                    CardRenderer.drawCounterImage(card, g2, x, y, w, h2);
                    return;
                }
            }
        }
        int c = 0;
        for (Map.Entry entry : card.getCounters().entrySet()) {
            CounterType counter = (CounterType)entry.getKey();
            int numberOfCounters = (Integer)entry.getValue();
            if (font == null || String.valueOf(numberOfCounters).isEmpty()) continue;
            layout.setText(font, String.valueOf(numberOfCounters));
            float counterBoxRealWidth = counterBoxBaseWidth + CardRenderer.layout.width + 4.0f;
            float counterYOffset = spaceFromTopOfCard - (float)currentCounter++ * (counterBoxHeight + -4.0f);
            g2.fillRect(counterBackgroundColor, x - 3.0f, counterYOffset, counterBoxRealWidth, counterBoxHeight);
            if (!counterColorCache.containsKey(counter)) {
                counterColorCache.put(counter, new Color((float)counter.getRed() / 255.0f, (float)counter.getGreen() / 255.0f, (float)counter.getBlue() / 255.0f, 1.0f));
            }
            Color counterColor = counterColorCache.get(counter);
            CardRenderer.drawText(g2, counter.getCounterOnCardDisplayName(), font, counterColor, x + 2.0f + additionalXOffset, counterYOffset, counterBoxRealWidth, counterBoxHeight, 8);
            CardRenderer.drawText(g2, String.valueOf(numberOfCounters), font, counterColor, x + counterBoxBaseWidth - 4.0f - additionalXOffset, counterYOffset, counterBoxRealWidth, counterBoxHeight, 8);
            c = (int)((float)c + counterBoxHeight);
        }
        markersHeight = c;
    }

    private static void drawText(Graphics g2, String text, BitmapFont font, Color color, float x, float y, float w, float h2, int horizontalAlignment) {
        if (color.a < 1.0f) {
            Gdx.gl.glEnable(3042);
        }
        if (font != null && !text.isEmpty()) {
            layout.setText(font, text);
            TextBounds textBounds = new TextBounds(CardRenderer.layout.width, CardRenderer.layout.height);
            float textHeight = textBounds.height;
            if (h2 > textHeight) {
                y += (h2 - textHeight) / 2.0f;
            }
            font.setColor(color);
            font.draw(g2.getBatch(), text, g2.adjustX(x), g2.adjustY(y, 0.0f), w, horizontalAlignment, true);
            if (color.a < 1.0f) {
                Gdx.gl.glDisable(3042);
            }
        }
    }

    private static void drawCounterImage(CardView card, Graphics g2, float x, float y, float w, float h2) {
        int number = 0;
        if (card.getCounters() != null) {
            for (Integer i : card.getCounters().values()) {
                number += i.intValue();
            }
        }
        int counters = number;
        float countersSize = w / 2.0f;
        float xCounters = x - countersSize / 2.0f;
        float yCounters = y + h2 * 2.0f / 3.0f - countersSize;
        if (counters == 1) {
            CardFaceSymbols.drawSymbol("counters1", g2, xCounters, yCounters, countersSize, countersSize);
        } else if (counters == 2) {
            CardFaceSymbols.drawSymbol("counters2", g2, xCounters, yCounters, countersSize, countersSize);
        } else if (counters == 3) {
            CardFaceSymbols.drawSymbol("counters3", g2, xCounters, yCounters, countersSize, countersSize);
        } else if (counters > 3) {
            CardFaceSymbols.drawSymbol("countersMulti", g2, xCounters, yCounters, countersSize, countersSize);
        }
    }

    private static void drawMarkersTabs(List<String> markers, Graphics g2, float x, float y, float w, float h2, boolean larger) {
        int fontSize = larger ? Math.max(9, Math.min(22, (int)((double)h2 * 0.08))) : Math.max(8, Math.min(22, (int)((double)h2 * 0.05)));
        BitmapFont font = Forge.getAssets().counterFonts().get(fontSize);
        float additionalXOffset = 3.0f * ((float)(fontSize - 8) / 8.0f);
        float otherSymbolsSize = w / 3.5f;
        float ySymbols = h2 / 12.0f - otherSymbolsSize / 2.0f;
        float markerBoxHeight = 9 + fontSize;
        float markerBoxBaseWidth = 8.0f + additionalXOffset * 2.0f;
        float markerBoxSpacing = -4.0f;
        float spaceFromTopOfCard = y + h2 - markerBoxHeight - -4.0f - otherSymbolsSize + ySymbols;
        int markerCounter = markers.size() - 1;
        for (String marker : markers) {
            if (font == null || marker.isEmpty()) continue;
            layout.setText(font, marker);
            float markerBoxRealWidth = markerBoxBaseWidth + CardRenderer.layout.width + 4.0f;
            float markerYOffset = spaceFromTopOfCard - (float)markerCounter-- * (markerBoxHeight + -4.0f);
            g2.fillRect(counterBackgroundColor, x - 3.0f, markerYOffset, markerBoxRealWidth, markerBoxHeight);
            Color markerColor = new Color(0.78431374f, 0.78431374f, 0.78431374f, 1.0f);
            CardRenderer.drawText(g2, marker, font, markerColor, x + 2.0f + additionalXOffset, markerYOffset, markerBoxRealWidth, markerBoxHeight, 8);
        }
    }

    private static void drawPtBox(Graphics g2, CardView card, CardView.CardStateView details, Color color, float x, float y, float w, float h2) {
        float padding;
        ArrayList<String> pieces = new ArrayList<String>();
        if (details.isCreature()) {
            pieces.add(String.valueOf(details.getPower()));
            pieces.add("/");
            pieces.add(String.valueOf(details.getToughness()));
        } else if (details.getType().hasSubtype("Vehicle")) {
            pieces.add("[");
            pieces.add(String.valueOf(details.getPower()));
            pieces.add("/");
            pieces.add(String.valueOf(details.getToughness()));
            pieces.add("]");
        }
        if (details.isPlaneswalker()) {
            if (pieces.isEmpty()) {
                pieces.add(String.valueOf(details.getLoyalty()));
            } else {
                pieces.add("(" + details.getLoyalty() + ")");
            }
        }
        if (pieces.isEmpty()) {
            return;
        }
        FSkinFont font = FSkinFont.forHeight(h2 * 0.15f);
        float boxWidth = padding = (float)Math.round(font.getCapHeight() / 4.0f);
        ArrayList<Float> pieceWidths = new ArrayList<Float>();
        for (String piece : pieces) {
            float pieceWidth = font.getBounds((CharSequence)piece).width + padding;
            pieceWidths.add(Float.valueOf(pieceWidth));
            boxWidth += pieceWidth;
        }
        float boxHeight = font.getCapHeight() + font.getAscent() + 2.0f * padding;
        x += w - boxWidth;
        y += h2 - boxHeight;
        w = boxWidth;
        h2 = boxHeight;
        if (card.getDamage() > 0) {
            g2.drawOutlinedText(">" + card.getDamage() + "<", font, Color.RED, Color.WHITE, x, y - h2 + padding, w, h2, false, 1, true);
        }
        g2.fillRect(color, x, y, w, h2);
        g2.drawRect(BORDER_THICKNESS, Color.BLACK, x, y, w, h2);
        x += padding;
        for (int i = 0; i < pieces.size(); ++i) {
            g2.drawText((String)pieces.get(i), font, Color.BLACK, x, y, w, h2, false, 8, true);
            x += ((Float)pieceWidths.get(i)).floatValue();
        }
    }

    private static void drawManaCost(Graphics g2, ManaCost cost, float x, float y, float w, float h2, float manaSymbolSize) {
        float manaCostWidth = CardFaceSymbols.getWidth(cost, manaSymbolSize);
        if (manaCostWidth > w) {
            manaCostWidth = w;
            manaSymbolSize = w / (float)cost.getGlyphCount();
        }
        CardFaceSymbols.drawManaCost(g2, cost, x + (w - manaCostWidth) / 2.0f, y + (h2 - manaSymbolSize) / 2.0f, manaSymbolSize);
    }

    public static void drawFoilEffect(Graphics g2, CardView card, float x, float y, float w, float h2, boolean inZoomer) {
        float minusxy;
        if (card.getCurrentState().isBattle()) {
            return;
        }
        if (card.getAlternateState() != null && card.getCurrentState().isBattle()) {
            return;
        }
        float new_x = x;
        float new_y = y;
        float new_w = w;
        float new_h = h2;
        float radius = (h2 - w) / 8.0f;
        float croppedArea = CardRenderer.isModernFrame(card) ? 0.96f : 0.97f;
        float f = minusxy = CardRenderer.isModernFrame(card) ? 0.0f : 0.13f * radius;
        if (card.getCurrentState().getSetCode().equals("LEA") || card.getCurrentState().getSetCode().equals("LEB")) {
            croppedArea = 0.975f;
            minusxy = 0.135f * radius;
        }
        if (Forge.enableUIMask.equals("Full")) {
            new_x += radius / 2.4f - minusxy;
            new_y += radius / 2.0f - minusxy;
            new_w = w * croppedArea;
            new_h = h2 * croppedArea;
        }
        if (CardRenderer.isPreferenceEnabled(ForgePreferences.FPref.UI_OVERLAY_FOIL_EFFECT) && MatchController.instance.mayView(card)) {
            boolean rotateSplit = CardRenderer.isPreferenceEnabled(ForgePreferences.FPref.UI_ROTATE_SPLIT_CARDS) && card.isSplitCard() && inZoomer;
            int foil = card.getCurrentState().getFoilIndex();
            if (foil > 0) {
                CardFaceSymbols.drawOther(g2, String.format("foil%02d", foil), new_x, new_y, new_w, new_h, rotateSplit);
            }
        }
    }

    private static boolean isPreferenceEnabled(ForgePreferences.FPref preferenceName) {
        return FModel.getPreferences().getPrefBoolean(preferenceName);
    }

    private static boolean isShowingOverlays(CardView card) {
        return CardRenderer.isPreferenceEnabled(ForgePreferences.FPref.UI_SHOW_CARD_OVERLAYS) && card != null;
    }

    private static boolean showCardNameOverlay(CardView card) {
        return CardRenderer.isShowingOverlays(card) && CardRenderer.isPreferenceEnabled(ForgePreferences.FPref.UI_OVERLAY_CARD_NAME);
    }

    private static boolean showCardPowerOverlay(CardView card) {
        return CardRenderer.isShowingOverlays(card) && CardRenderer.isPreferenceEnabled(ForgePreferences.FPref.UI_OVERLAY_CARD_POWER);
    }

    private static boolean showCardManaCostOverlay(CardView card) {
        return CardRenderer.isShowingOverlays(card) && CardRenderer.isPreferenceEnabled(ForgePreferences.FPref.UI_OVERLAY_CARD_MANA_COST);
    }

    public static boolean showAbilityIcons(CardView card) {
        return CardRenderer.isShowingOverlays(card) && CardRenderer.isPreferenceEnabled(ForgePreferences.FPref.UI_OVERLAY_ABILITY_ICONS);
    }

    private static boolean showCardIdOverlay(CardView card) {
        return card.getId() > 0 && CardRenderer.isShowingOverlays(card) && CardRenderer.isPreferenceEnabled(ForgePreferences.FPref.UI_OVERLAY_CARD_ID);
    }

    private static void generateFontForCounters(final int fontSize) {
        FileHandle ttfFile = Gdx.files.absolute(ForgeConstants.COMMON_FONTS_DIR).child("Roboto-Bold.ttf");
        if (!ttfFile.exists()) {
            return;
        }
        final FreeTypeFontGenerator generator = new FreeTypeFontGenerator(ttfFile);
        int pageSize = 128;
        String chars = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz1234567890/-+:'";
        final PixmapPacker packer = new PixmapPacker(pageSize, pageSize, Pixmap.Format.RGBA8888, 2, false);
        FreeTypeFontGenerator.FreeTypeFontParameter parameter = new FreeTypeFontGenerator.FreeTypeFontParameter();
        parameter.characters = chars;
        parameter.size = fontSize;
        parameter.packer = packer;
        final FreeTypeFontGenerator.FreeTypeBitmapFontData fontData = generator.generateData(parameter);
        final Array<PixmapPacker.Page> pages = packer.getPages();
        FThreads.invokeInEdtNowOrLater(new Runnable(){

            @Override
            public void run() {
                Array<TextureRegion> textureRegions = new Array<TextureRegion>();
                for (int i = 0; i < pages.size; ++i) {
                    PixmapPacker.Page p = (PixmapPacker.Page)pages.get(i);
                    Texture texture = new Texture(new PixmapTextureData(p.getPixmap(), p.getPixmap().getFormat(), false, false)){

                        @Override
                        public void dispose() {
                            super.dispose();
                            this.getTextureData().consumePixmap().dispose();
                        }
                    };
                    texture.setFilter(Texture.TextureFilter.Nearest, Texture.TextureFilter.Nearest);
                    textureRegions.add(new TextureRegion(texture));
                }
                Forge.getAssets().counterFonts().put(fontSize, new BitmapFont((BitmapFont.BitmapFontData)fontData, textureRegions, true));
                generator.dispose();
                packer.dispose();
            }
        });
    }

    static {
        try {
            for (int fontSize = 8; fontSize <= 22; ++fontSize) {
                CardRenderer.generateFontForCounters(fontSize);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        classicModuleCardtoCrop = FileUtil.readFile(ForgeConstants.CLASSIC_MODULE_CARD_TO_CROP_FILE);
        markersHeight = 0.0f;
    }

    static class RendererCachedCardImage
    extends CachedCardImage {
        boolean clearcardArtCache = false;

        public RendererCachedCardImage(CardView card, boolean clearArtCache) {
            super(card);
            this.clearcardArtCache = clearArtCache;
        }

        public RendererCachedCardImage(InventoryItem ii, boolean clearArtCache) {
            super(ii);
            this.clearcardArtCache = clearArtCache;
        }

        public RendererCachedCardImage(String key, boolean clearArtCache) {
            super(key);
            this.clearcardArtCache = clearArtCache;
        }

        @Override
        public void onImageFetched() {
            ImageCache.clear();
            if (this.clearcardArtCache) {
                CardRenderer.clearcardArtCache();
            }
        }
    }

    public static enum CardStackPosition {
        Top,
        BehindHorz,
        BehindVert;

    }
}

