/*
 * Decompiled with CFR 0.152.
 */
package forge.card;

import com.badlogic.gdx.math.Vector2;
import forge.card.CardZoom;
import forge.item.PaperCard;
import forge.toolbox.FChoiceList;
import forge.toolbox.FLabel;

public class CardListPreview
extends FLabel {
    public static final float CARD_PREVIEW_RATIO = 0.5f;
    private final FChoiceList<PaperCard> list;

    public CardListPreview(FChoiceList<PaperCard> list0) {
        super(new FLabel.Builder().iconScaleFactor(1.0f).insets(new Vector2(0.0f, 0.0f)).iconInBackground(true).align(1));
        this.list = list0;
    }

    @Override
    public boolean tap(float x, float y, int count) {
        return this.zoom();
    }

    @Override
    public boolean longPress(float x, float y) {
        return this.zoom();
    }

    private boolean zoom() {
        int index = this.list.getSelectedIndex();
        if (index == -1) {
            return false;
        }
        CardZoom.show(this.list.extractListData(), index, this.list);
        return true;
    }

    @Override
    public boolean fling(float velocityX, float velocityY) {
        if (Math.abs(velocityX) > Math.abs(velocityY)) {
            int selectedIndex = this.list.getSelectedIndex();
            if (velocityX > 0.0f) {
                if (selectedIndex > 0) {
                    this.list.setSelectedIndex(selectedIndex - 1);
                }
            } else if (selectedIndex < this.list.getCount() - 1) {
                this.list.setSelectedIndex(selectedIndex + 1);
            }
            return true;
        }
        return false;
    }
}

