/*
 * Decompiled with CFR 0.152.
 */
package forge.card;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Texture;
import com.google.common.collect.ImmutableList;
import forge.CachedCardImage;
import forge.Forge;
import forge.Graphics;
import forge.ImageKeys;
import forge.assets.FBufferedImage;
import forge.assets.FImage;
import forge.assets.FImageComplex;
import forge.assets.FSkin;
import forge.assets.FSkinColor;
import forge.assets.FSkinFont;
import forge.assets.FSkinImage;
import forge.assets.FSkinTexture;
import forge.assets.ImageCache;
import forge.assets.TextRenderer;
import forge.card.CardEdition;
import forge.card.CardFaceSymbols;
import forge.card.CardRarity;
import forge.card.CardRenderer;
import forge.card.ColorSet;
import forge.card.mana.ManaCost;
import forge.game.GameView;
import forge.game.card.CardView;
import forge.game.zone.ZoneType;
import forge.gui.card.CardDetailUtil;
import forge.item.PaperCard;
import forge.localinstance.properties.ForgeConstants;
import forge.localinstance.properties.ForgePreferences;
import forge.model.FModel;
import forge.screens.FScreen;
import forge.screens.match.MatchController;
import forge.util.CardTranslation;
import forge.util.ImageUtil;
import forge.util.TextBounds;
import forge.util.Utils;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class CardImageRenderer {
    private static final float BASE_IMAGE_WIDTH = 360.0f;
    private static final float BASE_IMAGE_HEIGHT = 504.0f;
    private static float MANA_SYMBOL_SIZE;
    private static float PT_BOX_WIDTH;
    private static float HEADER_PADDING;
    private static float BORDER_THICKNESS;
    private static FSkinFont NAME_FONT;
    private static FSkinFont TYPE_FONT;
    private static FSkinFont TEXT_FONT;
    private static FSkinFont PT_FONT;
    private static float prevImageWidth;
    private static float prevImageHeight;
    private static final float BLACK_BORDER_THICKNESS_RATIO = 0.021f;
    public static final FBufferedImage forgeArt;
    private static final FBufferedImage stretchedArt;
    private static final TextRenderer cardTextRenderer;

    private static Color fromDetailColor(CardDetailUtil.DetailColors detailColor) {
        return FSkinColor.fromRGB(detailColor.r, detailColor.g, detailColor.b);
    }

    public static void forceStaticFieldUpdate() {
        prevImageWidth = 0.0f;
        prevImageHeight = 0.0f;
        forgeArt.clear();
        stretchedArt.clear();
    }

    private static void updateStaticFields(float w, float h2) {
        if (w == prevImageWidth && h2 == prevImageHeight) {
            return;
        }
        float ratio = Math.min(w / 360.0f, h2 / 504.0f);
        MANA_SYMBOL_SIZE = 20.0f * ratio;
        PT_BOX_WIDTH = 56.0f * ratio;
        HEADER_PADDING = 5.0f * ratio;
        NAME_FONT = FSkinFont.forHeight(MANA_SYMBOL_SIZE);
        TYPE_FONT = FSkinFont.forHeight(MANA_SYMBOL_SIZE * 0.9f);
        TEXT_FONT = FSkinFont.forHeight(MANA_SYMBOL_SIZE * 0.95f);
        PT_FONT = NAME_FONT;
        BORDER_THICKNESS = Math.max(1.5f * ratio, 1.0f);
        prevImageWidth = w;
        prevImageHeight = h2;
    }

    public static void drawFaceDownCard(CardView card, Graphics g2, float x, float y, float w, float h2) {
        FImage sleeves = MatchController.getPlayerSleeve(card.getOwner());
        if (sleeves != null) {
            g2.drawImage(sleeves, x, y, w, h2);
        } else {
            CardImageRenderer.drawArt(null, g2, x, y, w, h2, false, true);
        }
    }

    public static void drawCardImage(Graphics g2, CardView card, boolean altState, float x, float y, float w, float h2, CardRenderer.CardStackPosition pos, boolean useCardBGTexture, boolean showArtist) {
        CardImageRenderer.drawCardImage(g2, card, altState, x, y, w, h2, pos, useCardBGTexture, false, false, showArtist);
    }

    public static void drawCardImage(Graphics g2, CardView card, boolean altState, float x, float y, float w, float h2, CardRenderer.CardStackPosition pos, boolean useCardBGTexture, boolean noText, boolean isChoiceList, boolean showArtist) {
        Color[] textBoxColors;
        float minTextBoxHeight;
        boolean drawDungeon;
        CardImageRenderer.updateStaticFields(w, h2);
        float blackBorderThickness = w * 0.021f;
        g2.fillRect(Color.BLACK, x, y, w, h2);
        x += blackBorderThickness;
        y += blackBorderThickness;
        w -= 2.0f * blackBorderThickness;
        h2 -= 2.0f * blackBorderThickness;
        CardView.CardStateView state = altState ? card.getAlternateState() : (isChoiceList && card.isSplitCard() ? card.getLeftSplitState() : card.getCurrentState());
        boolean isFaceDown = card.isFaceDown();
        boolean canShow = MatchController.instance.mayView(card);
        if (isFaceDown && altState && card.isSplitCard()) {
            state = card.getLeftSplitState();
        }
        boolean isSaga = state.getType().hasSubtype("Saga");
        boolean isClass = state.getType().hasSubtype("Class") || state.getType().hasSubtype("Case");
        boolean isDungeon = state.getType().isDungeon();
        boolean bl = drawDungeon = isDungeon && CardRenderer.getCardArt(card) != null;
        if (!canShow) {
            CardImageRenderer.drawFaceDownCard(card, g2, x, y, w, h2);
            return;
        }
        List<CardDetailUtil.DetailColors> borderColors = isFaceDown ? (!altState ? ImmutableList.of(CardDetailUtil.DetailColors.FACE_DOWN) : (!useCardBGTexture ? ImmutableList.of(CardDetailUtil.DetailColors.FACE_DOWN) : CardDetailUtil.getBorderColors(state, canShow))) : CardDetailUtil.getBorderColors(state, canShow);
        Color[] colors = useCardBGTexture && Forge.allowCardBG ? CardImageRenderer.drawCardBackgroundTexture(state, g2, borderColors, x, y, w, h2) : CardImageRenderer.fillColorBackground(g2, borderColors, x, y, w, h2);
        float artInset = blackBorderThickness * 0.5f;
        float outerBorderThickness = 2.0f * blackBorderThickness - artInset;
        float headerHeight = Math.max(MANA_SYMBOL_SIZE + 2.0f * HEADER_PADDING, 2.0f * NAME_FONT.getCapHeight()) + 2.0f;
        Color[] headerColors = FSkinColor.tintColors(Color.WHITE, colors, 0.2f);
        CardImageRenderer.drawHeader(g2, card, state, headerColors, x += outerBorderThickness, y += outerBorderThickness, w -= 2.0f * outerBorderThickness, headerHeight, isFaceDown && !altState, false);
        if (pos == CardRenderer.CardStackPosition.BehindVert) {
            return;
        }
        boolean onTop = pos == CardRenderer.CardStackPosition.Top;
        y += headerHeight;
        float artWidth = w - 2.0f * artInset;
        float artHeight = artWidth / 1.302f;
        float typeBoxHeight = 2.0f * TYPE_FONT.getCapHeight();
        float ptBoxHeight = 0.0f;
        float textBoxHeight = h2 - headerHeight - artHeight - typeBoxHeight - outerBorderThickness - artInset;
        if (state.isCreature() || state.isPlaneswalker() || state.getType().hasSubtype("Vehicle") || state.isBattle()) {
            ptBoxHeight = 2.0f * PT_FONT.getCapHeight();
        }
        textBoxHeight -= 2.0f * PT_FONT.getCapHeight();
        PaperCard paperCard = ImageUtil.getPaperCardFromImageKey(state.getImageKey());
        String artist = "WOTC";
        if (paperCard != null && !paperCard.getArtist().isEmpty()) {
            artist = paperCard.getArtist();
        }
        if (textBoxHeight < (minTextBoxHeight = 2.0f * headerHeight) && textBoxHeight < minTextBoxHeight) {
            artHeight -= minTextBoxHeight - textBoxHeight;
            textBoxHeight = minTextBoxHeight;
            if (artHeight < 0.0f) {
                textBoxHeight += artHeight;
                artHeight = 0.0f;
            }
        }
        if (artHeight > 0.0f) {
            if (isSaga) {
                CardImageRenderer.drawArt(card, g2, x + artInset + artWidth / 2.0f, y, artWidth / 2.0f, artHeight + textBoxHeight, altState, isFaceDown);
            } else if (isClass) {
                CardImageRenderer.drawArt(card, g2, x + artInset, y, artWidth / 2.0f, artHeight + textBoxHeight, altState, isFaceDown);
            } else if (isDungeon) {
                if (drawDungeon) {
                    CardImageRenderer.drawArt(card, g2, x + artInset, y, artWidth, artHeight + textBoxHeight, altState, isFaceDown);
                    y += textBoxHeight;
                }
            } else {
                CardImageRenderer.drawArt(card, g2, x + artInset, y, artWidth, artHeight, altState, isFaceDown);
            }
            y += artHeight;
        }
        if (isSaga) {
            textBoxColors = FSkinColor.tintColors(Color.WHITE, colors, 0.1f);
            CardImageRenderer.drawTextBox(g2, card, state, textBoxColors, x + artInset, y - artHeight, (w - 2.0f * artInset) / 2.0f, textBoxHeight + artHeight, onTop, useCardBGTexture, noText, altState, isFaceDown, canShow, isChoiceList);
            CardImageRenderer.drawTypeLine(g2, state, canShow, headerColors, x, y += textBoxHeight, w, typeBoxHeight, noText, false, false);
            y += typeBoxHeight;
        } else if (isClass) {
            textBoxColors = FSkinColor.tintColors(Color.WHITE, colors, 0.1f);
            CardImageRenderer.drawTextBox(g2, card, state, textBoxColors, x + artInset + artWidth / 2.0f, y - artHeight, (w - 2.0f * artInset) / 2.0f, textBoxHeight + artHeight, onTop, useCardBGTexture, noText, altState, isFaceDown, canShow, isChoiceList);
            CardImageRenderer.drawTypeLine(g2, state, canShow, headerColors, x, y += textBoxHeight, w, typeBoxHeight, noText, false, false);
            y += typeBoxHeight;
        } else if (isDungeon) {
            if (!drawDungeon) {
                textBoxColors = FSkinColor.tintColors(Color.WHITE, colors, 0.1f);
                CardImageRenderer.drawTextBox(g2, card, state, textBoxColors, x + artInset, y - artHeight, w - 2.0f * artInset, textBoxHeight + artHeight, onTop, useCardBGTexture, noText, altState, isFaceDown, canShow, isChoiceList);
                y += textBoxHeight;
            }
            CardImageRenderer.drawTypeLine(g2, state, canShow, headerColors, x, y, w, typeBoxHeight, noText, false, false);
            y += typeBoxHeight;
        } else {
            CardImageRenderer.drawTypeLine(g2, state, canShow, headerColors, x, y, w, typeBoxHeight, noText, false, false);
            textBoxColors = FSkinColor.tintColors(Color.WHITE, colors, 0.1f);
            CardImageRenderer.drawTextBox(g2, card, state, textBoxColors, x + artInset, y += typeBoxHeight, w - 2.0f * artInset, textBoxHeight, onTop, useCardBGTexture, noText, altState, isFaceDown, canShow, isChoiceList);
            y += textBoxHeight;
        }
        if (onTop && ptBoxHeight > 0.0f) {
            Color[] ptColors = FSkinColor.tintColors(Color.WHITE, colors, 0.2f);
            CardImageRenderer.drawPtBox(g2, card, state, ptColors, x, y - 2.0f * artInset, w, ptBoxHeight, noText);
        }
        if (showArtist) {
            g2.drawOutlinedText(artist, TEXT_FONT, Color.WHITE, Color.DARK_GRAY, x + TYPE_FONT.getCapHeight() / 2.0f, y + TYPE_FONT.getCapHeight() / 2.0f, w, h2, false, 8, false);
        }
    }

    private static void drawOutlineColor(Graphics g2, ColorSet colors, float x, float y, float w, float h2) {
        if (colors == null) {
            return;
        }
        switch (colors.countColors()) {
            case 0: {
                g2.drawRect(BORDER_THICKNESS * 2.0f, Color.valueOf("#A0A6A4"), x, y, w, h2);
                break;
            }
            case 1: {
                if (colors.hasBlack()) {
                    g2.drawRect(BORDER_THICKNESS * 2.0f, Color.valueOf("#48494a"), x, y, w, h2);
                    break;
                }
                if (colors.hasGreen()) {
                    g2.drawRect(BORDER_THICKNESS * 2.0f, Color.valueOf("#66cb35"), x, y, w, h2);
                    break;
                }
                if (colors.hasBlue()) {
                    g2.drawRect(BORDER_THICKNESS * 2.0f, Color.valueOf("#62b5f8"), x, y, w, h2);
                    break;
                }
                if (colors.hasRed()) {
                    g2.drawRect(BORDER_THICKNESS * 2.0f, Color.valueOf("#f6532d"), x, y, w, h2);
                    break;
                }
                if (!colors.hasWhite()) break;
                g2.drawRect(BORDER_THICKNESS * 2.0f, Color.valueOf("#EEEBE1"), x, y, w, h2);
                break;
            }
            default: {
                g2.drawRect(BORDER_THICKNESS * 2.0f, Color.valueOf("#F9E084"), x, y, w, h2);
            }
        }
    }

    private static void drawHeader(Graphics g2, CardView card, CardView.CardStateView state, Color[] colors, float x, float y, float w, float h2, boolean noText, boolean isAdventure) {
        float manaSymbolSize;
        float oldAlpha = g2.getfloatAlphaComposite();
        if (isAdventure) {
            g2.setAlphaComposite(0.8f);
        }
        CardImageRenderer.fillColorBackground(g2, colors, x, y, w, h2);
        g2.setAlphaComposite(oldAlpha);
        if (state != null) {
            CardImageRenderer.drawOutlineColor(g2, state.getColors(), x, y, w, h2);
        }
        g2.drawRect(BORDER_THICKNESS, Color.BLACK, x, y, w, h2);
        float padding = h2 / 8.0f;
        float manaCostWidth = 0.0f;
        float f = manaSymbolSize = isAdventure ? MANA_SYMBOL_SIZE * 0.75f : MANA_SYMBOL_SIZE;
        if (!noText && state != null) {
            ManaCost mainManaCost = state.getManaCost();
            if (card.isSplitCard() && card.getAlternateState() != null && !card.isFaceDown() && card.getZone() != ZoneType.Stack && card.getZone() != ZoneType.Battlefield) {
                mainManaCost = card.getLeftSplitState().getManaCost();
                ManaCost otherManaCost = card.getRightSplitState().getManaCost();
                manaCostWidth = CardFaceSymbols.getWidth(otherManaCost, manaSymbolSize) + HEADER_PADDING;
                CardFaceSymbols.drawManaCost(g2, otherManaCost, x + w - manaCostWidth, y + (h2 - manaSymbolSize) / 2.0f, manaSymbolSize);
                g2.drawText("//", NAME_FONT, Color.BLACK, x + w - (manaCostWidth += CardImageRenderer.NAME_FONT.getBounds((CharSequence)"//").width + HEADER_PADDING), y, w, h2, false, 8, true);
            }
            CardFaceSymbols.drawManaCost(g2, mainManaCost, x + w - (manaCostWidth += CardFaceSymbols.getWidth(mainManaCost, manaSymbolSize) + HEADER_PADDING), y + (h2 - manaSymbolSize) / 2.0f, manaSymbolSize);
        }
        x += padding;
        w -= 2.0f * padding;
        if (!noText && state != null) {
            g2.drawText(CardTranslation.getTranslatedName(state.getName()), NAME_FONT, Color.BLACK, x, y, w - manaCostWidth - padding, h2, false, 8, true);
        }
    }

    private static void drawArt(CardView cv, Graphics g2, float x, float y, float w, float h2, boolean altState, boolean isFaceDown) {
        boolean isSaga = cv.getCurrentState().getType().hasSubtype("Saga");
        boolean isClass = cv.getCurrentState().getType().hasSubtype("Class") || cv.getCurrentState().getType().hasSubtype("Case");
        boolean isDungeon = cv.getCurrentState().getType().isDungeon();
        ColorSet colorSet = cv.getCurrentState().getColors();
        if (altState && cv.hasAlternateState()) {
            isSaga = cv.getAlternateState().getType().hasSubtype("Saga");
            isClass = cv.getAlternateState().getType().hasSubtype("Class") || cv.getAlternateState().getType().hasSubtype("Case");
            isDungeon = cv.getAlternateState().getType().isDungeon();
            colorSet = cv.getAlternateState().getColors();
        }
        if (cv == null) {
            Texture cardBack;
            if (isFaceDown && (cardBack = ImageCache.getImage(ImageKeys.getTokenKey("hidden"), false)) != null) {
                g2.drawImage(cardBack, x, y, w, h2);
                return;
            }
            if (isSaga || isClass || isDungeon) {
                g2.drawImage(stretchedArt, x, y, w, h2);
            } else {
                g2.drawImage(forgeArt, x, y, w, h2);
            }
            g2.drawRect(BORDER_THICKNESS, Color.BLACK, x, y, w, h2);
            return;
        }
        if (Forge.enableUIMask.equals("Art")) {
            boolean isHidden;
            FImageComplex cardArt;
            FImageComplex altArt = cardArt = CardRenderer.getCardArt(cv);
            boolean bl = isHidden = cv.getCurrentState().getImageKey().equals(ImageKeys.getTokenKey("hidden")) || cv.getCurrentState().getImageKey().equals(ImageKeys.getTokenKey("foretell"));
            if (cardArt != null) {
                if (isHidden && !altState) {
                    if (isSaga || isClass || isDungeon) {
                        g2.drawImage(stretchedArt, x, y, w, h2);
                    } else {
                        g2.drawImage(forgeArt, x, y, w, h2);
                    }
                } else if (cv.getCurrentState().getImageKey().equals(ImageKeys.getTokenKey("manifest")) && !altState) {
                    altArt = CardRenderer.getAlternateCardArt(ImageKeys.getTokenKey("manifest"), false);
                    g2.drawImage(altArt, x, y, w, h2);
                } else if (cv.getCurrentState().getImageKey().equals(ImageKeys.getTokenKey("morph")) && !altState) {
                    altArt = CardRenderer.getAlternateCardArt(ImageKeys.getTokenKey("morph"), false);
                    g2.drawImage(altArt, x, y, w, h2);
                } else {
                    if (cv.hasAlternateState() && altState) {
                        altArt = cv.getAlternateState().isPlaneswalker() ? CardRenderer.getAlternateCardArt(cv.getAlternateState().getImageKey(), cv.getAlternateState().isPlaneswalker()) : CardRenderer.getCardArt(cv.getAlternateState().getImageKey(), cv.isSplitCard(), cv.getAlternateState().isPlane() || cv.getAlternateState().isPhenomenon(), cv.getText().contains("Aftermath"), cv.getAlternateState().getType().hasSubtype("Saga"), cv.getAlternateState().getType().hasSubtype("Class") || cv.getAlternateState().getType().hasSubtype("Case"), cv.getAlternateState().getType().isDungeon(), cv.isFlipCard(), cv.getAlternateState().isPlaneswalker(), CardRenderer.isModernFrame(cv), cv.getAlternateState().getType().isBattle());
                    }
                    if (cv.isSplitCard()) {
                        CardImageRenderer.drawSplitCard(cv, altArt, g2, x, y, w, h2, altState, isFaceDown);
                    } else if (cv.isFlipCard()) {
                        CardImageRenderer.drawFlipCard(isFaceDown ? altArt : cardArt, g2, x, y, w, h2, altState);
                    } else {
                        g2.drawImage(altArt, x, y, w, h2);
                    }
                }
            } else if (isSaga || isClass || isDungeon) {
                g2.drawImage(stretchedArt, x, y, w, h2);
            } else {
                g2.drawImage(forgeArt, x, y, w, h2);
            }
        } else if (isSaga || isClass || isDungeon) {
            g2.drawImage(stretchedArt, x, y, w, h2);
        } else {
            g2.drawImage(forgeArt, x, y, w, h2);
        }
        CardImageRenderer.drawOutlineColor(g2, colorSet, x, y, w, h2);
        g2.drawRect(BORDER_THICKNESS, Color.BLACK, x, y, w, h2);
    }

    private static void drawSplitCard(CardView card, FImageComplex cardArt, Graphics g2, float x, float y, float w, float h2, boolean altState, boolean isFaceDown) {
        boolean isAftermath;
        if (cardArt.getTexture() == forgeArt.getTexture()) {
            g2.drawImage(cardArt, x, y, w, h2);
            return;
        }
        CardView alt = card.getBackup();
        if (alt == null) {
            alt = card.getAlternateState().getCard();
        }
        CardView cv = altState && isFaceDown ? alt : card;
        boolean bl = isAftermath = altState ? cv.getAlternateState().hasAftermath() : cv.getRightSplitState().hasAftermath();
        if (!isAftermath) {
            CardEdition ed = FModel.getMagicDb().getEditions().get(cv.getCurrentState().getSetCode());
            boolean isOldFrame = ed != null && !ed.isModern();
            float modH = isOldFrame ? cardArt.getHeight() / 12.0f : 0.0f;
            float modW = !isOldFrame ? cardArt.getWidth() / 12.0f : 0.0f;
            float modW2 = !isOldFrame ? cardArt.getWidth() / 6.0f : 0.0f;
            float srcY = cardArt.getHeight() * 13.0f / 354.0f;
            float srcHeight = cardArt.getHeight() * 190.0f / 354.0f;
            float dh = srcHeight * (1.0f - cardArt.getWidth() / srcHeight / 1.302f);
            g2.drawRotatedImage(cardArt.getTexture(), x, y, h2 + modH, w / 2.0f, x + w / 2.0f, y + w / 2.0f, cardArt.getRegionX() + (int)modW, (int)(srcY += dh / 2.0f), (int)(cardArt.getWidth() - modW2), (int)(srcHeight -= dh), -90.0f);
            g2.drawRotatedImage(cardArt.getTexture(), x, y + w / 2.0f, h2 + modH, w / 2.0f, x + w / 2.0f, y + w / 2.0f, cardArt.getRegionX() + (int)modW, (int)cardArt.getHeight() - (int)(srcY + srcHeight), (int)(cardArt.getWidth() - modW2), (int)srcHeight, -90.0f);
            g2.drawLine(BORDER_THICKNESS, Color.BLACK, x + w / 2.0f, y, x + w / 2.0f, y + h2);
        } else {
            FImageComplex secondArt = CardRenderer.getAftermathSecondCardArt(cv.getCurrentState().getImageKey());
            g2.drawRotatedImage(cardArt.getTexture(), x, y, w, h2 / 2.0f, x + w, y + h2 / 2.0f, cardArt.getRegionX(), cardArt.getRegionY(), (int)cardArt.getWidth(), (int)cardArt.getHeight() / 2, 0.0f);
            g2.drawRotatedImage(secondArt.getTexture(), x - h2 / 2.0f, y + h2 / 2.0f, h2 / 2.0f, w, x, y + h2 / 2.0f, secondArt.getRegionX(), secondArt.getRegionY(), (int)secondArt.getWidth(), (int)secondArt.getHeight(), 90.0f);
            g2.drawLine(BORDER_THICKNESS, Color.BLACK, x, y + h2 / 2.0f, x + w, y + h2 / 2.0f);
        }
    }

    private static void drawFlipCard(FImageComplex cardArt, Graphics g2, float x, float y, float w, float h2, boolean altState) {
        if (altState) {
            g2.drawRotatedImage(cardArt.getTextureRegion(), x, y, w, h2, x + w / 2.0f, y + h2 / 2.0f, 180.0f);
        } else {
            g2.drawImage(cardArt, x, y, w, h2);
        }
    }

    private static void drawTypeLine(Graphics g2, CardView.CardStateView state, boolean canShow, Color[] colors, float x, float y, float w, float h2, boolean noText, boolean noRarity, boolean isAdventure) {
        float oldAlpha = g2.getfloatAlphaComposite();
        if (isAdventure) {
            g2.setAlphaComposite(0.6f);
        }
        CardImageRenderer.fillColorBackground(g2, colors, x, y, w, h2);
        g2.setAlphaComposite(oldAlpha);
        if (state != null) {
            CardImageRenderer.drawOutlineColor(g2, state.getColors(), x, y, w, h2);
        }
        g2.drawRect(BORDER_THICKNESS, Color.BLACK, x, y, w, h2);
        float padding = h2 / 8.0f;
        if (!noRarity && state != null) {
            float iconSize = h2 * 0.9f;
            float iconPadding = (h2 - iconSize) / 2.0f;
            w -= iconSize + iconPadding * 2.0f;
            if (state.getRarity() == null) {
                g2.drawImage(FSkinImage.SET_SPECIAL, x + w + iconPadding, y + (h2 - iconSize) / 2.0f, iconSize, iconSize);
            } else if (state.getRarity() == CardRarity.Special) {
                g2.drawImage(FSkinImage.SET_SPECIAL, x + w + iconPadding, y + (h2 - iconSize) / 2.0f, iconSize, iconSize);
            } else if (state.getRarity() == CardRarity.MythicRare) {
                g2.drawImage(FSkinImage.SET_MYTHIC, x + w + iconPadding, y + (h2 - iconSize) / 2.0f, iconSize, iconSize);
            } else if (state.getRarity() == CardRarity.Rare) {
                g2.drawImage(FSkinImage.SET_RARE, x + w + iconPadding, y + (h2 - iconSize) / 2.0f, iconSize, iconSize);
            } else if (state.getRarity() == CardRarity.Uncommon) {
                g2.drawImage(FSkinImage.SET_UNCOMMON, x + w + iconPadding, y + (h2 - iconSize) / 2.0f, iconSize, iconSize);
            } else {
                g2.drawImage(FSkinImage.SET_COMMON, x + w + iconPadding, y + (h2 - iconSize) / 2.0f, iconSize, iconSize);
            }
        }
        if (noText) {
            return;
        }
        x += padding;
        if (state != null) {
            g2.drawText(CardDetailUtil.formatCardType(state, canShow), TYPE_FONT, Color.BLACK, x, y, w, h2, false, 8, true);
        }
    }

    private static void drawTextBox(Graphics g2, CardView card, CardView.CardStateView state, Color[] colors, float x, float y, float w, float h2, boolean onTop, boolean useCardBGTexture, boolean noText, boolean altstate, boolean isFacedown, boolean canShow, boolean isChoiceList) {
        if (card.isAdventureCard()) {
            Color[] altcolors = FSkinColor.tintColors(Color.WHITE, CardImageRenderer.fillColorBackground(g2, CardDetailUtil.getBorderColors(card.getState(true), canShow), x, y, w, h2), 0.2f);
            if (isFacedown && !altstate || card.getZone() == ZoneType.Stack || isChoiceList || altstate) {
                CardImageRenderer.setTextBox(g2, card, state, colors, x, y, w, h2, onTop, useCardBGTexture, noText, 0.0f, 0.0f, false, altstate, isFacedown);
            } else {
                float typeBoxHeight = 2.0f * TYPE_FONT.getCapHeight();
                CardImageRenderer.drawHeader(g2, card, card.getState(true), altcolors, x, y, w - w / 2.0f, typeBoxHeight, noText, true);
                CardImageRenderer.drawTypeLine(g2, card.getState(true), canShow, altcolors, x, y + typeBoxHeight, w - w / 2.0f, typeBoxHeight, noText, true, true);
                float mod = typeBoxHeight + typeBoxHeight;
                CardImageRenderer.setTextBox(g2, card, card.getState(true), altcolors, x, y + mod, w - w / 2.0f, h2 - mod, onTop, useCardBGTexture, noText, typeBoxHeight, typeBoxHeight, true, altstate, isFacedown);
                CardImageRenderer.setTextBox(g2, card, state, colors, x + w / 2.0f, y, w - w / 2.0f, h2, onTop, useCardBGTexture, noText, 0.0f, 0.0f, false, altstate, isFacedown);
            }
        } else {
            CardImageRenderer.setTextBox(g2, card, state, colors, x, y, w, h2, onTop, useCardBGTexture, noText, 0.0f, 0.0f, false, altstate, isFacedown);
        }
    }

    private static void setTextBox(Graphics g2, CardView card, CardView.CardStateView state, Color[] colors, float x, float y, float w, float h2, boolean onTop, boolean useCardBGTexture, boolean noText, float adventureHeaderHeight, float adventureTypeHeight, boolean drawAdventure, boolean altstate, boolean isFaceDown) {
        boolean fakeDuals = false;
        if (state != null && state.isLand()) {
            float oldAlpha;
            CardDetailUtil.DetailColors modColors = CardDetailUtil.DetailColors.WHITE;
            if (state.isBasicLand()) {
                if (state.isForest()) {
                    modColors = CardDetailUtil.DetailColors.GREEN;
                } else if (state.isIsland()) {
                    modColors = CardDetailUtil.DetailColors.BLUE;
                } else if (state.isMountain()) {
                    modColors = CardDetailUtil.DetailColors.RED;
                } else if (state.isSwamp()) {
                    modColors = CardDetailUtil.DetailColors.BLACK;
                } else if (state.isPlains()) {
                    modColors = CardDetailUtil.DetailColors.LAND;
                }
            }
            if (state.origCanProduceColoredMana() == 2) {
                Color[] colorPairs = new Color[]{CardImageRenderer.fromDetailColor(CardDetailUtil.DetailColors.WHITE), CardImageRenderer.fromDetailColor(CardDetailUtil.DetailColors.WHITE)};
                if (state.origProduceAnyMana()) {
                    colorPairs[0] = CardImageRenderer.fromDetailColor(CardDetailUtil.DetailColors.MULTICOLOR);
                    colorPairs[1] = CardImageRenderer.fromDetailColor(CardDetailUtil.DetailColors.MULTICOLOR);
                } else {
                    fakeDuals = true;
                    if (state.origProduceManaW() && state.origProduceManaU()) {
                        colorPairs[0] = CardImageRenderer.fromDetailColor(CardDetailUtil.DetailColors.LAND);
                        colorPairs[1] = CardImageRenderer.fromDetailColor(CardDetailUtil.DetailColors.BLUE);
                    } else if (state.origProduceManaW() && state.origProduceManaB()) {
                        colorPairs[0] = CardImageRenderer.fromDetailColor(CardDetailUtil.DetailColors.LAND);
                        colorPairs[1] = CardImageRenderer.fromDetailColor(CardDetailUtil.DetailColors.BLACK);
                    } else if (state.origProduceManaW() && state.origProduceManaR()) {
                        colorPairs[0] = CardImageRenderer.fromDetailColor(CardDetailUtil.DetailColors.LAND);
                        colorPairs[1] = CardImageRenderer.fromDetailColor(CardDetailUtil.DetailColors.RED);
                    } else if (state.origProduceManaW() && state.origProduceManaG()) {
                        colorPairs[0] = CardImageRenderer.fromDetailColor(CardDetailUtil.DetailColors.LAND);
                        colorPairs[1] = CardImageRenderer.fromDetailColor(CardDetailUtil.DetailColors.GREEN);
                    } else if (state.origProduceManaU() && state.origProduceManaB()) {
                        colorPairs[0] = CardImageRenderer.fromDetailColor(CardDetailUtil.DetailColors.BLUE);
                        colorPairs[1] = CardImageRenderer.fromDetailColor(CardDetailUtil.DetailColors.BLACK);
                    } else if (state.origProduceManaU() && state.origProduceManaR()) {
                        colorPairs[0] = CardImageRenderer.fromDetailColor(CardDetailUtil.DetailColors.BLUE);
                        colorPairs[1] = CardImageRenderer.fromDetailColor(CardDetailUtil.DetailColors.RED);
                    } else if (state.origProduceManaU() && state.origProduceManaG()) {
                        colorPairs[0] = CardImageRenderer.fromDetailColor(CardDetailUtil.DetailColors.BLUE);
                        colorPairs[1] = CardImageRenderer.fromDetailColor(CardDetailUtil.DetailColors.GREEN);
                    } else if (state.origProduceManaB() && state.origProduceManaR()) {
                        colorPairs[0] = CardImageRenderer.fromDetailColor(CardDetailUtil.DetailColors.BLACK);
                        colorPairs[1] = CardImageRenderer.fromDetailColor(CardDetailUtil.DetailColors.RED);
                    } else if (state.origProduceManaB() && state.origProduceManaG()) {
                        colorPairs[0] = CardImageRenderer.fromDetailColor(CardDetailUtil.DetailColors.BLACK);
                        colorPairs[1] = CardImageRenderer.fromDetailColor(CardDetailUtil.DetailColors.GREEN);
                    } else if (state.origProduceManaR() && state.origProduceManaG()) {
                        colorPairs[0] = CardImageRenderer.fromDetailColor(CardDetailUtil.DetailColors.RED);
                        colorPairs[1] = CardImageRenderer.fromDetailColor(CardDetailUtil.DetailColors.GREEN);
                    }
                }
                colorPairs = FSkinColor.tintColors(Color.WHITE, colorPairs, 0.3f);
                oldAlpha = g2.getfloatAlphaComposite();
                if (!useCardBGTexture) {
                    CardImageRenderer.fillColorBackground(g2, colorPairs, x, y, w, h2);
                } else {
                    g2.setAlphaComposite(0.95f);
                    CardImageRenderer.fillColorBackground(g2, colorPairs, x, y, w, h2);
                    if (fakeDuals && state.countBasicLandTypes() == 2) {
                        g2.setAlphaComposite(0.1f);
                        CardImageRenderer.drawAlphaLines(g2, x, y, w, h2);
                    }
                    g2.setAlphaComposite(oldAlpha);
                }
            } else {
                if (state.origCanProduceColoredMana() > 2 || state.origProduceAnyMana()) {
                    modColors = CardDetailUtil.DetailColors.MULTICOLOR;
                } else if (state.origCanProduceColoredMana() == 1) {
                    if (state.origProduceManaW()) {
                        modColors = CardDetailUtil.DetailColors.LAND;
                    } else if (state.origProduceManaB()) {
                        modColors = CardDetailUtil.DetailColors.BLACK;
                    } else if (state.origProduceManaG()) {
                        modColors = CardDetailUtil.DetailColors.GREEN;
                    } else if (state.origProduceManaR()) {
                        modColors = CardDetailUtil.DetailColors.RED;
                    } else if (state.origProduceManaU()) {
                        modColors = CardDetailUtil.DetailColors.BLUE;
                    }
                }
                Color bgColor = CardImageRenderer.fromDetailColor(modColors);
                bgColor = FSkinColor.tintColor(Color.WHITE, bgColor, 0.2f);
                oldAlpha = g2.getfloatAlphaComposite();
                if (!useCardBGTexture) {
                    g2.fillRect(bgColor, x, y, w, h2);
                } else {
                    g2.setAlphaComposite(0.95f);
                    g2.fillRect(bgColor, x, y, w, h2);
                    g2.setAlphaComposite(oldAlpha);
                }
            }
        } else {
            float oldAlpha = g2.getfloatAlphaComposite();
            if (!useCardBGTexture) {
                CardImageRenderer.fillColorBackground(g2, colors, x, y, w, h2);
            } else {
                g2.setAlphaComposite(0.95f);
                CardImageRenderer.fillColorBackground(g2, colors, x, y, w, h2);
                g2.setAlphaComposite(oldAlpha);
            }
        }
        if (state != null) {
            CardImageRenderer.drawOutlineColor(g2, state.getColors(), x, y, w, h2);
        }
        g2.drawRect(BORDER_THICKNESS, Color.BLACK, x, y, w, h2);
        if (!onTop) {
            return;
        }
        if (state != null && state.isBasicLand()) {
            FSkinImage image = null;
            if (state.origCanProduceColoredMana() == 1 && !state.origProduceManaC()) {
                if (state.isPlains()) {
                    image = FSkinImage.WATERMARK_W;
                } else if (state.isIsland()) {
                    image = FSkinImage.WATERMARK_U;
                } else if (state.isSwamp()) {
                    image = FSkinImage.WATERMARK_B;
                } else if (state.isMountain()) {
                    image = FSkinImage.WATERMARK_R;
                } else if (state.isForest()) {
                    image = FSkinImage.WATERMARK_G;
                }
            } else if (state.origProduceManaC()) {
                image = FSkinImage.WATERMARK_C;
            }
            if (image != null) {
                float iconSize = h2 * 0.75f;
                g2.drawImage(image, x + (w - iconSize) / 2.0f, y + (h2 - iconSize) / 2.0f, iconSize, iconSize);
            }
        } else {
            boolean needTranslation = true;
            String text = "";
            if (card.isToken() && card.getCloneOrigin() == null) {
                needTranslation = false;
            }
            if (drawAdventure) {
                if (noText) {
                    return;
                }
                if (card.isAdventureCard()) {
                    CardView cv = card.getBackup();
                    if (cv == null || isFaceDown) {
                        cv = card;
                    }
                    CardView.CardStateView csv = cv.getState(true);
                    text = cv.getText(csv, needTranslation ? CardTranslation.getTranslationTexts(csv) : null);
                } else {
                    text = !card.isSplitCard() ? card.getText(state, needTranslation ? (state == null ? null : CardTranslation.getTranslationTexts(state)) : null) : card.getText(state, needTranslation ? CardTranslation.getTranslationTexts(card.getLeftSplitState(), card.getRightSplitState()) : null);
                }
            } else {
                if (noText) {
                    return;
                }
                if (card.isAdventureCard()) {
                    CardView cv = card.getBackup();
                    if (cv == null || isFaceDown) {
                        cv = card;
                    }
                    CardView.CardStateView csv = cv.getState(false);
                    text = cv.getText(csv, needTranslation ? CardTranslation.getTranslationTexts(csv) : null);
                } else {
                    String string = !card.isSplitCard() ? card.getText(state, needTranslation ? (state == null ? null : CardTranslation.getTranslationTexts(state)) : null) : (text = card.getText(state, needTranslation ? CardTranslation.getTranslationTexts(card.getLeftSplitState(), card.getRightSplitState()) : null));
                }
            }
            if (StringUtils.isEmpty(text)) {
                return;
            }
            float padding = TEXT_FONT.getCapHeight() * 0.75f;
            cardTextRenderer.drawText(g2, text, TEXT_FONT, Color.BLACK, x += padding, y += padding, w -= 2.0f * padding, h2 -= 2.0f * padding, y, h2, true, 8, true);
        }
    }

    private static void drawAlphaLines(Graphics g2, float x, float y, float w, float h2) {
        g2.drawImage(Forge.getAssets().getTexture(FSkin.getDefaultSkinFile("overlay_alpha.png")), x, y, w, h2);
    }

    private static void drawPtBox(Graphics g2, CardView card, CardView.CardStateView state, Color[] colors, float x, float y, float w, float h2, boolean noText) {
        ArrayList<String> pieces = new ArrayList<String>();
        if (state.isCreature()) {
            pieces.add(String.valueOf(state.getPower()));
            pieces.add("/");
            pieces.add(String.valueOf(state.getToughness()));
        } else if (state.isPlaneswalker()) {
            pieces.add(String.valueOf(state.getLoyalty()));
        } else if (state.getType().hasSubtype("Vehicle")) {
            pieces.add("[");
            pieces.add(String.valueOf(state.getPower()));
            pieces.add("/");
            pieces.add(String.valueOf(state.getToughness()));
            pieces.add("]");
        } else if (state.isBattle()) {
            pieces.add(String.valueOf(state.getDefense()));
        } else {
            return;
        }
        float padding = Math.round(PT_FONT.getCapHeight() / 4.0f);
        float totalPieceWidth = -padding;
        float[] pieceWidths = new float[pieces.size()];
        for (int i = 0; i < pieces.size(); ++i) {
            float pieceWidth;
            pieceWidths[i] = pieceWidth = CardImageRenderer.PT_FONT.getBounds((CharSequence)((CharSequence)pieces.get((int)i))).width + padding;
            totalPieceWidth += pieceWidth;
        }
        float boxHeight = PT_FONT.getCapHeight() + PT_FONT.getAscent() + 3.0f * padding;
        float boxWidth = Math.max(PT_BOX_WIDTH, totalPieceWidth + 2.0f * padding);
        x += w - boxWidth;
        y += h2 - boxHeight;
        w = boxWidth;
        h2 = boxHeight;
        CardImageRenderer.fillColorBackground(g2, colors, x, y, w, h2);
        if (state != null) {
            CardImageRenderer.drawOutlineColor(g2, state.getColors(), x, y, w, h2);
        }
        g2.drawRect(BORDER_THICKNESS, Color.BLACK, x, y, w, h2);
        if (noText) {
            return;
        }
        x += (boxWidth - totalPieceWidth) / 2.0f;
        for (int i = 0; i < pieces.size(); ++i) {
            g2.drawText((String)pieces.get(i), PT_FONT, Color.BLACK, x, y, w, h2, false, 8, true);
            x += pieceWidths[i];
        }
    }

    public static void drawZoom(Graphics g2, CardView card, GameView gameView, boolean altState, float x, float y, float w, float h2, float dispW, float dispH, boolean isCurrentCard) {
        boolean canshow = MatchController.instance.mayView(card);
        String key = card.getState(altState).getImageKey();
        Texture image = new CachedCardImageRenderer(key).getImage();
        FImage sleeves = MatchController.getPlayerSleeve(card.getOwner());
        if (image == null) {
            CardImageRenderer.drawDetails(g2, card, gameView, altState, x, y, w, h2);
            return;
        }
        if (card.isImmutable() && FModel.getPreferences().getPrefBoolean(ForgePreferences.FPref.UI_DISABLE_IMAGES_EFFECT_CARDS)) {
            CardImageRenderer.drawDetails(g2, card, gameView, altState, x, y, w, h2);
            return;
        }
        if (image == ImageCache.getDefaultImage() || Forge.enableUIMask.equals("Art")) {
            CardImageRenderer.drawCardImage(g2, card, altState, x, y, w, h2, CardRenderer.CardStackPosition.Top, true, true);
        } else {
            float minusxy;
            float radius = (h2 - w) / 8.0f;
            float wh_Adj = ForgeConstants.isGdxPortLandscape && isCurrentCard ? 1.38f : 1.0f;
            float new_w = w * wh_Adj;
            float new_h = h2 * wh_Adj;
            float new_x = ForgeConstants.isGdxPortLandscape && isCurrentCard ? (dispW - new_w) / 2.0f : x;
            float new_y = ForgeConstants.isGdxPortLandscape && isCurrentCard ? (dispH - new_h) / 2.0f : y;
            float new_xRotate = (dispW - new_h) / 2.0f;
            float new_yRotate = (dispH - new_w) / 2.0f;
            boolean rotateSplit = FModel.getPreferences().getPrefBoolean(ForgePreferences.FPref.UI_ROTATE_SPLIT_CARDS);
            boolean rotatePlane = FModel.getPreferences().getPrefBoolean(ForgePreferences.FPref.UI_ROTATE_PLANE_OR_PHENOMENON);
            float croppedArea = CardRenderer.isModernFrame(card) ? 0.96f : 0.97f;
            float f = minusxy = CardRenderer.isModernFrame(card) ? 0.0f : 0.13f * radius;
            if (card.getCurrentState().getSetCode().equals("LEA") || card.getCurrentState().getSetCode().equals("LEB")) {
                croppedArea = 0.975f;
                minusxy = 0.135f * radius;
            }
            if (rotatePlane && (card.getCurrentState().isPhenomenon() || card.getCurrentState().isPlane() || card.getCurrentState().isBattle() && !altState || card.getAlternateState() != null && card.getAlternateState().isBattle() && altState)) {
                if (Forge.enableUIMask.equals("Full")) {
                    if (image.toString().contains(".fullborder.")) {
                        g2.drawCardRoundRect(image, new_x, new_y, new_w, new_h, new_x + new_w / 2.0f, new_y + new_h / 2.0f, -90.0f);
                    } else {
                        g2.drawRotatedImage(FSkin.getBorders().get(0), new_x, new_y, new_w, new_h, new_x + new_w / 2.0f, new_y + new_h / 2.0f, -90.0f);
                        g2.drawRotatedImage(ImageCache.croppedBorderImage(image), new_x + radius / 2.0f - minusxy, new_y + radius / 2.0f - minusxy, new_w * croppedArea, new_h * croppedArea, new_x + radius / 2.0f - minusxy + new_w * croppedArea / 2.0f, new_y + radius / 2.0f - minusxy + new_h * croppedArea / 2.0f, -90.0f);
                    }
                } else if (Forge.enableUIMask.equals("Crop")) {
                    g2.drawRotatedImage(ImageCache.croppedBorderImage(image), new_x, new_y, new_w, new_h, new_x + new_w / 2.0f, new_y + new_h / 2.0f, -90.0f);
                } else {
                    g2.drawRotatedImage(image, new_x, new_y, new_w, new_h, new_x + new_w / 2.0f, new_y + new_h / 2.0f, -90.0f);
                }
            } else if (rotateSplit && isCurrentCard && card.isSplitCard() && canshow && !card.isFaceDown()) {
                boolean isAftermath;
                boolean bl = isAftermath = card.getText().contains("Aftermath") || card.getAlternateState().getOracleText().contains("Aftermath");
                if (Forge.enableUIMask.equals("Full")) {
                    if (image.toString().contains(".fullborder.")) {
                        g2.drawCardRoundRect(image, new_x, new_y, new_w, new_h, new_x + new_w / 2.0f, new_y + new_h / 2.0f, isAftermath ? 90.0f : -90.0f);
                    } else {
                        g2.drawRotatedImage(FSkin.getBorders().get(ImageCache.getFSkinBorders(card)), new_x, new_y, new_w, new_h, new_x + new_w / 2.0f, new_y + new_h / 2.0f, isAftermath ? 90.0f : -90.0f);
                        g2.drawRotatedImage(ImageCache.croppedBorderImage(image), new_x + radius / 2.0f - minusxy, new_y + radius / 2.0f - minusxy, new_w * croppedArea, new_h * croppedArea, new_x + radius / 2.0f - minusxy + new_w * croppedArea / 2.0f, new_y + radius / 2.0f - minusxy + new_h * croppedArea / 2.0f, isAftermath ? 90.0f : -90.0f);
                    }
                } else if (Forge.enableUIMask.equals("Crop")) {
                    g2.drawRotatedImage(ImageCache.croppedBorderImage(image), new_x, new_y, new_w, new_h, new_x + new_w / 2.0f, new_y + new_h / 2.0f, isAftermath ? 90.0f : -90.0f);
                } else {
                    g2.drawRotatedImage(image, new_x, new_y, new_w, new_h, new_x + new_w / 2.0f, new_y + new_h / 2.0f, isAftermath ? 90.0f : -90.0f);
                }
            } else if (card.isFaceDown() && ZoneType.Exile.equals((Object)card.getZone())) {
                if (card.isForeTold() || altState) {
                    if (card.isSplitCard() && rotateSplit && isCurrentCard) {
                        boolean isAftermath;
                        boolean bl = isAftermath = card.getText().contains("Aftermath") || card.getAlternateState().getOracleText().contains("Aftermath");
                        if (Forge.enableUIMask.equals("Full")) {
                            if (image.toString().contains(".fullborder.")) {
                                g2.drawCardRoundRect(image, new_x, new_y, new_w, new_h, new_x + new_w / 2.0f, new_y + new_h / 2.0f, isAftermath ? 90.0f : -90.0f);
                            } else {
                                g2.drawRotatedImage(FSkin.getBorders().get(ImageCache.getFSkinBorders(card)), new_x, new_y, new_w, new_h, new_x + new_w / 2.0f, new_y + new_h / 2.0f, isAftermath ? 90.0f : -90.0f);
                                g2.drawRotatedImage(ImageCache.croppedBorderImage(image), new_x + radius / 2.0f - minusxy, new_y + radius / 2.0f - minusxy, new_w * croppedArea, new_h * croppedArea, new_x + radius / 2.0f - minusxy + new_w * croppedArea / 2.0f, new_y + radius / 2.0f - minusxy + new_h * croppedArea / 2.0f, isAftermath ? 90.0f : -90.0f);
                            }
                        } else if (Forge.enableUIMask.equals("Crop")) {
                            g2.drawRotatedImage(ImageCache.croppedBorderImage(image), new_x, new_y, new_w, new_h, new_x + new_w / 2.0f, new_y + new_h / 2.0f, isAftermath ? 90.0f : -90.0f);
                        } else {
                            g2.drawRotatedImage(image, new_x, new_y, new_w, new_h, new_x + new_w / 2.0f, new_y + new_h / 2.0f, isAftermath ? 90.0f : -90.0f);
                        }
                    } else if (Forge.enableUIMask.equals("Full")) {
                        if (image.toString().contains(".fullborder.")) {
                            g2.drawCardRoundRect(image, null, x, y, w, h2, false, false);
                        } else {
                            g2.drawImage(ImageCache.getBorderImage(image.toString()), ImageCache.borderColor(image), x, y, w, h2);
                            g2.drawImage(ImageCache.croppedBorderImage(image), x + radius / 2.4f - minusxy, y + radius / 2.0f - minusxy, w * croppedArea, h2 * croppedArea);
                        }
                    } else if (Forge.enableUIMask.equals("Crop")) {
                        g2.drawImage(ImageCache.croppedBorderImage(image), x, y, w, h2);
                    } else {
                        g2.drawImage(image, x, y, w, h2);
                    }
                } else {
                    g2.drawImage(sleeves, x, y, w, h2);
                }
            } else if (Forge.enableUIMask.equals("Full") && canshow) {
                if (image.toString().contains(".fullborder.")) {
                    g2.drawCardRoundRect(image, null, x, y, w, h2, false, false);
                } else {
                    g2.drawImage(ImageCache.getBorderImage(image.toString()), ImageCache.borderColor(image), x, y, w, h2);
                    g2.drawImage(ImageCache.croppedBorderImage(image), x + radius / 2.4f - minusxy, y + radius / 2.0f - minusxy, w * croppedArea, h2 * croppedArea);
                }
            } else if (Forge.enableUIMask.equals("Crop") && canshow) {
                g2.drawImage(ImageCache.croppedBorderImage(image), x, y, w, h2);
            } else if (canshow) {
                g2.drawImage(image, x, y, w, h2);
            } else {
                g2.drawImage(sleeves, x, y, w, h2);
            }
        }
        CardRenderer.drawFoilEffect(g2, card, x, y, w, h2, isCurrentCard && canshow && image != ImageCache.getDefaultImage());
    }

    public static void drawDetails(Graphics g2, CardView card, GameView gameView, boolean altState, float x, float y, float w, float h2) {
        CardImageRenderer.updateStaticFields(w, h2);
        float blackBorderThickness = w * 0.021f;
        g2.fillRect(Color.BLACK, x, y, w, h2);
        CardView.CardStateView state = card.getState(altState);
        boolean canShow = MatchController.instance.mayView(card);
        boolean isFaceDown = card.isFaceDown();
        List<CardDetailUtil.DetailColors> borderColors = isFaceDown ? ImmutableList.of(CardDetailUtil.DetailColors.FACE_DOWN) : CardDetailUtil.getBorderColors(state, canShow);
        Color[] colors = Forge.allowCardBG ? CardImageRenderer.drawCardBackgroundTexture(state, g2, !altState ? borderColors : CardDetailUtil.getBorderColors(state, canShow), x += blackBorderThickness, y, w -= 2.0f * blackBorderThickness, h2) : CardImageRenderer.fillColorBackground(g2, borderColors, x, y += blackBorderThickness, w, h2 -= 2.0f * blackBorderThickness);
        Color idForeColor = FSkinColor.getHighContrastColor(colors[0]);
        float outerBorderThickness = 2.0f * blackBorderThickness;
        float cardNameBoxHeight = Math.max(MANA_SYMBOL_SIZE + 2.0f * HEADER_PADDING, 2.0f * NAME_FONT.getCapHeight()) + 2.0f * TYPE_FONT.getCapHeight() + 2.0f;
        Color[] nameBoxColors = FSkinColor.tintColors(Color.WHITE, colors, 0.2f);
        CardImageRenderer.drawDetailsNameBox(g2, card, state, canShow, nameBoxColors, x += outerBorderThickness, y += outerBorderThickness, w -= 2.0f * outerBorderThickness, cardNameBoxHeight);
        float innerBorderThickness = outerBorderThickness / 2.0f;
        float ptBoxHeight = 2.0f * PT_FONT.getCapHeight();
        float textBoxHeight = h2 - cardNameBoxHeight - ptBoxHeight - outerBorderThickness - 3.0f * innerBorderThickness;
        Color[] textBoxColors = FSkinColor.tintColors(Color.WHITE, colors, 0.1f);
        CardImageRenderer.drawDetailsTextBox(g2, state, gameView, canShow, textBoxColors, x, y += cardNameBoxHeight + innerBorderThickness, w, textBoxHeight);
        Color[] ptColors = FSkinColor.tintColors(Color.WHITE, colors, 0.2f);
        CardImageRenderer.drawDetailsIdAndPtBox(g2, card, state, canShow, idForeColor, ptColors, x, y += textBoxHeight + innerBorderThickness, w, ptBoxHeight);
    }

    public static Color[] fillColorBackground(Graphics g2, List<CardDetailUtil.DetailColors> backColors, float x, float y, float w, float h2) {
        Color[] colors = new Color[backColors.size()];
        for (int i = 0; i < colors.length; ++i) {
            CardDetailUtil.DetailColors dc = backColors.get(i);
            colors[i] = CardImageRenderer.fromDetailColor(dc);
        }
        CardImageRenderer.fillColorBackground(g2, colors, x, y, w, h2);
        return colors;
    }

    public static Color[] drawCardBackgroundTexture(CardView.CardStateView state, Graphics g2, List<CardDetailUtil.DetailColors> backColors, float x, float y, float w, float h2) {
        boolean isHybrid = state.getManaCost().hasMultiColor();
        boolean isPW = state.isPlaneswalker();
        boolean isNyx = state.isNyx();
        Color[] colors = new Color[backColors.size()];
        for (int i = 0; i < colors.length; ++i) {
            CardDetailUtil.DetailColors dc = backColors.get(i);
            colors[i] = CardImageRenderer.fromDetailColor(dc);
        }
        switch (backColors.size()) {
            case 1: {
                if (backColors.get(0) == CardDetailUtil.DetailColors.FACE_DOWN) {
                    g2.drawImage(FSkinTexture.CARDBG_C, x, y, w, h2);
                    break;
                }
                if (backColors.get(0) == CardDetailUtil.DetailColors.LAND) {
                    g2.drawImage(isPW ? FSkinTexture.PWBG_C : FSkinTexture.CARDBG_L, x, y, w, h2);
                    break;
                }
                if (backColors.get(0) == CardDetailUtil.DetailColors.MULTICOLOR) {
                    if (state.isVehicle()) {
                        g2.drawImage(FSkinTexture.CARDBG_V, x, y, w, h2);
                        break;
                    }
                    if (isNyx) {
                        g2.drawImage(FSkinTexture.NYX_M, x, y, w, h2);
                        break;
                    }
                    if (state.isArtifact() && !isPW) {
                        g2.drawImage(FSkinTexture.CARDBG_A, x, y, w, h2);
                        break;
                    }
                    g2.drawImage(isPW ? FSkinTexture.PWBG_M : FSkinTexture.CARDBG_M, x, y, w, h2);
                    break;
                }
                if (backColors.get(0) == CardDetailUtil.DetailColors.COLORLESS) {
                    if (state.isVehicle()) {
                        g2.drawImage(FSkinTexture.CARDBG_V, x, y, w, h2);
                        break;
                    }
                    if (isPW) {
                        g2.drawImage(FSkinTexture.PWBG_C, x, y, w, h2);
                        break;
                    }
                    if (isNyx) {
                        g2.drawImage(FSkinTexture.NYX_C, x, y, w, h2);
                        break;
                    }
                    if (state.isArtifact()) {
                        g2.drawImage(FSkinTexture.CARDBG_A, x, y, w, h2);
                        break;
                    }
                    g2.drawImage(FSkinTexture.CARDBG_C, x, y, w, h2);
                    break;
                }
                if (backColors.get(0) == CardDetailUtil.DetailColors.GREEN) {
                    if (state.isVehicle()) {
                        g2.drawImage(FSkinTexture.CARDBG_V, x, y, w, h2);
                        break;
                    }
                    if (isNyx) {
                        g2.drawImage(FSkinTexture.NYX_G, x, y, w, h2);
                        break;
                    }
                    if (state.isArtifact() && !isPW) {
                        g2.drawImage(FSkinTexture.CARDBG_A, x, y, w, h2);
                        break;
                    }
                    g2.drawImage(isPW ? FSkinTexture.PWBG_G : FSkinTexture.CARDBG_G, x, y, w, h2);
                    break;
                }
                if (backColors.get(0) == CardDetailUtil.DetailColors.RED) {
                    if (state.isVehicle()) {
                        g2.drawImage(FSkinTexture.CARDBG_V, x, y, w, h2);
                        break;
                    }
                    if (isNyx) {
                        g2.drawImage(FSkinTexture.NYX_R, x, y, w, h2);
                        break;
                    }
                    if (state.isArtifact() && !isPW) {
                        g2.drawImage(FSkinTexture.CARDBG_A, x, y, w, h2);
                        break;
                    }
                    g2.drawImage(isPW ? FSkinTexture.PWBG_R : FSkinTexture.CARDBG_R, x, y, w, h2);
                    break;
                }
                if (backColors.get(0) == CardDetailUtil.DetailColors.BLACK) {
                    if (state.isVehicle()) {
                        g2.drawImage(FSkinTexture.CARDBG_V, x, y, w, h2);
                        break;
                    }
                    if (isNyx) {
                        g2.drawImage(FSkinTexture.NYX_B, x, y, w, h2);
                        break;
                    }
                    if (state.isArtifact() && !isPW) {
                        g2.drawImage(FSkinTexture.CARDBG_A, x, y, w, h2);
                        break;
                    }
                    g2.drawImage(isPW ? FSkinTexture.PWBG_B : FSkinTexture.CARDBG_B, x, y, w, h2);
                    break;
                }
                if (backColors.get(0) == CardDetailUtil.DetailColors.BLUE) {
                    if (state.isVehicle()) {
                        g2.drawImage(FSkinTexture.CARDBG_V, x, y, w, h2);
                        break;
                    }
                    if (isNyx) {
                        g2.drawImage(FSkinTexture.NYX_U, x, y, w, h2);
                        break;
                    }
                    if (state.isArtifact() && !isPW) {
                        g2.drawImage(FSkinTexture.CARDBG_A, x, y, w, h2);
                        break;
                    }
                    g2.drawImage(isPW ? FSkinTexture.PWBG_U : FSkinTexture.CARDBG_U, x, y, w, h2);
                    break;
                }
                if (backColors.get(0) != CardDetailUtil.DetailColors.WHITE) break;
                if (state.isVehicle()) {
                    g2.drawImage(FSkinTexture.CARDBG_V, x, y, w, h2);
                    break;
                }
                if (isNyx) {
                    g2.drawImage(FSkinTexture.NYX_W, x, y, w, h2);
                    break;
                }
                if (state.isArtifact() && !isPW) {
                    g2.drawImage(FSkinTexture.CARDBG_A, x, y, w, h2);
                    break;
                }
                g2.drawImage(isPW ? FSkinTexture.PWBG_W : FSkinTexture.CARDBG_W, x, y, w, h2);
                break;
            }
            case 2: {
                if (state.isVehicle()) {
                    g2.drawImage(FSkinTexture.CARDBG_V, x, y, w, h2);
                    break;
                }
                if (isNyx) {
                    g2.drawImage(FSkinTexture.NYX_M, x, y, w, h2);
                    break;
                }
                if (state.isArtifact() && !isPW) {
                    g2.drawImage(FSkinTexture.CARDBG_A, x, y, w, h2);
                    break;
                }
                if (!isHybrid) {
                    g2.drawImage(isPW ? FSkinTexture.PWBG_M : FSkinTexture.CARDBG_M, x, y, w, h2);
                    break;
                }
                if (backColors.contains((Object)CardDetailUtil.DetailColors.WHITE) && backColors.contains((Object)CardDetailUtil.DetailColors.BLUE)) {
                    g2.drawImage(isPW ? FSkinTexture.PWBG_WU : FSkinTexture.CARDBG_WU, x, y, w, h2);
                    break;
                }
                if (backColors.contains((Object)CardDetailUtil.DetailColors.WHITE) && backColors.contains((Object)CardDetailUtil.DetailColors.BLACK)) {
                    g2.drawImage(isPW ? FSkinTexture.PWBG_WB : FSkinTexture.CARDBG_WB, x, y, w, h2);
                    break;
                }
                if (backColors.contains((Object)CardDetailUtil.DetailColors.WHITE) && backColors.contains((Object)CardDetailUtil.DetailColors.RED)) {
                    g2.drawImage(isPW ? FSkinTexture.PWBG_WR : FSkinTexture.CARDBG_WR, x, y, w, h2);
                    break;
                }
                if (backColors.contains((Object)CardDetailUtil.DetailColors.WHITE) && backColors.contains((Object)CardDetailUtil.DetailColors.GREEN)) {
                    g2.drawImage(isPW ? FSkinTexture.PWBG_WG : FSkinTexture.CARDBG_WG, x, y, w, h2);
                    break;
                }
                if (backColors.contains((Object)CardDetailUtil.DetailColors.BLUE) && backColors.contains((Object)CardDetailUtil.DetailColors.BLACK)) {
                    g2.drawImage(isPW ? FSkinTexture.PWBG_UB : FSkinTexture.CARDBG_UB, x, y, w, h2);
                    break;
                }
                if (backColors.contains((Object)CardDetailUtil.DetailColors.BLUE) && backColors.contains((Object)CardDetailUtil.DetailColors.RED)) {
                    g2.drawImage(isPW ? FSkinTexture.PWBG_UR : FSkinTexture.CARDBG_UR, x, y, w, h2);
                    break;
                }
                if (backColors.contains((Object)CardDetailUtil.DetailColors.BLUE) && backColors.contains((Object)CardDetailUtil.DetailColors.GREEN)) {
                    g2.drawImage(isPW ? FSkinTexture.PWBG_UG : FSkinTexture.CARDBG_UG, x, y, w, h2);
                    break;
                }
                if (backColors.contains((Object)CardDetailUtil.DetailColors.BLACK) && backColors.contains((Object)CardDetailUtil.DetailColors.RED)) {
                    g2.drawImage(isPW ? FSkinTexture.PWBG_BR : FSkinTexture.CARDBG_BR, x, y, w, h2);
                    break;
                }
                if (backColors.contains((Object)CardDetailUtil.DetailColors.BLACK) && backColors.contains((Object)CardDetailUtil.DetailColors.GREEN)) {
                    g2.drawImage(isPW ? FSkinTexture.PWBG_BG : FSkinTexture.CARDBG_BG, x, y, w, h2);
                    break;
                }
                if (!backColors.contains((Object)CardDetailUtil.DetailColors.RED) || !backColors.contains((Object)CardDetailUtil.DetailColors.GREEN)) break;
                g2.drawImage(isPW ? FSkinTexture.PWBG_RG : FSkinTexture.CARDBG_RG, x, y, w, h2);
                break;
            }
            case 3: {
                if (state.isVehicle()) {
                    g2.drawImage(FSkinTexture.CARDBG_V, x, y, w, h2);
                    break;
                }
                if (isNyx) {
                    g2.drawImage(FSkinTexture.NYX_M, x, y, w, h2);
                    break;
                }
                if (state.isArtifact() && !isPW) {
                    g2.drawImage(FSkinTexture.CARDBG_A, x, y, w, h2);
                    break;
                }
                g2.drawImage(isPW ? FSkinTexture.PWBG_M : FSkinTexture.CARDBG_M, x, y, w, h2);
                break;
            }
            default: {
                if (state.isVehicle()) {
                    g2.drawImage(FSkinTexture.CARDBG_V, x, y, w, h2);
                    break;
                }
                if (isNyx) {
                    g2.drawImage(FSkinTexture.NYX_C, x, y, w, h2);
                    break;
                }
                if (state.isArtifact() && !isPW) {
                    g2.drawImage(FSkinTexture.CARDBG_A, x, y, w, h2);
                    break;
                }
                g2.drawImage(isPW ? FSkinTexture.PWBG_C : FSkinTexture.CARDBG_C, x, y, w, h2);
            }
        }
        return colors;
    }

    public static void fillColorBackground(Graphics g2, Color[] colors, float x, float y, float w, float h2) {
        switch (colors.length) {
            case 1: {
                g2.fillRect(colors[0], x, y, w, h2);
                break;
            }
            case 2: {
                g2.fillGradientRect(colors[0], colors[1], false, x, y, w, h2);
                break;
            }
            case 3: {
                float halfWidth = w / 2.0f;
                g2.fillGradientRect(colors[0], colors[1], false, x, y, halfWidth, h2);
                g2.fillGradientRect(colors[1], colors[2], false, x + halfWidth, y, halfWidth, h2);
            }
        }
    }

    private static void drawDetailsNameBox(Graphics g2, CardView card, CardView.CardStateView state, boolean canShow, Color[] colors, float x, float y, float w, float h2) {
        CardImageRenderer.fillColorBackground(g2, colors, x, y, w, h2);
        g2.drawRect(BORDER_THICKNESS, Color.BLACK, x, y, w, h2);
        float padding = h2 / 8.0f;
        h2 = Math.max(MANA_SYMBOL_SIZE + 2.0f * HEADER_PADDING, 2.0f * NAME_FONT.getCapHeight());
        float manaCostWidth = 0.0f;
        if (canShow) {
            ManaCost mainManaCost = state.getManaCost();
            if (card.isSplitCard() && card.hasAlternateState() && !card.isFaceDown() && card.getZone() != ZoneType.Stack && card.getZone() != ZoneType.Battlefield) {
                mainManaCost = card.getLeftSplitState().getManaCost();
                ManaCost otherManaCost = card.getAlternateState().getManaCost();
                manaCostWidth = CardFaceSymbols.getWidth(otherManaCost, MANA_SYMBOL_SIZE) + HEADER_PADDING;
                CardFaceSymbols.drawManaCost(g2, otherManaCost, x + w - manaCostWidth, y + (h2 - MANA_SYMBOL_SIZE) / 2.0f, MANA_SYMBOL_SIZE);
                g2.drawText("//", NAME_FONT, Color.BLACK, x + w - (manaCostWidth += CardImageRenderer.NAME_FONT.getBounds((CharSequence)"//").width + HEADER_PADDING), y, w, h2, false, 8, true);
            }
            CardFaceSymbols.drawManaCost(g2, mainManaCost, x + w - (manaCostWidth += CardFaceSymbols.getWidth(mainManaCost, MANA_SYMBOL_SIZE) + HEADER_PADDING), y + (h2 - MANA_SYMBOL_SIZE) / 2.0f, MANA_SYMBOL_SIZE);
        }
        g2.drawText(CardDetailUtil.formatCardName(card, canShow, state == card.getAlternateState()), NAME_FONT, Color.BLACK, x += padding, y, (w -= 2.0f * padding) - manaCostWidth - padding, h2, false, 8, true);
        y += h2;
        h2 = 2.0f * TYPE_FONT.getCapHeight();
        String set = state.getSetCode();
        CardRarity rarity = state.getRarity();
        if (!canShow) {
            set = CardEdition.UNKNOWN.getCode();
            rarity = CardRarity.Unknown;
        }
        if (!StringUtils.isEmpty(set)) {
            float setWidth = CardRenderer.getSetWidth(TYPE_FONT, set);
            CardRenderer.drawSetLabel(g2, TYPE_FONT, set, rarity, x + w + padding - setWidth - HEADER_PADDING + CardRenderer.SET_BOX_MARGIN, y + CardRenderer.SET_BOX_MARGIN, setWidth, h2 - CardRenderer.SET_BOX_MARGIN);
            w -= setWidth;
        }
        g2.drawText(CardDetailUtil.formatCardType(state, canShow), TYPE_FONT, Color.BLACK, x, y, w, h2, false, 8, true);
    }

    private static void drawDetailsTextBox(Graphics g2, CardView.CardStateView state, GameView gameView, boolean canShow, Color[] colors, float x, float y, float w, float h2) {
        CardImageRenderer.fillColorBackground(g2, colors, x, y, w, h2);
        g2.drawRect(BORDER_THICKNESS, Color.BLACK, x, y, w, h2);
        float padX = TEXT_FONT.getCapHeight() / 2.0f;
        float padY = padX + Utils.scale(2.0f);
        cardTextRenderer.drawText(g2, CardDetailUtil.composeCardText(state, gameView, canShow), TEXT_FONT, Color.BLACK, x += padX, y += padY, w -= 2.0f * padX, h2 -= 2.0f * padY, y, h2, true, 8, false);
    }

    private static void drawDetailsIdAndPtBox(Graphics g2, CardView card, CardView.CardStateView state, boolean canShow, Color idForeColor, Color[] colors, float x, float y, float w, float h2) {
        String ptText;
        float idWidth = 0.0f;
        if (canShow) {
            String idText = CardDetailUtil.formatCardId(state);
            g2.drawText(idText, TYPE_FONT, idForeColor, x, y + TYPE_FONT.getCapHeight() / 2.0f, w, h2, false, 8, false);
            idWidth = CardImageRenderer.TYPE_FONT.getBounds((CharSequence)idText).width;
        }
        if (StringUtils.isEmpty(ptText = CardDetailUtil.formatPrimaryCharacteristic(state, canShow))) {
            return;
        }
        TextBounds bounds = cardTextRenderer.getBounds(ptText, PT_FONT);
        float padding = PT_FONT.getCapHeight() / 2.0f;
        float boxWidth = Math.min(bounds.width + 2.0f * padding, w - idWidth - padding);
        x += w - boxWidth;
        w = boxWidth;
        CardImageRenderer.fillColorBackground(g2, colors, x, y, w, h2);
        g2.drawRect(BORDER_THICKNESS, Color.BLACK, x, y, w, h2);
        cardTextRenderer.drawText(g2, ptText, PT_FONT, Color.BLACK, x, y, w, h2, y, h2, false, 1, true);
    }

    static {
        final float logoWidth = FSkinImage.LOGO.getWidth();
        final float logoHeight = FSkinImage.LOGO.getHeight();
        float h2 = logoHeight * 1.1f;
        float w = h2 * 1.302f;
        forgeArt = new FBufferedImage(w, h2){

            @Override
            protected void draw(Graphics g2, float w, float h2) {
                g2.drawImage(Forge.isMobileAdventureMode ? FSkinTexture.ADV_BG_TEXTURE : FSkinTexture.BG_TEXTURE, 0.0f, 0.0f, w, h2);
                g2.fillRect(FScreen.getTextureOverlayColor(), 0.0f, 0.0f, w, h2);
                g2.drawImage(FSkinImage.LOGO, (w - logoWidth) / 2.0f, (h2 - logoHeight) / 2.0f, logoWidth, logoHeight);
            }
        };
        stretchedArt = new FBufferedImage(w, h2){

            @Override
            protected void draw(Graphics g2, float w, float h2) {
                g2.drawImage(Forge.isMobileAdventureMode ? FSkinTexture.ADV_BG_TEXTURE : FSkinTexture.BG_TEXTURE, 0.0f, 0.0f, w, h2);
                g2.fillRect(FScreen.getTextureOverlayColor(), 0.0f, 0.0f, w, h2);
                g2.drawImage(FSkinImage.LOGO, (w - logoWidth) / 2.0f, (h2 - logoHeight) / 2.0f + h2 / 3.5f, logoWidth, logoHeight / 3.0f);
            }
        };
        cardTextRenderer = new TextRenderer(true);
    }

    static class CachedCardImageRenderer
    extends CachedCardImage {
        public CachedCardImageRenderer(String key) {
            super(key);
        }

        @Override
        public void onImageFetched() {
            ImageCache.clear();
        }
    }
}

