/*
 * Decompiled with CFR 0.152.
 */
package forge.card;

import com.badlogic.gdx.graphics.Texture;
import forge.Forge;
import forge.Graphics;
import forge.assets.FImage;
import forge.assets.ImageCache;
import forge.card.CardImageRenderer;
import forge.card.CardRenderer;
import forge.game.card.CardView;
import forge.item.PaperCard;

public class CardImage
implements FImage {
    private final PaperCard card;
    private Texture image;

    public CardImage(PaperCard card0) {
        this.card = card0;
    }

    @Override
    public float getWidth() {
        if (this.image != null) {
            return this.image.getWidth();
        }
        return ImageCache.getDefaultImage().getWidth();
    }

    @Override
    public float getHeight() {
        return this.getWidth() * 1.4f;
    }

    @Override
    public void draw(Graphics g2, float x, float y, float w, float h2) {
        if (this.image == null) {
            this.image = ImageCache.getImage(this.card);
            if (this.image == null) {
                if (!Forge.enableUIMask.equals("Off")) {
                    CardImageRenderer.drawCardImage(g2, CardView.getCardForUi(this.card), false, x, y, w, h2, CardRenderer.CardStackPosition.Top, Forge.enableUIMask.equals("Art"), true);
                }
                return;
            }
        }
        if (this.image == ImageCache.getDefaultImage() || Forge.enableUIMask.equals("Art")) {
            CardImageRenderer.drawCardImage(g2, CardView.getCardForUi(this.card), false, x, y, w, h2, CardRenderer.CardStackPosition.Top, true, true);
        } else if (Forge.enableUIMask.equals("Full")) {
            if (this.image.toString().contains(".fullborder.")) {
                g2.drawCardRoundRect(this.image, null, x, y, w, h2, false, false);
            } else {
                float radius = (h2 - w) / 8.0f;
                g2.drawborderImage(ImageCache.borderColor(this.image), x, y, w, h2);
                g2.drawImage(ImageCache.croppedBorderImage(this.image), x + radius / 2.2f, y + radius / 2.0f, w * 0.96f, h2 * 0.96f);
            }
        } else if (Forge.enableUIMask.equals("Crop")) {
            g2.drawImage(ImageCache.croppedBorderImage(this.image), x, y, w, h2);
        } else {
            g2.drawImage(this.image, x, y, w, h2);
        }
    }
}

