/*
 * Decompiled with CFR 0.152.
 */
package forge.card;

import com.google.common.base.Predicate;
import forge.card.CardType;
import forge.card.ICardFace;
import forge.card.mana.ManaCost;

public final class CardFacePredicates {
    public static Predicate<ICardFace> coreType(boolean isEqual, CardType.CoreType type) {
        return new PredicateCoreType(type, isEqual);
    }

    public static Predicate<ICardFace> superType(boolean isEqual, CardType.Supertype type) {
        return new PredicateSuperType(type, isEqual);
    }

    public static Predicate<ICardFace> cmc(int value) {
        return input -> {
            ManaCost cost = input.getManaCost();
            return cost != null && cost.getCMC() == value;
        };
    }

    public static Predicate<ICardFace> valid(String val) {
        return new ValidPredicate(val);
    }

    public static class Presets {
        public static final Predicate<ICardFace> IS_BASIC_LAND = subject -> subject.getType().isBasicLand();
        public static final Predicate<ICardFace> IS_NONBASIC_LAND = subject -> subject.getType().isLand() && !subject.getType().isBasicLand();
        public static final Predicate<ICardFace> IS_CREATURE = CardFacePredicates.coreType(true, CardType.CoreType.Creature);
        public static final Predicate<ICardFace> IS_LEGENDARY = CardFacePredicates.superType(true, CardType.Supertype.Legendary);
        public static final Predicate<ICardFace> IS_NON_LAND = CardFacePredicates.coreType(false, CardType.CoreType.Land);
    }

    static class ValidPredicate
    implements Predicate<ICardFace> {
        private String valid;

        public ValidPredicate(String valid) {
            this.valid = valid;
        }

        @Override
        public boolean apply(ICardFace input) {
            String[] k = this.valid.split("\\.", 2);
            if (!"Card".equals(k[0]) && ("Permanent".equals(k[0]) ? input.getType().isInstant() || input.getType().isSorcery() : !input.getType().hasStringType(k[0]))) {
                return false;
            }
            if (k.length > 1) {
                for (String m4 : k[1].split("\\+")) {
                    int i;
                    String manaCost;
                    if (!(m4.contains("ManaCost") ? !ValidPredicate.hasManaCost(input, manaCost = m4.substring(8)) : (m4.contains("cmcEQ") ? !ValidPredicate.hasCMC(input, i = Integer.parseInt(m4.substring(5))) : !ValidPredicate.hasProperty(input, m4)))) continue;
                    return false;
                }
            }
            return true;
        }

        protected static boolean hasProperty(ICardFace input, String v) {
            if (v.startsWith("non")) {
                return !ValidPredicate.hasProperty(input, v.substring(3));
            }
            return input.getType().hasStringType(v);
        }

        protected static boolean hasManaCost(ICardFace input, String mC) {
            return mC.equals(input.getManaCost().getShortString());
        }

        protected static boolean hasCMC(ICardFace input, int value) {
            ManaCost cost = input.getManaCost();
            return cost != null && cost.getCMC() == value;
        }
    }

    private static class PredicateSuperType
    implements Predicate<ICardFace> {
        private final CardType.Supertype operand;
        private final boolean shouldBeEqual;

        @Override
        public boolean apply(ICardFace face) {
            return this.shouldBeEqual == face.getType().hasSupertype(this.operand);
        }

        public PredicateSuperType(CardType.Supertype type, boolean wantEqual) {
            this.operand = type;
            this.shouldBeEqual = wantEqual;
        }
    }

    private static class PredicateCoreType
    implements Predicate<ICardFace> {
        private final CardType.CoreType operand;
        private final boolean shouldBeEqual;

        @Override
        public boolean apply(ICardFace face) {
            if (null == face) {
                return false;
            }
            return this.shouldBeEqual == face.getType().hasType(this.operand);
        }

        public PredicateCoreType(CardType.CoreType type, boolean wantEqual) {
            this.operand = type;
            this.shouldBeEqual = wantEqual;
        }
    }
}

