/*
 * Decompiled with CFR 0.152.
 */
package forge.assets;

import com.badlogic.gdx.graphics.Color;
import forge.Forge;
import forge.Graphics;
import forge.assets.FSkinColor;
import forge.assets.FSkinFont;
import forge.assets.FSkinImageInterface;
import forge.localinstance.properties.ForgePreferences;
import forge.model.FModel;
import forge.util.TextBounds;
import java.text.BreakIterator;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class TextRenderer {
    private final boolean parseReminderText;
    private String fullText = "";
    private float width;
    private float height;
    private float totalHeight;
    private FSkinFont baseFont;
    private FSkinFont font;
    private boolean wrap;
    private boolean needClip;
    private List<Piece> pieces = new ArrayList<Piece>();
    private List<Float> lineWidths = new ArrayList<Float>();
    private BreakIterator boundary = BreakIterator.getLineInstance(new Locale(Forge.locale));

    public static String startColor(Color color) {
        return "<clr " + Color.rgba8888(color) + ">";
    }

    public static String endColor() {
        return "</clr>";
    }

    public TextRenderer() {
        this(false);
    }

    public TextRenderer(boolean parseReminderText0) {
        this.parseReminderText = parseReminderText0;
    }

    /*
     * Unable to fully structure code
     */
    private void updatePieces(FSkinFont font0) {
        this.pieces.clear();
        this.lineWidths.clear();
        this.font = font0;
        this.needClip = false;
        if (this.fullText == null || this.fullText.isEmpty()) {
            return;
        }
        this.totalHeight = this.font.getCapHeight();
        if (this.totalHeight > this.height) {
            if (this.font.canShrink()) {
                this.updatePieces(this.font.shrink());
                return;
            }
            this.needClip = true;
        }
        this.boundary.setText(this.fullText);
        prefs = FModel.getPreferences();
        hideReminderText = prefs != null && prefs.getPrefBoolean(ForgePreferences.FPref.UI_HIDE_REMINDER_TEXT) != false;
        x = 0.0f;
        y = 0.0f;
        pieceWidth = 0.0f;
        lineHeight = this.font.getLineHeight();
        nextSpaceIdx = this.boundary.first();
        lastSpaceIdx = -1;
        lineNum = 0;
        text = new StringBuilder();
        inSymbolCount = 0;
        consecutiveSymbols = 0;
        inKeywordCount = 0;
        atReminderTextEnd = false;
        inReminderTextCount = 0;
        colorOverride = null;
        block25: for (i = 0; i < this.fullText.length(); ++i) {
            atReminderTextEnd = false;
            if (i == nextSpaceIdx) {
                lastSpaceIdx = text.length();
                nextSpaceIdx = this.boundary.next();
            }
            try {
                ch = this.fullText.charAt(i);
            }
            catch (StringIndexOutOfBoundsException e) {
                ch = '\u0000';
            }
            switch (ch) {
                case '\r': {
                    continue block25;
                }
                case '\n': {
                    if (inSymbolCount > 0) {
                        inSymbolCount = 0;
                        text.insert(0, '{');
                    }
                    this.lineWidths.add(Float.valueOf(x + pieceWidth));
                    if (text.length() > 0) {
                        this.addPiece(new TextPiece(text.toString(), colorOverride, inReminderTextCount > 0), lineNum, x, y, pieceWidth, lineHeight);
                        pieceWidth = 0.0f;
                        text.setLength(0);
                        consecutiveSymbols = 0;
                    }
                    lastSpaceIdx = -1;
                    x = 0.0f;
                    y += lineHeight;
                    this.totalHeight += lineHeight;
                    ++lineNum;
                    if (!(this.totalHeight > this.height)) continue block25;
                    if (this.font.canShrink()) {
                        this.updatePieces(this.font.shrink());
                        return;
                    }
                    this.needClip = true;
                    continue block25;
                }
                case '{': {
                    if (inSymbolCount == 0 && text.length() > 0) {
                        this.addPiece(new TextPiece(text.toString(), colorOverride, inReminderTextCount > 0), lineNum, x, y, pieceWidth, lineHeight);
                        x += pieceWidth;
                        pieceWidth = 0.0f;
                        text.setLength(0);
                        lastSpaceIdx = -1;
                        consecutiveSymbols = 0;
                    }
                    ++inSymbolCount;
                    continue block25;
                }
                case '}': {
                    if (inSymbolCount > 0) {
                        --inSymbolCount;
                        if (text.length() > 0 && (symbol = Forge.getAssets().symbolLookup().get(text.toString().replace("/", ""))) != null) {
                            pieceWidth = lineHeight * 0.85f;
                            if (x + pieceWidth > this.width) {
                                if (this.wrap) {
                                    y += lineHeight;
                                    this.totalHeight += lineHeight;
                                    ++lineNum;
                                    if (this.totalHeight > this.height) {
                                        if (this.font.canShrink()) {
                                            this.updatePieces(this.font.shrink());
                                            return;
                                        }
                                        this.needClip = true;
                                    }
                                    if (consecutiveSymbols == 0) {
                                        this.lineWidths.add(Float.valueOf(x));
                                        x = 0.0f;
                                    } else {
                                        x = 0.0f;
                                        startSymbolIdx = this.pieces.size() - consecutiveSymbols;
                                        this.lineWidths.add(Float.valueOf(this.pieces.get((int)startSymbolIdx).x));
                                        for (j = startSymbolIdx; j < this.pieces.size(); ++j) {
                                            piece = this.pieces.get(j);
                                            piece.x = x;
                                            piece.y += lineHeight;
                                            ++piece.lineNum;
                                            x += piece.w;
                                        }
                                    }
                                } else {
                                    if (this.font.canShrink()) {
                                        this.updatePieces(this.font.shrink());
                                        return;
                                    }
                                    this.needClip = true;
                                }
                            }
                            this.addPiece(new SymbolPiece(symbol, inReminderTextCount > 0), lineNum, x, y - this.font.getAscent() + (lineHeight - pieceWidth) / 2.0f, pieceWidth, pieceWidth);
                            x += pieceWidth;
                            pieceWidth = 0.0f;
                            text.setLength(0);
                            lastSpaceIdx = -1;
                            ++consecutiveSymbols;
                            continue block25;
                        }
                        if (!hideReminderText || inReminderTextCount == 0) {
                            text.insert(0, '{');
                            if (lastSpaceIdx >= 0) {
                                ++lastSpaceIdx;
                            }
                        }
                    }
                    ** GOTO lbl232
                }
                case '<': {
                    if (inSymbolCount > 0) {
                        inSymbolCount = 0;
                        text.insert(0, '{');
                        if (lastSpaceIdx >= 0) {
                            ++lastSpaceIdx;
                        }
                    }
                    if (inKeywordCount == 0 && text.length() > 0) {
                        this.addPiece(new TextPiece(text.toString(), colorOverride, false), lineNum, x, y, pieceWidth, lineHeight);
                        x += pieceWidth;
                        pieceWidth = 0.0f;
                        text.setLength(0);
                        lastSpaceIdx = -1;
                        consecutiveSymbols = 0;
                    }
                    ++inKeywordCount;
                    ** GOTO lbl232
                }
                case '>': {
                    if (inSymbolCount > 0) {
                        inSymbolCount = 0;
                        text.insert(0, '{');
                        if (lastSpaceIdx >= 0) {
                            ++lastSpaceIdx;
                        }
                    }
                    if (inKeywordCount <= 0) ** GOTO lbl232
                    try {
                        if (--inKeywordCount == 0 && text.length() > 0) {
                            text.deleteCharAt(0);
                            if (text.charAt(0) == '/') {
                                keyword = text.substring(1);
                                value = null;
                            } else {
                                idx = text.indexOf(" ");
                                if (idx != -1) {
                                    keyword = text.substring(0, idx);
                                    value = text.substring(idx + 1);
                                } else {
                                    keyword = text.toString();
                                    value = null;
                                }
                            }
                            validKeyword = true;
                            piece = keyword;
                            var24_42 = -1;
                            switch (piece.hashCode()) {
                                case 98601: {
                                    if (!piece.equals("clr")) break;
                                    var24_42 = 0;
                                    break;
                                }
                                case 3536714: {
                                    if (!piece.equals("span")) break;
                                    var24_42 = 1;
                                }
                            }
                            switch (var24_42) {
                                case 0: {
                                    colorOverride = value != null ? new Color(Integer.parseInt(value)) : null;
                                    break;
                                }
                                case 1: {
                                    if (value != null && value.contains("color:")) {
                                        startIdx = value.indexOf(58) + 1;
                                        colorName = value.substring(startIdx, endIdx = value.indexOf(59));
                                        if (!colorName.equals("gray")) break;
                                        colorOverride = Color.GRAY;
                                        break;
                                    }
                                    colorOverride = null;
                                    break;
                                }
                                default: {
                                    validKeyword = false;
                                }
                            }
                            if (validKeyword) {
                                text.setLength(0);
                                lastSpaceIdx = -1;
                                continue block25;
                            }
                        }
                        ** GOTO lbl232
                    }
                    catch (Exception keyword) {
                        ** GOTO lbl232
                    }
                }
                case '(': {
                    if (inSymbolCount > 0) {
                        inSymbolCount = 0;
                        text.insert(0, '{');
                        if (lastSpaceIdx >= 0) {
                            ++lastSpaceIdx;
                        }
                    }
                    if (this.parseReminderText) {
                        if (inReminderTextCount == 0 && text.length() > 0) {
                            this.addPiece(new TextPiece(text.toString(), colorOverride, false), lineNum, x, y, pieceWidth, lineHeight);
                            x += pieceWidth;
                            pieceWidth = 0.0f;
                            text.setLength(0);
                            lastSpaceIdx = -1;
                            consecutiveSymbols = 0;
                        }
                        ++inReminderTextCount;
                    }
                    ** GOTO lbl232
                }
                case ')': {
                    if (inSymbolCount > 0) {
                        inSymbolCount = 0;
                        text.insert(0, '{');
                        if (lastSpaceIdx >= 0) {
                            ++lastSpaceIdx;
                        }
                    }
                    if (inReminderTextCount > 0 && --inReminderTextCount == 0) {
                        atReminderTextEnd = true;
                    }
                    ** GOTO lbl232
                }
                case ' ': {
                    if (inKeywordCount == 0 && inSymbolCount > 0) {
                        inSymbolCount = 0;
                        text.insert(0, '{');
                        if (lastSpaceIdx >= 0) {
                            ++lastSpaceIdx;
                        }
                    }
                }
lbl232:
                // 13 sources

                default: {
                    if (hideReminderText && (inReminderTextCount > 0 || atReminderTextEnd)) continue block25;
                    text.append(ch);
                    if (inSymbolCount != 0 || inKeywordCount != 0) continue block25;
                    pieceWidth = this.font.getBounds((CharSequence)text).width;
                    if (!(x + pieceWidth > this.width)) ** GOTO lbl340
                    if (!this.wrap || lastSpaceIdx < 0 && consecutiveSymbols <= 0) ** GOTO lbl278
                    if (lastSpaceIdx < 0) {
                        x = 0.0f;
                        startSymbolIdx = this.pieces.size() - consecutiveSymbols;
                        this.lineWidths.add(Float.valueOf(this.pieces.get((int)startSymbolIdx).x));
                        for (j = startSymbolIdx; j < this.pieces.size(); ++j) {
                            piece = this.pieces.get(j);
                            piece.x = x;
                            piece.y += lineHeight;
                            ++piece.lineNum;
                            x += piece.w;
                        }
                    } else {
                        endIdx = lastSpaceIdx;
                        if (lastSpaceIdx > 0 && text.charAt(lastSpaceIdx - 1) == ' ') {
                            endIdx = lastSpaceIdx - 1;
                        }
                        if (!(currentLineText = text.substring(0, endIdx)).isEmpty()) {
                            pieceWidth = this.font.getBounds((CharSequence)currentLineText).width;
                            this.addPiece(new TextPiece(currentLineText, colorOverride, inReminderTextCount > 0 || atReminderTextEnd != false), lineNum, x, y, pieceWidth, lineHeight);
                            consecutiveSymbols = 0;
                        } else {
                            pieceWidth = 0.0f;
                        }
                        this.lineWidths.add(Float.valueOf(x + pieceWidth));
                        text.delete(0, lastSpaceIdx);
                        x = 0.0f;
                    }
                    lastSpaceIdx = -1;
                    pieceWidth = text.length() == 0 ? 0.0f : this.font.getBounds((CharSequence)text).width;
                    y += lineHeight;
                    this.totalHeight += lineHeight;
                    ++lineNum;
                    if (this.totalHeight > this.height) {
                        if (this.font.canShrink()) {
                            this.updatePieces(this.font.shrink());
                            return;
                        }
                        this.needClip = true;
                    }
                    ** GOTO lbl340
lbl278:
                    // 1 sources

                    if (!(x > 0.0f) || !(pieceWidth <= this.width)) ** GOTO lbl336
                    for (lastPieceIdx = this.pieces.size() - 1; lastPieceIdx >= 0; --lastPieceIdx) {
                        lastPiece = this.pieces.get(lastPieceIdx);
                        if (lastPiece.lineNum < lineNum) {
                            lastPieceIdx = this.pieces.size() - 1;
                            break;
                        }
                        if (!(lastPiece instanceof TextPiece) || (index = TextPiece.access$200(textPiece = (TextPiece)lastPiece).lastIndexOf(32)) == -1) continue;
                        if (index == 0) {
                            TextPiece.access$202(textPiece, TextPiece.access$200(textPiece).substring(1));
                            textPiece.w = this.font.getBounds((CharSequence)TextPiece.access$200((TextPiece)textPiece)).width;
                            --lastPieceIdx;
                            break;
                        }
                        if (index == TextPiece.access$200(textPiece).length() - 1) {
                            TextPiece.access$202(textPiece, TextPiece.access$200(textPiece).substring(0, TextPiece.access$200(textPiece).length() - 1));
                            textPiece.w = this.font.getBounds((CharSequence)TextPiece.access$200((TextPiece)textPiece)).width;
                            break;
                        }
                        splitPiece = new TextPiece(TextPiece.access$200(textPiece).substring(index + 1), TextPiece.access$300(textPiece), textPiece.inReminderText);
                        TextPiece.access$202(textPiece, TextPiece.access$200(textPiece).substring(0, index));
                        textPiece.w = this.font.getBounds((CharSequence)TextPiece.access$200((TextPiece)textPiece)).width;
                        splitPiece.x = textPiece.x + textPiece.w;
                        splitPiece.y = textPiece.y;
                        splitPiece.w = this.font.getBounds((CharSequence)TextPiece.access$200((TextPiece)splitPiece)).width;
                        splitPiece.h = textPiece.h;
                        break;
                    }
                    if (lastPieceIdx < 0) ** GOTO lbl331
                    try {
                        lastPiece = this.pieces.get(lastPieceIdx);
                        this.lineWidths.add(Float.valueOf(lastPiece.x + lastPiece.w));
                        x = 0.0f;
                        size = this.pieces.size();
                        for (j = lastPieceIdx + 1; j < size; ++j) {
                            piece = this.pieces.get(j);
                            piece.x = x;
                            piece.y += lineHeight;
                            ++piece.lineNum;
                            x += piece.w;
                        }
                        y += lineHeight;
                        this.totalHeight += lineHeight;
                        ++lineNum;
                        if (this.totalHeight > this.height) {
                            if (this.font.canShrink()) {
                                this.updatePieces(this.font.shrink());
                                return;
                            }
                            this.needClip = true;
                        }
                        ** GOTO lbl340
                    }
                    catch (Exception var21_31) {}
                    ** GOTO lbl340
lbl331:
                    // 1 sources

                    if (this.font.canShrink()) {
                        this.updatePieces(this.font.shrink());
                        return;
                    }
                    this.needClip = true;
                    ** GOTO lbl340
lbl336:
                    // 1 sources

                    if (this.font.canShrink()) {
                        this.updatePieces(this.font.shrink());
                        return;
                    }
                    this.needClip = true;
lbl340:
                    // 7 sources

                    if (!atReminderTextEnd || text.length() <= 0) continue block25;
                    this.addPiece(new TextPiece(text.toString(), colorOverride, true), lineNum, x, y, pieceWidth, lineHeight);
                    x += pieceWidth;
                    pieceWidth = 0.0f;
                    text.setLength(0);
                    lastSpaceIdx = -1;
                    consecutiveSymbols = 0;
                }
            }
        }
        this.lineWidths.add(Float.valueOf(x + pieceWidth));
        if (text.length() > 0) {
            this.addPiece(new TextPiece(text.toString(), colorOverride, inReminderTextCount > 0), lineNum, x, y, pieceWidth, lineHeight);
            consecutiveSymbols = 0;
        }
    }

    private void addPiece(Piece piece, int lineNum, float x, float y, float w, float h2) {
        piece.lineNum = lineNum;
        piece.x = x;
        piece.y = y;
        piece.w = w;
        piece.h = h2;
        this.pieces.add(piece);
    }

    private void setProps(String text, FSkinFont skinFont, float w, float h2, boolean wrap0) {
        boolean needUpdate = false;
        if (this.fullText == null) {
            this.fullText = text;
            needUpdate = true;
        } else if (!this.fullText.equals(text)) {
            this.fullText = text;
            needUpdate = true;
        }
        if (skinFont != this.baseFont) {
            this.baseFont = skinFont;
            needUpdate = true;
        }
        if (this.width != w) {
            this.width = w;
            needUpdate = true;
        }
        if (this.height != h2) {
            this.height = h2;
            needUpdate = true;
        }
        if (this.wrap != wrap0) {
            this.wrap = wrap0;
            needUpdate = true;
        }
        if (needUpdate) {
            this.updatePieces(this.baseFont);
        }
    }

    private TextBounds getCurrentBounds() {
        float maxWidth = 0.0f;
        for (Float lineWidth : this.lineWidths) {
            if (!(lineWidth.floatValue() > maxWidth)) continue;
            maxWidth = lineWidth.floatValue();
        }
        TextBounds bounds = new TextBounds();
        bounds.width = maxWidth;
        bounds.height = this.totalHeight;
        return bounds;
    }

    public TextBounds getBounds(String text, FSkinFont skinFont) {
        this.setProps(text, skinFont, Float.MAX_VALUE, Float.MAX_VALUE, false);
        return this.getCurrentBounds();
    }

    public TextBounds getWrappedBounds(String text, FSkinFont skinFont, float maxWidth) {
        this.setProps(text, skinFont, maxWidth, Float.MAX_VALUE, true);
        return this.getCurrentBounds();
    }

    public void drawText(Graphics g2, String text, FSkinFont skinFont, FSkinColor skinColor, float x, float y, float w, float h2, float visibleStartY, float visibleHeight, boolean wrap0, int horzAlignment, boolean centerVertically) {
        this.drawText(g2, text, skinFont, skinColor.getColor(), x, y, w, h2, visibleStartY, visibleHeight, wrap0, horzAlignment, centerVertically);
    }

    public void drawText(Graphics g2, String text, FSkinFont skinFont, Color color, float x, float y, float w, float h2, float visibleStartY, float visibleHeight, boolean wrap0, int horzAlignment, boolean centerVertically) {
        this.setProps(text, skinFont, w, h2, wrap0);
        if (this.needClip) {
            g2.startClip(x, y, w, h2);
        }
        try {
            if (this.height > this.totalHeight && centerVertically) {
                y += (this.height - this.totalHeight) / 2.0f;
            }
            float[] alignmentOffsets = new float[this.lineWidths.size()];
            int size = this.lineWidths.size();
            block7: for (int i = 0; i < size; ++i) {
                switch (horzAlignment) {
                    case 8: {
                        alignmentOffsets[i] = 0.0f;
                        continue block7;
                    }
                    case 1: {
                        alignmentOffsets[i] = Math.max((this.width - this.lineWidths.get(i).floatValue()) / 2.0f, 0.0f);
                        continue block7;
                    }
                    case 16: {
                        alignmentOffsets[i] = Math.max(this.width - this.lineWidths.get(i).floatValue(), 0.0f);
                    }
                }
            }
            float visibleEndY = (visibleStartY -= y) + visibleHeight;
            for (Piece piece : this.pieces) {
                if (piece.y + piece.h < visibleStartY) continue;
                if (!(piece.y >= visibleEndY)) {
                    piece.draw(g2, color, x + alignmentOffsets[piece.lineNum], y);
                    continue;
                }
                break;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.needClip) {
            g2.endClip();
        }
    }

    private class SymbolPiece
    extends Piece {
        private FSkinImageInterface image;

        private SymbolPiece(FSkinImageInterface image0, boolean inReminderText0) {
            super(inReminderText0);
            this.image = image0;
        }

        @Override
        public void draw(Graphics g2, Color color, float offsetX, float offsetY) {
            if (this.inReminderText) {
                g2.setAlphaComposite(0.5f);
            }
            g2.drawImage(this.image, this.x + offsetX, this.y + offsetY, this.w, this.h);
            if (this.inReminderText) {
                g2.resetAlphaComposite();
            }
        }
    }

    private class TextPiece
    extends Piece {
        private String text;
        private Color colorOverride;

        private TextPiece(String text0, Color colorOverride0, boolean inReminderText0) {
            super(inReminderText0);
            this.text = text0;
            this.colorOverride = colorOverride0;
        }

        @Override
        public void draw(Graphics g2, Color color, float offsetX, float offsetY) {
            if (this.colorOverride != null) {
                color = this.colorOverride;
            } else if (this.inReminderText) {
                color = FSkinColor.alphaColor(color, 0.5f);
            }
            g2.drawText(this.text, TextRenderer.this.font, color, this.x + offsetX, this.y + offsetY, this.w, this.h, false, 8, false);
        }

        static /* synthetic */ String access$200(TextPiece x0) {
            return x0.text;
        }

        static /* synthetic */ String access$202(TextPiece x0, String x1) {
            x0.text = x1;
            return x0.text;
        }

        static /* synthetic */ Color access$300(TextPiece x0) {
            return x0.colorOverride;
        }
    }

    private abstract class Piece {
        protected static final float ALPHA_COMPOSITE = 0.5f;
        protected final boolean inReminderText;
        protected float x;
        protected float y;
        protected float w;
        protected float h;
        protected int lineNum;

        protected Piece(boolean inReminderText0) {
            this.inReminderText = inReminderText0;
        }

        public abstract void draw(Graphics var1, Color var2, float var3, float var4);
    }
}

