/*
 * Decompiled with CFR 0.152.
 */
package forge.assets;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.graphics.glutils.PixmapTextureData;
import com.google.common.collect.EvictingQueue;
import com.google.common.collect.Queues;
import com.google.common.collect.Sets;
import forge.Forge;
import forge.ImageKeys;
import forge.assets.FImage;
import forge.assets.FSkinImage;
import forge.assets.FTextureImage;
import forge.card.CardEdition;
import forge.card.CardRenderer;
import forge.deck.Deck;
import forge.deck.DeckProxy;
import forge.game.card.CardView;
import forge.game.player.IHasIcon;
import forge.gui.FThreads;
import forge.gui.GuiBase;
import forge.item.InventoryItem;
import forge.item.PaperCard;
import forge.localinstance.properties.ForgeConstants;
import forge.localinstance.properties.ForgePreferences;
import forge.model.FModel;
import forge.util.FileUtil;
import forge.util.ImageUtil;
import forge.util.TextUtil;
import java.io.File;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class ImageCache {
    private static final HashSet<String> missingIconKeys = new HashSet();
    private static List<String> borderlessCardlistKey = FileUtil.readFile(ForgeConstants.BORDERLESS_CARD_LIST_FILE);
    public static int counter = 0;
    static int maxCardCapacity = 300;
    static EvictingQueue<String> q;
    static Set<String> cardsLoaded;
    static Queue<String> syncQ;
    private static final HashMap<String, ImageRecord> imageRecord;
    private static boolean imageLoaded;
    private static boolean delayLoadRequested;

    public static void initCache(int capacity) {
        maxCardCapacity = capacity;
        q = EvictingQueue.create(capacity);
        syncQ = Queues.synchronizedQueue(q);
        int cl = GuiBase.isAndroid() ? maxCardCapacity + capacity / 3 : 400;
        cardsLoaded = new HashSet<String>(cl);
    }

    public static Texture getDefaultImage() {
        return Forge.getAssets().getDefaultImage();
    }

    public static void allowSingleLoad() {
        imageLoaded = false;
        delayLoadRequested = false;
    }

    public static void clear() {
        missingIconKeys.clear();
        ImageKeys.clearMissingCards();
    }

    public static void clearGeneratedCards() {
        Forge.getAssets().generatedCards().clear();
    }

    public static void disposeTextures() {
        CardRenderer.clearcardArtCache();
        for (String fileName : cardsLoaded) {
            if (Forge.getAssets().manager().get(fileName, Texture.class, false) == null) continue;
            Forge.getAssets().manager().unload(fileName);
        }
        cardsLoaded.clear();
        ((Forge)Gdx.app.getApplicationListener()).needsUpdate = true;
    }

    public static void updateSynqCount(File file, int count) {
        if (file == null) {
            return;
        }
        syncQ.add(file.getPath());
        cardsLoaded.add(file.getPath());
        counter += count;
    }

    public static Texture getImage(InventoryItem ii) {
        boolean useDefault = ii instanceof DeckProxy;
        String imageKey = ii.getImageKey(false);
        if (imageKey != null && (imageKey.startsWith("c:") || imageKey.startsWith("t:"))) {
            return ImageCache.getImage(ii.getImageKey(false), useDefault, false);
        }
        return ImageCache.getImage(ii.getImageKey(false), true, true);
    }

    public static FImage getIcon(IHasIcon ihi) {
        Texture icon;
        String imageKey = ihi.getIconImageKey();
        if (missingIconKeys.contains(imageKey) || (icon = ImageCache.getImage(ihi.getIconImageKey(), false, true)) == null) {
            missingIconKeys.add(imageKey);
            return FSkinImage.UNKNOWN;
        }
        return new FTextureImage(icon);
    }

    public static boolean imageKeyFileExists(String imageKey) {
        String tokenfilename;
        if (StringUtils.isEmpty(imageKey)) {
            return false;
        }
        if (imageKey.length() < 2) {
            return false;
        }
        String prefix = imageKey.substring(0, 2);
        PaperCard paperCard = null;
        if (prefix.equals("c:")) {
            try {
                paperCard = ImageUtil.getPaperCardFromImageKey(imageKey);
            }
            catch (Exception e) {
                return false;
            }
            if (paperCard == null) {
                return false;
            }
            if (!FModel.getPreferences().getPrefBoolean(ForgePreferences.FPref.UI_ENABLE_ONLINE_IMAGE_FETCHER)) {
                return paperCard.hasImage();
            }
            boolean backFace = imageKey.endsWith("$alt");
            String cardfilename = backFace ? paperCard.getCardAltImageKey() : paperCard.getCardImageKey();
            return ImageKeys.getCachedCardsFile(cardfilename) != null;
        }
        return !prefix.equals("t:") || new File(ForgeConstants.CACHE_TOKEN_PICS_DIR, tokenfilename = imageKey.substring(2) + ".jpg").exists();
    }

    public static Texture getImage(String imageKey, boolean useDefaultIfNotFound) {
        return ImageCache.getImage(imageKey, useDefaultIfNotFound, false);
    }

    public static Texture getImage(String imageKey, boolean useDefaultIfNotFound, boolean others) {
        Texture image;
        if (FModel.getPreferences().getPrefBoolean(ForgePreferences.FPref.UI_DISABLE_CARD_IMAGES)) {
            return null;
        }
        if (StringUtils.isEmpty(imageKey)) {
            return null;
        }
        boolean altState = imageKey.endsWith("$alt");
        if (altState) {
            imageKey = imageKey.substring(0, imageKey.length() - "$alt".length());
        }
        if (imageKey.startsWith("c:")) {
            PaperCard card = ImageUtil.getPaperCardFromImageKey(imageKey);
            if (card != null) {
                String string = imageKey = altState ? card.getCardAltImageKey() : card.getCardImageKey();
            }
            if (StringUtils.isBlank(imageKey)) {
                if (useDefaultIfNotFound) {
                    return ImageCache.getDefaultImage();
                }
                return null;
            }
        }
        File imageFile = ImageKeys.getImageFile(imageKey);
        if (useDefaultIfNotFound) {
            image = ImageCache.getAsset(imageKey, imageFile, others);
            if (image != null) {
                return image;
            }
            if (imageLoaded) {
                if (!delayLoadRequested) {
                    delayLoadRequested = true;
                    Gdx.graphics.requestRendering();
                }
                return null;
            }
            imageLoaded = true;
        }
        try {
            image = ImageCache.loadAsset(imageKey, imageFile, others);
        }
        catch (Exception ex) {
            image = null;
        }
        if (image == null && useDefaultIfNotFound) {
            image = ImageCache.getDefaultImage();
            imageLoaded = false;
            if (image != null && imageRecord.get(image.toString()) == null) {
                imageRecord.put(image.toString(), new ImageRecord(Color.valueOf("#171717").toString(), false, ImageCache.getRadius(image)));
            }
        }
        return image;
    }

    static Texture getAsset(String imageKey, File file, boolean others) {
        if (file == null) {
            return null;
        }
        return Forge.getAssets().manager().get(file.getPath(), Texture.class, false);
    }

    static Texture loadAsset(String imageKey, File file, boolean others) {
        if (file == null) {
            return null;
        }
        Texture check = ImageCache.getAsset(imageKey, file, others);
        if (check != null) {
            return check;
        }
        if (!others) {
            syncQ.add(file.getPath());
            cardsLoaded.add(file.getPath());
            ImageCache.unloadCardTextures(false);
        }
        String fileName = file.getPath();
        try {
            if (Forge.getAssets().manager().get(fileName, Texture.class, false) == null) {
                Forge.getAssets().manager().load(fileName, Texture.class, Forge.getAssets().getTextureFilter());
                Forge.getAssets().manager().finishLoadingAsset(fileName);
                ++counter;
            }
        }
        catch (Exception e) {
            System.err.println("Failed to load image: " + fileName);
        }
        if (others) {
            return Forge.getAssets().manager().get(fileName, Texture.class, false);
        }
        Texture cardTexture = Forge.getAssets().manager().get(fileName, Texture.class, false);
        if (cardTexture != null) {
            boolean borderless = ImageCache.isBorderless(imageKey);
            String setCode = imageKey.split("/")[0].trim().toUpperCase();
            int radius = setCode.equals("A") || setCode.equals("LEA") || setCode.equals("B") || setCode.equals("LEB") ? 28 : (setCode.equals("MED") || setCode.equals("ME2") || setCode.equals("ME3") || setCode.equals("ME4") || setCode.equals("TD0") || setCode.equals("TD1") ? 25 : 22);
            ImageCache.updateImageRecord(cardTexture.toString(), borderless ? Color.valueOf("#171717").toString() : ImageCache.isCloserToWhite(ImageCache.getpixelColor(cardTexture)).getLeft(), borderless ? false : ImageCache.isCloserToWhite(ImageCache.getpixelColor(cardTexture)).getRight(), radius);
        }
        return cardTexture;
    }

    public static void unloadCardTextures(boolean removeAll) {
        if (removeAll) {
            try {
                for (String asset : Forge.getAssets().manager().getAssetNames()) {
                    if (!asset.contains(".full")) continue;
                    Forge.getAssets().manager().unload(asset);
                }
                syncQ.clear();
                cardsLoaded.clear();
                counter = 0;
                CardRenderer.clearcardArtCache();
                return;
            }
            catch (Exception exception) {}
            finally {
                return;
            }
        }
        if (cardsLoaded.size() <= maxCardCapacity) {
            return;
        }
        HashSet<String> newQ = Sets.newHashSet(syncQ);
        Sets.SetView<String> toUnload = Sets.difference(cardsLoaded, newQ);
        try {
            for (String asset : toUnload) {
                if (Forge.getAssets().manager().get(asset, Texture.class, false) != null) {
                    Forge.getAssets().manager().unload(asset);
                }
                cardsLoaded.remove(asset);
            }
            CardRenderer.clearcardArtCache();
            ((Forge)Gdx.app.getApplicationListener()).needsUpdate = true;
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            // empty catch block
        }
    }

    public static void preloadCache(Iterable<String> keys) {
        if (FModel.getPreferences().getPrefBoolean(ForgePreferences.FPref.UI_DISABLE_CARD_IMAGES)) {
            return;
        }
        for (String imageKey : keys) {
            if (ImageCache.getImage(imageKey, false) != null) continue;
            System.err.println("could not load card image:" + imageKey);
        }
    }

    public static void preloadCache(Deck deck) {
        if (FModel.getPreferences().getPrefBoolean(ForgePreferences.FPref.UI_DISABLE_CARD_IMAGES)) {
            return;
        }
        if (deck == null || !Forge.enablePreloadExtendedArt) {
            return;
        }
        if (deck.getAllCardsInASinglePool().toFlatList().size() <= 100) {
            for (PaperCard p : deck.getAllCardsInASinglePool().toFlatList()) {
                if (ImageCache.getImage(p.getImageKey(false), false) != null) continue;
                System.err.println("could not load card image:" + p.toString());
            }
        }
    }

    public static TextureRegion croppedBorderImage(Texture image) {
        if (!image.toString().contains(".fullborder.")) {
            return new TextureRegion(image);
        }
        float rscale = 0.96f;
        int rw = Math.round((float)image.getWidth() * rscale);
        int rh = Math.round((float)image.getHeight() * rscale);
        int rx = Math.round((float)(image.getWidth() - rw) / 2.0f);
        int ry = Math.round((float)(image.getHeight() - rh) / 2.0f) - 2;
        return new TextureRegion(image, rx, ry, rw, rh);
    }

    public static Color borderColor(Texture t2) {
        if (t2 == null) {
            return Color.valueOf("#171717");
        }
        try {
            return Color.valueOf(ImageCache.imageRecord.get((Object)t2.toString()).colorValue);
        }
        catch (Exception e) {
            return Color.valueOf("#171717");
        }
    }

    public static int getFSkinBorders(CardView c) {
        if (c == null) {
            return 0;
        }
        CardView.CardStateView state = c.getCurrentState();
        CardEdition ed = FModel.getMagicDb().getEditions().get(state.getSetCode());
        if (ed != null && ed.getBorderColor() == CardEdition.BorderColor.WHITE && state.getFoilIndex() == 0) {
            return 1;
        }
        return 0;
    }

    public static void updateImageRecord(String textureString, String colorValue, Boolean isClosertoWhite, int radius) {
        imageRecord.put(textureString, new ImageRecord(colorValue, isClosertoWhite, radius));
    }

    public static int getRadius(Texture t2) {
        ImageRecord record = imageRecord.get(t2.toString());
        if (record == null) {
            return 20;
        }
        Integer i = record.cardRadius;
        if (i == null) {
            return 20;
        }
        return i;
    }

    public static FImage getBorder(String textureString) {
        ImageRecord record = imageRecord.get(textureString);
        if (record == null) {
            return FSkinImage.IMG_BORDER_BLACK;
        }
        Boolean border = record.isCloserToWhite;
        if (border == null) {
            return FSkinImage.IMG_BORDER_BLACK;
        }
        return border != false ? FSkinImage.IMG_BORDER_WHITE : FSkinImage.IMG_BORDER_BLACK;
    }

    public static FImage getBorderImage(String textureString, boolean canshow) {
        if (!canshow) {
            return FSkinImage.IMG_BORDER_BLACK;
        }
        return ImageCache.getBorder(textureString);
    }

    public static FImage getBorderImage(String textureString) {
        return ImageCache.getBorder(textureString);
    }

    public static Color getTint(CardView c, Texture t2) {
        if (c == null) {
            return ImageCache.borderColor(t2);
        }
        if (c.isFaceDown()) {
            return Color.valueOf("#171717");
        }
        CardView.CardStateView state = c.getCurrentState();
        if (state.getColors().isColorless()) {
            if (state.hasDevoid()) {
                return ImageCache.borderColor(t2);
            }
            return Color.valueOf("#A0A6A4");
        }
        if (state.getColors().isMonoColor()) {
            if (state.getColors().hasBlack()) {
                return Color.valueOf("#48494a");
            }
            if (state.getColors().hasBlue()) {
                return Color.valueOf("#62b5f8");
            }
            if (state.getColors().hasRed()) {
                return Color.valueOf("#f6532d");
            }
            if (state.getColors().hasGreen()) {
                return Color.valueOf("#66cb35");
            }
            if (state.getColors().hasWhite()) {
                return Color.valueOf("#EEEBE1");
            }
        } else if (state.getColors().isMulticolor()) {
            return Color.valueOf("#F9E084");
        }
        return ImageCache.borderColor(t2);
    }

    public static Texture generateTexture(FileHandle fh, Texture cardTexture, boolean textureFilter) {
        if (cardTexture == null || fh == null) {
            return cardTexture;
        }
        Texture[] placeholder = new Texture[1];
        FThreads.invokeInEdtNowOrLater(() -> {
            Pixmap pImage = new Pixmap(fh);
            int w = pImage.getWidth();
            int h2 = pImage.getHeight();
            int radius = (h2 - w) / 8;
            Pixmap pMask = ImageCache.createRoundedRectangle(w, h2, radius, Color.RED);
            ImageCache.drawPixelstoMask(pImage, pMask);
            PixmapTextureData textureData = new PixmapTextureData(pMask, Pixmap.Format.RGBA4444, textureFilter, false, true);
            placeholder[0] = new Texture(textureData);
            if (textureFilter) {
                placeholder[0].setFilter(Texture.TextureFilter.MipMapLinearLinear, Texture.TextureFilter.Linear);
            }
            pImage.dispose();
            pMask.dispose();
        });
        return placeholder[0];
    }

    public static Pixmap createRoundedRectangle(int width, int height, int cornerRadius, Color color) {
        Pixmap pixmap = new Pixmap(width, height, Pixmap.Format.RGBA4444);
        Pixmap ret = new Pixmap(width, height, Pixmap.Format.RGBA4444);
        pixmap.setColor(color);
        pixmap.fillCircle(cornerRadius, cornerRadius, cornerRadius);
        pixmap.fillCircle(width - cornerRadius - 1, cornerRadius, cornerRadius);
        pixmap.fillCircle(cornerRadius, height - cornerRadius - 1, cornerRadius);
        pixmap.fillCircle(width - cornerRadius - 1, height - cornerRadius - 1, cornerRadius);
        pixmap.fillRectangle(cornerRadius, 0, width - cornerRadius * 2, height);
        pixmap.fillRectangle(0, cornerRadius, width, height - cornerRadius * 2);
        ret.setColor(color);
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                if (pixmap.getPixel(x, y) == 0) continue;
                ret.drawPixel(x, y);
            }
        }
        pixmap.dispose();
        return ret;
    }

    public static void drawPixelstoMask(Pixmap pixmap, Pixmap mask) {
        int pixmapWidth = mask.getWidth();
        int pixmapHeight = mask.getHeight();
        Color pixelColor = new Color();
        for (int x = 0; x < pixmapWidth; ++x) {
            for (int y = 0; y < pixmapHeight; ++y) {
                if (mask.getPixel(x, y) == 0) continue;
                Color.rgba8888ToColor(pixelColor, pixmap.getPixel(x, y));
                mask.setColor(pixelColor);
                mask.drawPixel(x, y);
            }
        }
    }

    public static boolean isBorderless(String imagekey) {
        if (borderlessCardlistKey.isEmpty()) {
            return false;
        }
        if (imagekey.length() > 7 && !imagekey.substring(0, 7).contains("MPS_KLD") && imagekey.substring(0, 4).contains("MPS_")) {
            return true;
        }
        return borderlessCardlistKey.contains(TextUtil.fastReplace(imagekey, ".full", ".fullborder"));
    }

    public static boolean isBorderless(Texture t2) {
        if (borderlessCardlistKey.isEmpty()) {
            return false;
        }
        if (t2.toString().contains("com.badlogic.gdx.graphics.Texture@")) {
            return true;
        }
        return borderlessCardlistKey.stream().anyMatch(key -> t2.toString().contains((CharSequence)key));
    }

    public static String getpixelColor(Texture i) {
        if (!i.getTextureData().isPrepared()) {
            i.getTextureData().prepare();
        }
        Pixmap pixmap = i.getTextureData().consumePixmap();
        Color color = new Color(pixmap.getPixel(ImageCache.croppedBorderImage(i).getRegionX() + 1, ImageCache.croppedBorderImage(i).getRegionY() + 1));
        pixmap.dispose();
        return color.toString();
    }

    public static Pair<String, Boolean> isCloserToWhite(String c) {
        int c_b;
        int c_g;
        if (c == null || c == "") {
            return Pair.of(Color.valueOf("#171717").toString(), false);
        }
        int c_r = Integer.parseInt(c.substring(0, 2), 16);
        int brightness = (c_r * 299 + (c_g = Integer.parseInt(c.substring(2, 4), 16)) * 587 + (c_b = Integer.parseInt(c.substring(4, 6), 16)) * 114) / 1000;
        return Pair.of(c, brightness > 155);
    }

    static {
        imageRecord = new HashMap(1024);
    }

    static class ImageRecord {
        String colorValue;
        Boolean isCloserToWhite;
        Integer cardRadius;

        ImageRecord(String colorString, Boolean closetoWhite, int radius) {
            this.colorValue = colorString;
            this.isCloserToWhite = closetoWhite;
            this.cardRadius = radius;
        }
    }
}

