/*
 * Decompiled with CFR 0.152.
 */
package forge.assets;

import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Texture;
import forge.Forge;
import forge.Graphics;
import forge.assets.FImage;
import forge.assets.FSkin;
import forge.gui.GuiBase;
import forge.util.ImageFetcher;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public enum FSkinTexture implements FImage
{
    BG_TEXTURE("bg_texture.jpg", true, false),
    BG_MATCH("bg_match.jpg", false, false),
    BG_MATCH_DAY("bg_day.jpg", false, false),
    BG_MATCH_NIGHT("bg_night.jpg", false, false),
    BG_SPACE("bg_space.png", false, false),
    BG_CHAOS_WHEEL("bg_chaos_wheel.png", false, false),
    ADV_BG_TEXTURE("adv_bg_texture.jpg", true, false),
    ADV_BG_MATCH("adv_bg_match.jpg", false, false),
    ADV_BG_MATCH_DAY("adv_bg_match_day.jpg", false, false),
    ADV_BG_MATCH_NIGHT("adv_bg_match_nigh.jpg", false, false),
    ADV_BG_SWAMP("adv_bg_swamp.jpg", false, false),
    ADV_BG_FOREST("adv_bg_forest.jpg", false, false),
    ADV_BG_MOUNTAIN("adv_bg_mountain.jpg", false, false),
    ADV_BG_ISLAND("adv_bg_island.jpg", false, false),
    ADV_BG_PLAINS("adv_bg_plains.jpg", false, false),
    ADV_BG_WASTE("adv_bg_waste.jpg", false, false),
    ADV_BG_COMMON("adv_bg_common.jpg", false, false),
    ADV_BG_CAVE("adv_bg_cave.jpg", false, false),
    ADV_BG_DUNGEON("adv_bg_dungeon.jpg", false, false),
    ADV_BG_CASTLE("adv_bg_castle.jpg", false, false),
    CARDBG_A("IMG_CARDBG_A.png", false, false),
    CARDBG_B("IMG_CARDBG_B.png", false, false),
    CARDBG_BG("IMG_CARDBG_BG.png", false, false),
    CARDBG_BR("IMG_CARDBG_BR.png", false, false),
    CARDBG_C("IMG_CARDBG_C.png", false, false),
    CARDBG_G("IMG_CARDBG_G.png", false, false),
    CARDBG_L("IMG_CARDBG_L.png", false, false),
    CARDBG_M("IMG_CARDBG_M.png", false, false),
    CARDBG_R("IMG_CARDBG_R.png", false, false),
    CARDBG_RG("IMG_CARDBG_RG.png", false, false),
    CARDBG_U("IMG_CARDBG_U.png", false, false),
    CARDBG_UB("IMG_CARDBG_UB.png", false, false),
    CARDBG_UG("IMG_CARDBG_UG.png", false, false),
    CARDBG_UR("IMG_CARDBG_UR.png", false, false),
    CARDBG_V("IMG_CARDBG_V.png", false, false),
    CARDBG_W("IMG_CARDBG_W.png", false, false),
    CARDBG_WB("IMG_CARDBG_WB.png", false, false),
    CARDBG_WG("IMG_CARDBG_WG.png", false, false),
    CARDBG_WR("IMG_CARDBG_WR.png", false, false),
    CARDBG_WU("IMG_CARDBG_WU.png", false, false),
    PWBG_B("IMG_PWBG_B.png", false, false),
    PWBG_BG("IMG_PWBG_BG.png", false, false),
    PWBG_BR("IMG_PWBG_BR.png", false, false),
    PWBG_C("IMG_PWBG_C.png", false, false),
    PWBG_G("IMG_PWBG_G.png", false, false),
    PWBG_M("IMG_PWBG_M.png", false, false),
    PWBG_R("IMG_PWBG_R.png", false, false),
    PWBG_RG("IMG_PWBG_RG.png", false, false),
    PWBG_U("IMG_PWBG_U.png", false, false),
    PWBG_UB("IMG_PWBG_UB.png", false, false),
    PWBG_UG("IMG_PWBG_UG.png", false, false),
    PWBG_UR("IMG_PWBG_UR.png", false, false),
    PWBG_W("IMG_PWBG_W.png", false, false),
    PWBG_WB("IMG_PWBG_WB.png", false, false),
    PWBG_WG("IMG_PWBG_WG.png", false, false),
    PWBG_WR("IMG_PWBG_WR.png", false, false),
    PWBG_WU("IMG_PWBG_WU.png", false, false),
    NYX_B("IMG_NYX_B.png", false, false),
    NYX_G("IMG_NYX_G.png", false, false),
    NYX_M("IMG_NYX_M.png", false, false),
    NYX_R("IMG_NYX_R.png", false, false),
    NYX_U("IMG_NYX_U.png", false, false),
    NYX_W("IMG_NYX_W.png", false, false),
    NYX_C("IMG_NYX_C.png", false, false),
    GENERIC_PLANE("", false, true);

    private String filename;
    private final boolean repeat;
    private Texture texture;
    private final boolean isPlanechaseBG;
    private static List<String> planechaseString;
    private boolean isloaded = false;
    private boolean hasError = false;

    private FSkinTexture(String filename0, boolean repeat0, boolean isPlanechaseBG0) {
        this.filename = filename0;
        this.repeat = repeat0;
        this.isPlanechaseBG = isPlanechaseBG0;
    }

    public static List<String> getValues() {
        if (planechaseString == null) {
            planechaseString = new ArrayList<String>();
            for (FSkinTexture fskinTexture : FSkinTexture.values()) {
                if (!fskinTexture.isPlanechaseBG) continue;
                planechaseString.add(fskinTexture.filename.replace(".jpg", "").replace("'", "").replace("-", ""));
            }
        }
        return Collections.unmodifiableList(planechaseString);
    }

    public void load() {
        this.load("");
    }

    public boolean load(String planeName) {
        FileHandle preferredFile;
        if (this.hasError) {
            return false;
        }
        if (!planeName.isEmpty()) {
            this.texture = null;
            this.filename = planeName + ".jpg";
        }
        FileHandle fileHandle = preferredFile = this.isPlanechaseBG ? FSkin.getCachePlanechaseFile(this.filename) : FSkin.getSkinFile(this.filename);
        if (preferredFile.exists()) {
            try {
                this.texture = Forge.getAssets().getTexture(preferredFile, false);
                if (this.texture != null) {
                    this.isloaded = true;
                }
            }
            catch (Exception e) {
                System.err.println("Failed to load skin file: " + preferredFile);
                e.printStackTrace();
                this.isloaded = false;
                this.hasError = true;
            }
        }
        if (this.texture == null) {
            FileHandle defaultFile = FSkin.getDefaultSkinFile(this.filename);
            if (this.isPlanechaseBG) {
                ImageFetcher fetcher = GuiBase.getInterface().getImageFetcher();
                fetcher.fetchImage("PLANECHASEBG:" + this.filename, () -> {
                    this.hasError = false;
                    this.load();
                });
                defaultFile = FSkin.getSkinFile("bg_match.jpg");
                if (!defaultFile.exists()) {
                    defaultFile = FSkin.getDefaultSkinFile("bg_match.jpg");
                }
            }
            if (defaultFile.exists()) {
                try {
                    this.texture = Forge.getAssets().getTexture(defaultFile);
                    this.isloaded = true;
                }
                catch (Exception e) {
                    System.err.println("Failed to load skin file: " + defaultFile);
                    e.printStackTrace();
                    this.isloaded = false;
                    this.hasError = true;
                    return false;
                }
            } else {
                System.err.println("Failed to load skin file: " + defaultFile);
                this.isloaded = false;
                this.hasError = true;
                return false;
            }
        }
        if (this.repeat && this.texture != null) {
            this.texture.setWrap(Texture.TextureWrap.Repeat, Texture.TextureWrap.Repeat);
        }
        return true;
    }

    @Override
    public float getWidth() {
        if (!this.isloaded) {
            this.load();
        }
        if (this.hasError) {
            return 0.0f;
        }
        return this.texture.getWidth();
    }

    @Override
    public float getHeight() {
        if (!this.isloaded) {
            this.load();
        }
        if (this.hasError) {
            return 0.0f;
        }
        return this.texture.getHeight();
    }

    @Override
    public void draw(Graphics g2, float x, float y, float w, float h2) {
        if (!this.isloaded) {
            this.load();
        }
        if (this.hasError) {
            return;
        }
        if (this.repeat) {
            g2.drawRepeatingImage(this.texture, x, y, w, h2);
        } else {
            g2.drawImage(this.texture, x, y, w, h2);
        }
    }

    public void drawRotated(Graphics g2, float x, float y, float w, float h2, float rotation) {
        if (!this.isloaded) {
            this.load();
        }
        if (this.hasError) {
            return;
        }
        g2.drawRotatedImage(this.texture, x, y, w, h2, x + w / 2.0f, y + h2 / 2.0f, rotation);
    }

    public void drawFlipped(Graphics g2, float x, float y, float w, float h2) {
        if (!this.isloaded) {
            this.load();
        }
        if (this.hasError) {
            return;
        }
        g2.drawFlippedImage(this.texture, x, y, w, h2);
    }
}

