/*
 * Decompiled with CFR 0.152.
 */
package forge.assets;

import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import forge.Forge;
import forge.Graphics;
import forge.assets.FSkin;
import forge.assets.FSkinImageInterface;
import forge.localinstance.skin.FSkinProp;
import forge.util.ImageUtil;

public class FSkinImageImpl
implements FSkinImageInterface {
    private final int x;
    private final int y;
    private final int w;
    private final int h;
    FSkinProp skinProp;
    private TextureRegion textureRegion;

    FSkinImageImpl(FSkinProp skinProp0) {
        int[] coords = skinProp0.getCoords();
        this.x = coords[0];
        this.y = coords[1];
        this.w = coords[2];
        this.h = coords[3];
        this.skinProp = skinProp0;
    }

    @Override
    public void load(Pixmap preferredIcons) {
        FSkinProp.PropType type = this.skinProp.getType();
        String filename = type.getFilename();
        if (filename == null) {
            return;
        }
        boolean is2D = type == FSkinProp.PropType.ADVENTURE;
        FileHandle preferredFile = type == FSkinProp.PropType.MANAICONS ? FSkin.getDefaultSkinFile(filename) : FSkin.getSkinFile(filename);
        Texture texture = Forge.getAssets().getTexture(preferredFile, is2D, false);
        if (texture == null && preferredFile.exists()) {
            try {
                texture = Forge.getAssets().getTexture(preferredFile, is2D, false);
            }
            catch (Exception e) {
                System.err.println("Failed to load skin file: " + preferredFile);
            }
        }
        if (texture != null) {
            if (type != FSkinProp.PropType.ABILITY && type != FSkinProp.PropType.IMAGE && type != FSkinProp.PropType.ICON && type != FSkinProp.PropType.MANAICONS) {
                this.textureRegion = new TextureRegion(texture, this.x, this.y, this.w, this.h);
                return;
            }
            int fullWidth = texture.getWidth();
            int fullHeight = texture.getHeight();
            if (this.x + this.w <= fullWidth && this.y + this.h <= fullHeight) {
                int x0 = 0;
                int y0 = 0;
                x0 = this.x + this.w / 2;
                y0 = this.y + this.h / 2;
                Color c = new Color(preferredIcons.getPixel(x0, y0));
                if (c.a != 0.0f) {
                    this.textureRegion = new TextureRegion(texture, this.x, this.y, this.w, this.h);
                    return;
                }
                c = new Color(preferredIcons.getPixel(x0 += 2, y0 += 2));
                if (c.a != 0.0f) {
                    this.textureRegion = new TextureRegion(texture, this.x, this.y, this.w, this.h);
                    return;
                }
                c = new Color(preferredIcons.getPixel(x0 -= 4, y0));
                if (c.a != 0.0f) {
                    this.textureRegion = new TextureRegion(texture, this.x, this.y, this.w, this.h);
                    return;
                }
                c = new Color(preferredIcons.getPixel(x0, y0 -= 4));
                if (c.a != 0.0f) {
                    this.textureRegion = new TextureRegion(texture, this.x, this.y, this.w, this.h);
                    return;
                }
                c = new Color(preferredIcons.getPixel(x0 += 4, y0));
                if (c.a != 0.0f) {
                    this.textureRegion = new TextureRegion(texture, this.x, this.y, this.w, this.h);
                    return;
                }
            }
        }
        FileHandle defaultFile = FSkin.getDefaultSkinFile(filename);
        texture = Forge.getAssets().getTexture(defaultFile, is2D, false);
        if (texture == null && defaultFile.exists()) {
            try {
                texture = Forge.getAssets().getTexture(defaultFile, is2D, false);
            }
            catch (Exception e) {
                System.err.println("Failed to load skin file: " + defaultFile);
            }
        }
        if (texture != null) {
            this.textureRegion = new TextureRegion(texture, this.x, this.y, this.w, this.h);
        }
    }

    @Override
    public float getWidth() {
        return this.w;
    }

    @Override
    public float getHeight() {
        return this.h;
    }

    @Override
    public TextureRegion getTextureRegion() {
        return this.textureRegion;
    }

    @Override
    public float getNearestHQWidth(float baseWidth) {
        return ImageUtil.getNearestHQSize(baseWidth, this.w);
    }

    @Override
    public float getNearestHQHeight(float baseHeight) {
        return ImageUtil.getNearestHQSize(baseHeight, this.h);
    }

    @Override
    public void draw(Graphics g2, float x, float y, float w, float h2) {
        g2.drawImage(this.textureRegion, x, y, w, h2);
    }
}

