/*
 * Decompiled with CFR 0.152.
 */
package forge.assets;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.assets.loaders.TextureLoader;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.utils.Array;
import forge.Forge;
import forge.assets.FSkinColor;
import forge.assets.FSkinFont;
import forge.assets.FSkinImage;
import forge.assets.FSkinImageImpl;
import forge.assets.FSkinImageInterface;
import forge.assets.FSkinTexture;
import forge.card.CardFaceSymbols;
import forge.gui.FThreads;
import forge.gui.GuiBase;
import forge.localinstance.properties.ForgeConstants;
import forge.localinstance.properties.ForgePreferences;
import forge.localinstance.skin.FSkinProp;
import forge.screens.LoadingOverlay;
import forge.screens.SplashScreen;
import forge.screens.TransitionScreen;
import forge.toolbox.FProgressBar;
import forge.util.WordUtil;
import java.util.Map;

public class FSkin {
    private static Array<String> allSkins;
    private static FileHandle preferredDir;
    private static String preferredName;
    private static boolean loaded;

    public static Texture getLogo() {
        if (Forge.isMobileAdventureMode) {
            return Forge.getAssets().getTexture(FSkin.getDefaultSkinFile("adv_logo.png"), true, false);
        }
        return Forge.getAssets().getTexture(FSkin.getSkinFile("hd_logo.png"), false);
    }

    public static void saveSkinName(ForgePreferences prefs, String skinName) {
        prefs.setPref(ForgePreferences.FPref.UI_SKIN, skinName);
        prefs.save();
    }

    public static void changeSkin(String skinName) {
        if (skinName.equals(GuiBase.getForgePrefs().getPref(ForgePreferences.FPref.UI_SKIN))) {
            return;
        }
        FSkin.saveSkinName(GuiBase.getForgePrefs(), skinName);
        Forge.setTransitionScreen(new TransitionScreen(() -> FThreads.invokeInBackgroundThread(() -> FThreads.invokeInEdtLater(() -> {
            LoadingOverlay loader = new LoadingOverlay(Forge.getLocalizer().getMessageorUseDefault("lblRestartInFewSeconds", "Forge will restart after a few seconds...", new Object[0]), true);
            loader.show();
            FThreads.invokeInBackgroundThread(() -> {
                FSkinFont.deleteCachedFiles();
                FThreads.delayInEDT(2000, () -> {
                    Forge.clearTransitionScreen();
                    FThreads.invokeInEdtLater(() -> Forge.restart(true));
                });
            });
        })), null, false, true));
    }

    public static boolean isThemeValid(FileHandle themeDir, String themeName, boolean silent) {
        int missing = 0;
        if (!themeDir.child("bg_splash.png").exists()) {
            if (!silent) {
                System.err.println(themeDir + themeName + "/bg_splash.png not found.");
            }
            ++missing;
        }
        if (!themeDir.child("bg_match.jpg").exists()) {
            if (!silent) {
                System.err.println(themeDir + themeName + "/bg_match.jpg not found.");
            }
            ++missing;
        }
        if (!themeDir.child("bg_texture.jpg").exists()) {
            if (!silent) {
                System.err.println(themeDir + themeName + "/bg_texture.jpg not found.");
            }
            ++missing;
        }
        if (!themeDir.child("sprite_icons.png").exists()) {
            if (!silent) {
                System.err.println(themeDir + themeName + "/sprite_icons.png not found.");
            }
            ++missing;
        }
        if (!themeDir.child("font1.ttf").exists()) {
            if (!silent) {
                System.err.println(themeDir + themeName + "/font1.ttf not found.");
            }
            ++missing;
        }
        return missing == 0;
    }

    private static void checkThemeDir(FileHandle themeDir, String themeName) {
        if (themeDir == null || !themeDir.exists() || !themeDir.isDirectory()) {
            System.err.println("Skin not found. Defaulting to fallback_skin.");
            FSkin.useFallbackDir();
        } else if (!FSkin.isThemeValid(themeDir, themeName, false)) {
            System.err.println(themeName + " theme is missing some files to work properly.");
            FileHandle def = Gdx.files.absolute(ForgeConstants.DEFAULT_SKINS_DIR);
            if (def.exists() && def.isDirectory() && FSkin.isThemeValid(def, "", true)) {
                FSkinFont.deleteCachedFiles();
                preferredDir = def;
                FSkin.saveSkinName(GuiBase.getForgePrefs(), "Default");
            } else {
                FSkin.useFallbackDir();
            }
        }
    }

    private static void useFallbackDir() {
        preferredDir = GuiBase.isAndroid() ? Gdx.files.internal("fallback_skin") : Gdx.files.classpath("fallback_skin");
    }

    public static void loadLight(String skinName, SplashScreen splashScreen, FileHandle prefDir) {
        preferredDir = prefDir;
        FSkin.loadLight(skinName, splashScreen);
    }

    public static void loadLight(String skinName, SplashScreen splashScreen) {
        preferredName = skinName.toLowerCase().replace(' ', '_');
        Forge.hdbuttons = false;
        Forge.hdstart = false;
        FileHandle dir = Gdx.files.absolute(ForgeConstants.CACHE_SKINS_DIR);
        if (preferredDir == null) {
            if (!dir.exists() || !dir.isDirectory()) {
                FSkin.useFallbackDir();
            } else {
                if (splashScreen != null && allSkins == null) {
                    allSkins = new Array();
                    allSkins.add("Default");
                    Array<String> skinDirectoryNames = FSkin.getSkinDirectoryNames();
                    for (String skinDirectoryName : skinDirectoryNames) {
                        allSkins.add(WordUtil.capitalize(skinDirectoryName.replace('_', ' ')));
                    }
                    allSkins.sort();
                }
                if (!(preferredDir = Gdx.files.absolute(preferredName.equalsIgnoreCase("default") ? ForgeConstants.BASE_SKINS_DIR + preferredName : ForgeConstants.CACHE_SKINS_DIR + preferredName)).exists() || !preferredDir.isDirectory()) {
                    preferredDir.mkdirs();
                }
            }
        }
        FSkin.checkThemeDir(preferredDir, preferredName);
        FSkinTexture.BG_TEXTURE.load();
        Forge.getAssets().loadTexture(FSkin.getSkinFile("hd_logo.png"));
        Forge.getAssets().loadTexture(FSkin.getDefaultSkinFile("adv_logo.png"), new TextureLoader.TextureParameter());
        Forge.getAssets().loadTexture(FSkin.getDefaultSkinFile("overlay_alpha.png"));
        Forge.getAssets().loadTexture(FSkin.getDefaultSkinFile("splatter.png"));
        if (splashScreen != null) {
            FileHandle f = FSkin.getSkinFile("bg_splash.png");
            FileHandle f2 = FSkin.getSkinFile("bg_splash_hd.png");
            FileHandle f3 = FSkin.getSkinFile("adv_bg_splash.png");
            FileHandle f4 = FSkin.getSkinFile("adv_bg_texture.jpg");
            if (!f3.exists()) {
                f3 = FSkin.getDefaultSkinFile("adv_bg_splash.png");
            }
            if (!f4.exists()) {
                f4 = FSkin.getDefaultSkinFile("adv_bg_texture.jpg");
            }
            if (!f.exists()) {
                if (!skinName.equals("default")) {
                    FSkin.loadLight("default", splashScreen);
                }
                return;
            }
            try {
                int h2;
                int w;
                if (f.path().contains("fallback_skin")) {
                    Texture txSplash = Forge.getAssets().getTexture(f);
                    w = txSplash.getWidth();
                    h2 = txSplash.getHeight();
                    splashScreen.setSplashTexture(new TextureRegion(txSplash, 0, 0, w, h2 - 100));
                } else {
                    Forge.getAssets().loadTexture(f);
                    w = Forge.getAssets().getTexture(f).getWidth();
                    h2 = Forge.getAssets().getTexture(f).getHeight();
                    if (f2.exists()) {
                        Forge.getAssets().loadTexture(f2);
                        splashScreen.setSplashTexture(new TextureRegion(Forge.getAssets().getTexture(f2)));
                    } else {
                        splashScreen.setSplashTexture(new TextureRegion(Forge.getAssets().getTexture(f), 0, 0, w, h2 - 100));
                    }
                }
                Pixmap pxSplash = new Pixmap(f);
                if (Forge.selector.equals("Adventure")) {
                    if (f3.exists()) {
                        Texture advSplash = Forge.getAssets().getTexture(f3, true, false);
                        w = advSplash.getWidth();
                        h2 = advSplash.getHeight();
                        splashScreen.setSplashTexture(new TextureRegion(advSplash, 0, 0, w, h2 - 100));
                        pxSplash = new Pixmap(f3);
                    }
                    if (f4.exists()) {
                        Texture advBG = Forge.getAssets().getTexture(f4, true, false);
                        advBG.setWrap(Texture.TextureWrap.Repeat, Texture.TextureWrap.Repeat);
                        splashScreen.setSplashBGTexture(advBG);
                    }
                }
                FProgressBar.BACK_COLOR = new Color(pxSplash.getPixel(25, h2 - 75));
                FProgressBar.FORE_COLOR = new Color(pxSplash.getPixel(75, h2 - 75));
                FProgressBar.SEL_BACK_COLOR = new Color(pxSplash.getPixel(25, h2 - 25));
                FProgressBar.SEL_FORE_COLOR = new Color(pxSplash.getPixel(75, h2 - 25));
            }
            catch (Exception exception) {
                // empty catch block
            }
            loaded = true;
        }
    }

    public static void loadFull(SplashScreen splashScreen) {
        if (splashScreen != null && preferredName.isEmpty()) {
            FSkin.loadLight("default", splashScreen);
        }
        Forge.getAssets().avatars().clear();
        Forge.getAssets().sleeves().clear();
        FileHandle f1 = FSkin.getDefaultSkinFile("sprite_icons.png");
        FileHandle f2 = FSkin.getSkinFile("sprite_icons.png");
        FileHandle f3 = FSkin.getDefaultSkinFile("sprite_foils.png");
        FileHandle f4 = FSkin.getDefaultSkinFile("sprite_avatars.png");
        FileHandle f5 = FSkin.getSkinFile("sprite_avatars.png");
        FileHandle f6 = FSkin.getDefaultSkinFile("sprite_old_foils.png");
        FileHandle f7 = FSkin.getDefaultSkinFile("sprite_manaicons.png");
        FileHandle f8 = FSkin.getDefaultSkinFile("sprite_sleeves.png");
        FileHandle f9 = FSkin.getDefaultSkinFile("sprite_sleeves2.png");
        FileHandle f10 = FSkin.getDefaultSkinFile("sprite_border.png");
        FileHandle f11 = FSkin.getSkinFile("sprite_buttons.png");
        FileHandle f11b = FSkin.getDefaultSkinFile("sprite_buttons.png");
        FileHandle f12 = FSkin.getSkinFile("sprite_start.png");
        FileHandle f12b = FSkin.getDefaultSkinFile("sprite_start.png");
        FileHandle f13 = FSkin.getDefaultSkinFile("sprite_deckbox.png");
        FileHandle f17 = FSkin.getDefaultSkinFile("sprite_cracks.png");
        FileHandle f19 = FSkin.getDefaultSkinFile("sprite_cursor.png");
        FileHandle f20 = FSkin.getSkinFile("sprite_sleeves.png");
        FileHandle f21 = FSkin.getSkinFile("sprite_sleeves2.png");
        FileHandle f22 = FSkin.getDefaultSkinFile("sprite_adv_buttons.png");
        FileHandle f23 = FSkin.getSkinFile("sprite_adv_buttons.png");
        try {
            int sh;
            int sw;
            Pixmap pxPreferredSleeves;
            int i;
            int j;
            int ph;
            int pw;
            Forge.getAssets().loadTexture(f1);
            Pixmap adventureButtons = f23.exists() ? new Pixmap(f23) : new Pixmap(f22);
            Pixmap preferredIcons = new Pixmap(f1);
            if (f2.exists()) {
                Forge.getAssets().loadTexture(f2);
                preferredIcons = new Pixmap(f2);
            }
            Forge.getAssets().loadTexture(f3);
            Forge.getAssets().loadTexture(f6);
            Forge.getAssets().loadTexture(f7, new TextureLoader.TextureParameter(){
                {
                    this.genMipMaps = true;
                }
            });
            if (f11.exists()) {
                if (!Forge.allowCardBG) {
                    Forge.hdbuttons = false;
                } else {
                    Forge.getAssets().loadTexture(f11);
                    Forge.hdbuttons = true;
                }
            } else if (f11b.exists() && Forge.allowCardBG) {
                if (preferredName.isEmpty() || preferredName.equalsIgnoreCase("default")) {
                    Forge.getAssets().loadTexture(f11b);
                    Forge.hdbuttons = true;
                } else {
                    Forge.hdbuttons = false;
                }
            } else {
                Forge.hdbuttons = false;
            }
            if (f12.exists()) {
                if (!Forge.allowCardBG) {
                    Forge.hdstart = false;
                } else {
                    Forge.getAssets().loadTexture(f12);
                    Forge.hdstart = true;
                }
            } else if (f12b.exists() && Forge.allowCardBG) {
                if (preferredName.isEmpty() || preferredName.equalsIgnoreCase("default")) {
                    Forge.getAssets().loadTexture(f12b);
                    Forge.hdstart = true;
                } else {
                    Forge.hdstart = false;
                }
            } else {
                Forge.hdstart = false;
            }
            for (FSkinColor.Colors colors : FSkinColor.Colors.values()) {
                if (colors.toString().startsWith("ADV_CLR")) {
                    colors.setColor(new Color(adventureButtons.getPixel(colors.getX(), colors.getY())));
                    continue;
                }
                colors.setColor(new Color(preferredIcons.getPixel(colors.getX(), colors.getY())));
            }
            for (Enum enum_ : FSkinImage.values()) {
                if (GuiBase.isAndroid()) {
                    if (Forge.allowCardBG) {
                        ((FSkinImage)enum_).load(preferredIcons);
                        continue;
                    }
                    if (enum_.toString().equals("HDMULTI")) {
                        ((FSkinImage)enum_).load(preferredIcons);
                        continue;
                    }
                    if (enum_.toString().startsWith("HD")) continue;
                    ((FSkinImage)enum_).load(preferredIcons);
                    continue;
                }
                ((FSkinImage)enum_).load(preferredIcons);
            }
            for (FSkinProp prop : FSkinProp.MANA_IMG.values()) {
                FSkinImageImpl image = new FSkinImageImpl(prop);
                image.load(preferredIcons);
                FSkin.getImages().put(prop, image);
            }
            int counter = 0;
            int scount = 0;
            Pixmap pixmap = new Pixmap(f4);
            Pixmap pxDefaultSleeves = new Pixmap(f8);
            Forge.getAssets().loadTexture(f4);
            Forge.getAssets().loadTexture(f8);
            if (f5.exists()) {
                Pixmap pxPreferredAvatars = new Pixmap(f5);
                Forge.getAssets().loadTexture(f5);
                pw = pxPreferredAvatars.getWidth();
                ph = pxPreferredAvatars.getHeight();
                for (j = 0; j < ph; j += 100) {
                    for (i = 0; i < pw; i += 100) {
                        if (i == 0 && j == 0) continue;
                        Color pxTest = new Color(pxPreferredAvatars.getPixel(i + 50, j + 50));
                        if (pxTest.a == 0.0f) continue;
                        Forge.getAssets().avatars().put(counter++, new TextureRegion(Forge.getAssets().getTexture(f5), i, j, 100, 100));
                    }
                }
                pxPreferredAvatars.dispose();
            } else if (!preferredName.isEmpty()) {
                pw = pixmap.getWidth();
                ph = pixmap.getHeight();
                for (j = 0; j < ph; j += 100) {
                    for (i = 0; i < pw; i += 100) {
                        if (i == 0 && j == 0) continue;
                        Color pxTest = new Color(pixmap.getPixel(i + 50, j + 50));
                        if (pxTest.a == 0.0f) continue;
                        Forge.getAssets().avatars().put(counter++, new TextureRegion(Forge.getAssets().getTexture(f4), i, j, 100, 100));
                    }
                }
            }
            if (f20.exists()) {
                pxPreferredSleeves = new Pixmap(f20);
                Forge.getAssets().loadTexture(f20);
                sw = pxPreferredSleeves.getWidth();
                sh = pxPreferredSleeves.getHeight();
                for (j = 0; j < sh; j += 500) {
                    for (i = 0; i < sw; i += 360) {
                        Color pxTest = new Color(pxPreferredSleeves.getPixel(i + 180, j + 250));
                        if (pxTest.a == 0.0f) continue;
                        Forge.getAssets().sleeves().put(scount++, new TextureRegion(Forge.getAssets().getTexture(f20), i, j, 360, 500));
                    }
                }
                pxPreferredSleeves.dispose();
            } else {
                sw = pxDefaultSleeves.getWidth();
                sh = pxDefaultSleeves.getHeight();
                for (j = 0; j < sh; j += 500) {
                    for (i = 0; i < sw; i += 360) {
                        Color pxTest = new Color(pxDefaultSleeves.getPixel(i + 180, j + 250));
                        if (pxTest.a == 0.0f) continue;
                        Forge.getAssets().sleeves().put(scount++, new TextureRegion(Forge.getAssets().getTexture(f8), i, j, 360, 500));
                    }
                }
            }
            if (f21.exists()) {
                pxPreferredSleeves = new Pixmap(f21);
                Forge.getAssets().loadTexture(f21);
                sw = pxPreferredSleeves.getWidth();
                sh = pxPreferredSleeves.getHeight();
                for (j = 0; j < sh; j += 500) {
                    for (i = 0; i < sw; i += 360) {
                        Color pxTest = new Color(pxPreferredSleeves.getPixel(i + 180, j + 250));
                        if (pxTest.a == 0.0f) continue;
                        Forge.getAssets().sleeves().put(scount++, new TextureRegion(Forge.getAssets().getTexture(f21), i, j, 360, 500));
                    }
                }
                pxPreferredSleeves.dispose();
            } else {
                pxDefaultSleeves = new Pixmap(f9);
                Forge.getAssets().loadTexture(f9);
                int sw2 = pxDefaultSleeves.getWidth();
                int sh2 = pxDefaultSleeves.getHeight();
                for (j = 0; j < sh2; j += 500) {
                    for (i = 0; i < sw2; i += 360) {
                        Color pxTest = new Color(pxDefaultSleeves.getPixel(i + 180, j + 250));
                        if (pxTest.a == 0.0f) continue;
                        Forge.getAssets().sleeves().put(scount++, new TextureRegion(Forge.getAssets().getTexture(f9), i, j, 360, 500));
                    }
                }
            }
            Forge.getAssets().loadTexture(f17);
            int crackCount = 0;
            for (int j2 = 0; j2 < 4; ++j2) {
                int x = j2 * 200;
                Forge.getAssets().cracks().put(crackCount++, new TextureRegion(Forge.getAssets().getTexture(f17), x, 0, 200, 279));
            }
            Forge.getAssets().loadTexture(f10);
            Forge.getAssets().borders().put(0, new TextureRegion(Forge.getAssets().getTexture(f10), 2, 2, 672, 936));
            Forge.getAssets().borders().put(1, new TextureRegion(Forge.getAssets().getTexture(f10), 676, 2, 672, 936));
            Forge.getAssets().loadTexture(f13);
            Forge.getAssets().deckbox().put(0, new TextureRegion(Forge.getAssets().getTexture(f13), 2, 2, 488, 680));
            Forge.getAssets().deckbox().put(1, new TextureRegion(Forge.getAssets().getTexture(f13), 492, 2, 488, 680));
            Forge.getAssets().deckbox().put(2, new TextureRegion(Forge.getAssets().getTexture(f13), 982, 2, 488, 680));
            Forge.getAssets().loadTexture(f19);
            Forge.getAssets().cursor().put(0, new TextureRegion(Forge.getAssets().getTexture(f19), 0, 0, 32, 32));
            Forge.getAssets().cursor().put(1, new TextureRegion(Forge.getAssets().getTexture(f19), 32, 0, 32, 32));
            Forge.getAssets().cursor().put(2, new TextureRegion(Forge.getAssets().getTexture(f19), 64, 0, 32, 32));
            Forge.setCursor(Forge.getAssets().cursor().get(0), "0");
            FProgressBar.ADV_BACK_COLOR = new Color(adventureButtons.getPixel(FSkinColor.Colors.ADV_CLR_BORDERS.getX(), FSkinColor.Colors.ADV_CLR_BORDERS.getY()));
            FProgressBar.ADV_FORE_COLOR = new Color(adventureButtons.getPixel(FSkinColor.Colors.ADV_CLR_THEME.getX(), FSkinColor.Colors.ADV_CLR_THEME.getY()));
            FProgressBar.ADV_SEL_BACK_COLOR = new Color(adventureButtons.getPixel(FSkinColor.Colors.ADV_CLR_ACTIVE.getX(), FSkinColor.Colors.ADV_CLR_ACTIVE.getY()));
            FProgressBar.ADV_SEL_FORE_COLOR = new Color(adventureButtons.getPixel(FSkinColor.Colors.ADV_CLR_BORDERS.getX(), FSkinColor.Colors.ADV_CLR_BORDERS.getY()));
            preferredIcons.dispose();
            pixmap.dispose();
            pxDefaultSleeves.dispose();
            adventureButtons.dispose();
        }
        catch (Exception e) {
            System.err.println("FSkin$loadFull: Missing a sprite (default icons, preferred icons, or foils.");
        }
        FSkinColor.updateAll();
        loaded = true;
        if (splashScreen != null) {
            CardFaceSymbols.loadImages();
        }
    }

    public static String getName() {
        return preferredName;
    }

    public static FileHandle getSkinFile(String filename) {
        return preferredDir.child(filename);
    }

    public static FileHandle getDefaultSkinFile(String filename) {
        return Gdx.files.absolute(ForgeConstants.DEFAULT_SKINS_DIR + filename);
    }

    public static FileHandle getCachePlanechaseFile(String filename) {
        return Gdx.files.absolute(ForgeConstants.CACHE_PLANECHASE_PICS_DIR + filename);
    }

    public static FileHandle getSkinDir() {
        return preferredDir;
    }

    public static Array<String> getSkinDirectoryNames() {
        Array<String> mySkins = new Array<String>();
        FileHandle dir = Gdx.files.absolute(ForgeConstants.CACHE_SKINS_DIR);
        for (FileHandle skinFile : dir.list()) {
            String skinName = skinFile.name();
            if (skinName.equalsIgnoreCase(".svn") || skinName.equalsIgnoreCase(".DS_Store") || !skinFile.isDirectory() || !FSkin.isThemeValid(skinFile, skinName, true)) continue;
            mySkins.add(skinName);
        }
        return mySkins;
    }

    public static Iterable<String> getAllSkins() {
        if (allSkins != null) {
            allSkins.clear();
            allSkins.add("Default");
            Array<String> skinDirectoryNames = FSkin.getSkinDirectoryNames();
            for (String skinDirectoryName : skinDirectoryNames) {
                allSkins.add(WordUtil.capitalize(skinDirectoryName.replace('_', ' ')));
            }
            allSkins.sort();
        }
        return allSkins;
    }

    public static Map<FSkinProp, FSkinImageInterface> getImages() {
        return Forge.getAssets().images();
    }

    public static Map<Integer, TextureRegion> getAvatars() {
        return Forge.getAssets().avatars();
    }

    public static Map<Integer, TextureRegion> getSleeves() {
        return Forge.getAssets().sleeves();
    }

    public static Map<Integer, TextureRegion> getCracks() {
        return Forge.getAssets().cracks();
    }

    public static Map<Integer, TextureRegion> getBorders() {
        return Forge.getAssets().borders();
    }

    public static Map<Integer, TextureRegion> getDeckbox() {
        return Forge.getAssets().deckbox();
    }

    public static Map<Integer, TextureRegion> getCursor() {
        return Forge.getAssets().cursor();
    }

    public static boolean isLoaded() {
        return loaded;
    }

    static {
        loaded = false;
    }
}

