/*
 * Decompiled with CFR 0.152.
 */
package forge.assets;

import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import forge.Graphics;
import forge.assets.FImageComplex;

public class FRotatedImage
extends FImageComplex {
    private final Texture texture;
    private final int srcX;
    private final int srcY;
    private final int srcWidth;
    private final int srcHeight;
    private final boolean clockwise;

    public FRotatedImage(Texture texture0, int srcX0, int srcY0, int srcWidth0, int srcHeight0, boolean clockwise0) {
        this.texture = texture0;
        this.srcX = srcX0;
        this.srcY = srcY0;
        this.srcWidth = srcWidth0;
        this.srcHeight = srcHeight0;
        this.clockwise = clockwise0;
    }

    @Override
    public float getWidth() {
        return this.srcHeight;
    }

    @Override
    public float getHeight() {
        return this.srcWidth;
    }

    @Override
    public Texture getTexture() {
        return this.texture;
    }

    @Override
    public TextureRegion getTextureRegion() {
        return new TextureRegion(this.texture);
    }

    @Override
    public int getRegionX() {
        return this.srcX;
    }

    @Override
    public int getRegionY() {
        return this.srcY;
    }

    @Override
    public void draw(Graphics g2, float x, float y, float w, float h2) {
        float rotation;
        float originY;
        float originX;
        if (this.clockwise) {
            originX = x + w / 2.0f;
            originY = y + w / 2.0f;
            rotation = -90.0f;
        } else {
            originX = x + h2 / 2.0f;
            originY = y + h2 / 2.0f;
            rotation = 90.0f;
        }
        g2.drawRotatedImage(this.texture, x, y, h2, w, originX, originY, this.srcX, this.srcY, this.srcWidth, this.srcHeight, rotation);
    }
}

