/*
 * Decompiled with CFR 0.152.
 */
package forge.assets;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.graphics.glutils.FrameBuffer;
import com.badlogic.gdx.math.Matrix4;
import forge.Graphics;
import forge.assets.FImageComplex;
import forge.gui.FThreads;

public abstract class FBufferedImage
extends FImageComplex {
    private final float width;
    private final float height;
    private final float opacity;
    private FrameBuffer frameBuffer;

    public FBufferedImage(float width0, float height0) {
        this(width0, height0, 1.0f);
    }

    public FBufferedImage(float width0, float height0, float opacity0) {
        this.width = width0;
        this.height = height0;
        this.opacity = opacity0;
    }

    @Override
    public float getWidth() {
        return this.width;
    }

    @Override
    public float getHeight() {
        return this.height;
    }

    @Override
    public int getRegionX() {
        return 0;
    }

    @Override
    public int getRegionY() {
        return 0;
    }

    @Override
    public TextureRegion getTextureRegion() {
        return new TextureRegion((Texture)this.checkFrameBuffer().getColorBufferTexture());
    }

    @Override
    public Texture getTexture() {
        return (Texture)this.checkFrameBuffer().getColorBufferTexture();
    }

    public void clear() {
        FrameBuffer fb = this.frameBuffer;
        if (fb != null) {
            this.frameBuffer = null;
            FThreads.invokeInEdtNowOrLater(fb::dispose);
        }
    }

    public FrameBuffer checkFrameBuffer() {
        if (this.frameBuffer == null) {
            Gdx.gl.glDisable(3089);
            this.frameBuffer = new FrameBuffer(Pixmap.Format.RGBA8888, (int)this.width, (int)this.height, false);
            this.frameBuffer.begin();
            Graphics frameGraphics = new Graphics();
            Matrix4 matrix = new Matrix4();
            matrix.setToOrtho2D(0.0f, 0.0f, this.width, this.height);
            frameGraphics.setProjectionMatrix(matrix);
            frameGraphics.begin(this.width, this.height);
            this.draw(frameGraphics, this.width, this.height);
            frameGraphics.end();
            this.frameBuffer.end();
            frameGraphics.dispose();
            Gdx.gl.glEnable(3089);
        }
        return this.frameBuffer;
    }

    public void dispose() {
        if (this.frameBuffer != null) {
            this.frameBuffer.dispose();
        }
    }

    protected abstract void draw(Graphics var1, float var2, float var3);

    @Override
    public void draw(Graphics g2, float x, float y, float w, float h2) {
        if (this.opacity < 1.0f) {
            g2.setAlphaComposite(this.opacity);
        }
        g2.drawFlippedImage(this.getTexture(), x, y, w, h2);
        if (this.opacity < 1.0f) {
            g2.resetAlphaComposite();
        }
    }
}

