/*
 * Decompiled with CFR 0.152.
 */
package forge.assets;

import com.badlogic.gdx.Files;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.assets.AssetLoaderParameters;
import com.badlogic.gdx.assets.AssetManager;
import com.badlogic.gdx.assets.loaders.FileHandleResolver;
import com.badlogic.gdx.assets.loaders.ParticleEffectLoader;
import com.badlogic.gdx.assets.loaders.TextureLoader;
import com.badlogic.gdx.assets.loaders.resolvers.AbsoluteFileHandleResolver;
import com.badlogic.gdx.audio.Music;
import com.badlogic.gdx.audio.Sound;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.TextureData;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.ParticleEffect;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.utils.Disposable;
import com.badlogic.gdx.utils.ObjectMap;
import com.github.tommyettinger.textra.Font;
import forge.Forge;
import forge.assets.FImage;
import forge.assets.FImageComplex;
import forge.assets.FSkinFont;
import forge.assets.FSkinImageInterface;
import forge.gui.FThreads;
import forge.gui.GuiBase;
import forge.localinstance.properties.ForgeConstants;
import forge.localinstance.skin.FSkinProp;
import java.util.HashMap;
import java.util.Map;

public class Assets
implements Disposable {
    private MemoryTrackingAssetManager manager;
    private HashMap<Integer, FSkinFont> fonts;
    private HashMap<String, FImageComplex> cardArtCache;
    private HashMap<String, FImage> avatarImages;
    private HashMap<String, FSkinImageInterface> manaImages;
    private HashMap<String, FSkinImageInterface> symbolLookup;
    private HashMap<FSkinProp, FSkinImageInterface> images;
    private HashMap<Integer, TextureRegion> avatars;
    private HashMap<Integer, TextureRegion> sleeves;
    private HashMap<Integer, TextureRegion> cracks;
    private HashMap<Integer, TextureRegion> borders;
    private HashMap<Integer, TextureRegion> deckbox;
    private HashMap<Integer, TextureRegion> cursor;
    private ObjectMap<Integer, BitmapFont> counterFonts;
    private ObjectMap<String, Texture> generatedCards;
    private ObjectMap<String, Texture> fallback_skins;
    private ObjectMap<String, Texture> tmxMap;
    private Texture defaultImage;
    private Texture dummy;
    private TextureLoader.TextureParameter textureParameter;
    private ObjectMap<String, Font> textrafonts;
    private int cGen = 0;
    private int cGenVal = 0;
    private int cFB = 0;
    private int cFBVal = 0;
    private int cTM = 0;
    private int cTMVal = 0;
    private int cSF = 0;
    private int cSFVal = 0;
    private int cCF = 0;
    private int cCFVal = 0;
    private int aDF = 0;
    private int cDFVal = 0;

    public Assets() {
        String titleFilename = Forge.isLandscapeMode() ? "title_bg_lq.png" : "title_bg_lq_portrait.png";
        try {
            if (GuiBase.isAndroid()) {
                this.getTexture(Gdx.files.internal("fallback_skin").child(titleFilename));
            } else {
                this.getTexture(Gdx.files.classpath("fallback_skin").child(titleFilename));
            }
            if (GuiBase.isAndroid()) {
                this.getTexture(Gdx.files.internal("fallback_skin").child("transition.png"));
            } else {
                this.getTexture(Gdx.files.classpath("fallback_skin").child("transition.png"));
            }
        }
        catch (Exception e) {
            this.fallback_skins().clear();
            this.fallback_skins().put("title", this.getDummy());
            this.fallback_skins().put("transition", this.getDummy());
        }
    }

    @Override
    public void dispose() {
        try {
            if (this.counterFonts != null) {
                for (BitmapFont bitmapFont : this.counterFonts.values()) {
                    bitmapFont.dispose();
                }
                this.counterFonts.clear();
            }
            if (this.generatedCards != null) {
                for (Texture texture : this.generatedCards.values()) {
                    texture.dispose();
                }
                this.generatedCards.clear();
            }
            if (this.fallback_skins != null) {
                for (Texture texture : this.fallback_skins.values()) {
                    texture.dispose();
                }
                this.fallback_skins.clear();
            }
            if (this.tmxMap != null) {
                for (Texture texture : this.tmxMap.values()) {
                    texture.dispose();
                }
                this.tmxMap.clear();
            }
            if (this.defaultImage != null) {
                this.defaultImage.dispose();
            }
            if (this.dummy != null) {
                this.dummy.dispose();
            }
            if (this.textrafonts != null) {
                for (Font f : this.textrafonts.values()) {
                    f.dispose();
                }
            }
            this.cardArtCache.clear();
            this.avatarImages.clear();
            this.manaImages.clear();
            this.symbolLookup.clear();
            this.images.clear();
            this.avatars.clear();
            this.sleeves.clear();
            this.cracks.clear();
            this.borders.clear();
            this.deckbox.clear();
            this.cursor.clear();
            this.fonts.clear();
            if (this.manager != null) {
                this.manager.dispose();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public MemoryTrackingAssetManager manager() {
        if (this.manager == null) {
            this.manager = new MemoryTrackingAssetManager(new AbsoluteFileHandleResolver());
        }
        return this.manager;
    }

    public HashMap<Integer, FSkinFont> fonts() {
        if (this.fonts == null) {
            this.fonts = new HashMap();
        }
        return this.fonts;
    }

    public HashMap<String, FImageComplex> cardArtCache() {
        if (this.cardArtCache == null) {
            this.cardArtCache = new HashMap();
        }
        return this.cardArtCache;
    }

    public HashMap<String, FImage> avatarImages() {
        if (this.avatarImages == null) {
            this.avatarImages = new HashMap();
        }
        return this.avatarImages;
    }

    public HashMap<String, FSkinImageInterface> manaImages() {
        if (this.manaImages == null) {
            this.manaImages = new HashMap();
        }
        return this.manaImages;
    }

    public HashMap<String, FSkinImageInterface> symbolLookup() {
        if (this.symbolLookup == null) {
            this.symbolLookup = new HashMap();
        }
        return this.symbolLookup;
    }

    public HashMap<FSkinProp, FSkinImageInterface> images() {
        if (this.images == null) {
            this.images = new HashMap();
        }
        return this.images;
    }

    public HashMap<Integer, TextureRegion> avatars() {
        if (this.avatars == null) {
            this.avatars = new HashMap();
        }
        return this.avatars;
    }

    public HashMap<Integer, TextureRegion> sleeves() {
        if (this.sleeves == null) {
            this.sleeves = new HashMap();
        }
        return this.sleeves;
    }

    public HashMap<Integer, TextureRegion> cracks() {
        if (this.cracks == null) {
            this.cracks = new HashMap();
        }
        return this.cracks;
    }

    public HashMap<Integer, TextureRegion> borders() {
        if (this.borders == null) {
            this.borders = new HashMap();
        }
        return this.borders;
    }

    public HashMap<Integer, TextureRegion> deckbox() {
        if (this.deckbox == null) {
            this.deckbox = new HashMap();
        }
        return this.deckbox;
    }

    public HashMap<Integer, TextureRegion> cursor() {
        if (this.cursor == null) {
            this.cursor = new HashMap();
        }
        return this.cursor;
    }

    public ObjectMap<Integer, BitmapFont> counterFonts() {
        if (this.counterFonts == null) {
            this.counterFonts = new ObjectMap();
        }
        return this.counterFonts;
    }

    public ObjectMap<String, Texture> generatedCards() {
        if (this.generatedCards == null) {
            this.generatedCards = new ObjectMap();
        }
        return this.generatedCards;
    }

    public ObjectMap<String, Texture> fallback_skins() {
        if (this.fallback_skins == null) {
            this.fallback_skins = new ObjectMap<String, Texture>(){

                @Override
                public Texture put(String key, Texture value) {
                    Texture old = (Texture)this.remove(key);
                    if (old != null) {
                        old.dispose();
                    }
                    return super.put(key, value);
                }
            };
        }
        return this.fallback_skins;
    }

    public ObjectMap<String, Texture> tmxMap() {
        if (this.tmxMap == null) {
            this.tmxMap = new ObjectMap();
        }
        return this.tmxMap;
    }

    public TextureLoader.TextureParameter getTextureFilter() {
        if (this.textureParameter == null) {
            this.textureParameter = new TextureLoader.TextureParameter();
        }
        if (Forge.isTextureFilteringEnabled()) {
            this.textureParameter.genMipMaps = true;
            this.textureParameter.minFilter = Texture.TextureFilter.MipMapLinearLinear;
            this.textureParameter.magFilter = Texture.TextureFilter.Linear;
        } else {
            this.textureParameter.genMipMaps = false;
            this.textureParameter.minFilter = Texture.TextureFilter.Nearest;
            this.textureParameter.magFilter = Texture.TextureFilter.Nearest;
        }
        return this.textureParameter;
    }

    public Texture getTexture(FileHandle file) {
        return this.getTexture(file, true);
    }

    public Texture getTexture(FileHandle file, boolean required) {
        return this.getTexture(file, false, required);
    }

    public Texture getTexture(FileHandle file, boolean is2D, boolean required) {
        if (file == null || !file.exists()) {
            if (!required) {
                return null;
            }
            System.err.println("Failed to load: " + file + "!. Creating dummy texture.");
            return this.getDummy();
        }
        if (!Files.FileType.Absolute.equals((Object)file.type()) || file.path().contains("fallback_skin")) {
            Texture f = this.fallback_skins().get(file.path());
            if (f == null) {
                f = new Texture(file);
                this.fallback_skins().put(file.path(), f);
            }
            return f;
        }
        Texture t2 = this.manager().get(file.path(), Texture.class, false);
        if (t2 == null) {
            if (is2D) {
                this.manager().load(file.path(), Texture.class, new TextureLoader.TextureParameter());
            } else {
                this.manager().load(file.path(), Texture.class, this.getTextureFilter());
            }
            this.manager().finishLoadingAsset(file.path());
            t2 = this.manager().get(file.path(), Texture.class);
        }
        return t2;
    }

    public ParticleEffect getEffect(FileHandle file) {
        if (file == null || !file.exists() || !Files.FileType.Absolute.equals((Object)file.type())) {
            System.err.println("Failed to load: " + file + "!.");
            return null;
        }
        ParticleEffect effect = this.manager().get(file.path(), ParticleEffect.class, false);
        if (effect == null) {
            this.manager().load(file.path(), ParticleEffect.class, new ParticleEffectLoader.ParticleEffectParameter());
            this.manager().finishLoadingAsset(file.path());
            effect = this.manager().get(file.path(), ParticleEffect.class);
        }
        return effect;
    }

    public Texture getDefaultImage() {
        if (this.defaultImage == null) {
            FileHandle blankImage = Gdx.files.absolute(ForgeConstants.NO_CARD_FILE);
            if (blankImage.exists()) {
                this.defaultImage = this.manager().get(blankImage.path(), Texture.class, false);
                if (this.defaultImage != null) {
                    return this.defaultImage;
                }
                this.manager().load(blankImage.path(), Texture.class, this.getTextureFilter());
                this.manager().finishLoadingAsset(blankImage.path());
                this.defaultImage = (Texture)this.manager().get(blankImage.path());
            } else {
                this.defaultImage = this.getDummy();
            }
        }
        return this.defaultImage;
    }

    public void loadTexture(FileHandle file) {
        this.loadTexture(file, this.getTextureFilter());
    }

    public void loadTexture(FileHandle file, TextureLoader.TextureParameter parameter) {
        try {
            if (file == null || !file.exists()) {
                return;
            }
            if (!Files.FileType.Absolute.equals((Object)file.type())) {
                return;
            }
            this.manager().load(file.path(), Texture.class, parameter);
            this.manager().finishLoadingAsset(file.path());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private Texture getDummy() {
        if (this.dummy == null) {
            Pixmap P = new Pixmap(1, 1, Pixmap.Format.RGBA8888);
            P.setColor(0.0f, 0.0f, 0.0f, 1.0f);
            P.drawPixel(0, 0);
            this.dummy = new Texture(P);
            P.dispose();
        }
        return this.dummy;
    }

    public Font getTextraFont(BitmapFont bitmapFont, TextureAtlas item_atlas, TextureAtlas pixelmana_atlas) {
        if (this.textrafonts == null) {
            this.textrafonts = new ObjectMap();
        }
        if (!this.textrafonts.containsKey("textrafont")) {
            Font font = new Font(bitmapFont, 0.0f, 2.0f, 0.0f, 1.0f);
            font.addAtlas(item_atlas, 0.0f, 6.0f, 0.0f);
            font.integerPosition = false;
            this.textrafonts.put("textrafont", font);
        }
        return this.textrafonts.get("textrafont");
    }

    public Font getKeysFont(BitmapFont bitmapFont, TextureAtlas keys_atlas) {
        if (this.textrafonts == null) {
            this.textrafonts = new ObjectMap();
        }
        if (!this.textrafonts.containsKey("keysfont")) {
            Font font = new Font(bitmapFont);
            font.addAtlas(keys_atlas, 0.0f, 6.0f, 0.0f);
            font.integerPosition = false;
            this.textrafonts.put("keysfont", font);
        }
        return this.textrafonts.get("keysfont");
    }

    public Font getTextraFont(String name, BitmapFont bitmapFont, TextureAtlas items_atlas) {
        if (this.textrafonts == null) {
            this.textrafonts = new ObjectMap();
        }
        if (!this.textrafonts.containsKey(name)) {
            Font font = new Font(bitmapFont, 0.0f, 2.0f, 0.0f, 1.0f);
            font.addAtlas(items_atlas, 0.0f, 6.0f, 0.0f);
            font.integerPosition = false;
            this.textrafonts.put(name, font);
        }
        return this.textrafonts.get(name);
    }

    public Font getGenericHeaderFont(BitmapFont bitmapFont) {
        if (this.textrafonts == null) {
            this.textrafonts = new ObjectMap();
        }
        if (!this.textrafonts.containsKey("GenericHeaderFont")) {
            Font font = new Font(bitmapFont, 0.0f, -0.5f, 0.0f, -2.5f);
            font.integerPosition = false;
            this.textrafonts.put("GenericHeaderFont", font);
        }
        return this.textrafonts.get("GenericHeaderFont");
    }

    public Music getMusic(FileHandle file) {
        if (file == null || !file.exists() || !Files.FileType.Absolute.equals((Object)file.type())) {
            System.err.println("Failed to load: " + file + "!.");
            return null;
        }
        Music music = this.manager().get(file.path(), Music.class, false);
        if (music == null) {
            this.manager().load(file.path(), Music.class);
            this.manager().finishLoadingAsset(file.path());
            music = this.manager().get(file.path(), Music.class);
        }
        return music;
    }

    public Sound getSound(FileHandle file) {
        if (file == null || !file.exists() || !Files.FileType.Absolute.equals((Object)file.type())) {
            System.err.println("Failed to load: " + file + "!.");
            return null;
        }
        Sound sound = this.manager().get(file.path(), Sound.class, false);
        if (sound == null) {
            this.manager().load(file.path(), Sound.class);
            this.manager().finishLoadingAsset(file.path());
            sound = this.manager().get(file.path(), Sound.class);
        }
        return sound;
    }

    public class MemoryTrackingAssetManager
    extends AssetManager {
        private int currentMemory;
        private Map<String, Integer> memoryPerFile;

        public MemoryTrackingAssetManager(FileHandleResolver resolver) {
            super(resolver);
            this.currentMemory = 0;
            this.memoryPerFile = new HashMap<String, Integer>();
        }

        private int calculateTextureSize(AssetManager assetManager, String fileName, Class<?> type) {
            if (!Forge.showFPS) {
                return 0;
            }
            Texture texture = (Texture)assetManager.get(fileName, type);
            TextureData textureData = texture.getTextureData();
            int textureSize = textureData.getWidth() * textureData.getHeight();
            if (Forge.isTextureFilteringEnabled()) {
                textureSize += textureSize / 3;
            }
            this.memoryPerFile.put(fileName, this.calcTextureDataSize(textureSize, textureData.getFormat()));
            return this.memoryPerFile.values().stream().mapToInt(Integer::intValue).sum() + this.calcFonts() + this.calcCounterFonts() + this.calculateObjectMaps(Assets.this.generatedCards()) + this.calculateObjectMaps(Assets.this.fallback_skins()) + this.calculateObjectMaps(Assets.this.tmxMap());
        }

        private int calculateObjectMaps(ObjectMap<?, Texture> objectMap) {
            if (!Forge.showFPS) {
                return 0;
            }
            if (objectMap == null || objectMap.isEmpty()) {
                return 0;
            }
            if (objectMap == Assets.this.generatedCards) {
                if (Assets.this.cGen == objectMap.size) {
                    return Assets.this.cGenVal;
                }
                Assets.this.cGen = objectMap.size;
            }
            if (objectMap == Assets.this.tmxMap) {
                if (Assets.this.cTM == objectMap.size) {
                    return Assets.this.cTMVal;
                }
                Assets.this.cTM = objectMap.size;
            }
            if (objectMap == Assets.this.fallback_skins) {
                if (Assets.this.cFB == objectMap.size) {
                    return Assets.this.cFBVal;
                }
                Assets.this.cFB = objectMap.size;
            }
            int sum = 0;
            for (Texture texture : objectMap.values()) {
                TextureData textureData = texture.getTextureData();
                int textureSize = textureData.getWidth() * textureData.getHeight();
                if (Forge.isTextureFilteringEnabled()) {
                    textureSize += textureSize / 3;
                }
                sum += this.calcTextureDataSize(textureSize, textureData.getFormat());
            }
            if (objectMap == Assets.this.generatedCards) {
                Assets.this.cGenVal = sum;
            }
            if (objectMap == Assets.this.tmxMap) {
                Assets.this.cTMVal = sum;
            }
            if (objectMap == Assets.this.fallback_skins) {
                Assets.this.cFBVal = sum;
            }
            return sum;
        }

        private int calcFonts() {
            if (!Forge.showFPS) {
                return 0;
            }
            if (Assets.this.fonts == null || Assets.this.fonts.isEmpty()) {
                return 0;
            }
            if (Assets.this.cSF == Assets.this.fonts.size()) {
                return Assets.this.cSFVal;
            }
            Assets.this.cSF = Assets.this.fonts.size();
            int val = 0;
            for (FSkinFont sf : Assets.this.fonts.values()) {
                val += this.calcBitmapFont(sf.font);
            }
            Assets.this.cSFVal = val;
            return Assets.this.cSFVal;
        }

        private int calcCounterFonts() {
            if (!Forge.showFPS) {
                return 0;
            }
            if (Assets.this.counterFonts == null || Assets.this.counterFonts.isEmpty()) {
                return 0;
            }
            if (Assets.this.cCF == ((Assets)Assets.this).counterFonts.size) {
                return Assets.this.cCFVal;
            }
            int val = 0;
            for (BitmapFont cf : Assets.this.counterFonts.values()) {
                val += this.calcBitmapFont(cf);
            }
            Assets.this.cCFVal = val;
            return Assets.this.cCFVal;
        }

        private int calcBitmapFont(BitmapFont bitmapFont) {
            if (bitmapFont == null) {
                return 0;
            }
            int val = 0;
            for (TextureRegion tr : bitmapFont.getRegions()) {
                Texture t2 = tr.getTexture();
                val += t2.getWidth() * t2.getHeight() * 4;
            }
            return val;
        }

        private int calcTextureDataSize(int textureSize, Pixmap.Format format) {
            switch (format) {
                case RGB565: 
                case RGBA4444: {
                    return textureSize * 2;
                }
                case RGB888: {
                    return textureSize * 3;
                }
                case RGBA8888: {
                    return textureSize * 4;
                }
            }
            return textureSize * 3;
        }

        @Override
        public synchronized <T> void load(String fileName, Class<T> type, AssetLoaderParameters<T> parameter) {
            if (type.equals(Texture.class)) {
                if (parameter == null) {
                    parameter = Assets.this.getTextureFilter();
                }
                AssetLoaderParameters.LoadedCallback prevCallback = parameter.loadedCallback;
                parameter.loadedCallback = (assetManager, fileName1, type1) -> {
                    if (prevCallback != null) {
                        prevCallback.finishedLoading(assetManager, fileName1, type1);
                    }
                    this.currentMemory = this.calculateTextureSize(assetManager, fileName1, type1);
                };
            }
            super.load(fileName, type, parameter);
        }

        @Override
        public synchronized void unload(String fileName) {
            if (this.isLoaded(fileName)) {
                super.unload(fileName);
            }
            this.memoryPerFile.remove(fileName);
            Assets.this.cardArtCache().clear();
        }

        @Override
        public <T> T finishLoadingAsset(String fileName) {
            FThreads.assertExecutedByEdt(true);
            return super.finishLoadingAsset(fileName);
        }

        public float getMemoryInMegabytes() {
            return (float)this.currentMemory / 1024.0f / 1024.0f;
        }
    }
}

