/*
 * Decompiled with CFR 0.152.
 */
package forge.app;

import com.badlogic.gdx.ApplicationListener;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.backends.lwjgl3.Lwjgl3Application;
import com.badlogic.gdx.backends.lwjgl3.Lwjgl3ApplicationConfiguration;
import com.badlogic.gdx.backends.lwjgl3.Lwjgl3Clipboard;
import com.badlogic.gdx.backends.lwjgl3.Lwjgl3WindowAdapter;
import com.badlogic.gdx.graphics.glutils.HdpiMode;
import forge.Forge;
import forge.adventure.util.Config;
import forge.interfaces.IDeviceAdapter;
import forge.localinstance.properties.ForgePreferences;
import forge.model.FModel;
import forge.util.FileUtil;
import forge.util.OperatingSystem;
import forge.util.RestartUtil;
import java.awt.Desktop;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import javax.imageio.ImageIO;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.lang3.tuple.Pair;

public class Main {
    public static void main(String[] args) {
        String[] res;
        String switchOrientationFile;
        String assetsDir;
        CommandLine cmd;
        Options options = new Options();
        options.addOption("h", "help", false, "Show help.");
        options.addOption("f", "fullscreen", false, "fullscreen mode");
        options.addOption("l", "landscape", false, "landscape mode");
        options.addOption("r", "resolution", true, "resolution (WxH)");
        DefaultParser parser = new DefaultParser();
        HelpFormatter formatter = new HelpFormatter();
        try {
            cmd = parser.parse(options, args);
        }
        catch (ParseException e) {
            System.out.println(e.getMessage());
            formatter.printHelp("forge-mobile-dev", options);
            System.exit(1);
            return;
        }
        boolean desktopMode = true;
        String desktopModeAssetsDir = "./";
        if (!Files.exists(Paths.get(desktopModeAssetsDir + "res", new String[0]), new LinkOption[0])) {
            desktopModeAssetsDir = "../forge-gui/";
        }
        if (!Files.exists(Paths.get((assetsDir = "./") + "res", new String[0]), new LinkOption[0])) {
            assetsDir = "../forge-gui/";
        }
        boolean landscapeMode = FileUtil.doesFileExist(switchOrientationFile = assetsDir + "switch_orientation.ini") || cmd.hasOption("landscape");
        int screenWidth = landscapeMode ? 853 : 320;
        int screenHeight = 480;
        if (cmd.hasOption("resolution")) {
            res = cmd.getOptionValue("resolution").split("x");
            if (res.length >= 2) {
                screenWidth = Integer.parseInt(res[0].trim());
                screenHeight = Integer.parseInt(res[1].trim());
            }
            desktopMode = false;
        }
        int desktopScreenWidth = Lwjgl3ApplicationConfiguration.getDisplayMode().width;
        int desktopScreenHeight = Lwjgl3ApplicationConfiguration.getDisplayMode().height;
        boolean fullscreenFlag = true;
        if (FileUtil.doesFileExist(desktopModeAssetsDir + "screen_resolution.ini")) {
            res = FileUtil.readFileToString(desktopModeAssetsDir + "screen_resolution.ini").split("x");
            boolean bl = fullscreenFlag = res.length != 3 || Integer.parseInt(res[2].trim()) > 0;
            if (res.length >= 2) {
                desktopScreenWidth = Integer.parseInt(res[0].trim());
                desktopScreenHeight = Integer.parseInt(res[1].trim());
            }
        }
        Lwjgl3ApplicationConfiguration config = new Lwjgl3ApplicationConfiguration();
        config.setResizable(false);
        ForgePreferences prefs = FModel.getPreferences();
        boolean propertyConfig = prefs != null && prefs.getPrefBoolean(ForgePreferences.FPref.UI_NETPLAY_COMPAT);
        ApplicationListener start = Forge.getApp(new Lwjgl3Clipboard(), new DesktopAdapter(switchOrientationFile), desktopMode ? desktopModeAssetsDir : assetsDir, propertyConfig, false, 0, false, 0, "", "");
        if (Config.instance().getSettingData().fullScreen) {
            config.setFullscreenMode(Lwjgl3ApplicationConfiguration.getDisplayMode());
            config.setAutoIconify(true);
            config.setHdpiMode(HdpiMode.Logical);
        } else {
            config.setWindowedMode(Config.instance().getSettingData().width, Config.instance().getSettingData().height);
        }
        config.setTitle("Forge");
        config.setWindowListener(new Lwjgl3WindowAdapter(){

            @Override
            public boolean closeRequested() {
                if (Forge.safeToClose) {
                    Forge.exit(true);
                }
                return false;
            }
        });
        if (desktopMode) {
            config.setHdpiMode(HdpiMode.Logical);
        }
        new Lwjgl3Application(start, config);
    }

    private static class DesktopAdapter
    implements IDeviceAdapter {
        private final String switchOrientationFile;

        private DesktopAdapter(String switchOrientationFile0) {
            this.switchOrientationFile = switchOrientationFile0;
        }

        @Override
        public boolean isConnectedToInternet() {
            return true;
        }

        @Override
        public boolean isConnectedToWifi() {
            return true;
        }

        @Override
        public String getDownloadsDir() {
            return System.getProperty("user.home") + "/Downloads/";
        }

        @Override
        public boolean openFile(String filename) {
            try {
                Desktop.getDesktop().open(new File(filename));
                return true;
            }
            catch (IOException e) {
                e.printStackTrace();
                return false;
            }
        }

        @Override
        public void restart() {
            if (RestartUtil.prepareForRestart()) {
                Gdx.app.exit();
                System.exit(0);
            }
        }

        @Override
        public void exit() {
            Gdx.app.exit();
            System.exit(0);
        }

        @Override
        public boolean isTablet() {
            return true;
        }

        @Override
        public void setLandscapeMode(boolean landscapeMode) {
            if (landscapeMode) {
                FileUtil.writeFile(this.switchOrientationFile, "1");
            } else {
                FileUtil.deleteFile(this.switchOrientationFile);
            }
        }

        @Override
        public void preventSystemSleep(boolean preventSleep) {
            OperatingSystem.preventSystemSleep(preventSleep);
        }

        @Override
        public void convertToJPEG(InputStream input, OutputStream output) throws IOException {
            BufferedImage image = ImageIO.read(input);
            ImageIO.write((RenderedImage)image, "jpg", output);
        }

        @Override
        public Pair<Integer, Integer> getRealScreenSize(boolean real) {
            return Pair.of(Gdx.graphics.getWidth(), Gdx.graphics.getHeight());
        }

        @Override
        public ArrayList<String> getGamepads() {
            return new ArrayList<String>();
        }
    }
}

