/*
 * Decompiled with CFR 0.152.
 */
package forge.animation;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.g2d.Animation;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import forge.Graphics;
import forge.animation.ForgeAnimation;
import forge.animation.GifDecoder;

public class GifAnimation
extends ForgeAnimation {
    private final Animation<TextureRegion> animation;
    private TextureRegion currentFrame;
    private float stateTime;

    public GifAnimation(String filename) {
        this.animation = GifDecoder.loadGIFAnimation(Animation.PlayMode.NORMAL, Gdx.files.absolute(filename).read());
    }

    public GifAnimation(String filename, Animation.PlayMode mode) {
        this.animation = GifDecoder.loadGIFAnimation(mode, Gdx.files.absolute(filename).read());
    }

    @Override
    public void start() {
        this.currentFrame = this.animation.getKeyFrame(0.0f);
        super.start();
    }

    @Override
    protected boolean advance(float dt) {
        this.stateTime += dt;
        this.currentFrame = this.animation.getKeyFrame(this.stateTime);
        return this.currentFrame != null;
    }

    public void draw(Graphics g2, float x, float y, float w, float h2) {
        if (this.currentFrame != null) {
            g2.drawImage(this.currentFrame, x, y, w, h2);
        }
    }

    @Override
    protected void onEnd(boolean endingAll) {
    }

    public void dispose() {
        if (this.animation != null) {
            for (TextureRegion tr : this.animation.getKeyFrames()) {
                try {
                    tr.getTexture().dispose();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }
}

