/*
 * Decompiled with CFR 0.152.
 */
package forge.ai.simulation;

import forge.ai.simulation.PossibleTargetSelector;
import forge.game.spellability.AbilitySub;
import forge.game.spellability.SpellAbility;
import forge.game.spellability.SpellAbilityCondition;
import java.util.ArrayList;
import java.util.List;

public class MultiTargetSelector {
    private final List<PossibleTargetSelector> selectors;
    private final List<SpellAbility> targetingSAs;
    private int currentIndex;

    public MultiTargetSelector(SpellAbility sa, List<AbilitySub> plannedSubs) {
        this.targetingSAs = this.getTargetingSAs(sa, plannedSubs);
        this.selectors = new ArrayList<PossibleTargetSelector>(this.targetingSAs.size());
        for (int i = 0; i < this.targetingSAs.size(); ++i) {
            this.selectors.add(new PossibleTargetSelector(sa, this.targetingSAs.get(i), i));
        }
        this.currentIndex = -1;
    }

    public boolean hasPossibleTargets() {
        if (this.targetingSAs.isEmpty()) {
            return false;
        }
        for (PossibleTargetSelector selector : this.selectors) {
            if (selector.hasPossibleTargets()) continue;
            return false;
        }
        return true;
    }

    public Targets getLastSelectedTargets() {
        Targets targets = new Targets();
        targets.targets = new ArrayList(this.selectors.size());
        for (PossibleTargetSelector selector : this.selectors) {
            targets.targets.add(selector.getLastSelectedTargets());
        }
        return targets;
    }

    public boolean selectTargets(Targets targets) {
        if (targets.targets.size() != this.selectors.size()) {
            return false;
        }
        for (int i = 0; i < this.selectors.size(); ++i) {
            this.selectors.get(i).reset();
            if (this.selectors.get(i).selectTargets((PossibleTargetSelector.Targets)targets.targets.get(i))) continue;
            return false;
        }
        return true;
    }

    public void reset() {
        for (PossibleTargetSelector selector : this.selectors) {
            selector.reset();
        }
        this.currentIndex = -1;
    }

    public boolean selectTargetsByIndex(int i) {
        if (i < this.currentIndex) {
            this.reset();
        }
        while (this.currentIndex < i) {
            if (this.selectNextTargets()) continue;
            return false;
        }
        return true;
    }

    private boolean selectTargetsStartingFrom(int selectorIndex) {
        if (this.selectors.get(selectorIndex).selectNextTargets()) {
            for (int i = selectorIndex + 1; i < this.selectors.size(); ++i) {
                this.selectors.get(i).reset();
                if (this.selectors.get(i).selectNextTargets()) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean selectNextTargets() {
        if (this.selectors.size() == 0) {
            return false;
        }
        if (this.currentIndex == -1) {
            if (this.selectTargetsStartingFrom(0)) {
                this.currentIndex = 0;
                return true;
            }
            return false;
        }
        int selectorIndex = this.selectors.size() - 1;
        while (!this.selectTargetsStartingFrom(selectorIndex)) {
            if (selectorIndex == 0) {
                return false;
            }
            --selectorIndex;
        }
        ++this.currentIndex;
        return true;
    }

    private static boolean conditionsAreMet(SpellAbility saOrSubSa) {
        SpellAbilityCondition conditions = saOrSubSa.getConditions();
        return conditions == null || conditions.areMet(saOrSubSa);
    }

    private List<SpellAbility> getTargetingSAs(SpellAbility sa, List<AbilitySub> plannedSubs) {
        ArrayList<SpellAbility> result = new ArrayList<SpellAbility>();
        for (SpellAbility saOrSubSa = sa; saOrSubSa != null; saOrSubSa = saOrSubSa.getSubAbility()) {
            if (!saOrSubSa.usesTargeting() || !MultiTargetSelector.conditionsAreMet(saOrSubSa)) continue;
            result.add(saOrSubSa);
        }
        if (plannedSubs != null) {
            for (AbilitySub sub : plannedSubs) {
                if (!sub.usesTargeting() || !MultiTargetSelector.conditionsAreMet(sub)) continue;
                result.add(sub);
            }
        }
        return result;
    }

    public static class Targets {
        private ArrayList<PossibleTargetSelector.Targets> targets;

        public int size() {
            return this.targets.size();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            for (PossibleTargetSelector.Targets tgt : this.targets) {
                if (sb.length() != 0) {
                    sb.append(", ");
                }
                sb.append(tgt.toString());
            }
            return sb.toString();
        }
    }
}

