/*
 * Decompiled with CFR 0.152.
 */
package forge.ai.ability;

import com.google.common.collect.Iterables;
import forge.ai.SpellAbilityAi;
import forge.game.CardTraitBase;
import forge.game.ability.ApiType;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.card.CardLists;
import forge.game.card.CardPredicates;
import forge.game.phase.PhaseType;
import forge.game.player.Player;
import forge.game.spellability.AbilitySub;
import forge.game.spellability.SpellAbility;
import forge.game.zone.ZoneType;

public class UntapAllAi
extends SpellAbilityAi {
    @Override
    protected boolean canPlayAI(Player aiPlayer, SpellAbility sa) {
        Card source = sa.getHostCard();
        AbilitySub abSub = sa.getSubAbility();
        if (abSub != null) {
            if (ApiType.AddPhase == abSub.getApi() && source.getGame().getPhaseHandler().getPhase().isBefore(PhaseType.COMBAT_END)) {
                return false;
            }
            CardCollection list = CardLists.filter((Iterable<Card>)aiPlayer.getGame().getCardsIn(ZoneType.Battlefield), CardPredicates.Presets.TAPPED);
            String valid = sa.getParamOrDefault("ValidCards", "");
            list = CardLists.getValidCards((Iterable<Card>)list, valid, source.getController(), source, (CardTraitBase)sa);
            return Iterables.any(list, CardPredicates.isControlledByAnyOf(aiPlayer.getYourTeam()));
        }
        return false;
    }

    @Override
    protected boolean doTriggerAINoCost(Player aiPlayer, SpellAbility sa, boolean mandatory) {
        Card source = sa.getHostCard();
        if (sa.hasParam("ValidCards")) {
            String valid = sa.getParam("ValidCards");
            CardCollection list = CardLists.filter((Iterable<Card>)aiPlayer.getGame().getCardsIn(ZoneType.Battlefield), CardPredicates.Presets.TAPPED);
            list = CardLists.getValidCards((Iterable<Card>)list, valid, source.getController(), source, (CardTraitBase)sa);
            return mandatory || !list.isEmpty();
        }
        return mandatory;
    }
}

