/*
 * Decompiled with CFR 0.152.
 */
package forge.ai.ability;

import forge.ai.AiAttackController;
import forge.ai.SpellAbilityAi;
import forge.game.CardTraitBase;
import forge.game.ability.AbilityUtils;
import forge.game.card.Card;
import forge.game.card.CardCollectionView;
import forge.game.card.CardLists;
import forge.game.player.Player;
import forge.game.spellability.SpellAbility;
import forge.game.zone.ZoneType;
import forge.util.collect.FCollection;

public class TwoPilesAi
extends SpellAbilityAi {
    @Override
    protected boolean canPlayAI(Player ai, SpellAbility sa) {
        Card card = sa.getHostCard();
        ZoneType zone = null;
        if (sa.hasParam("Zone")) {
            zone = ZoneType.smartValueOf(sa.getParam("Zone"));
        }
        String valid = sa.getParamOrDefault("ValidCards", "");
        Player opp = AiAttackController.choosePreferredDefenderPlayer(ai);
        if (sa.usesTargeting()) {
            sa.resetTargets();
            if (sa.canTarget(opp)) {
                sa.getTargets().add(opp);
            } else {
                return false;
            }
        }
        FCollection<Player> tgtPlayers = sa.usesTargeting() && !sa.hasParam("Defined") ? new FCollection<Player>(sa.getTargets().getTargetPlayers()) : AbilityUtils.getDefinedPlayers(card, sa.getParam("Defined"), sa);
        Player p = (Player)tgtPlayers.get(0);
        CardCollectionView pool = sa.hasParam("DefinedCards") ? AbilityUtils.getDefinedCards(card, sa.getParam("DefinedCards"), sa) : p.getCardsIn(zone);
        pool = CardLists.getValidCards((Iterable<Card>)pool, valid, card.getController(), card, (CardTraitBase)sa);
        int size = pool.size();
        return size > 2;
    }
}

