/*
 * Decompiled with CFR 0.152.
 */
package forge.ai.ability;

import com.google.common.collect.Iterables;
import forge.ai.ComputerUtilCombat;
import forge.ai.SpellAbilityAi;
import forge.game.CardTraitBase;
import forge.game.Game;
import forge.game.ability.AbilityUtils;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.card.CardCollectionView;
import forge.game.card.CardLists;
import forge.game.card.CardPredicates;
import forge.game.combat.CombatUtil;
import forge.game.phase.PhaseType;
import forge.game.player.Player;
import forge.game.player.PlayerCollection;
import forge.game.player.PlayerPredicates;
import forge.game.spellability.SpellAbility;
import forge.game.zone.ZoneType;
import forge.util.MyRandom;

public class TapAllAi
extends SpellAbilityAi {
    @Override
    protected boolean canPlayAI(Player ai, SpellAbility sa) {
        String logic;
        Card source = sa.getHostCard();
        Player opp = ai.getStrongestOpponent();
        Game game = ai.getGame();
        if (game.getPhaseHandler().getPhase().isAfter(PhaseType.COMBAT_BEGIN)) {
            return false;
        }
        String valid = sa.getParamOrDefault("ValidCards", "");
        CardCollectionView validTappables = game.getCardsIn(ZoneType.Battlefield);
        if (sa.usesTargeting()) {
            sa.resetTargets();
            sa.getTargets().add(opp);
            validTappables = opp.getCardsIn(ZoneType.Battlefield);
        }
        validTappables = CardLists.getValidCards((Iterable<Card>)validTappables, valid, source.getController(), source, (CardTraitBase)sa);
        validTappables = CardLists.filter((Iterable<Card>)validTappables, CardPredicates.Presets.UNTAPPED);
        if (sa.hasParam("AILogic") && (logic = sa.getParam("AILogic")).startsWith("AtLeast")) {
            int num = AbilityUtils.calculateAmount(source, logic.substring(7), sa);
            if (validTappables.size() < num) {
                return false;
            }
        }
        if ((double)MyRandom.getRandom().nextFloat() > Math.pow(0.6667, sa.getActivationsThisTurn())) {
            return false;
        }
        if (validTappables.isEmpty()) {
            return false;
        }
        CardCollection human = CardLists.filterControlledBy((Iterable<Card>)validTappables, opp);
        CardCollection compy = CardLists.filterControlledBy((Iterable<Card>)validTappables, ai);
        if (human.size() <= compy.size()) {
            return false;
        }
        if (game.getPhaseHandler().isPlayerTurn(ai)) {
            validTappables = ai.getCardsIn(ZoneType.Battlefield);
            boolean any = Iterables.any(validTappables, c -> CombatUtil.canAttack(c) && ComputerUtilCombat.canAttackNextTurn(c));
            return any;
        }
        return true;
    }

    private CardCollectionView getTapAllTargets(String valid, Card source, SpellAbility sa) {
        Game game = source.getGame();
        CardCollectionView tmpList = game.getCardsIn(ZoneType.Battlefield);
        tmpList = CardLists.getValidCards((Iterable<Card>)tmpList, valid, source.getController(), source, (CardTraitBase)sa);
        tmpList = CardLists.filter((Iterable<Card>)tmpList, CardPredicates.Presets.UNTAPPED);
        return tmpList;
    }

    @Override
    protected boolean doTriggerAINoCost(Player ai, SpellAbility sa, boolean mandatory) {
        int compy;
        int human;
        Card source = sa.getHostCard();
        String valid = sa.getParamOrDefault("ValidCards", "");
        CardCollectionView validTappables = this.getTapAllTargets(valid, source, sa);
        if (sa.usesTargeting()) {
            PlayerCollection targetableOpps = ai.getOpponents().filter(PlayerPredicates.isTargetableBy(sa));
            Player target = targetableOpps.max(PlayerPredicates.compareByLife());
            if (target == null && mandatory) {
                target = ai;
            }
            sa.resetTargets();
            sa.getTargets().add(target);
            validTappables = target.getCardsIn(ZoneType.Battlefield);
        }
        if (mandatory) {
            return true;
        }
        boolean rr = false;
        if ((double)MyRandom.getRandom().nextFloat() <= Math.pow(0.6667, sa.getActivationsThisTurn())) {
            rr = true;
        }
        if (validTappables.size() > 0 && (human = CardLists.count(validTappables, CardPredicates.isControlledByAnyOf(ai.getYourTeam()))) > (compy = CardLists.count(validTappables, CardPredicates.isControlledByAnyOf(ai.getOpponents())))) {
            return rr;
        }
        return false;
    }
}

