/*
 * Decompiled with CFR 0.152.
 */
package forge.ai.ability;

import com.google.common.collect.Iterables;
import forge.ai.AiPlayDecision;
import forge.ai.PlayerControllerAi;
import forge.ai.ability.RevealAiBase;
import forge.game.ability.AbilityUtils;
import forge.game.card.Card;
import forge.game.cost.Cost;
import forge.game.player.Player;
import forge.game.spellability.Spell;
import forge.game.spellability.SpellAbility;
import forge.util.MyRandom;

public class RevealAi
extends RevealAiBase {
    @Override
    protected boolean checkApiLogic(Player ai, SpellAbility sa) {
        boolean randomReturn;
        boolean bFlag = this.revealHandTargetAI(ai, sa, false);
        if (!bFlag) {
            return false;
        }
        boolean bl = randomReturn = (double)MyRandom.getRandom().nextFloat() <= Math.pow(0.667, sa.getActivationsThisTurn() + 1);
        if (RevealAi.playReusable(ai, sa)) {
            randomReturn = true;
        }
        return randomReturn;
    }

    @Override
    protected boolean doTriggerAINoCost(Player ai, SpellAbility sa, boolean mandatory) {
        if (sa.hasParam("MiracleCost")) {
            Card c = sa.getHostCard();
            for (SpellAbility s2 : c.getBasicSpells()) {
                Spell spell = (Spell)s2;
                s2.setActivatingPlayer(ai, true);
                if (!s2.getRestrictions().checkTimingRestrictions(c, s2)) continue;
                spell = (Spell)spell.copyWithDefinedCost(new Cost(sa.getParam("MiracleCost"), false));
                if (AiPlayDecision.WillPlay != ((PlayerControllerAi)ai.getController()).getAi().canPlayFromEffectAI(spell, false, false)) continue;
                return true;
            }
            return false;
        }
        if ("Kefnet".equals(sa.getParam("AILogic"))) {
            Card c = Iterables.getFirst(AbilityUtils.getDefinedCards(sa.getHostCard(), sa.getParam("RevealDefined"), sa), null);
            if (c == null || !c.isInstant() && !c.isSorcery()) {
                return false;
            }
            for (SpellAbility s3 : c.getBasicSpells()) {
                Spell spell = (Spell)s3.copy(ai);
                if (!spell.getRestrictions().checkTimingRestrictions(c, spell)) continue;
                spell.putParam("ReduceCost", "2");
                if (AiPlayDecision.WillPlay != ((PlayerControllerAi)ai.getController()).getAi().canPlayFromEffectAI(spell, false, false)) continue;
                return true;
            }
            return false;
        }
        return this.revealHandTargetAI(ai, sa, mandatory);
    }
}

