/*
 * Decompiled with CFR 0.152.
 */
package forge.ai.ability;

import forge.ai.ComputerUtil;
import forge.ai.ComputerUtilCard;
import forge.ai.ComputerUtilCombat;
import forge.ai.SpellAbilityAi;
import forge.game.Game;
import forge.game.GameObject;
import forge.game.ability.AbilityUtils;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.card.CardLists;
import forge.game.card.CardPredicates;
import forge.game.combat.Combat;
import forge.game.phase.PhaseType;
import forge.game.player.Player;
import forge.game.spellability.SpellAbility;
import forge.game.zone.ZoneType;
import java.util.ArrayList;
import java.util.List;

public class RegenerateAi
extends SpellAbilityAi {
    @Override
    protected boolean checkApiLogic(Player ai, SpellAbility sa) {
        boolean chance;
        block14: {
            Card hostCard;
            Game game;
            block11: {
                block13: {
                    CardCollection targetables;
                    Combat combat;
                    block12: {
                        game = ai.getGame();
                        combat = game.getCombat();
                        hostCard = sa.getHostCard();
                        chance = false;
                        if (!sa.usesTargeting()) break block11;
                        sa.resetTargets();
                        targetables = CardLists.getTargetableCards(ai.getCardsIn(ZoneType.Battlefield), sa);
                        if (targetables.isEmpty()) {
                            return false;
                        }
                        if (game.getStack().isEmpty()) break block12;
                        List<GameObject> objects = ComputerUtil.predictThreatenedObjects(sa.getActivatingPlayer(), sa, true);
                        ArrayList<Card> threatenedTargets = new ArrayList<Card>();
                        for (Card c : targetables) {
                            if (!objects.contains(c) || ComputerUtil.canRegenerate(ai, c)) continue;
                            threatenedTargets.add(c);
                        }
                        if (threatenedTargets.isEmpty()) break block13;
                        sa.getTargets().add(ComputerUtilCard.getBestCreatureAI(threatenedTargets));
                        chance = true;
                        break block13;
                    }
                    if (game.getPhaseHandler().is(PhaseType.COMBAT_DECLARE_BLOCKERS)) {
                        CardCollection combatants = CardLists.filter((Iterable<Card>)targetables, CardPredicates.Presets.CREATURES);
                        ComputerUtilCard.sortByEvaluateCreature(combatants);
                        for (Card c : combatants) {
                            if (c.getShieldCount() != 0 || !ComputerUtilCombat.combatantWouldBeDestroyed(ai, c, combat)) continue;
                            sa.getTargets().add(c);
                            chance = true;
                            break;
                        }
                    }
                }
                if (sa.getTargets().isEmpty()) {
                    return false;
                }
                break block14;
            }
            CardCollection list = AbilityUtils.getDefinedCards(hostCard, sa.getParam("Defined"), sa);
            if (list.isEmpty()) {
                return false;
            }
            int numToSave = Math.min(2, list.size());
            int saved = 0;
            if (game.getPhaseHandler().is(PhaseType.COMBAT_DECLARE_BLOCKERS)) {
                for (Card c : list) {
                    if (c.getShieldCount() == 0 && ComputerUtil.predictCreatureWillDieThisTurn(ai, c, sa)) {
                        ++saved;
                    }
                    if (saved != numToSave) continue;
                    break;
                }
            } else {
                List<GameObject> objects = ComputerUtil.predictThreatenedObjects(sa.getActivatingPlayer(), sa, true);
                objects.retainAll(list);
                saved = objects.size();
            }
            chance = saved >= numToSave;
        }
        return chance;
    }

    @Override
    protected boolean doTriggerAINoCost(Player ai, SpellAbility sa, boolean mandatory) {
        boolean chance = false;
        chance = sa.usesTargeting() ? RegenerateAi.regenMandatoryTarget(ai, sa, mandatory) : true;
        return chance;
    }

    private static boolean regenMandatoryTarget(Player ai, SpellAbility sa, boolean mandatory) {
        Game game = ai.getGame();
        sa.resetTargets();
        CardCollection targetables = CardLists.getTargetableCards(game.getCardsIn(ZoneType.Battlefield), sa);
        CardCollection compTargetables = CardLists.filterControlledBy((Iterable<Card>)targetables, ai);
        if (targetables.isEmpty()) {
            return false;
        }
        if (!mandatory && compTargetables.isEmpty()) {
            return false;
        }
        if (compTargetables.size() > 0) {
            CardCollection combatants = CardLists.filter((Iterable<Card>)compTargetables, CardPredicates.Presets.CREATURES);
            ComputerUtilCard.sortByEvaluateCreature(combatants);
            if (game.getPhaseHandler().is(PhaseType.COMBAT_DECLARE_BLOCKERS)) {
                Combat combat = game.getCombat();
                for (Card c : combatants) {
                    if (c.getShieldCount() != 0 || !ComputerUtilCombat.combatantWouldBeDestroyed(ai, c, combat)) continue;
                    sa.getTargets().add(c);
                    return true;
                }
            }
            if (CardLists.getNotType(compTargetables, "Creature").isEmpty()) {
                for (Card c : combatants) {
                    if (c.getShieldCount() != 0) continue;
                    sa.getTargets().add(c);
                    return true;
                }
                sa.getTargets().add((GameObject)combatants.get(false));
                return true;
            }
            CardLists.sortByCmcDesc(compTargetables);
            for (Card c : compTargetables) {
                if (c.getShieldCount() != 0) continue;
                sa.getTargets().add(c);
                return true;
            }
            sa.getTargets().add((GameObject)compTargetables.get(0));
            return true;
        }
        sa.getTargets().add(ComputerUtilCard.getCheapestPermanentAI(targetables, sa, false));
        return true;
    }
}

