/*
 * Decompiled with CFR 0.152.
 */
package forge.ai.ability;

import forge.ai.AiCardMemory;
import forge.ai.AiController;
import forge.ai.AiProps;
import forge.ai.ComputerUtilMana;
import forge.ai.PlayerControllerAi;
import forge.ai.SpellAbilityAi;
import forge.game.ability.AbilityUtils;
import forge.game.card.Card;
import forge.game.card.CardLists;
import forge.game.card.CardPredicates;
import forge.game.phase.PhaseHandler;
import forge.game.phase.PhaseType;
import forge.game.player.Player;
import forge.game.player.PlayerActionConfirmMode;
import forge.game.player.PlayerCollection;
import forge.game.player.PlayerPredicates;
import forge.game.spellability.SpellAbility;
import forge.game.zone.ZoneType;
import forge.util.MyRandom;
import java.util.Map;

public class RearrangeTopOfLibraryAi
extends SpellAbilityAi {
    @Override
    protected boolean canPlayAI(Player aiPlayer, SpellAbility sa) {
        PhaseHandler ph = aiPlayer.getGame().getPhaseHandler();
        Card source = sa.getHostCard();
        if (!sa.isTrigger()) {
            if (!(!source.isPermanent() || sa.getRestrictions().isSorcerySpeed() || !sa.getPayCosts().hasTapCost() && !sa.getPayCosts().hasManaCost() || ph.is(PhaseType.END_OF_TURN) && ph.getNextTurn() == aiPlayer)) {
                return false;
            }
            if (AiCardMemory.isRememberedCardByName(aiPlayer, source.getName(), AiCardMemory.MemorySet.ACTIVATED_THIS_TURN)) {
                return false;
            }
        }
        if (sa.usesTargeting()) {
            sa.resetTargets();
            PlayerCollection targetableOpps = aiPlayer.getOpponents().filter(PlayerPredicates.isTargetableBy(sa));
            Player opp = targetableOpps.min(PlayerPredicates.compareByLife());
            boolean canTgtAI = sa.canTarget(aiPlayer);
            boolean canTgtHuman = sa.canTarget(opp);
            if (canTgtHuman && canTgtAI) {
                Player preferredTarget = MyRandom.percentTrue(50) ? aiPlayer : opp;
                sa.getTargets().add(preferredTarget);
            } else if (canTgtAI) {
                sa.getTargets().add(aiPlayer);
            } else if (canTgtHuman) {
                sa.getTargets().add(opp);
            } else {
                return false;
            }
            if (!canTgtHuman || !canTgtAI) {
                AiCardMemory.rememberCard(aiPlayer, source, AiCardMemory.MemorySet.ACTIVATED_THIS_TURN);
            }
        } else {
            AiCardMemory.rememberCard(aiPlayer, source, AiCardMemory.MemorySet.ACTIVATED_THIS_TURN);
        }
        return true;
    }

    @Override
    protected boolean doTriggerAINoCost(Player ai, SpellAbility sa, boolean mandatory) {
        return this.canPlayAI(ai, sa) || mandatory;
    }

    @Override
    public boolean confirmAction(Player player, SpellAbility sa, PlayerActionConfirmMode mode, String message, Map<String, Object> params) {
        Card top;
        PlayerCollection pc = sa.usesTargeting() ? new PlayerCollection(sa.getTargets().getTargetPlayers()) : AbilityUtils.getDefinedPlayers(sa.getHostCard(), sa.getParam("Defined"), sa);
        Player p = (Player)pc.getFirst();
        Card card = top = p.getCardsIn(ZoneType.Library).isEmpty() ? null : (Card)p.getCardsIn(ZoneType.Library).getFirst();
        if (top == null) {
            return false;
        }
        int uncastableCMCThreshold = 2;
        int minLandsToScryLandsAway = 4;
        if (player.getController().isAI()) {
            AiController aic = ((PlayerControllerAi)player.getController()).getAi();
            minLandsToScryLandsAway = aic.getIntProperty(AiProps.SCRY_NUM_LANDS_TO_NOT_NEED_MORE);
            uncastableCMCThreshold = aic.getIntProperty(AiProps.SCRY_IMMEDIATELY_UNCASTABLE_CMC_DIFF);
        }
        int landsOTB = CardLists.count(p.getCardsIn(ZoneType.Battlefield), CardPredicates.Presets.LANDS_PRODUCING_MANA);
        int cmc = top.isSplitCard() ? Math.min(top.getCMC(Card.SplitCMCMode.LeftSplitCMC), top.getCMC(Card.SplitCMCMode.RightSplitCMC)) : top.getCMC();
        int maxCastable = ComputerUtilMana.getAvailableManaEstimate(p, false);
        if (!top.isLand() && cmc - maxCastable >= uncastableCMCThreshold) {
            return !p.isOpponentOf(player);
        }
        if (top.isLand() && landsOTB <= minLandsToScryLandsAway) {
            return p.isOpponentOf(player);
        }
        return false;
    }
}

