/*
 * Decompiled with CFR 0.152.
 */
package forge.ai.ability;

import com.google.common.collect.Iterables;
import forge.ai.ComputerUtil;
import forge.ai.ComputerUtilCard;
import forge.ai.ComputerUtilCombat;
import forge.ai.ComputerUtilCost;
import forge.ai.ability.PumpAiBase;
import forge.game.CardTraitBase;
import forge.game.Game;
import forge.game.GameObject;
import forge.game.ability.AbilityUtils;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.card.CardLists;
import forge.game.combat.Combat;
import forge.game.cost.Cost;
import forge.game.keyword.Keyword;
import forge.game.phase.PhaseHandler;
import forge.game.phase.PhaseType;
import forge.game.player.Player;
import forge.game.spellability.SpellAbility;
import forge.game.zone.ZoneType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class PumpAllAi
extends PumpAiBase {
    @Override
    protected boolean canPlayAI(Player ai, SpellAbility sa) {
        PhaseHandler ph;
        Card source = sa.getHostCard();
        Game game = ai.getGame();
        Combat combat = game.getCombat();
        Cost abCost = sa.getPayCosts();
        String logic = sa.getParamOrDefault("AILogic", "");
        if (logic.equals("UntapCombatTrick") && !(ph = ai.getGame().getPhaseHandler()).is(PhaseType.COMBAT_DECLARE_BLOCKERS, ai) && (ph.getPlayerTurn().equals(ai) || !ph.is(PhaseType.COMBAT_DECLARE_ATTACKERS))) {
            return false;
        }
        if (ComputerUtil.preventRunAwayActivations(sa)) {
            return false;
        }
        if (abCost != null && source.hasSVar("AIPreference") && !ComputerUtilCost.checkSacrificeCost(ai, abCost, source, sa, true)) {
            return false;
        }
        Player opp = ai.getStrongestOpponent();
        if (sa.usesTargeting()) {
            if (sa.canTarget(opp) && sa.isCurse()) {
                sa.resetTargets();
                sa.getTargets().add(opp);
                return true;
            }
            if (sa.canTarget(ai) && !sa.isCurse()) {
                sa.resetTargets();
                sa.getTargets().add(ai);
                return true;
            }
        }
        int power = AbilityUtils.calculateAmount(source, sa.getParam("NumAtt"), sa);
        int defense = AbilityUtils.calculateAmount(source, sa.getParam("NumDef"), sa);
        ArrayList keywords = sa.hasParam("KW") ? Arrays.asList(sa.getParam("KW").split(" & ")) : new ArrayList();
        PhaseType phase = game.getPhaseHandler().getPhase();
        String valid = sa.getParamOrDefault("ValidCards", "");
        CardCollection comp = CardLists.getValidCards((Iterable<Card>)ai.getCardsIn(ZoneType.Battlefield), valid, source.getController(), source, (CardTraitBase)sa);
        CardCollection human = CardLists.getValidCards((Iterable<Card>)opp.getCardsIn(ZoneType.Battlefield), valid, source.getController(), source, (CardTraitBase)sa);
        if (sa.isCurse()) {
            if (defense < 0) {
                comp = CardLists.filter((Iterable<Card>)comp, c -> {
                    if (c.getNetToughness() <= -defense) {
                        return true;
                    }
                    return ComputerUtilCombat.getDamageToKill(c, false) <= -defense && !c.hasKeyword(Keyword.INDESTRUCTIBLE);
                });
                human = CardLists.filter((Iterable<Card>)human, c -> {
                    if (c.getNetToughness() <= -defense) {
                        return true;
                    }
                    return ComputerUtilCombat.getDamageToKill(c, false) <= -defense && !c.hasKeyword(Keyword.INDESTRUCTIBLE);
                });
            } else if (power < 0) {
                if (phase.isAfter(PhaseType.COMBAT_DECLARE_BLOCKERS) || phase.isBefore(PhaseType.COMBAT_DECLARE_ATTACKERS) || game.getPhaseHandler().isPlayerTurn(sa.getActivatingPlayer()) || game.getReplacementHandler().isPreventCombatDamageThisTurn()) {
                    return false;
                }
                int totalPower = 0;
                for (Card c2 : human) {
                    if (combat == null || !combat.isAttacking(c2)) continue;
                    totalPower += Math.min(c2.getNetPower(), power * -1);
                    if (phase == PhaseType.COMBAT_DECLARE_BLOCKERS && combat.isUnblocked(c2)) {
                        if (ComputerUtilCombat.lifeInDanger(sa.getActivatingPlayer(), combat)) {
                            return true;
                        }
                        totalPower += Math.min(c2.getNetPower(), power * -1);
                    }
                    if (totalPower < power * -2) continue;
                    return true;
                }
                return false;
            }
            if (comp.isEmpty() && ComputerUtil.activateForCost(sa, ai)) {
                return true;
            }
            return ComputerUtilCard.evaluateCreatureList(comp) + 200 < ComputerUtilCard.evaluateCreatureList(human);
        }
        if (!game.getStack().isEmpty()) {
            return this.pumpAgainstRemoval(ai, sa, comp);
        }
        return Iterables.any(ai.getCreaturesInPlay(), c -> c.isValid(valid, source.getController(), source, (CardTraitBase)sa) && ComputerUtilCard.shouldPumpCard(ai, sa, c, defense, power, keywords));
    }

    @Override
    public boolean chkAIDrawback(SpellAbility sa, Player aiPlayer) {
        return true;
    }

    @Override
    protected boolean doTriggerAINoCost(Player ai, SpellAbility sa, boolean mandatory) {
        if (!sa.usesTargeting() && !sa.isCurse() && sa.hasParam("ValidCards") && sa.getParam("ValidCards").contains("YouCtrl")) {
            return true;
        }
        return this.canPlayAI(ai, sa) || mandatory;
    }

    boolean pumpAgainstRemoval(Player ai, SpellAbility sa, List<Card> comp) {
        List<GameObject> objects = ComputerUtil.predictThreatenedObjects(sa.getActivatingPlayer(), sa, true);
        for (Card c : comp) {
            if (!objects.contains(c)) continue;
            return true;
        }
        return false;
    }
}

