/*
 * Decompiled with CFR 0.152.
 */
package forge.ai.ability;

import forge.ai.AiAttackController;
import forge.ai.ComputerUtil;
import forge.ai.ComputerUtilCard;
import forge.ai.ComputerUtilCombat;
import forge.ai.ComputerUtilCost;
import forge.ai.SpellAbilityAi;
import forge.card.MagicColor;
import forge.game.CardTraitBase;
import forge.game.Game;
import forge.game.GameObject;
import forge.game.ability.AbilityUtils;
import forge.game.ability.ApiType;
import forge.game.ability.effects.ProtectEffect;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.card.CardLists;
import forge.game.card.CardUtil;
import forge.game.combat.Combat;
import forge.game.phase.PhaseHandler;
import forge.game.phase.PhaseType;
import forge.game.player.Player;
import forge.game.spellability.SpellAbility;
import forge.game.spellability.TargetRestrictions;
import forge.util.MyRandom;
import java.util.ArrayList;
import java.util.List;

public class ProtectAi
extends SpellAbilityAi {
    private static boolean hasProtectionFrom(Card card, String color) {
        ArrayList<String> onlyColors = new ArrayList<String>(MagicColor.Constant.ONLY_COLORS);
        if (!onlyColors.contains(color)) {
            return false;
        }
        String protection = "Protection from " + color;
        return card.hasKeyword(protection);
    }

    private static boolean hasProtectionFromAny(Card card, Iterable<String> colors) {
        boolean protect = false;
        for (String color : colors) {
            protect |= ProtectAi.hasProtectionFrom(card, color);
        }
        return protect;
    }

    private static boolean hasProtectionFromAll(Card card, Iterable<String> colors) {
        boolean protect = true;
        boolean isEmpty = true;
        for (String color : colors) {
            protect &= ProtectAi.hasProtectionFrom(card, color);
            isEmpty = false;
        }
        return protect && !isEmpty;
    }

    public static String toProtectFrom(Card threat, SpellAbility sa) {
        if (sa.getApi() != ApiType.Protection) {
            return null;
        }
        List<String> choices = ProtectEffect.getProtectionList(sa);
        if (threat.isArtifact() && choices.contains("Artifact")) {
            return "Artifact";
        }
        if (threat.isBlack() && choices.contains("black")) {
            return "black";
        }
        if (threat.isBlue() && choices.contains("blue")) {
            return "blue";
        }
        if (threat.isGreen() && choices.contains("green")) {
            return "green";
        }
        if (threat.isRed() && choices.contains("red")) {
            return "red";
        }
        if (threat.isWhite() && choices.contains("white")) {
            return "white";
        }
        return null;
    }

    public static CardCollection getProtectCreatures(Player ai, SpellAbility sa) {
        List<String> gains = ProtectEffect.getProtectionList(sa);
        Game game = ai.getGame();
        Combat combat = game.getCombat();
        PhaseHandler ph = game.getPhaseHandler();
        CardCollection list = ai.getCreaturesInPlay();
        List<GameObject> threatenedObjects = ComputerUtil.predictThreatenedObjects(sa.getActivatingPlayer(), sa, true);
        list = CardLists.filter((Iterable<Card>)list, c -> {
            if (!c.canBeTargetedBy(sa)) {
                return false;
            }
            if (ProtectAi.hasProtectionFromAll(c, gains)) {
                return false;
            }
            if (threatenedObjects.contains(c)) {
                return true;
            }
            if (combat != null) {
                CardCollection threats;
                if (combat.isBlocking((Card)c) && ComputerUtilCombat.blockerWouldBeDestroyed(ai, c, combat)) {
                    CardCollection threats2 = combat.getAttackersBlockedBy((Card)c);
                    return threats2 != null && !threats2.isEmpty() && ProtectAi.toProtectFrom((Card)threats2.get(0), sa) != null;
                }
                if (combat.isAttacking((Card)c) && combat.isBlocked((Card)c) && ComputerUtilCombat.attackerWouldBeDestroyed(ai, c, combat) && (threats = combat.getBlockers((Card)c)) != null && !threats.isEmpty()) {
                    ComputerUtilCard.sortByEvaluateCreature(threats);
                    return ProtectAi.toProtectFrom((Card)threats.get(false), sa) != null;
                }
            }
            if (ph.getPlayerTurn() == ai && ph.getPhase() == PhaseType.MAIN1) {
                AiAttackController aiAtk = new AiAttackController(ai, (Card)c);
                String s2 = aiAtk.toProtectAttacker(sa);
                if (s2 == null) {
                    return false;
                }
                Player opponent = ai.getWeakestOpponent();
                Combat combat1 = ai.getGame().getCombat();
                int dmg = ComputerUtilCombat.damageIfUnblocked(c, opponent, combat1, true);
                float ratio = 1.0f * (float)dmg / (float)opponent.getLife();
                return MyRandom.getRandom().nextFloat() < ratio;
            }
            return false;
        });
        return list;
    }

    @Override
    protected boolean checkPhaseRestrictions(Player ai, SpellAbility sa, PhaseHandler ph) {
        boolean notAiMain1 = ph.getPlayerTurn() != ai || ph.getPhase() != PhaseType.MAIN1;
        return !ProtectAi.isSorcerySpeed(sa, ai) || !notAiMain1;
    }

    @Override
    protected boolean checkApiLogic(Player ai, SpellAbility sa) {
        if (sa.usesTargeting()) {
            return this.protectTgtAI(ai, sa, false);
        }
        CardCollection cards = AbilityUtils.getDefinedCards(sa.getHostCard(), sa.getParam("Defined"), sa);
        if (cards.size() == 0) {
            return false;
        }
        if (cards.size() == 1) {
            return ProtectAi.getProtectCreatures(ai, sa).contains(cards.get(0));
        }
        return false;
    }

    private boolean protectTgtAI(Player ai, SpellAbility sa, boolean mandatory) {
        Game game = ai.getGame();
        if (!mandatory && game.getPhaseHandler().getPhase().isAfter(PhaseType.COMBAT_DECLARE_BLOCKERS) && game.getStack().isEmpty()) {
            return false;
        }
        Card source = sa.getHostCard();
        TargetRestrictions tgt = sa.getTargetRestrictions();
        sa.resetTargets();
        CardCollection list = ProtectAi.getProtectCreatures(ai, sa);
        list = CardLists.getValidCards((Iterable<Card>)list, tgt.getValidTgts(), sa.getActivatingPlayer(), source, (CardTraitBase)sa);
        if (game.getStack().isEmpty() && sa.getPayCosts().hasTapCost()) {
            if (game.getPhaseHandler().getPhase().isBefore(PhaseType.COMBAT_DECLARE_ATTACKERS) && game.getPhaseHandler().isPlayerTurn(ai)) {
                list.remove(sa.getHostCard());
            }
            if (game.getPhaseHandler().getPhase().isBefore(PhaseType.COMBAT_DECLARE_BLOCKERS) && game.getPhaseHandler().isPlayerTurn(ai)) {
                list.remove(sa.getHostCard());
            }
        }
        list = ComputerUtil.getSafeTargets(ai, sa, list);
        if (ComputerUtilCost.isSacrificeSelfCost(sa.getPayCosts())) {
            list.remove(source);
        }
        if (list.isEmpty()) {
            return mandatory && ProtectAi.protectMandatoryTarget(ai, sa);
        }
        while (sa.canAddMoreTarget()) {
            Card t2 = null;
            if (list.isEmpty()) {
                if (sa.getTargets().size() >= tgt.getMinTargets(source, sa) && sa.getTargets().size() != 0) break;
                if (mandatory) {
                    return ProtectAi.protectMandatoryTarget(ai, sa);
                }
                sa.resetTargets();
                return false;
            }
            t2 = ComputerUtilCard.getBestCreatureAI(list);
            sa.getTargets().add(t2);
            list.remove(t2);
        }
        return true;
    }

    private static boolean protectMandatoryTarget(Player ai, SpellAbility sa) {
        Card c2;
        TargetRestrictions tgt = sa.getTargetRestrictions();
        Card source = sa.getHostCard();
        List<Card> list = CardUtil.getValidCardsToTarget(sa);
        if (list.size() < tgt.getMinTargets(source, sa)) {
            sa.resetTargets();
            return false;
        }
        CardCollection pref = CardLists.filterControlledBy(list, ai);
        pref = CardLists.filter((Iterable<Card>)pref, c -> !ProtectAi.hasProtectionFromAll(c, ProtectEffect.getProtectionList(sa)));
        CardCollection pref2 = CardLists.filterControlledBy(list, ai);
        pref = CardLists.filter((Iterable<Card>)pref, c -> !ProtectAi.hasProtectionFromAny(c, ProtectEffect.getProtectionList(sa)));
        CardCollection forced = CardLists.filterControlledBy(list, ai);
        while (sa.canAddMoreTarget() && !pref.isEmpty()) {
            c2 = ComputerUtilCard.getBestAI(pref);
            pref.remove(c2);
            sa.getTargets().add(c2);
        }
        while (sa.canAddMoreTarget() && !pref2.isEmpty()) {
            c2 = ComputerUtilCard.getBestAI(pref2);
            pref2.remove(c2);
            sa.getTargets().add(c2);
        }
        while (!sa.isMinTargetChosen() && !forced.isEmpty()) {
            c2 = CardLists.getNotType(forced, "Creature").isEmpty() ? ComputerUtilCard.getWorstCreatureAI(forced) : ComputerUtilCard.getCheapestPermanentAI(forced, sa, false);
            forced.remove(c2);
            sa.getTargets().add(c2);
        }
        if (!sa.isMinTargetChosen()) {
            sa.resetTargets();
            return false;
        }
        return true;
    }

    @Override
    protected boolean doTriggerAINoCost(Player ai, SpellAbility sa, boolean mandatory) {
        if (!sa.usesTargeting()) {
            if (mandatory) {
                return true;
            }
        } else {
            return this.protectTgtAI(ai, sa, mandatory);
        }
        return true;
    }

    @Override
    public boolean chkAIDrawback(SpellAbility sa, Player ai) {
        if (sa.usesTargeting()) {
            return this.protectTgtAI(ai, sa, false);
        }
        return true;
    }
}

