/*
 * Decompiled with CFR 0.152.
 */
package forge.ai.ability;

import forge.ai.ComputerUtilCard;
import forge.ai.SpellAbilityAi;
import forge.game.CardTraitBase;
import forge.game.ability.AbilityUtils;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.card.CardLists;
import forge.game.player.Player;
import forge.game.spellability.SpellAbility;
import forge.game.spellability.TargetRestrictions;
import forge.game.zone.ZoneType;
import forge.util.MyRandom;

public class PowerExchangeAi
extends SpellAbilityAi {
    @Override
    protected boolean canPlayAI(Player ai, SpellAbility sa) {
        Card c1 = null;
        Card c2 = null;
        TargetRestrictions tgt = sa.getTargetRestrictions();
        sa.resetTargets();
        CardCollection list = CardLists.getValidCards((Iterable<Card>)ai.getGame().getCardsIn(ZoneType.Battlefield), tgt.getValidTgts(), ai, sa.getHostCard(), (CardTraitBase)sa);
        list = CardLists.filter((Iterable<Card>)list, c -> c.canBeTargetedBy(sa) && c.getController() != ai);
        CardLists.sortByPowerDesc(list);
        Card card = c1 = list.isEmpty() ? null : (Card)list.get(0);
        if (sa.hasParam("Defined")) {
            c2 = (Card)AbilityUtils.getDefinedCards(sa.getHostCard(), sa.getParam("Defined"), sa).get(false);
        } else if (tgt.getMinTargets(sa.getHostCard(), sa) > 1) {
            CardCollection list2 = CardLists.getValidCards((Iterable<Card>)ai.getCardsIn(ZoneType.Battlefield), tgt.getValidTgts(), ai, sa.getHostCard(), (CardTraitBase)sa);
            CardLists.sortByPowerDesc(list2);
            c2 = list2.isEmpty() ? null : (Card)list2.get(false);
            sa.getTargets().add(c2);
        }
        if (c1 == null || c2 == null) {
            return false;
        }
        if (sa.isMandatory() || ComputerUtilCard.evaluateCreature(c1) > ComputerUtilCard.evaluateCreature(c2) + 40) {
            sa.getTargets().add(c1);
            return (double)MyRandom.getRandom().nextFloat() <= Math.pow(0.6667, sa.getActivationsThisTurn());
        }
        return false;
    }

    @Override
    protected boolean doTriggerAINoCost(Player aiPlayer, SpellAbility sa, boolean mandatory) {
        if (!sa.usesTargeting()) {
            if (mandatory) {
                return true;
            }
        } else {
            return this.canPlayAI(aiPlayer, sa);
        }
        return true;
    }
}

