/*
 * Decompiled with CFR 0.152.
 */
package forge.ai.ability;

import forge.ai.AiController;
import forge.ai.AiProps;
import forge.ai.ComputerUtil;
import forge.ai.ComputerUtilCard;
import forge.ai.ComputerUtilCombat;
import forge.ai.ComputerUtilCost;
import forge.ai.PlayerControllerAi;
import forge.ai.ability.ManaAi;
import forge.ai.ability.PermanentAi;
import forge.card.mana.ManaCost;
import forge.game.Game;
import forge.game.ability.ApiType;
import forge.game.card.Card;
import forge.game.card.CardCopyService;
import forge.game.card.CardLists;
import forge.game.combat.Combat;
import forge.game.keyword.Keyword;
import forge.game.phase.PhaseHandler;
import forge.game.phase.PhaseType;
import forge.game.player.Player;
import forge.game.spellability.SpellAbility;
import forge.game.staticability.StaticAbility;
import forge.game.zone.ZoneType;
import forge.util.MyRandom;
import org.apache.commons.lang3.StringUtils;

public class PermanentCreatureAi
extends PermanentAi {
    @Override
    protected boolean checkAiLogic(Player ai, SpellAbility sa, String aiLogic) {
        return !"Never".equals(aiLogic);
    }

    @Override
    protected boolean checkPhaseRestrictions(Player ai, SpellAbility sa, PhaseHandler ph) {
        Card card = sa.getHostCard();
        Game game = ai.getGame();
        if (sa.isDash()) {
            if (ph.isPlayerTurn(ai) && ph.getPhase().isBefore(PhaseType.COMBAT_DECLARE_ATTACKERS)) {
                if (game.getReplacementHandler().wouldPhaseBeSkipped(ai, "BeginCombat")) {
                    return false;
                }
                if (ComputerUtilCost.canPayCost(sa.getHostCard().getSpellPermanent(), ai, false)) {
                    return false;
                }
                Card dashed = CardCopyService.getLKICopy(sa.getHostCard());
                dashed.setSickness(false);
                return ComputerUtilCard.doesSpecifiedCreatureAttackAI(ai, dashed);
            }
            return false;
        }
        if (sa.isBlitz() && ph.getPhase().isAfter(PhaseType.MAIN1)) {
            return false;
        }
        if (card.hasSVar("EndOfTurnLeavePlay") && (!ph.isPlayerTurn(ai) || ph.getPhase().isAfter(PhaseType.COMBAT_DECLARE_ATTACKERS) || game.getReplacementHandler().wouldPhaseBeSkipped(ai, "BeginCombat"))) {
            return false;
        }
        boolean advancedFlash = false;
        if (ai.getController().isAI()) {
            advancedFlash = ((PlayerControllerAi)ai.getController()).getAi().getBooleanProperty(AiProps.FLASH_ENABLE_ADVANCED_LOGIC);
        }
        if (card.hasKeyword(Keyword.FLASH) || !ai.canCastSorcery() && sa.canCastTiming(ai) && !sa.isCastFromPlayEffect()) {
            if (advancedFlash) {
                return this.doAdvancedFlashLogic(card, ai, sa);
            }
            if ((ai.isUnlimitedHandSize() || ai.getCardsIn(ZoneType.Hand).size() <= ai.getMaxHandSize() || ph.getPhase().isBefore(PhaseType.END_OF_TURN)) && ai.getManaPool().totalMana() <= 0 && (ph.isPlayerTurn(ai) || ph.getPhase().isBefore(PhaseType.COMBAT_DECLARE_ATTACKERS)) && !card.hasETBTrigger(true) && !card.hasSVar("AmbushAI") && game.getStack().isEmpty() && !ComputerUtil.castPermanentInMain1(ai, sa)) {
                return false;
            }
        }
        return super.checkPhaseRestrictions(ai, sa, ph);
    }

    private boolean doAdvancedFlashLogic(Card card, Player ai, SpellAbility sa) {
        SpellAbility peekSa;
        Player activator;
        Game game = ai.getGame();
        PhaseHandler ph = game.getPhaseHandler();
        Combat combat = game.getCombat();
        AiController aic = ((PlayerControllerAi)ai.getController()).getAi();
        boolean isOppTurn = ph.getPlayerTurn().isOpponentOf(ai);
        boolean isOwnEOT = ph.is(PhaseType.END_OF_TURN, ai);
        boolean isEOTBeforeMyTurn = ph.is(PhaseType.END_OF_TURN) && ph.getNextTurn().equals(ai);
        boolean isMyDeclareBlockers = ph.is(PhaseType.COMBAT_DECLARE_BLOCKERS, ai) && ph.inCombat();
        boolean isOppDeclareAttackers = ph.is(PhaseType.COMBAT_DECLARE_ATTACKERS) && isOppTurn && ph.inCombat();
        boolean isMyMain1OrLater = ph.is(PhaseType.MAIN1, ai) || ph.getPhase().isAfter(PhaseType.MAIN1) && ph.getPlayerTurn().equals(ai);
        boolean canRespondToStack = false;
        if (!game.getStack().isEmpty() && (activator = (peekSa = game.getStack().peekAbility()).getActivatingPlayer()) != null && activator.isOpponentOf(ai) && peekSa.getApi() != ApiType.DestroyAll && peekSa.getApi() != ApiType.DamageAll) {
            canRespondToStack = true;
        }
        boolean hasETBTrigger = card.hasETBTrigger(true);
        boolean hasAmbushAI = card.hasSVar("AmbushAI");
        boolean defOnlyAmbushAI = hasAmbushAI && "BlockOnly".equals(card.getSVar("AmbushAI"));
        boolean loseFloatMana = ai.getManaPool().totalMana() > 0 && !ManaAi.canRampPool(ai, card);
        boolean willDiscardNow = isOwnEOT && !ai.isUnlimitedHandSize() && ai.getCardsIn(ZoneType.Hand).size() > ai.getMaxHandSize();
        boolean willDieNow = combat != null && ComputerUtilCombat.lifeInSeriousDanger(ai, combat);
        boolean wantToCastInMain1 = ph.is(PhaseType.MAIN1, ai) && ComputerUtil.castPermanentInMain1(ai, sa);
        boolean isCommander = card.isCommander();
        boolean valuableBlocker = false;
        if (combat != null && combat.getDefendingPlayers().contains(ai)) {
            int numUntappedPotentialBlockers = CardLists.filter((Iterable<Card>)ai.getCreaturesInPlay(), card1 -> card1.isUntapped() && !ComputerUtilCard.isUselessCreature(ai, card1)).size();
            if (combat.getAttackersOf(ai).size() > numUntappedPotentialBlockers) {
                valuableBlocker = true;
            }
        }
        int chanceToObeyAmbushAI = aic.getIntProperty(AiProps.FLASH_CHANCE_TO_OBEY_AMBUSHAI);
        int chanceToAddBlocker = aic.getIntProperty(AiProps.FLASH_CHANCE_TO_CAST_AS_VALUABLE_BLOCKER);
        int chanceToCastForETB = aic.getIntProperty(AiProps.FLASH_CHANCE_TO_CAST_DUE_TO_ETB_EFFECTS);
        int chanceToRespondToStack = aic.getIntProperty(AiProps.FLASH_CHANCE_TO_RESPOND_TO_STACK_WITH_ETB);
        int chanceToProcETBBeforeMain1 = aic.getIntProperty(AiProps.FLASH_CHANCE_TO_CAST_FOR_ETB_BEFORE_MAIN1);
        boolean canCastAtOppTurn = true;
        block0: for (Card c : ai.getGame().getCardsIn(ZoneType.Battlefield)) {
            for (StaticAbility s2 : c.getStaticAbilities()) {
                if (!"CantBeCast".equals(s2.getParam("Mode")) || !StringUtils.contains((CharSequence)s2.getParam("Activator"), "NonActive") || s2.getParam("Activator").startsWith("You") && !c.getController().equals(ai)) continue;
                canCastAtOppTurn = false;
                continue block0;
            }
        }
        if (loseFloatMana || willDiscardNow || willDieNow) {
            return true;
        }
        if (isCommander && isMyMain1OrLater) {
            return true;
        }
        if (wantToCastInMain1) {
            return isMyMain1OrLater;
        }
        if (hasAmbushAI && MyRandom.percentTrue(chanceToObeyAmbushAI)) {
            return defOnlyAmbushAI && canCastAtOppTurn ? isOppDeclareAttackers : isOppDeclareAttackers || isMyDeclareBlockers;
        }
        if (valuableBlocker && isOppDeclareAttackers && MyRandom.percentTrue(chanceToAddBlocker)) {
            return true;
        }
        if (hasETBTrigger && MyRandom.percentTrue(chanceToCastForETB)) {
            return isMyMain1OrLater || isOppTurn || MyRandom.percentTrue(chanceToProcETBBeforeMain1);
        }
        if (hasETBTrigger && canRespondToStack && MyRandom.percentTrue(chanceToRespondToStack)) {
            return canCastAtOppTurn || ph.getPlayerTurn().equals(ai);
        }
        return canCastAtOppTurn ? isEOTBeforeMyTurn : isOwnEOT;
    }

    @Override
    protected boolean checkApiLogic(Player ai, SpellAbility sa) {
        if (!super.checkApiLogic(ai, sa)) {
            return false;
        }
        Card card = sa.getHostCard();
        ManaCost mana = card.getManaCost();
        Game game = ai.getGame();
        if (card.hasStartOfKeyword("etbCounter") || mana.countX() != 0 || card.hasETBTrigger(false) || card.hasETBReplacement() || card.hasSVar("NoZeroToughnessAI")) {
            return true;
        }
        Card copy = CardCopyService.getLKICopy(card);
        ComputerUtilCard.applyStaticContPT(game, copy, null);
        return copy.getNetToughness() > 0;
    }
}

