/*
 * Decompiled with CFR 0.152.
 */
package forge.ai.ability;

import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import forge.ai.ComputerUtil;
import forge.ai.ComputerUtilCost;
import forge.ai.ComputerUtilMana;
import forge.ai.SpellAbilityAi;
import forge.card.CardStateName;
import forge.card.CardType;
import forge.card.mana.ManaCost;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.card.CardCollectionView;
import forge.game.card.CardLists;
import forge.game.card.CardPredicates;
import forge.game.card.CounterEnumType;
import forge.game.cost.Cost;
import forge.game.keyword.Keyword;
import forge.game.keyword.KeywordInterface;
import forge.game.mana.ManaCostBeingPaid;
import forge.game.phase.PhaseHandler;
import forge.game.phase.PhaseType;
import forge.game.player.Player;
import forge.game.spellability.SpellAbility;
import forge.game.zone.ZoneType;
import org.apache.commons.lang3.StringUtils;

public class PermanentAi
extends SpellAbilityAi {
    @Override
    protected boolean checkPhaseRestrictions(Player ai, SpellAbility sa, PhaseHandler ph) {
        Card card = sa.getHostCard();
        if (card.hasKeyword("MayFlashSac") && !ai.canCastSorcery()) {
            return false;
        }
        return !ph.is(PhaseType.MAIN1) || !ph.isPlayerTurn(ai) || sa.hasParam("WithoutManaCost") || ComputerUtil.castPermanentInMain1(ai, sa);
    }

    @Override
    protected boolean checkApiLogic(Player ai, SpellAbility sa) {
        ManaCost cardCost;
        int i;
        CardCollection list;
        Card source = sa.getHostCard();
        if (!source.ignoreLegendRule() && ai.isCardInPlay(source.getName())) {
            if (!source.hasSVar("AILegendaryException")) {
                return false;
            }
            String specialRule = source.getSVar("AILegendaryException");
            if ("TwoCopiesAllowed".equals(specialRule)) {
                if (CardLists.count(ai.getCardsIn(ZoneType.Battlefield), CardPredicates.nameEquals(source.getName())) > 1) {
                    return false;
                }
            } else if (!"AlwaysAllowed".equals(specialRule)) {
                return false;
            }
        }
        if (source.getType().hasSupertype(CardType.Supertype.World) && !(list = CardLists.getType(ai.getCardsIn(ZoneType.Battlefield), "World")).isEmpty()) {
            return false;
        }
        ManaCost mana = sa.getPayCosts().getTotalMana();
        if (mana.countX() > 0) {
            int xPay = ComputerUtilCost.getMaxXValue(sa, ai, false);
            if (source.hasConverge()) {
                int nColors = ComputerUtilMana.getConvergeCount(sa, ai);
                for (i = 1; i <= xPay; ++i) {
                    sa.setXManaCostPaid(i);
                    int newColors = ComputerUtilMana.getConvergeCount(sa, ai);
                    if (newColors <= nColors) {
                        sa.setXManaCostPaid(i - 1);
                        break;
                    }
                    nColors = newColors;
                }
            } else {
                if (xPay <= 0) {
                    return false;
                }
                sa.setXManaCostPaid(xPay);
            }
        } else if (mana.isZero() && (cardCost = source.getManaCost()) != null && cardCost.countX() > 0) {
            return false;
        }
        if ("SacToReduceCost".equals(sa.getParam("AILogic"))) {
            sa.setXManaCostPaid(0);
            ManaCostBeingPaid paidCost = ComputerUtilMana.calculateManaCost(sa, true, 0);
            int generic = paidCost.getGenericManaAmount();
            int xPay = ComputerUtilCost.getMaxXValue(sa, ai, false);
            xPay = Math.min(xPay, generic / 2);
            sa.setXManaCostPaid(xPay);
        }
        if ("ChaliceOfTheVoid".equals(source.getSVar("AICurseEffect"))) {
            int maxX = sa.getXManaCostPaid();
            CardCollection otherChalices = CardLists.filter((Iterable<Card>)ai.getGame().getCardsIn(ZoneType.Battlefield), CardPredicates.nameEquals("Chalice of the Void"));
            block1: for (i = 0; i <= maxX; ++i) {
                for (Card chalice : otherChalices) {
                    if (chalice.getCounters(CounterEnumType.CHARGE) != i) continue;
                    continue block1;
                }
                int manaValue = i;
                CardCollection aiCards = CardLists.filter((Iterable<Card>)ai.getAllCards(), card -> (card.isInZone(ZoneType.Library) || !card.isInZone(ZoneType.Hand)) && card.getState(CardStateName.Original).getManaCost() != null && card.getState(CardStateName.Original).getManaCost().getCMC() == manaValue);
                CardCollection oppCards = CardLists.filter((Iterable<Card>)ai.getStrongestOpponent().getAllCards(), card -> (card.isInZone(ZoneType.Library) || !card.isInZone(ZoneType.Hand)) && card.getState(CardStateName.Original).getManaCost() != null && card.getState(CardStateName.Original).getManaCost().getCMC() == manaValue);
                if (manaValue == 0) {
                    aiCards = CardLists.filter((Iterable<Card>)aiCards, Predicates.not(CardPredicates.isType("Land")));
                    oppCards = CardLists.filter((Iterable<Card>)oppCards, Predicates.not(CardPredicates.isType("Land")));
                    aiCards = CardLists.filter((Iterable<Card>)aiCards, Predicates.not(CardPredicates.nameEquals("Chalice of the Void")));
                }
                if (oppCards.size() <= 3 || oppCards.size() < aiCards.size() * 2) continue;
                sa.setXManaCostPaid(manaValue);
                return true;
            }
            return false;
        }
        for (KeywordInterface ki : source.getKeywords(Keyword.MULTIKICKER)) {
            String o = ki.getOriginal();
            String costStr = o.split(":")[1];
            Cost cost = new Cost(costStr, false);
            if (!cost.hasManaCost()) continue;
            ManaCost mkCost = cost.getTotalMana();
            ManaCost mCost = sa.getPayCosts().getTotalMana();
            boolean isZeroCost = mCost.isZero();
            for (int i2 = 0; i2 < 10; ++i2) {
                ManaCostBeingPaid mcbp = new ManaCostBeingPaid(mCost = ManaCost.combine(mCost, mkCost));
                if (!ComputerUtilMana.canPayManaCost(mcbp, sa, ai, false)) {
                    sa.setOptionalKeywordAmount(ki, i2);
                    break;
                }
                sa.setOptionalKeywordAmount(ki, i2 + 1);
            }
            if (!isZeroCost || sa.getOptionalKeywordAmount(ki) != 0) continue;
            sa.clearOptionalKeywordAmount();
            return false;
        }
        for (KeywordInterface inst : source.getKeywords()) {
            String ability = inst.getOriginal();
            if (!ability.startsWith("UpkeepCost")) continue;
            String[] k = ability.split(":");
            String costs = k[1];
            SpellAbility.EmptySa emptyAbility = new SpellAbility.EmptySa(source, ai);
            emptyAbility.setPayCosts(new Cost(costs, true));
            emptyAbility.setTargetRestrictions(sa.getTargetRestrictions());
            emptyAbility.setCardState(sa.getCardState());
            emptyAbility.setActivatingPlayer(ai, true);
            if (ComputerUtilCost.canPayCost(emptyAbility, ai, true)) continue;
            return false;
        }
        if (source.hasSVar("AICastPreference")) {
            String pref = source.getSVar("AICastPreference");
            String[] groups = StringUtils.split(pref, "|");
            boolean dontCast = false;
            for (String group : groups) {
                String[] elems = StringUtils.split(group.trim(), '$');
                String param = elems[0].trim();
                String value = elems[1].trim();
                if (param.equals("MustHaveInHand")) {
                    boolean hasCard = Iterables.any(ai.getCardsIn(ZoneType.Hand), CardPredicates.nameEquals(value));
                    if (hasCard) continue;
                    dontCast = true;
                    continue;
                }
                if (param.startsWith("MaxControlled")) {
                    CardCollectionView valid = param.contains("Globally") ? ai.getGame().getCardsIn(ZoneType.Battlefield) : ai.getCardsIn(ZoneType.Battlefield);
                    CardCollection ctrld = CardLists.filter((Iterable<Card>)valid, CardPredicates.nameEquals(source.getName()));
                    int numControlled = 0;
                    if (param.endsWith("WithoutOppAuras")) {
                        for (Card c : ctrld) {
                            if (c.getEnchantedBy().isEmpty()) {
                                ++numControlled;
                                continue;
                            }
                            for (Card att : c.getEnchantedBy()) {
                                if (att.getController().isOpponentOf(ai)) continue;
                                ++numControlled;
                            }
                        }
                    } else {
                        numControlled = ctrld.size();
                    }
                    if (numControlled < Integer.parseInt(value)) continue;
                    dontCast = true;
                    continue;
                }
                if (param.equals("NumManaSources")) {
                    CardCollection m4 = ComputerUtilMana.getAvailableManaSources(ai, true);
                    if (m4.size() >= Integer.parseInt(value)) continue;
                    dontCast = true;
                    continue;
                }
                if (param.equals("NumManaSourcesNextTurn")) {
                    int extraMana;
                    CardCollection m5 = ComputerUtilMana.getAvailableManaSources(ai, true);
                    int n = extraMana = CardLists.count(ai.getCardsIn(ZoneType.Hand), CardPredicates.Presets.LANDS) > 0 ? 1 : 0;
                    if (source.getName().equals("Illusions of Grandeur")) {
                        extraMana += Math.min(3, CardLists.filter((Iterable<Card>)ai.getCardsIn(ZoneType.Battlefield), Predicates.or(CardPredicates.nameEquals("Sapphire Medallion"), CardPredicates.nameEquals("Helm of Awakening"))).size()) * 2;
                    }
                    if (m5.size() + extraMana >= Integer.parseInt(value)) continue;
                    dontCast = true;
                    continue;
                }
                if (param.equals("NeverCastIfLifeBelow")) {
                    if (ai.getLife() >= Integer.parseInt(value)) continue;
                    dontCast = true;
                    continue;
                }
                if (param.equals("NeverCastIfLifeAbove")) {
                    if (ai.getLife() <= Integer.parseInt(value)) continue;
                    dontCast = true;
                    continue;
                }
                if (param.equals("AlwaysCastIfLifeBelow")) {
                    if (ai.getLife() >= Integer.parseInt(value)) continue;
                    dontCast = false;
                    break;
                }
                if (param.equals("AlwaysCastIfLifeAbove")) {
                    if (ai.getLife() <= Integer.parseInt(value)) continue;
                    dontCast = false;
                    break;
                }
                if (!param.equals("OnlyFromZone") || source.getZone().getZoneType().toString().equals(value)) continue;
                dontCast = true;
                break;
            }
            return !dontCast;
        }
        return true;
    }

    @Override
    protected boolean doTriggerAINoCost(Player ai, SpellAbility sa, boolean mandatory) {
        Card source = sa.getHostCard();
        Cost cost = sa.getPayCosts();
        if (!sa.metConditions()) {
            return false;
        }
        if (sa.hasParam("AILogic") && !this.checkAiLogic(ai, sa, sa.getParam("AILogic"))) {
            return false;
        }
        if (cost != null && !this.willPayCosts(ai, sa, cost, source)) {
            return false;
        }
        if (!this.checkPhaseRestrictions(ai, sa, ai.getGame().getPhaseHandler())) {
            return false;
        }
        return this.checkApiLogic(ai, sa) || mandatory;
    }
}

