/*
 * Decompiled with CFR 0.152.
 */
package forge.ai.ability;

import forge.ai.AiAttackController;
import forge.ai.SpellAbilityAi;
import forge.ai.SpellApiToAi;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.phase.PhaseHandler;
import forge.game.phase.PhaseType;
import forge.game.player.Player;
import forge.game.player.PlayerActionConfirmMode;
import forge.game.spellability.AbilityStatic;
import forge.game.spellability.AbilitySub;
import forge.game.spellability.SpellAbility;
import forge.game.zone.ZoneType;
import java.util.Map;

public class PeekAndRevealAi
extends SpellAbilityAi {
    @Override
    protected boolean canPlayAI(Player aiPlayer, SpellAbility sa) {
        PhaseHandler ph;
        if (sa instanceof AbilityStatic) {
            return false;
        }
        String logic = sa.getParamOrDefault("AILogic", "");
        if ("Main2".equals(logic) ? aiPlayer.getGame().getPhaseHandler().getPhase().isBefore(PhaseType.MAIN2) : "EndOfOppTurn".equals(logic) && ((ph = aiPlayer.getGame().getPhaseHandler()).getNextTurn() != aiPlayer || !ph.is(PhaseType.END_OF_TURN))) {
            return false;
        }
        Player opp = AiAttackController.choosePreferredDefenderPlayer(aiPlayer);
        Card host = sa.getHostCard();
        Player libraryOwner = aiPlayer;
        if (!this.willPayCosts(aiPlayer, sa, sa.getPayCosts(), host)) {
            return false;
        }
        if (sa.usesTargeting()) {
            sa.resetTargets();
            if (!sa.canTarget(opp)) {
                return false;
            }
            sa.getTargets().add(opp);
            libraryOwner = opp;
        }
        return !libraryOwner.getCardsIn(ZoneType.Library).isEmpty();
    }

    @Override
    public boolean confirmAction(Player player, SpellAbility sa, PlayerActionConfirmMode mode, String message, Map<String, Object> params) {
        AbilitySub subAb;
        if ("InstantOrSorcery".equals(sa.getParam("AILogic"))) {
            CardCollection revealed = (CardCollection)params.get("Revealed");
            for (Card c : revealed) {
                if (c.isInstant() || c.isSorcery()) continue;
                return false;
            }
        }
        return (subAb = sa.getSubAbility()) != null && SpellApiToAi.Converter.get(subAb.getApi()).chkDrawbackWithSubs(player, subAb);
    }
}

