/*
 * Decompiled with CFR 0.152.
 */
package forge.ai.ability;

import com.google.common.collect.Iterables;
import forge.ai.AiCardMemory;
import forge.ai.ComputerUtilCard;
import forge.ai.ComputerUtilCombat;
import forge.ai.SpellAbilityAi;
import forge.game.Game;
import forge.game.ability.AbilityUtils;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.card.CardLists;
import forge.game.combat.Combat;
import forge.game.combat.CombatUtil;
import forge.game.keyword.Keyword;
import forge.game.phase.PhaseType;
import forge.game.player.Player;
import forge.game.spellability.SpellAbility;
import java.util.List;
import java.util.Map;

public class MustBlockAi
extends SpellAbilityAi {
    @Override
    protected boolean canPlayAI(Player aiPlayer, SpellAbility sa) {
        boolean onlyLethal;
        Card source = sa.getHostCard();
        Game game = aiPlayer.getGame();
        Combat combat = game.getCombat();
        boolean bl = onlyLethal = !"AllowNonLethal".equals(sa.getParam("AILogic"));
        if (combat == null || !combat.isAttacking(source)) {
            return false;
        }
        if (AiCardMemory.isRememberedCard(aiPlayer, source, AiCardMemory.MemorySet.ACTIVATED_THIS_TURN)) {
            return false;
        }
        List<Card> list = this.determineGoodBlockers(source, aiPlayer, combat.getDefenderPlayerByAttacker(source), sa, onlyLethal, false);
        if (!list.isEmpty()) {
            Card blocker = ComputerUtilCard.getBestCreatureAI(list);
            if (blocker == null) {
                return false;
            }
            sa.getTargets().add(blocker);
            AiCardMemory.rememberCard(aiPlayer, source, AiCardMemory.MemorySet.ACTIVATED_THIS_TURN);
            return true;
        }
        return false;
    }

    @Override
    public boolean chkAIDrawback(SpellAbility sa, Player aiPlayer) {
        if (sa.hasParam("DefinedAttacker")) {
            return false;
        }
        return this.canPlayAI(aiPlayer, sa);
    }

    @Override
    protected boolean doTriggerAINoCost(Player ai, SpellAbility sa, boolean mandatory) {
        Card blocker;
        Card source = sa.getHostCard();
        if (!ai.getGame().getPhaseHandler().getPhase().isBefore(PhaseType.MAIN2)) {
            return false;
        }
        Card attacker = source;
        if (sa.hasParam("DefinedAttacker")) {
            CardCollection cards = AbilityUtils.getDefinedCards(source, sa.getParam("DefinedAttacker"), sa);
            if (cards.isEmpty()) {
                return false;
            }
            attacker = (Card)cards.get(0);
        }
        boolean chance = false;
        if (sa.usesTargeting()) {
            Player defender;
            Combat combat;
            List<Card> list = this.determineGoodBlockers(attacker, ai, ai.getWeakestOpponent(), sa, true, true);
            if (list.isEmpty()) {
                return sa.isTargetNumberValid();
            }
            blocker = ComputerUtilCard.getBestCreatureAI(list);
            if (blocker == null) {
                return false;
            }
            if (source.hasKeyword(Keyword.PROVOKE) && blocker.isTapped() && (combat = ai.getGame().getCombat()) != null && (defender = combat.getDefenderPlayerByAttacker(source)) != null && combat.getAttackingPlayer().equals(ai) && defender.canLoseLife() && !defender.cantLoseForZeroOrLessLife() && ComputerUtilCombat.lifeThatWouldRemain(defender, combat) <= 0) {
                return false;
            }
        } else {
            return sa.hasParam("Choices");
        }
        sa.getTargets().add(blocker);
        chance = true;
        return chance;
    }

    private List<Card> determineBlockerFromList(Card attacker, Player ai, Iterable<Card> options, SpellAbility sa, boolean onlyLethal, boolean testTapped) {
        CardCollection list = CardLists.filter(options, c -> {
            boolean tapped = c.isTapped();
            if (testTapped) {
                c.setTapped(false);
            }
            if (!CombatUtil.canBlock(attacker, c)) {
                return false;
            }
            if (ComputerUtilCombat.canDestroyAttacker(ai, attacker, c, null, false)) {
                return false;
            }
            if (onlyLethal && !ComputerUtilCombat.canDestroyBlocker(ai, c, attacker, null, false)) {
                return false;
            }
            if (testTapped) {
                c.setTapped(tapped);
            }
            return true;
        });
        return list;
    }

    private List<Card> determineGoodBlockers(Card attacker, Player ai, Player defender, SpellAbility sa, boolean onlyLethal, boolean testTapped) {
        CardCollection list = defender.getCreaturesInPlay();
        if (sa.usesTargeting()) {
            list = CardLists.getTargetableCards(list, sa);
        }
        return this.determineBlockerFromList(attacker, ai, list, sa, onlyLethal, testTapped);
    }

    @Override
    protected Card chooseSingleCard(Player ai, SpellAbility sa, Iterable<Card> options, boolean isOptional, Player targetedPlayer, Map<String, Object> params) {
        Card host;
        Card attacker = host = sa.getHostCard();
        if (sa.hasParam("DefinedAttacker")) {
            CardCollection attackers = AbilityUtils.getDefinedCards(host, sa.getParam("DefinedAttacker"), sa);
            attacker = Iterables.getFirst(attackers, null);
        }
        if (attacker == null) {
            return Iterables.getFirst(options, null);
        }
        List<Card> better = this.determineBlockerFromList(attacker, ai, options, sa, false, false);
        if (!better.isEmpty()) {
            return Iterables.getFirst(better, null);
        }
        return Iterables.getFirst(options, null);
    }
}

