/*
 * Decompiled with CFR 0.152.
 */
package forge.ai.ability;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import forge.ai.ComputerUtil;
import forge.ai.ComputerUtilCost;
import forge.ai.SpecialCardAi;
import forge.ai.SpellAbilityAi;
import forge.game.GameObject;
import forge.game.ability.AbilityUtils;
import forge.game.card.Card;
import forge.game.card.CardCollectionView;
import forge.game.card.CardLists;
import forge.game.card.CardPredicates;
import forge.game.phase.PhaseHandler;
import forge.game.phase.PhaseType;
import forge.game.player.Player;
import forge.game.player.PlayerActionConfirmMode;
import forge.game.player.PlayerPredicates;
import forge.game.spellability.SpellAbility;
import forge.game.zone.ZoneType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class MillAi
extends SpellAbilityAi {
    @Override
    protected boolean checkAiLogic(Player ai, SpellAbility sa, String aiLogic) {
        PhaseHandler ph = ai.getGame().getPhaseHandler();
        if (aiLogic.equals("Main1")) {
            return !ph.getPhase().isBefore(PhaseType.MAIN2) || sa.hasParam("ActivationPhases") || ComputerUtil.castSpellInMain1(ai, sa);
        }
        if (aiLogic.equals("EndOfOppTurn")) {
            return ph.is(PhaseType.END_OF_TURN) && ph.getNextTurn().equals(ai);
        }
        if (aiLogic.equals("LilianaMill")) {
            return CardLists.filter((Iterable<Card>)ai.getCardsIn(ZoneType.Graveyard), CardPredicates.Presets.CREATURES).size() >= 1;
        }
        return true;
    }

    @Override
    protected boolean checkPhaseRestrictions(Player ai, SpellAbility sa, PhaseHandler ph) {
        if ("ExileAndPlayUntilEOT".equals(sa.getParam("AILogic"))) {
            return ph.is(PhaseType.MAIN1) && ph.isPlayerTurn(ai);
        }
        if ("ExileAndPlayOrDealDamage".equals(sa.getParam("AILogic"))) {
            return (ph.is(PhaseType.MAIN1) || ph.is(PhaseType.MAIN2)) && ph.isPlayerTurn(ai);
        }
        if (!(sa.isPwAbility() || !"You".equals(sa.getParam("Defined")) || !MillAi.isSorcerySpeed(sa, ai) && ph.is(PhaseType.END_OF_TURN) && ph.getNextTurn().equals(ai))) {
            return false;
        }
        if (sa.getHostCard().isCreature() && sa.getPayCosts().hasTapCost()) {
            return ph.is(PhaseType.END_OF_TURN) && ph.getNextTurn().equals(ai);
        }
        return true;
    }

    @Override
    protected boolean checkApiLogic(Player ai, SpellAbility sa) {
        if (ComputerUtil.preventRunAwayActivations(sa)) {
            return false;
        }
        if (("You".equals(sa.getParam("Defined")) || "Player".equals(sa.getParam("Defined"))) && ai.getCardsIn(ZoneType.Library).size() < 10) {
            return false;
        }
        if (sa.usesTargeting() && !this.targetAI(ai, sa, false)) {
            return false;
        }
        if (sa.hasParam("NumCards") && (sa.getParam("NumCards").equals("X") || sa.getParam("NumCards").equals("Z")) && sa.getSVar("X").startsWith("Count$xPaid")) {
            int cardsToDiscard = this.getNumToDiscard(ai, sa);
            sa.setXManaCostPaid(cardsToDiscard);
            return cardsToDiscard > 0;
        }
        return true;
    }

    private boolean targetAI(Player ai, SpellAbility sa, boolean mandatory) {
        Card source = sa.getHostCard();
        if (sa.usesTargeting()) {
            sa.resetTargets();
            HashMap<Player, Integer> list = Maps.newHashMap();
            for (Player o : ai.getOpponents()) {
                CardCollectionView pLibrary;
                int numCards;
                if (!sa.canTarget(o)) continue;
                if (sa.hasParam("NumCards")) {
                    sa.getTargets().add(o);
                    numCards = AbilityUtils.calculateAmount(sa.getHostCard(), sa.getParam("NumCards"), sa);
                    sa.getTargets().remove(o);
                } else {
                    numCards = 1;
                }
                if (numCards <= 0 && (!sa.hasParam("NumCards") || !sa.getParam("NumCards").equals("X") && !sa.getParam("NumCards").equals("Z") || !source.getSVar("X").startsWith("Count$xPaid") && !source.getSVar("X").startsWith("Remembered$ChromaSource")) || (pLibrary = o.getCardsIn(ZoneType.Library)).isEmpty()) continue;
                if (numCards >= pLibrary.size()) {
                    sa.getTargets().add(o);
                    return true;
                }
                list.put(o, numCards);
            }
            if (list.isEmpty()) {
                if (mandatory && !sa.isTargetNumberValid() && sa.canTarget(ai)) {
                    sa.getTargets().add(ai);
                    return true;
                }
                return sa.isTargetNumberValid();
            }
            Map.Entry max = Collections.max(list.entrySet(), Map.Entry.comparingByValue());
            sa.getTargets().add((GameObject)max.getKey());
        }
        return true;
    }

    @Override
    public boolean chkAIDrawback(SpellAbility sa, Player aiPlayer) {
        return this.targetAI(aiPlayer, sa, true);
    }

    @Override
    protected boolean doTriggerAINoCost(Player aiPlayer, SpellAbility sa, boolean mandatory) {
        if (!this.targetAI(aiPlayer, sa, mandatory)) {
            return false;
        }
        if (sa.hasParam("NumCards") && sa.getParam("NumCards").equals("X") && sa.getSVar("X").equals("Count$xPaid")) {
            sa.setXManaCostPaid(this.getNumToDiscard(aiPlayer, sa));
        }
        return true;
    }

    @Override
    public boolean confirmAction(Player player, SpellAbility sa, PlayerActionConfirmMode mode, String message, Map<String, Object> params) {
        if ("TimmerianFiends".equals(sa.getParam("AILogic"))) {
            return SpecialCardAi.TimmerianFiends.consider(player, sa);
        }
        return true;
    }

    private int getNumToDiscard(Player ai, SpellAbility sa) {
        ArrayList<Player> list = Lists.newArrayList();
        if (sa.usesTargeting()) {
            list.addAll(Lists.newArrayList(sa.getTargets().getTargetPlayers()));
        } else {
            list.addAll(AbilityUtils.getDefinedPlayers(sa.getHostCard(), sa.getParam("Defined"), sa));
        }
        Player m4 = Collections.max(list, PlayerPredicates.compareByZoneSize(ZoneType.Library));
        int cardsToDiscard = m4.getCardsIn(ZoneType.Library).size();
        if (list.contains(ai)) {
            cardsToDiscard = Math.min(ai.getCardsIn(ZoneType.Library).size() - 5, cardsToDiscard);
        }
        return Math.min(ComputerUtilCost.getMaxXValue(sa, ai, sa.isTrigger()), cardsToDiscard);
    }
}

